# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: lifolbl.tcl,v 2.20 2006/01/28 19:16:59 jfontain Exp $


# last-in-first-out label generally used at the bottom of an application window for messages display

class lifoLabel {

    proc lifoLabel {this parentPath args} composite {[new scrollingLabel $parentPath] $args} {
        set ($this,lifo,0) [new lifo]; set ($this,lifo,1) [new lifo]                                     ;# normal and high priority
        set ($this,current,0) {}; set ($this,current,1) {}
        composite::complete $this
    }

    proc ~lifoLabel {this} {
        delete $($this,lifo,0) $($this,lifo,1)
    }

    proc options {this} {                                                                     ;# force initialization of all options
        return [list\
            [list -borderwidth $widget::option(button,borderwidth)]\
            [list -font {helvetica -12}]\
            [list -relief sunken]\
        ]
    }

    proc set-relief {this value} {
        composite::configure $composite::($this,base) base -relief $value
    }

    proc set-borderwidth {this value} {
        composite::configure $composite::($this,base) base -borderwidth $value
    }

    proc set-font {this value} {
        composite::configure $composite::($this,base) -font $value
    }

    proc refresh {this} {
        if {$($this,current,1) ne ""} {                                                           ;# high priority data is available
            composite::configure $composite::($this,base) -text $($this,current,1)
        } else {
            composite::configure $composite::($this,base) -text $($this,current,0)
        }
    }

    proc push {this string {priority 0}} {                                                    ;# user procedure for pushing a string
        if {$($this,current,$priority) ne ""} {
            xifo::in $($this,lifo,$priority) $($this,current,$priority)                ;# store current string in stack if non empty
        }
        set ($this,current,$priority) $string
        refresh $this
    }

    proc pop {this {priority 0}} {                                                            ;# user procedure for popping a string
        set ($this,current,$priority) {}
        catch {set ($this,current,$priority) [lifo::out $($this,lifo,$priority)]}                      ;# stack may be empty already
        refresh $this
    }

    proc flash {this string {seconds 1}} {                                                   ;# user procedure for flashing a string
        after [expr {1000 * $seconds}] "lifoLabel::pop $this 1"                                                 ;# use high priority
        push $this $string 1
    }

}
