# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: trace.tcl,v 1.20 2006/01/28 19:16:59 jfontain Exp $


package provide trace [lindex {$Revision: 1.20 $} 1]
package require msgcat
namespace import msgcat::*
package require internationalization


namespace eval trace {

    variable nextRow 0
    variable numberOfRows 10                                                                                           ;# by default

    array set data [list\
        updates 0\
        0,label {} 0,type integer 0,message [mc {row creation order}]\
        1,label [mc date] 1,type clock 1,message [mc {date of message occurrence}]\
        2,label [mc time] 2,type clock 2,message [mc {time of message occurrence}]\
        3,label [mc module] 3,type dictionary 3,message [mc {module identification}] 3,anchor left\
        4,label [mc message] 4,type ascii 4,message [mc {message from module}] 4,anchor left\
        switches {-m 1 --modules 1 --rows 1}\
        pollTimes -10\
        sort {0 decreasing}\
    ]
    set file [open trace.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar 1 $optionsName options
        variable numberOfRows
        variable display
        variable data

        catch {set modules $options(-m)}
        catch {set modules $options(--modules)}                                                                 ;# favor long option
        if {[info exists modules]} {                                                                  ;# remember modules to display
            foreach module [split $modules ,] {
                set display($module) {}
            }
        }
        catch {set numberOfRows $options(--rows)}
        set data(identifier) trace           ;# never show an instance number since resident trace module already takes one instance
    }

    proc update {module identifier message} {         ;# directly invoked by the core when it receives a trace message from a module
        variable display
        variable nextRow
        variable data
        variable numberOfRows

        if {[info exists display] && ![info exists display($module)]} return                                         ;# filtered out
        set row $nextRow
        incr nextRow
        set data($row,0) $row
        set seconds [clock seconds]
        set data($row,1) [clock format $seconds -format {%d %b %Y}]
        set data($row,2) [clock format $seconds -format %T]
        set data($row,3) $identifier
        set data($row,4) $message
        if {$numberOfRows > 0} {                                                                       ;# eventually remove old rows
            incr row -$numberOfRows
            catch {unset data($row,0) data($row,1) data($row,2) data($row,3) data($row,4)}
        }
        incr data(updates)
    }

}
