# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: peerdlg.tcl,v 1.5 2006/01/28 19:16:59 jfontain Exp $


namespace eval peer {

    namespace eval dialog {

        proc configuration {export} {
            variable message
            variable confirmed
            variable done
            variable port; variable host                                               ;# public values available after confirmation

            set confirmed 0
            set dialog [new dialogBox .grabber\
                -buttons hoc -default o -title [mc {moodss: Peer configuration}] -x [winfo pointerx .] -y [winfo pointery .]\
                -die 0\
            ]
            composite::configure $dialog -command "peer::dialog::validate $dialog $export"
            if {$export} {
                composite::configure $dialog -helpcommand {generalHelpWindow #menus.file.peer.export}
            } else {
                composite::configure $dialog -helpcommand {generalHelpWindow #menus.file.peer.import}
            }
            grab .grabber                                                  ;# grab siblings such as help window so that it is usable
            lappend objects [linkedHelpWidgetTip $composite::($dialog,help,path)]
            set frame [frame $widget::($dialog,path).frame]
            grid rowconfigure $frame 0 -weight 1
            grid columnconfigure $frame 0 -weight 1
            grid columnconfigure $frame 1 -weight 1
            if {$export} {
                set text [mc {Configuration for exporting data cells:}]
            } else {
                set text [mc {Configuration for importing data cells:}]
            }
            set message\
                [message $frame.message -width [winfo screenwidth .] -font $font::(mediumNormal) -justify center -text $text]
            set row 0
            grid $message -sticky nsew -row $row -column 0 -columnspan 100                                     ;# occupy whole width
            grid [label $frame.portLabel -text [mc Port:]] -row [incr row] -column 0 -sticky e -padx 2
            set port 8008                                                                     ;# by default, since we are using HTTP
            set entry [entry $frame.portEntry -width 5 -textvariable peer::dialog::port]
            # filter on positive integers and limit entry length:
            setupEntryValidation $entry {{checkMaximumLength 5 %P} {check31BitUnsignedInteger %P}}
            grid $entry -row $row -column 1 -sticky w -padx 2
            if {!$export} {
                set host 127.0.0.1                                                                                        ;# default
                grid [label $frame.hostLabel -text [mc Server:]] -row [incr row] -column 0 -sticky e -padx 2
                set entry [entry $frame.hostEntry -width 20 -textvariable peer::dialog::host]
                grid $entry -row $row -column 1 -sticky w -padx 2
            }
            grid rowconfigure $frame [incr row] -weight 1
            composite::configure $dialog -deletecommand "grab release .grabber; delete $objects; set peer::dialog::done {}"
            dialogBox::display $dialog $frame
            vwait peer::dialog::done                                                                          ;# wait for user input
            if {$confirmed} {
                set return [list port $port]                                                                     ;# serialized array
                if {!$export} {
                    lappend return host [string trim $host]
                }
            } else {
                set return {}                                                            ;# cancelled: return empty serialized array
            }
            unset message confirmed done port; if {!$export} {unset host}
            return $return
        }

        proc validate {dialog export} {
            variable confirmed
            variable message
            variable port
            variable host

            if {$port eq ""} {
                set error [mc {a port name or number is required:}]
            }
            if {!$export && ([string trim $host] eq "")} {
                set error [mc {a host name or IP address is required:}]
            }
            if {[info exists error]} {
                $message configure -font $font::(mediumBold) -text $error
            } else {
                set confirmed 1
                delete $dialog                                                                                               ;# done
            }
        }

    }

}
