/* $Id: logging.c,v 1.7 2005/06/20 00:17:55 jfontain Exp $ */

/* to create the loadable library, use: cc -shared -o liblogging.so.1.0 -O2 -fPIC -Wall logging.c */
/* with stubs: cc -shared -o liblogging.so.1.0 -O2 -fPIC -Wall -DUSE_TCL_STUBS logging.c /usr/lib/libtclstub8.3.a */
/* pkgIndex.tcl: package ifneeded logging 1.0 [list load [file join $dir liblogging.so.1.0]] */

#include <tcl.h>
#include <syslog.h>


static int system(ClientData clientData, Tcl_Interp *interpreter, int numberOfArguments, Tcl_Obj * CONST arguments[])
{
#if (TCL_MINOR_VERSION >= 4) || (TCL_MAJOR_VERSION > 8)
    static CONST char *levels[] = {
#else
    static char *levels[] = {
#endif
        "emergency", "0", "alert", "1", "critical", "2", "error", "3", "warning", "4", "notice", "5", "info", "6", "debug", "7"
    };                                                                               /* accept both explicit and numerical values */
    int level;

    if(numberOfArguments != 4){
        Tcl_WrongNumArgs(interpreter, 1, arguments, "identification level message");
        return TCL_ERROR;
    }
    if(Tcl_GetIndexFromObj(interpreter, arguments[2], levels, "level", TCL_EXACT, &level) == TCL_ERROR){
        return TCL_ERROR;
    }
    openlog(Tcl_GetStringFromObj(arguments[1], 0), LOG_PID, LOG_USER);
    syslog(level / 2, Tcl_GetStringFromObj(arguments[3], 0));            /* divide by 2 to pass the correct level numerical value */
    closelog();
    return TCL_OK;
}

EXTERN int Logging_Init(Tcl_Interp *interpreter)                                      /* create all commands in logging namespace */
{
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interpreter, "8.1", 0) == NULL) {
        return TCL_ERROR;
    }
#endif
    Tcl_CreateObjCommand(interpreter, "::logging::system", system, 0, 0);
    return Tcl_PkgProvide(interpreter, "logging", "1.0");
}

EXTERN int Logging_SafeInit(Tcl_Interp *interpreter)
{
    return Logging_Init(interpreter);                                                                    /* all commands are safe */
}
