# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: html.tcl,v 1.57 2006/01/28 19:16:59 jfontain Exp $


set global::fileCloseImage [image create photo -data {
    R0lGODlhFgAWAMYAALGxuYmJmYmJmIiImLCwuM/P0YqKmkREYTw8XEFBYEdHZkZGZT8/Xzk5WEBAXIeHls7O0Lu7wVlZcz4+XnNzkcLC0uvr8PX198zM2oaG
    oVNTbLm5v0VFY05Obr+/0Obm7cnJ11xcfD09WU1Nbb29ztbW4dPT383N2lhYeFFRaZ+ft8XF1Lm5y/Pz9rq6y/7+/9zc5bS0xz09XYSEk2Jigbe3yeTk7LOz
    xnJykDk5VYWFoKKiudvb5d7e566uwn5+mmNjglJScjIyUK6utYuLppCQqtXV4ODg6F1dfTg4V4ODks7O24KCkWtripmZscDA0IKCkFlZeZKSrDU1U4GBkFNT
    c1RUdI+PqS0tS62ttEpKaldXd+Hh6ZiYsDQ0UDo6WWBgf2Rkg6Cgt+Pj625ujMfH1oGBj1NTa3Bwjp+ftnp6l6iovUREY0pKYc3Nz3h4lX19mXd3lElJaTQ0
    T7e3vTs7WmdnhomJo2VlhDY2VEhIaGFhgP///////////////yH5BAEKAH8ALAAAAAAWABYAAAf+gH+Cg4SFhoeCAAECAgMEiIUFBgcICQoLDA0ODxCQERIT
    FBUWF6UYGQ0aG4cRHB0eH7GysSAhIquEBRIjJCUmJcDBvycoKZ2DBhMqKywtFivQKy4vMCsxMjOEBzQxNS0vLzYxMTfgLxgxODmDAAg6Ozs85j0+5jY/QEFC
    Q4IBCURFAhoxZ+4IkiAIkygRJGDBj4cPlxA0iBBhAiaCBixowpGjE4JPKiJkACUjgygoo0ghCC5kxSlUBBFoUMWKlSsFn5h7UqUnliyDHGjZ0sQcFxpbKpjr
    skWBF0IPvoAJI+bFGDJhspZ5USYMGCFmCEE4owUNmjRqzKpdY5ZNGzc5hTaI6PAGjt27duPImUPn0IYUdezcGUwYT542fRFBmJEjj549YBYI8WIGLqRBQ5Qw
    oUIF6OXPiAIBADs=
}]

proc displayHelpWindow {topLevelName name title} {
    upvar 1 $topLevelName toplevel

    # child of common parent so that user interaction can be limited to 2 windows (print dialog box and main help for example)
    set toplevel .grabber.help${name}
    if {[winfo exists $toplevel]} {
        wm deiconify $toplevel
        raise $toplevel
        return 0
    }
    toplevel $toplevel
    wm group $toplevel .                                             ;# for proper window manager (windowmaker for example) behavior
    wm title $toplevel $title
    frame $toplevel.bound                     ;# create a frame for bindings that otherwise would propagate to all toplevel children
    return 1
}

proc generalHelpWindow {{url {}}} {
    static bottom 0

    if {[displayHelpWindow toplevel moodss [mc {moodss: Global help}]]} {
        loadHelpData
        set bottom [helpWindow $toplevel $::htmlHelpContents $::htmlHelpData]
    }
    if {([string length $url] > 0) && ![catch {classof $bottom}]} {                          ;# viewer may not have been created yet
        htmlViewer::goTo $bottom $url
    }
}

proc formulasHelpWindow {{url {}}} {
    static bottom 0

    if {[displayHelpWindow toplevel formulas [mc {moodss: Formulas help}]]} {
        loadHelpData
        set bottom [helpWindow $toplevel $::htmlFormulasHelpContents $::htmlFormulasHelpData]
    }
    if {([string length $url] > 0) && ![catch {classof $bottom}]} {                          ;# viewer may not have been created yet
        htmlViewer::goTo $bottom $url
    }
}

proc statisticsHelpWindow {{url {}}} {
    static bottom 0

    if {[displayHelpWindow toplevel statistics [mc {moodss: Predictor help}]]} {
        loadHelpData
        set bottom [helpWindow $toplevel $::htmlStatisticsHelpContents $::htmlStatisticsHelpData]
    }
    if {([string length $url] > 0) && ![catch {classof $bottom}]} {                          ;# viewer may not have been created yet
        htmlViewer::goTo $bottom $url
    }
}

proc loadHelpData {} {                                                                       ;# load huge HTML data only when needed
    if {\
        ([info exists ::env(LC_ALL)] && [string match ja* $::env(LC_ALL)]) ||\
        ([info exists ::env(LANG)] && [string match ja* $::env(LANG)])\
    } {
        package require moodsshelp-ja
    } else {
        package require moodsshelp
    }
}

proc helpWindow {toplevel htmlContents htmlData} {
    set panes [new panner $toplevel -panes 2]                                        ;# split window in 2 for contents and help data
    pack $widget::($panes,path) -fill both -expand 1
    set top [new htmlViewer $panner::($panes,frame1)]
    composite::configure $top base -height 100 -width 500
    pack $widget::($top,path) -fill both -expand 1
    set bottom [new htmlViewer $panner::($panes,frame2)]
    composite::configure $top -linkto $bottom
    composite::configure $bottom base -height 400
    focus $htmlViewer::($bottom,textPath)                                 ;# so that scrolling with keyboard is immediately possible
    pack $widget::($bottom,path) -fill both -expand 1
    bind $toplevel.bound <Destroy> "delete $bottom $top $panes"
    set button [button $toplevel.close -image $global::fileCloseImage -command "destroy $toplevel"]
    place $button -in $htmlViewer::($top,textPath) -relx 1 -anchor ne      ;# place inside text area so as not to obstruct scrollbar
    busy 1 $htmlViewer::($top,textPath)                                ;# force busy cursor on contents while bottom pane is loading
    composite::configure $top -data $htmlContents
    if {![winfo exists $toplevel]} {                                ;# user may have destroyed the window through the window manager
        return 0
    }
    composite::configure $bottom -data $htmlData
    catch {busy 0 $htmlViewer::($top,textPath)}                                            ;# window may have been destroyed by user
    return $bottom
}

proc moduleHelpWindow {name text} {
    if {![displayHelpWindow toplevel $name [format [mc {moodss: %s module help}] $name]]} return
    set viewer [new htmlViewer $toplevel]
    composite::configure $viewer base -height 300 -width 500
    pack $widget::($viewer,path) -fill both -expand 1
    bind $toplevel.bound <Destroy> "delete $viewer"
    composite::configure $viewer -data $text
    set button [button $toplevel.close -image $global::fileCloseImage -command "destroy $toplevel"]
    place $button -in $htmlViewer::($viewer,textPath) -relx 1 -anchor ne   ;# place inside text area so as not to obstruct scrollbar
}
