# copyright (C) 1997-2006 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: formulas.tcl,v 1.11 2006/01/28 19:16:59 jfontain Exp $


package provide formulas [lindex {$Revision: 1.11 $} 1]
package require msgcat
namespace import msgcat::*
package require internationalization


namespace eval formulas {

    array set data [list\
        updates 0\
        0,label [mc name] 0,type ascii 0,message [mc {formula name}]\
        1,label [mc value] 1,type real 1,message [mc {current value of expression}]\
        pollTimes -10\
        switches {--object 1 --category 1}\
    ]

    proc initialize {optionsName} {
        upvar 1 $optionsName options
        variable data

        catch {set identifier $options(--object)}
        if {[info exists options(--category)]} {
            if {[info exists identifier] > 0} {append identifier ,}
            append identifier $options(--category)
        }
        catch {set data(identifier) formulas($identifier)}
    }

    proc messages {} {
        variable data

        return [list $data(0,message) $data(1,message)]
    }

    proc new {row} {
        variable data

        set data($row,0) {}
        set data($row,1) ?
    }

    proc value {row value} {
        variable data

        set data($row,1) $value
    }

    proc name {row string} {
        variable data

        set data($row,0) $string
    }

    proc exists {row column} {
        variable data

        return [info exists data($row,$column)]
    }

    proc delete {row} {
        variable data

        unset data($row,0) data($row,1)
    }

    proc update {} {
        variable data

        incr data(updates)
    }

}
