#!/usr/local/groundwork/bin/perl --
# MonArch - Groundwork Monitor Architect
# monarch_as_nagios.pl
#
############################################################################
# Release 2.5
# 7-Apr-2008
############################################################################
# Author: Scott Parris
#
# Copyright 2007, 2008 GroundWork Open Source, Inc. (GroundWork)  
# All rights reserved. This program is free software; you can redistribute
# it and/or modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

use strict;

$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/groundwork/bin';
my $whoami = qx(whoami);
my $temp = $ARGV[0];
my $error = undef;
my $res = undef;
open (FILE, "<$temp") || ($error = "Cannot open $temp to write");
my $command = <FILE>;
close FILE;
unless ($error) {
	if ($command =~ /(.+)/) { $command = $1 } # untaints data read from file
	if ($whoami =~ /(.+)/) { $whoami = $1 } # untaints data read from file
	$res = qx($command 2>&1) || print "Error(s) executing $command $!";
	$res .= " - $whoami";
}
print $res;
