open Atom
;;

type t =
  | Bfalse
  | Btrue
  | Batom of atom
  (* begin
       rule Batom (p) -> Bp (p, Btrue, Bfalse)
     end *)
  | Bnot of t
  (* begin
       involutive
       rule Bnot (Bp ((p, x, y))) -> Bp (p, Bnot x, Bnot y)
       rule Bnot (Btrue) -> Bfalse
       rule Bnot (Bfalse) -> Btrue
     end *)
  | Band of t * t
  (* begin
       absorbent (Bfalse)
       neutral (Btrue)
       rule Band ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q = 0
         -> Bp (p, Band (x, z), Band (y, w))
       rule Band ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q < 0
         -> Bp (p, Band (x, Bp (q, z, w)), Band (y, Bp (q, z, w)))
       rule Band ((Bp ((q, x, y)), Bp ((p, z, w)))) when Atom.compare p q < 0
         -> Bp (p, Band (Bp (q, x, y), z), Band (Bp (q, x, y), w))
     end *)
  | Bor of t * t
  (* begin
       neutral (Bfalse)
       absorbent (Btrue)
       rule Bor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q = 0
         -> Bp (p, Bor (x, z), Bor (y, w))
       rule Bor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q < 0
         -> Bp (p, Bor (x, Bp (q, z, w)), Bor (y, Bp (q, z, w)))
       rule Bor ((Bp ((q, x, y)), Bp ((p, z, w)))) when Atom.compare p q < 0
         -> Bp (p, Bor (Bp (q, x, y), z), Bor (Bp (q, x, y), w))
     end *)
  | Bxor of t * t
  (* begin
       neutral (Bfalse)
       rule Bxor ((x, Btrue)) -> Bnot x
       rule Bxor ((Btrue, x)) -> Bnot x
       rule Bxor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q = 0
         -> Bp (p, Bxor (x, z), Bxor (y, w))
       rule Bxor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q < 0
         -> Bp (p, Bxor (x, Bp (q, z, w)), Bxor (y, Bp (q, z, w)))
       rule Bxor ((Bp ((q, x, y)), Bp ((p, z, w)))) when Atom.compare p q < 0
         -> Bp (p, Bxor (Bp (q, x, y), z), Bxor (Bp (q, x, y), w))
     end *)
  | Bimplies of t * t
  (* begin
       rule Bimplies ((x, y)) -> Bor (Bnot x, y)
     end *)
  | Bp of atom * t * t
  (* begin
       rule Bp ((_, x, y)) when Pervasives.compare x y = 0 -> x
     end *)
;;

(* System obtained by adhoc completion and used by Moca:

type t = private
  | Bimplies of t * t
  begin
    rule Bimplies ((x, y)) -> Bor (Bnot x, y)
  end
  | Bnot of t
  begin
    rule Bnot (Bp ((p, x, y))) -> Bp (p, Bnot x, Bnot y)
    rule Bnot (Btrue) -> Bfalse
    rule Bnot (Bfalse) -> Btrue
    involutive
  end
  | Bfalse
  | Band of t * t
  begin
    rule Band ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q = 0 ->
      Bp (p, Band (x, z), Band (y, w))
    rule Band ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q < 0 ->
      Bp (p, Band (x, Bp (q, z, w)), Band (y, Bp (q, z, w)))
    rule Band ((Bp ((q, x, y)), Bp ((p, z, w)))) when Atom.compare p q < 0 ->
      Bp (p, Band (Bp (q, x, y), z), Band (Bp (q, x, y), w))
    absorbent (Bfalse)
    neutral (Btrue)
  end
  | Batom of atom
  begin
    rule Batom (p) -> Bp (p, Btrue, Bfalse)
  end
  | Bp of atom * t * t
  begin
    rule Bp ((_, x, y)) when Pervasives.compare x y = 0 -> x
  end
  | Bor of t * t
  begin
    rule Bor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q = 0 ->
      Bp (p, Bor (x, z), Bor (y, w))
    rule Bor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q < 0 ->
      Bp (p, Bor (x, Bp (q, z, w)), Bor (y, Bp (q, z, w)))
    rule Bor ((Bp ((q, x, y)), Bp ((p, z, w)))) when Atom.compare p q < 0 ->
      Bp (p, Bor (Bp (q, x, y), z), Bor (Bp (q, x, y), w))
    absorbent (Btrue)
    neutral (Bfalse)
  end
  | Btrue
  | Bxor of t * t
  begin
    rule Bxor ((x, Btrue)) -> Bnot x
    rule Bxor ((Btrue, x)) -> Bnot x
    rule Bxor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q = 0 ->
      Bp (p, Bxor (x, z), Bxor (y, w))
    rule Bxor ((Bp ((p, x, y)), Bp ((q, z, w)))) when Atom.compare p q < 0 ->
      Bp (p, Bxor (x, Bp (q, z, w)), Bxor (y, Bp (q, z, w)))
    rule Bxor ((Bp ((q, x, y)), Bp ((p, z, w)))) when Atom.compare p q < 0 ->
      Bp (p, Bxor (Bp (q, x, y), z), Bxor (Bp (q, x, y), w))
    neutral (Bfalse)
  end
;;

 *)


let rec bimplies moca_z =
  match moca_z with
    | (x, y) -> bor (bnot x, y)
    | (moca_x, moca_y) -> insert_bimplies moca_x moca_y

and is_redex_bimplies moca_z =
  match moca_z with
    | (_, _) -> true
    | _ -> false

and return_bimplies moca_z =
  match moca_z with
    | (moca_x, moca_y) ->
        if is_redex_bimplies (moca_x, moca_y)
        then bimplies (moca_x, moca_y)
        else Bimplies (moca_x, moca_y)

and insert_bimplies moca_x moca_u =
  match moca_u with
    | _ -> return_bimplies (moca_x, moca_u)

and bnot moca_x =
  match moca_x with
    | Bp ((p, x, y)) -> bp (p, bnot x, bnot y)
    | Btrue -> bfalse
    | Bfalse -> btrue
    | Bnot moca_x -> moca_x
    | _ -> Bnot moca_x

and bfalse = Bfalse

and band moca_z =
  match moca_z with
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q = 0) ->
        bp (p, band (x, z), band (y, w))
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q < 0) ->
        bp (p, band (x, bp (q, z, w)), band (y, bp (q, z, w)))
    | (Bp ((q, x, y)), Bp ((p, z, w))) when (Atom.compare p q < 0) ->
        bp (p, band (bp (q, x, y), z), band (bp (q, x, y), w))
    | (Bfalse, _) -> bfalse
    | (_, Bfalse) -> bfalse
    | (Btrue, moca_y) -> moca_y
    | (moca_x, Btrue) -> moca_x
    | (moca_x, moca_y) -> insert_band moca_x moca_y

and is_redex_band moca_z =
  match moca_z with
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q = 0) -> true
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q < 0) -> true
    | (Bp ((q, x, y)), Bp ((p, z, w))) when (Atom.compare p q < 0) -> true
    | (Bfalse, _) -> true
    | (_, Bfalse) -> true
    | (Btrue, _) -> true
    | (_, Btrue) -> true
    | _ -> false

and return_band moca_z =
  match moca_z with
    | (moca_x, moca_y) ->
        if is_redex_band (moca_x, moca_y)
        then band (moca_x, moca_y)
        else Band (moca_x, moca_y)

and insert_band moca_x moca_u =
  match moca_u with
    | _ -> return_band (moca_x, moca_u)

and batom moca_x =
  match moca_x with
    | p -> bp (p, btrue, bfalse)
    | _ -> Batom moca_x

and bp moca_z =
  match moca_z with
    | (_, x, y) when (Pervasives.compare x y = 0) -> x
    | (moca_x1, moca_x2, moca_x3) -> Bp (moca_x1, moca_x2, moca_x3)

and bor moca_z =
  match moca_z with
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q = 0) ->
        bp (p, bor (x, z), bor (y, w))
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q < 0) ->
        bp (p, bor (x, bp (q, z, w)), bor (y, bp (q, z, w)))
    | (Bp ((q, x, y)), Bp ((p, z, w))) when (Atom.compare p q < 0) ->
        bp (p, bor (bp (q, x, y), z), bor (bp (q, x, y), w))
    | (Btrue, _) -> btrue
    | (_, Btrue) -> btrue
    | (Bfalse, moca_y) -> moca_y
    | (moca_x, Bfalse) -> moca_x
    | (moca_x, moca_y) -> insert_bor moca_x moca_y

and is_redex_bor moca_z =
  match moca_z with
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q = 0) -> true
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q < 0) -> true
    | (Bp ((q, x, y)), Bp ((p, z, w))) when (Atom.compare p q < 0) -> true
    | (Btrue, _) -> true
    | (_, Btrue) -> true
    | (Bfalse, _) -> true
    | (_, Bfalse) -> true
    | _ -> false

and return_bor moca_z =
  match moca_z with
    | (moca_x, moca_y) ->
        if is_redex_bor (moca_x, moca_y)
        then bor (moca_x, moca_y)
        else Bor (moca_x, moca_y)

and insert_bor moca_x moca_u =
  match moca_u with
    | _ -> return_bor (moca_x, moca_u)

and btrue = Btrue

and bxor moca_z =
  match moca_z with
    | (x, Btrue) -> bnot x
    | (Btrue, x) -> bnot x
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q = 0) ->
        bp (p, bxor (x, z), bxor (y, w))
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q < 0) ->
        bp (p, bxor (x, bp (q, z, w)), bxor (y, bp (q, z, w)))
    | (Bp ((q, x, y)), Bp ((p, z, w))) when (Atom.compare p q < 0) ->
        bp (p, bxor (bp (q, x, y), z), bxor (bp (q, x, y), w))
    | (Bfalse, moca_y) -> moca_y
    | (moca_x, Bfalse) -> moca_x
    | (moca_x, moca_y) -> insert_bxor moca_x moca_y

and is_redex_bxor moca_z =
  match moca_z with
    | (_, Btrue) -> true
    | (Btrue, _) -> true
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q = 0) -> true
    | (Bp ((p, x, y)), Bp ((q, z, w))) when (Atom.compare p q < 0) -> true
    | (Bp ((q, x, y)), Bp ((p, z, w))) when (Atom.compare p q < 0) -> true
    | (Bfalse, _) -> true
    | (_, Bfalse) -> true
    | _ -> false

and return_bxor moca_z =
  match moca_z with
    | (moca_x, moca_y) ->
        if is_redex_bxor (moca_x, moca_y)
        then bxor (moca_x, moca_y)
        else Bxor (moca_x, moca_y)

and insert_bxor moca_x moca_u =
  match moca_u with
    | _ -> return_bxor (moca_x, moca_u)
;;

external eq_t : t -> t -> bool =  "%equal"
;;

