functor MLLrValsFun (structure Token: TOKEN
                              structure Ast: AST) = 
struct
structure ParserData=
struct
structure Header = 
struct
(*#line 1.2 "ml.grm"*)(* Heavily modified from SML/NJ sources. *)

(* ml.grm
 *
 * Copyright 1989,1992 by AT&T Bell Laboratories
 *
 * SML/NJ is released under a HPND-style license.
 * See the file NJ-LICENSE for details.
 *)

(* Copyright (C) 2008,2009,2014-2017,2019,2022 Matthew Fluet.
 * Copyright (C) 1999-2006 Henry Cejtin, Matthew Fluet, Suresh
 *    Jagannathan, and Stephen Weeks.
 * Copyright (C) 1997-2000 NEC Research Institute.
 *
 * MLton is released under a HPND-style license.
 * See the file MLton-LICENSE for details.
 *)

fun reg (left, right) = Region.make {left = left, right = right}
fun error (reg, msg) = Control.error (reg, Layout.str msg, Layout.empty)

local
   open Control.Elaborate
in
   val allowOptBar = fn () => current allowOptBar
   val allowOptSemicolon = fn () => current allowOptSemicolon
   val allowRecordPunExps = fn () => current allowRecordPunExps
end

open Ast
structure Field = Record.Field
structure Srecord = SortedRecord

structure Type =
   struct
      open Type

      fun tuple ts =
         Record (Record.tuple (Vector.map (ts, fn t => (Region.bogus, t))))

      val unit = tuple (Vector.new0 ())

      fun arrow (t1, t2) = Con (Longtycon.arrow, Vector.new2 (t1, t2))
   end

structure DatBind =
   struct
      open DatBind

      fun make (dbs, withtypes, left, right) =
         makeRegion' (T {datatypes = dbs, withtypes = withtypes},
                      left, right)
   end

structure Pat =
   struct
      open Pat

      fun tuple ps =
         if 1 = Vector.length ps
            then Paren (Vector.sub (ps, 0))
         else Tuple ps

      val unit = tuple (Vector.new0 ())

      val bogus = unit

      fun makeAs (p1: t, p2: t): node =
         let
            fun err () =
               error (Pat.region p1, "must have variable to left in as pattern")
            fun fixopVar (p : t) =
               case node p of
                  FlatApp ps =>
                     if 1 = Vector.length ps
                        then (case node (Vector.sub (ps, 0)) of
                                 Var {fixop,name} =>
                                    (case Longvid.split name of
                                        ([], vid) =>
                                           SOME (fixop, Vid.toVar vid)
                                      | _ =>
                                           let
                                              val () = err ()
                                           in
                                              SOME (Fixop.None, Var.bogus)
                                           end)
                               | _ => NONE)
                     else NONE
                | _ => NONE
         in
            case fixopVar p1 of
               SOME (fixop, var) =>
                  Layered {fixop = fixop, var = var,
                           constraint = NONE,
                           pat = p2}
             | NONE =>
                  case node p1 of
                     Pat.Constraint (p, t) =>
                        (case fixopVar p of
                            SOME (fixop, var) =>
                               Layered {fixop = fixop, var = var,
                                        constraint = SOME t,
                                        pat = p2}
                          | _ => (err (); bogus))
                   | _ => (err (); bogus)
         end
   end

structure Exp =
   struct
      open Exp

      fun tuple es =
         if 1 = Vector.length es
            then Paren (Vector.sub (es, 0))
         else Record (Record.tuple (Vector.map (es, fn e => (Region.bogus, e))))

      val unit = tuple (Vector.new0 ())
   end

structure Dec =
   struct
      open Dec

      fun sequence (d1: t, d2: t): t =
         makeRegion (case (node d1, node d2) of
                        (SeqDec d1, SeqDec d2) => SeqDec (Vector.concat [d1, d2])
                      | (SeqDec d1, _) =>
                           SeqDec (Vector.concat [d1, Vector.new1 d2])
                      | (_, SeqDec d2) =>
                           SeqDec (Vector.concat [Vector.new1 d1, d2])
                      | _ => SeqDec (Vector.new2 (d1, d2)),
                     Region.append (region d1, region d2))
   end

structure Spec =
   struct
      open Spec

      (* Some of this mess is so that a sharing equation captures as
       * many specs as possible in its scope.
       *)
      fun seq (s: t, s': t): t =
         let
            fun reg s'' = makeRegion (s'', Region.append (region s, region s'))
         in
            case (node s, node s') of
               (Empty, _) => s'
             | (_, Empty) => s
             | (_, Seq (s1, s2)) => reg (Seq (seq (s, s1), s2))
             | (_, Sharing {spec, equation}) =>
                  reg (Sharing {spec = seq (s, spec), equation = equation})
             | _ => reg (Seq (s, s'))
         end
   end

fun consTopdec (d, dss) =
   case dss of
      [] => [[d]]
    | ds :: dss => (d :: ds) :: dss

type rule = Pat.t * Exp.t
type clause = {pats : Pat.t vector,
               resultType : Type.t option,
               body : Exp.t}
type clauses = clause vector
type eb = Con.t * EbRhs.t
type db = {tyvars: Tyvar.t vector,
           tycon: Tycon.t,
           cons: (Con.t * Type.t option) vector}
type tb = {def: Type.t,
           tycon: Tycon.t,
           tyvars: Tyvar.t vector}

type strdesc = Strid.t * Sigexp.t

type typdesc =  {tyvars: Tyvar.t vector,
                 tycon: Tycon.t}

type valdesc = Var.t * Type.t

type exndesc = Con.t * Type.t option

type strbind = {name: Strid.t,
                def: Strexp.t,
                constraint: SigConst.t}

type sigbind = Sigid.t * Sigexp.t

type funbind = {name : Fctid.t,
                arg : FctArg.t,
                result : SigConst.t,
                body : Strexp.t}

type vb = {pat: Pat.t,
           exp: Exp.t}

type rvb = {pat: Pat.t,
            match: Match.t}

fun longIdFromTok (s, left, right) =
   let
      val syms = List.map (String.split (s, #"."), Symbol.fromString)
   in
      (syms, reg (left, right))
   end

fun shortIdFromTok (s, left, right) =
   (Symbol.fromString s, reg (left, right))

fun longIdFromShortId (sym, reg) = ([sym], reg)

fun cons1 (x, (l, y)) = (x :: l, y)

fun augment (id, sigexp, (whereeqns, binds)) =
   (id, Sigexp.wheree (sigexp, Vector.fromList whereeqns))
   :: binds

fun 'a augment1 ((strexp: Strexp.t,
                  sigconst: Sigexp.t -> SigConst.t,
                  sigexp: Sigexp.t),
                 (whereeqns: WhereEquation.t list,
                  z: 'a)): Strexp.t * 'a =
   let
      val sigexp = Sigexp.wheree (sigexp, Vector.fromList whereeqns)
   in
      (Strexp.makeRegion
       (Strexp.Constrained (strexp, sigconst sigexp),
        Region.append (Strexp.region strexp, Sigexp.region sigexp)),
       z)
   end

type 'a whereAndEqns = WhereEquation.t list * 'a list

  
(*#line 244.1 "ml.grm.sml"*)
end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\009\000\121\000\010\000\069\000\016\000\067\000\017\000\189\000\
\\037\000\120\000\043\000\119\000\044\000\118\000\047\000\117\000\
\\051\000\116\000\070\000\114\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\009\000\121\000\010\000\069\000\016\000\067\000\037\000\120\000\
\\043\000\119\000\044\000\118\000\047\000\117\000\051\000\116\000\
\\057\000\115\000\070\000\114\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\017\000\189\000\037\000\120\000\
\\043\000\119\000\044\000\118\000\047\000\242\000\051\000\116\000\
\\070\000\114\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\018\000\066\000\027\000\064\000\
\\032\000\061\000\036\000\058\000\037\000\057\000\038\000\056\000\
\\043\000\053\000\044\000\052\000\045\000\051\000\047\000\049\000\
\\051\000\047\000\054\000\044\000\056\000\161\000\069\000\038\000\
\\073\000\037\000\074\000\036\000\075\000\035\000\076\000\034\000\
\\077\000\033\000\078\000\032\000\079\000\031\000\080\000\030\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\018\000\066\000\027\000\064\000\
\\032\000\061\000\036\000\058\000\037\000\057\000\038\000\056\000\
\\043\000\053\000\044\000\052\000\045\000\051\000\047\000\049\000\
\\051\000\047\000\054\000\044\000\056\000\176\000\069\000\038\000\
\\073\000\037\000\074\000\036\000\075\000\035\000\076\000\034\000\
\\077\000\033\000\078\000\032\000\079\000\031\000\080\000\030\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\018\000\066\000\027\000\064\000\
\\032\000\061\000\036\000\058\000\037\000\057\000\038\000\056\000\
\\043\000\053\000\044\000\052\000\045\000\051\000\047\000\049\000\
\\051\000\047\000\054\000\044\000\058\000\148\000\069\000\038\000\
\\073\000\037\000\074\000\036\000\075\000\035\000\076\000\034\000\
\\077\000\033\000\078\000\032\000\079\000\031\000\080\000\030\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\018\000\066\000\027\000\064\000\
\\032\000\061\000\036\000\058\000\037\000\057\000\038\000\056\000\
\\043\000\053\000\044\000\052\000\045\000\051\000\047\000\049\000\
\\051\000\047\000\054\000\044\000\069\000\038\000\073\000\037\000\
\\074\000\036\000\075\000\035\000\076\000\034\000\077\000\033\000\
\\078\000\032\000\079\000\031\000\080\000\030\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\037\000\120\000\043\000\119\000\
\\044\000\118\000\047\000\242\000\051\000\116\000\057\000\115\000\
\\070\000\114\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\037\000\120\000\043\000\119\000\
\\044\000\118\000\047\000\242\000\051\000\116\000\057\000\250\000\
\\070\000\114\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\037\000\120\000\043\000\119\000\
\\044\000\118\000\047\000\242\000\051\000\116\000\070\000\114\000\000\000\
\\001\000\001\000\077\000\002\000\076\000\003\000\075\000\007\000\071\000\
\\008\000\070\000\010\000\069\000\000\000\
\\001\000\002\000\171\000\003\000\075\000\004\000\074\000\016\000\170\000\000\000\
\\001\000\002\000\171\000\003\000\075\000\004\000\074\000\016\000\170\000\
\\055\000\169\000\000\000\
\\001\000\002\000\171\000\003\000\075\000\004\000\074\000\016\000\170\000\
\\055\000\070\001\000\000\
\\001\000\002\000\171\000\003\000\075\000\004\000\074\000\016\000\009\001\
\\023\000\008\001\027\000\064\000\000\000\
\\001\000\002\000\171\000\003\000\075\000\004\000\074\000\016\000\009\001\
\\023\000\008\001\027\000\064\000\055\000\007\001\000\000\
\\001\000\003\000\156\003\004\000\156\003\005\000\156\003\011\000\155\003\
\\012\000\155\003\013\000\155\003\014\000\155\003\015\000\155\003\
\\016\000\156\003\017\000\155\003\019\000\155\003\020\000\155\003\
\\021\000\155\003\022\000\155\003\024\000\155\003\025\000\155\003\
\\026\000\155\003\027\000\155\003\028\000\155\003\029\000\155\003\
\\030\000\155\003\031\000\155\003\033\000\155\003\034\000\155\003\
\\035\000\155\003\039\000\155\003\040\000\155\003\041\000\155\003\
\\042\000\155\003\046\000\155\003\048\000\155\003\049\000\155\003\
\\050\000\155\003\052\000\155\003\053\000\155\003\055\000\155\003\
\\056\000\155\003\058\000\155\003\059\000\155\003\060\000\155\003\
\\062\000\155\003\064\000\155\003\065\000\155\003\066\000\155\003\
\\067\000\155\003\068\000\155\003\071\000\155\003\072\000\155\003\
\\081\000\155\003\000\000\
\\001\000\003\000\075\000\000\000\
\\001\000\003\000\075\000\004\000\074\000\000\000\
\\001\000\003\000\075\000\004\000\074\000\005\000\073\000\000\000\
\\001\000\003\000\075\000\004\000\074\000\005\000\073\000\006\000\072\000\
\\016\000\067\000\027\000\064\000\000\000\
\\001\000\003\000\075\000\004\000\074\000\005\000\073\000\006\000\072\000\
\\016\000\067\000\027\000\064\000\051\000\148\001\000\000\
\\001\000\003\000\075\000\004\000\074\000\005\000\073\000\009\000\121\000\
\\043\000\226\000\047\000\225\000\000\000\
\\001\000\003\000\075\000\004\000\074\000\005\000\073\000\016\000\063\001\000\000\
\\001\000\003\000\075\000\004\000\074\000\016\000\067\000\027\000\064\000\000\000\
\\001\000\003\000\075\000\004\000\074\000\016\000\067\000\027\000\064\000\
\\051\000\199\000\000\000\
\\001\000\003\000\075\000\005\000\073\000\000\000\
\\001\000\003\000\075\000\005\000\073\000\045\000\196\001\063\000\195\001\000\000\
\\001\000\003\000\075\000\005\000\073\000\066\000\223\001\000\000\
\\001\000\003\000\075\000\061\000\109\001\000\000\
\\001\000\003\000\075\000\066\000\015\002\000\000\
\\001\000\008\000\091\000\000\000\
\\001\000\008\000\091\000\016\000\093\000\000\000\
\\001\000\008\000\091\000\016\000\095\000\000\000\
\\001\000\009\000\121\000\000\000\
\\001\000\011\000\153\002\012\000\003\002\019\000\156\002\020\000\156\002\
\\022\000\153\002\025\000\153\002\026\000\153\002\029\000\153\002\
\\030\000\153\002\033\000\153\002\034\000\153\002\039\000\153\002\
\\041\000\153\002\042\000\153\002\046\000\153\002\048\000\153\002\
\\052\000\153\002\053\000\153\002\058\000\153\002\059\000\153\002\
\\062\000\153\002\064\000\153\002\066\000\153\002\067\000\153\002\
\\068\000\007\002\081\000\153\002\000\000\
\\001\000\011\000\153\002\012\000\079\002\019\000\171\002\020\000\171\002\
\\022\000\153\002\025\000\153\002\026\000\153\002\029\000\153\002\
\\030\000\153\002\033\000\153\002\034\000\153\002\039\000\153\002\
\\041\000\153\002\042\000\153\002\046\000\153\002\048\000\153\002\
\\052\000\153\002\053\000\153\002\058\000\153\002\059\000\153\002\
\\062\000\153\002\064\000\153\002\066\000\153\002\067\000\153\002\
\\068\000\007\002\081\000\153\002\000\000\
\\001\000\011\000\153\002\012\000\079\002\019\000\174\002\020\000\174\002\
\\022\000\153\002\025\000\153\002\026\000\153\002\029\000\153\002\
\\030\000\153\002\033\000\153\002\034\000\153\002\039\000\153\002\
\\041\000\153\002\042\000\153\002\046\000\153\002\048\000\153\002\
\\052\000\153\002\053\000\153\002\058\000\153\002\059\000\153\002\
\\062\000\153\002\064\000\153\002\066\000\153\002\067\000\153\002\
\\068\000\007\002\081\000\153\002\000\000\
\\001\000\011\000\161\002\012\000\161\002\019\000\158\002\020\000\158\002\
\\022\000\161\002\025\000\161\002\026\000\161\002\029\000\161\002\
\\030\000\161\002\033\000\161\002\034\000\161\002\039\000\161\002\
\\041\000\161\002\042\000\161\002\046\000\161\002\048\000\161\002\
\\052\000\161\002\053\000\161\002\058\000\161\002\059\000\161\002\
\\062\000\161\002\064\000\161\002\066\000\161\002\067\000\161\002\
\\081\000\161\002\000\000\
\\001\000\011\000\232\002\012\000\105\002\019\000\156\002\020\000\156\002\
\\022\000\232\002\026\000\232\002\029\000\232\002\030\000\232\002\
\\033\000\232\002\034\000\232\002\041\000\232\002\042\000\232\002\
\\046\000\232\002\048\000\232\002\052\000\232\002\053\000\232\002\
\\059\000\232\002\062\000\232\002\064\000\232\002\066\000\232\002\
\\067\000\232\002\068\000\108\002\081\000\232\002\000\000\
\\001\000\011\000\232\002\012\000\120\002\019\000\171\002\020\000\171\002\
\\022\000\232\002\026\000\232\002\029\000\232\002\030\000\232\002\
\\033\000\232\002\034\000\232\002\041\000\232\002\042\000\232\002\
\\046\000\232\002\048\000\232\002\052\000\232\002\053\000\232\002\
\\059\000\232\002\062\000\232\002\064\000\232\002\066\000\232\002\
\\067\000\232\002\068\000\108\002\081\000\232\002\000\000\
\\001\000\011\000\232\002\012\000\120\002\019\000\174\002\020\000\174\002\
\\022\000\232\002\026\000\232\002\029\000\232\002\030\000\232\002\
\\033\000\232\002\034\000\232\002\041\000\232\002\042\000\232\002\
\\046\000\232\002\048\000\232\002\052\000\232\002\053\000\232\002\
\\059\000\232\002\062\000\232\002\064\000\232\002\066\000\232\002\
\\067\000\232\002\068\000\108\002\081\000\232\002\000\000\
\\001\000\011\000\213\003\012\000\213\003\019\000\213\003\020\000\213\003\
\\022\000\213\003\025\000\213\003\026\000\213\003\029\000\213\003\
\\030\000\213\003\033\000\213\003\034\000\213\003\039\000\213\003\
\\041\000\213\003\042\000\213\003\046\000\213\003\047\000\217\003\
\\048\000\213\003\052\000\213\003\053\000\213\003\058\000\213\003\
\\059\000\213\003\062\000\213\003\064\000\213\003\066\000\213\003\
\\067\000\213\003\081\000\213\003\000\000\
\\001\000\013\000\088\000\019\000\087\000\024\000\208\001\035\000\086\000\
\\049\000\085\000\000\000\
\\001\000\013\000\088\000\019\000\087\000\030\000\240\000\035\000\086\000\
\\049\000\085\000\000\000\
\\001\000\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\
\\050\000\059\001\000\000\
\\001\000\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\
\\065\000\038\001\000\000\
\\001\000\014\000\064\001\015\000\019\002\000\000\
\\001\000\014\000\064\001\021\000\162\001\058\000\161\001\000\000\
\\001\000\014\000\064\001\027\000\174\001\000\000\
\\001\000\014\000\064\001\059\000\166\001\000\000\
\\001\000\014\000\064\001\059\000\168\001\000\000\
\\001\000\014\000\064\001\059\000\173\001\000\000\
\\001\000\014\000\064\001\059\000\175\001\000\000\
\\001\000\014\000\064\001\059\000\245\001\000\000\
\\001\000\014\000\064\001\059\000\246\001\000\000\
\\001\000\014\000\064\001\059\000\247\001\000\000\
\\001\000\014\000\064\001\059\000\248\001\000\000\
\\001\000\014\000\064\001\059\000\249\001\000\000\
\\001\000\015\000\189\003\019\000\189\003\021\000\189\003\027\000\208\003\
\\055\000\189\003\000\000\
\\001\000\015\000\190\003\019\000\190\003\021\000\190\003\027\000\209\003\
\\055\000\190\003\000\000\
\\001\000\015\000\191\003\019\000\191\003\021\000\191\003\027\000\210\003\
\\055\000\191\003\000\000\
\\001\000\019\000\228\000\000\000\
\\001\000\019\000\231\000\000\000\
\\001\000\019\000\237\000\000\000\
\\001\000\019\000\238\000\000\000\
\\001\000\019\000\239\000\000\000\
\\001\000\019\000\034\001\021\000\007\003\027\000\211\003\055\000\007\003\000\000\
\\001\000\019\000\072\001\000\000\
\\001\000\019\000\076\001\000\000\
\\001\000\019\000\077\001\000\000\
\\001\000\019\000\078\001\000\000\
\\001\000\019\000\079\001\000\000\
\\001\000\019\000\112\001\000\000\
\\001\000\019\000\165\001\000\000\
\\001\000\019\000\209\001\000\000\
\\001\000\019\000\009\002\020\000\008\002\000\000\
\\001\000\019\000\009\002\020\000\008\002\025\000\098\002\000\000\
\\001\000\019\000\009\002\020\000\008\002\058\000\080\002\000\000\
\\001\000\019\000\024\002\000\000\
\\001\000\019\000\028\002\000\000\
\\001\000\025\000\205\001\000\000\
\\001\000\025\000\206\001\000\000\
\\001\000\025\000\239\001\000\000\
\\001\000\025\000\016\002\000\000\
\\001\000\025\000\020\002\000\000\
\\001\000\025\000\052\002\000\000\
\\001\000\026\000\000\000\000\000\
\\001\000\027\000\243\000\000\000\
\\001\000\027\000\016\001\000\000\
\\001\000\027\000\035\001\000\000\
\\001\000\027\000\089\001\000\000\
\\001\000\027\000\100\001\000\000\
\\001\000\027\000\102\001\000\000\
\\001\000\027\000\104\001\000\000\
\\001\000\027\000\142\001\000\000\
\\001\000\027\000\150\001\000\000\
\\001\000\027\000\154\001\000\000\
\\001\000\027\000\029\002\000\000\
\\001\000\027\000\063\002\000\000\
\\001\000\027\000\070\002\000\000\
\\001\000\027\000\101\002\000\000\
\\001\000\031\000\144\001\000\000\
\\001\000\032\000\178\001\000\000\
\\001\000\039\000\024\001\000\000\
\\001\000\039\000\027\001\000\000\
\\001\000\039\000\119\001\000\000\
\\001\000\039\000\053\002\000\000\
\\001\000\047\000\040\001\000\000\
\\001\000\047\000\011\002\000\000\
\\001\000\055\000\036\001\000\000\
\\001\000\055\000\098\001\000\000\
\\001\000\055\000\163\001\000\000\
\\001\000\056\000\031\001\000\000\
\\001\000\056\000\039\001\000\000\
\\001\000\056\000\096\001\000\000\
\\001\000\056\000\101\001\000\000\
\\001\000\058\000\019\001\000\000\
\\001\000\058\000\020\001\000\000\
\\001\000\058\000\091\001\000\000\
\\001\000\058\000\093\001\000\000\
\\001\000\058\000\160\001\000\000\
\\001\000\058\000\211\001\000\000\
\\001\000\058\000\081\002\000\000\
\\001\000\059\000\042\002\000\000\
\\001\000\066\000\015\002\000\000\
\\001\000\071\000\061\001\000\000\
\\126\002\000\000\
\\127\002\000\000\
\\128\002\000\000\
\\129\002\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\011\000\068\000\016\000\067\000\018\000\066\000\
\\022\000\065\000\027\000\064\000\029\000\063\000\030\000\062\000\
\\032\000\061\000\033\000\060\000\034\000\059\000\036\000\058\000\
\\037\000\057\000\038\000\056\000\041\000\055\000\042\000\054\000\
\\043\000\053\000\044\000\052\000\045\000\051\000\046\000\050\000\
\\047\000\049\000\048\000\048\000\051\000\047\000\052\000\046\000\
\\053\000\045\000\054\000\044\000\059\000\043\000\062\000\042\000\
\\064\000\041\000\066\000\040\000\067\000\039\000\069\000\038\000\
\\073\000\037\000\074\000\036\000\075\000\035\000\076\000\034\000\
\\077\000\033\000\078\000\032\000\079\000\031\000\080\000\030\000\
\\081\000\029\000\000\000\
\\129\002\011\000\068\000\022\000\065\000\029\000\063\000\030\000\062\000\
\\033\000\060\000\034\000\059\000\041\000\055\000\042\000\054\000\
\\046\000\050\000\048\000\048\000\052\000\046\000\053\000\045\000\
\\059\000\043\000\062\000\042\000\064\000\041\000\066\000\040\000\
\\067\000\039\000\081\000\029\000\000\000\
\\129\002\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\
\\059\000\043\000\000\000\
\\130\002\000\000\
\\131\002\000\000\
\\132\002\000\000\
\\133\002\000\000\
\\134\002\000\000\
\\135\002\000\000\
\\136\002\000\000\
\\137\002\000\000\
\\138\002\003\000\075\000\005\000\073\000\011\000\068\000\022\000\065\000\
\\029\000\063\000\030\000\062\000\033\000\060\000\041\000\055\000\
\\042\000\054\000\045\000\196\001\046\000\050\000\048\000\048\000\
\\052\000\046\000\053\000\045\000\059\000\152\000\063\000\195\001\
\\064\000\041\000\066\000\040\000\067\000\039\000\081\000\029\000\000\000\
\\138\002\011\000\068\000\022\000\065\000\029\000\063\000\030\000\062\000\
\\033\000\060\000\041\000\055\000\042\000\054\000\046\000\050\000\
\\048\000\048\000\052\000\046\000\053\000\045\000\059\000\152\000\
\\064\000\041\000\066\000\040\000\067\000\039\000\081\000\029\000\000\000\
\\139\002\000\000\
\\140\002\000\000\
\\141\002\000\000\
\\142\002\000\000\
\\143\002\000\000\
\\144\002\000\000\
\\145\002\000\000\
\\146\002\000\000\
\\147\002\000\000\
\\148\002\000\000\
\\149\002\000\000\
\\150\002\000\000\
\\151\002\000\000\
\\152\002\000\000\
\\153\002\012\000\003\002\000\000\
\\154\002\000\000\
\\155\002\000\000\
\\156\002\068\000\199\001\000\000\
\\157\002\000\000\
\\158\002\000\000\
\\159\002\000\000\
\\160\002\000\000\
\\162\002\000\000\
\\163\002\000\000\
\\164\002\000\000\
\\165\002\000\000\
\\166\002\000\000\
\\167\002\000\000\
\\168\002\068\000\199\001\000\000\
\\169\002\000\000\
\\170\002\000\000\
\\171\002\012\000\056\002\068\000\199\001\000\000\
\\172\002\000\000\
\\173\002\000\000\
\\174\002\012\000\056\002\068\000\199\001\000\000\
\\175\002\000\000\
\\176\002\000\000\
\\177\002\000\000\
\\178\002\000\000\
\\179\002\000\000\
\\179\002\003\000\075\000\000\000\
\\180\002\000\000\
\\181\002\012\000\203\001\068\000\202\001\000\000\
\\181\002\012\000\060\002\068\000\202\001\000\000\
\\182\002\000\000\
\\183\002\000\000\
\\184\002\000\000\
\\185\002\000\000\
\\186\002\014\000\064\001\000\000\
\\187\002\019\000\015\001\020\000\014\001\000\000\
\\188\002\000\000\
\\189\002\000\000\
\\190\002\003\000\075\000\022\000\139\001\028\000\138\001\029\000\137\001\
\\040\000\136\001\059\000\135\001\060\000\134\001\064\000\133\001\
\\066\000\132\001\067\000\131\001\000\000\
\\190\002\022\000\139\001\028\000\138\001\029\000\137\001\040\000\136\001\
\\059\000\135\001\060\000\134\001\064\000\133\001\066\000\132\001\
\\067\000\131\001\000\000\
\\191\002\000\000\
\\192\002\000\000\
\\193\002\000\000\
\\194\002\000\000\
\\195\002\000\000\
\\196\002\000\000\
\\197\002\000\000\
\\198\002\000\000\
\\199\002\000\000\
\\200\002\000\000\
\\201\002\000\000\
\\202\002\000\000\
\\203\002\000\000\
\\204\002\000\000\
\\205\002\000\000\
\\206\002\027\000\029\002\000\000\
\\207\002\000\000\
\\208\002\027\000\070\002\000\000\
\\209\002\000\000\
\\210\002\000\000\
\\211\002\012\000\092\002\068\000\091\002\000\000\
\\211\002\012\000\117\002\068\000\091\002\000\000\
\\212\002\000\000\
\\213\002\000\000\
\\214\002\000\000\
\\215\002\000\000\
\\216\002\012\000\027\002\000\000\
\\217\002\000\000\
\\218\002\000\000\
\\218\002\027\000\102\001\000\000\
\\219\002\012\000\025\002\000\000\
\\220\002\000\000\
\\221\002\014\000\064\001\000\000\
\\222\002\012\000\034\002\000\000\
\\223\002\000\000\
\\224\002\000\000\
\\225\002\050\000\036\002\000\000\
\\226\002\014\000\064\001\000\000\
\\227\002\000\000\
\\228\002\000\000\
\\229\002\000\000\
\\230\002\000\000\
\\231\002\000\000\
\\232\002\012\000\105\002\000\000\
\\233\002\000\000\
\\234\002\000\000\
\\235\002\000\000\
\\236\002\000\000\
\\237\002\000\000\
\\238\002\011\000\068\000\022\000\065\000\029\000\063\000\030\000\062\000\
\\033\000\060\000\041\000\055\000\042\000\054\000\046\000\158\000\
\\048\000\048\000\052\000\046\000\053\000\045\000\059\000\157\000\
\\066\000\040\000\067\000\039\000\000\000\
\\239\002\000\000\
\\240\002\000\000\
\\241\002\000\000\
\\242\002\000\000\
\\243\002\000\000\
\\244\002\000\000\
\\245\002\000\000\
\\246\002\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\000\000\
\\247\002\000\000\
\\248\002\000\000\
\\249\002\000\000\
\\250\002\000\000\
\\251\002\000\000\
\\252\002\000\000\
\\253\002\000\000\
\\254\002\000\000\
\\255\002\000\000\
\\000\003\000\000\
\\001\003\012\000\176\001\013\000\088\000\019\000\087\000\035\000\086\000\
\\049\000\085\000\000\000\
\\002\003\000\000\
\\003\003\000\000\
\\004\003\000\000\
\\005\003\012\000\043\002\000\000\
\\006\003\000\000\
\\007\003\019\000\034\001\000\000\
\\008\003\014\000\064\001\000\000\
\\009\003\012\000\043\001\000\000\
\\010\003\000\000\
\\011\003\000\000\
\\012\003\000\000\
\\013\003\017\000\044\001\000\000\
\\014\003\000\000\
\\015\003\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\000\000\
\\016\003\000\000\
\\017\003\000\000\
\\018\003\012\000\012\001\000\000\
\\019\003\000\000\
\\020\003\014\000\064\001\000\000\
\\021\003\000\000\
\\022\003\009\000\121\000\047\000\128\000\000\000\
\\023\003\000\000\
\\024\003\000\000\
\\025\003\021\000\092\001\000\000\
\\026\003\000\000\
\\027\003\017\000\075\002\000\000\
\\028\003\000\000\
\\029\003\050\000\074\002\000\000\
\\030\003\014\000\064\001\000\000\
\\031\003\000\000\
\\032\003\000\000\
\\033\003\012\000\053\001\000\000\
\\034\003\000\000\
\\035\003\000\000\
\\036\003\000\000\
\\037\003\027\000\052\001\050\000\051\001\000\000\
\\038\003\014\000\064\001\000\000\
\\039\003\000\000\
\\040\003\000\000\
\\041\003\002\000\139\000\000\000\
\\042\003\000\000\
\\043\003\002\000\139\000\000\000\
\\044\003\000\000\
\\045\003\000\000\
\\046\003\002\000\139\000\000\000\
\\047\003\000\000\
\\048\003\000\000\
\\049\003\000\000\
\\050\003\000\000\
\\051\003\000\000\
\\052\003\000\000\
\\053\003\000\000\
\\054\003\000\000\
\\055\003\000\000\
\\056\003\072\000\057\001\000\000\
\\057\003\000\000\
\\058\003\000\000\
\\059\003\012\000\058\001\000\000\
\\060\003\000\000\
\\061\003\000\000\
\\062\003\000\000\
\\063\003\012\000\086\002\000\000\
\\064\003\000\000\
\\065\003\000\000\
\\066\003\017\000\143\001\000\000\
\\067\003\000\000\
\\068\003\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\000\000\
\\069\003\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\000\000\
\\070\003\000\000\
\\071\003\000\000\
\\072\003\021\000\037\001\000\000\
\\073\003\000\000\
\\074\003\000\000\
\\075\003\000\000\
\\076\003\000\000\
\\077\003\013\000\088\000\019\000\087\000\000\000\
\\078\003\019\000\087\000\000\000\
\\079\003\014\000\064\001\000\000\
\\080\003\000\000\
\\081\003\000\000\
\\082\003\000\000\
\\083\003\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\000\000\
\\084\003\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\000\000\
\\085\003\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\000\000\
\\086\003\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\027\000\064\000\036\000\058\000\
\\037\000\057\000\043\000\053\000\044\000\052\000\045\000\051\000\
\\047\000\049\000\051\000\047\000\073\000\037\000\074\000\036\000\
\\075\000\035\000\076\000\034\000\077\000\033\000\078\000\032\000\
\\079\000\031\000\080\000\030\000\000\000\
\\087\003\000\000\
\\088\003\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\027\000\064\000\036\000\058\000\
\\037\000\057\000\043\000\053\000\044\000\052\000\045\000\051\000\
\\047\000\049\000\051\000\047\000\073\000\037\000\074\000\036\000\
\\075\000\035\000\076\000\034\000\077\000\033\000\078\000\032\000\
\\079\000\031\000\080\000\030\000\000\000\
\\089\003\000\000\
\\090\003\000\000\
\\091\003\000\000\
\\092\003\000\000\
\\093\003\000\000\
\\094\003\000\000\
\\095\003\000\000\
\\096\003\000\000\
\\097\003\000\000\
\\098\003\000\000\
\\099\003\000\000\
\\100\003\000\000\
\\101\003\000\000\
\\102\003\000\000\
\\103\003\000\000\
\\104\003\000\000\
\\105\003\000\000\
\\106\003\000\000\
\\107\003\000\000\
\\108\003\000\000\
\\109\003\000\000\
\\110\003\000\000\
\\111\003\000\000\
\\112\003\000\000\
\\113\003\003\000\075\000\000\000\
\\114\003\000\000\
\\115\003\003\000\075\000\000\000\
\\116\003\000\000\
\\117\003\000\000\
\\118\003\013\000\088\000\019\000\087\000\021\000\023\001\035\000\086\000\
\\049\000\085\000\000\000\
\\119\003\013\000\088\000\019\000\087\000\021\000\032\001\035\000\086\000\
\\049\000\085\000\000\000\
\\120\003\000\000\
\\121\003\000\000\
\\122\003\015\000\246\000\017\000\245\000\019\000\244\000\000\000\
\\123\003\000\000\
\\124\003\015\000\246\000\019\000\244\000\000\000\
\\125\003\014\000\064\001\000\000\
\\126\003\000\000\
\\127\003\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\037\000\120\000\043\000\119\000\
\\044\000\118\000\047\000\242\000\051\000\116\000\070\000\114\000\000\000\
\\128\003\000\000\
\\129\003\000\000\
\\130\003\000\000\
\\131\003\000\000\
\\132\003\000\000\
\\133\003\000\000\
\\134\003\000\000\
\\135\003\000\000\
\\136\003\000\000\
\\137\003\000\000\
\\138\003\000\000\
\\139\003\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\009\000\121\000\010\000\069\000\016\000\067\000\037\000\120\000\
\\043\000\119\000\044\000\118\000\047\000\242\000\051\000\116\000\
\\070\000\114\000\000\000\
\\139\003\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\037\000\120\000\043\000\119\000\
\\044\000\118\000\047\000\242\000\051\000\116\000\070\000\114\000\000\000\
\\140\003\000\000\
\\141\003\015\000\246\000\017\000\177\001\019\000\244\000\000\000\
\\142\003\000\000\
\\143\003\021\000\095\001\000\000\
\\144\003\000\000\
\\145\003\000\000\
\\146\003\021\000\099\001\000\000\
\\147\003\000\000\
\\148\003\000\000\
\\149\003\000\000\
\\150\003\015\000\182\001\000\000\
\\151\003\000\000\
\\152\003\000\000\
\\153\003\000\000\
\\154\003\014\000\064\001\000\000\
\\156\003\000\000\
\\157\003\000\000\
\\158\003\000\000\
\\159\003\000\000\
\\160\003\000\000\
\\161\003\000\000\
\\162\003\000\000\
\\163\003\000\000\
\\164\003\014\000\064\001\000\000\
\\165\003\000\000\
\\166\003\021\000\164\001\000\000\
\\167\003\000\000\
\\168\003\003\000\075\000\004\000\074\000\005\000\073\000\016\000\063\001\000\000\
\\169\003\014\000\064\001\021\000\162\001\000\000\
\\170\003\000\000\
\\171\003\017\000\189\000\000\000\
\\171\003\017\000\189\000\022\000\238\001\000\000\
\\172\003\000\000\
\\173\003\000\000\
\\174\003\013\000\088\000\019\000\087\000\021\000\023\001\035\000\086\000\
\\049\000\085\000\059\000\022\001\000\000\
\\174\003\013\000\088\000\019\000\087\000\035\000\086\000\049\000\085\000\
\\059\000\022\001\000\000\
\\175\003\001\000\077\000\002\000\076\000\003\000\075\000\004\000\074\000\
\\005\000\073\000\006\000\072\000\007\000\071\000\008\000\070\000\
\\010\000\069\000\016\000\067\000\018\000\066\000\027\000\064\000\
\\032\000\061\000\036\000\058\000\037\000\057\000\038\000\056\000\
\\043\000\053\000\044\000\052\000\045\000\051\000\047\000\049\000\
\\051\000\047\000\054\000\044\000\069\000\038\000\073\000\037\000\
\\074\000\036\000\075\000\035\000\076\000\034\000\077\000\033\000\
\\078\000\032\000\079\000\031\000\080\000\030\000\000\000\
\\176\003\000\000\
\\177\003\000\000\
\\178\003\000\000\
\\179\003\000\000\
\\180\003\000\000\
\\181\003\000\000\
\\182\003\000\000\
\\183\003\000\000\
\\184\003\000\000\
\\185\003\000\000\
\\186\003\000\000\
\\187\003\000\000\
\\188\003\000\000\
\\189\003\000\000\
\\190\003\000\000\
\\191\003\000\000\
\\192\003\000\000\
\\193\003\000\000\
\\194\003\000\000\
\\195\003\000\000\
\\196\003\000\000\
\\197\003\000\000\
\\198\003\000\000\
\\199\003\000\000\
\\200\003\000\000\
\\201\003\000\000\
\\202\003\000\000\
\\203\003\000\000\
\\204\003\000\000\
\\205\003\000\000\
\\206\003\000\000\
\\207\003\000\000\
\\208\003\000\000\
\\209\003\000\000\
\\210\003\000\000\
\\211\003\000\000\
\\212\003\000\000\
\\213\003\000\000\
\\214\003\000\000\
\\215\003\000\000\
\\216\003\000\000\
\\217\003\000\000\
\\218\003\003\000\075\000\004\000\074\000\016\000\067\000\027\000\064\000\000\000\
\\219\003\000\000\
\\220\003\003\000\075\000\000\000\
\\221\003\000\000\
\\222\003\003\000\075\000\005\000\073\000\000\000\
\\223\003\000\000\
\"
val actionRowNumbers =
"\130\000\190\001\205\001\208\001\
\\129\000\136\000\131\000\145\000\
\\137\000\200\001\199\001\209\001\
\\210\001\096\001\207\001\206\001\
\\189\001\024\000\135\000\127\000\
\\083\001\132\000\148\000\188\001\
\\099\001\088\001\094\001\149\000\
\\031\000\032\000\033\000\031\000\
\\031\000\031\000\031\000\031\000\
\\006\000\001\000\030\001\017\000\
\\017\000\130\000\006\000\054\001\
\\026\000\020\000\053\001\005\000\
\\142\000\246\000\003\000\012\000\
\\051\001\049\001\006\000\004\000\
\\011\000\017\000\000\000\179\001\
\\006\000\025\000\202\001\030\001\
\\006\000\201\001\030\001\057\001\
\\192\001\191\001\198\001\197\001\
\\196\001\195\001\056\001\193\001\
\\134\000\097\001\006\001\203\001\
\\204\001\228\001\128\000\006\000\
\\179\001\022\000\006\000\095\001\
\\062\000\194\001\123\001\063\000\
\\121\001\121\001\121\001\123\001\
\\064\000\065\000\066\000\044\000\
\\252\000\008\001\007\000\031\001\
\\088\000\138\001\131\001\130\001\
\\140\001\134\001\137\001\135\001\
\\141\001\008\000\020\000\147\001\
\\148\001\015\000\148\001\213\001\
\\029\001\018\000\001\001\025\001\
\\024\001\026\001\034\000\192\000\
\\146\000\223\001\089\000\138\000\
\\226\001\133\000\093\001\024\000\
\\055\001\058\001\224\001\005\001\
\\232\001\225\001\098\001\117\000\
\\118\000\183\001\105\001\140\000\
\\104\000\142\000\142\000\105\000\
\\250\000\249\000\246\000\246\000\
\\246\000\113\000\127\001\109\001\
\\219\001\218\001\222\001\067\000\
\\090\000\110\000\080\001\104\001\
\\220\001\059\001\052\001\050\001\
\\046\000\114\000\102\001\221\001\
\\100\001\227\001\139\000\108\000\
\\002\000\009\000\255\000\017\001\
\\019\001\021\001\015\001\182\001\
\\181\001\009\000\089\001\254\000\
\\211\001\045\001\004\001\041\001\
\\039\001\024\000\018\000\061\001\
\\066\001\064\001\067\001\060\001\
\\002\001\062\001\045\000\018\000\
\\126\000\229\001\085\001\084\001\
\\165\001\161\001\216\001\016\000\
\\023\000\087\001\162\001\215\001\
\\214\001\171\001\217\001\022\000\
\\013\000\086\001\022\000\068\000\
\\123\001\022\000\121\001\069\000\
\\070\000\071\000\072\000\022\000\
\\022\000\022\000\006\000\253\000\
\\148\001\006\000\022\000\009\000\
\\009\000\136\001\011\001\091\000\
\\008\000\139\001\119\000\033\001\
\\120\000\152\001\115\000\015\001\
\\060\000\059\000\111\000\155\001\
\\092\000\145\001\156\001\061\000\
\\116\000\093\000\030\001\094\000\
\\029\000\029\000\029\000\073\000\
\\233\001\106\001\107\001\081\001\
\\185\001\006\000\142\000\144\000\
\\143\000\006\000\247\000\248\000\
\\106\000\108\001\006\000\078\001\
\\022\000\006\000\103\001\011\000\
\\006\000\101\001\195\000\000\001\
\\020\001\002\000\009\000\095\000\
\\073\001\074\001\102\000\044\001\
\\043\001\022\000\021\000\025\000\
\\040\001\096\000\065\001\030\001\
\\030\001\179\001\097\000\246\000\
\\170\001\022\000\022\000\121\000\
\\048\000\112\000\174\001\074\000\
\\167\001\050\000\022\000\124\001\
\\051\000\122\001\022\000\022\000\
\\022\000\022\000\052\000\049\000\
\\053\000\091\001\009\001\133\001\
\\150\001\129\001\132\001\103\000\
\\012\001\032\001\034\000\142\001\
\\149\001\009\000\143\001\159\001\
\\146\001\014\000\009\000\144\001\
\\022\000\027\001\027\000\182\000\
\\181\000\171\000\194\000\196\000\
\\193\000\185\000\022\000\082\001\
\\184\001\125\001\126\001\081\000\
\\082\000\246\000\128\001\016\001\
\\077\001\079\001\043\000\075\000\
\\245\000\199\000\196\000\209\000\
\\122\000\024\000\030\001\017\000\
\\028\000\196\000\029\000\024\000\
\\030\001\030\001\018\001\022\001\
\\006\000\009\000\006\000\046\001\
\\212\001\047\001\020\000\042\001\
\\180\001\070\001\068\001\090\001\
\\179\001\083\000\164\001\176\001\
\\175\001\163\001\019\000\169\001\
\\022\000\166\001\011\000\022\000\
\\118\001\054\000\120\001\055\000\
\\056\000\057\000\058\000\114\001\
\\010\000\112\001\007\000\009\000\
\\179\001\034\001\152\001\158\001\
\\009\000\154\001\157\001\028\001\
\\159\000\038\000\157\000\035\000\
\\076\000\150\000\042\000\165\000\
\\109\000\142\000\142\000\173\000\
\\172\000\125\000\084\000\180\000\
\\125\000\017\000\047\000\147\000\
\\110\001\085\000\006\000\029\000\
\\198\000\192\000\079\000\200\000\
\\227\000\018\000\201\000\223\000\
\\202\000\080\000\206\000\211\000\
\\098\000\019\000\197\000\183\000\
\\207\000\205\000\230\000\233\000\
\\018\000\203\000\204\000\023\001\
\\075\001\076\001\048\001\025\000\
\\019\000\003\001\168\001\178\001\
\\177\001\173\001\172\001\119\001\
\\116\001\117\001\115\001\111\001\
\\187\001\124\000\186\001\010\001\
\\151\001\013\001\153\001\160\001\
\\152\000\017\000\161\000\153\000\
\\151\000\125\000\029\000\029\000\
\\167\000\141\000\086\000\107\000\
\\174\000\030\001\184\000\186\000\
\\187\000\020\000\251\000\092\001\
\\244\000\099\000\022\000\024\000\
\\226\000\030\001\029\000\026\000\
\\210\000\100\000\208\000\230\001\
\\024\000\232\000\022\000\225\000\
\\037\001\069\001\035\001\063\001\
\\113\001\008\000\158\000\036\000\
\\164\000\163\000\162\000\160\000\
\\078\000\123\000\166\000\027\000\
\\175\000\176\000\125\000\019\000\
\\188\000\189\000\030\000\007\001\
\\071\001\027\000\229\000\228\000\
\\224\000\217\000\213\000\212\000\
\\019\000\231\001\231\000\234\000\
\\022\000\025\000\014\001\154\000\
\\155\000\030\000\169\000\170\000\
\\077\000\177\000\101\000\186\000\
\\020\000\240\000\039\000\235\000\
\\216\000\125\000\017\000\215\000\
\\214\000\038\001\036\001\037\000\
\\168\000\179\000\178\000\022\000\
\\190\000\072\001\237\000\017\000\
\\238\000\236\000\125\000\218\000\
\\219\000\156\000\191\000\241\000\
\\040\000\220\000\221\000\030\000\
\\239\000\242\000\030\000\218\000\
\\041\000\222\000\243\000\087\000"
val gotoT =
"\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\030\000\022\000\042\000\021\000\046\000\020\000\047\000\019\000\
\\048\000\018\000\052\000\017\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\085\000\123\002\094\000\010\000\095\000\009\000\114\000\008\000\
\\115\000\007\000\134\000\006\000\135\000\005\000\136\000\004\000\
\\157\000\003\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\030\000\022\000\048\000\018\000\052\000\017\000\114\000\008\000\
\\115\000\007\000\134\000\006\000\135\000\005\000\136\000\076\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\026\000\005\000\077\000\014\000\024\000\015\000\023\000\
\\060\000\016\000\062\000\015\000\063\000\014\000\069\000\013\000\
\\070\000\012\000\071\000\011\000\094\000\010\000\095\000\009\000\
\\157\000\003\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\010\000\095\000\009\000\156\000\081\000\157\000\080\000\
\\158\000\079\000\159\000\078\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\048\000\082\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\026\000\005\000\087\000\014\000\024\000\015\000\023\000\
\\060\000\016\000\062\000\015\000\063\000\014\000\069\000\013\000\
\\070\000\012\000\071\000\011\000\094\000\010\000\095\000\009\000\
\\157\000\003\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\127\000\088\000\000\000\
\\127\000\090\000\000\000\
\\127\000\092\000\000\000\
\\127\000\094\000\000\000\
\\127\000\095\000\000\000\
\\127\000\096\000\000\000\
\\127\000\097\000\000\000\
\\127\000\098\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\099\000\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\104\000\
\\094\000\010\000\095\000\009\000\148\000\103\000\151\000\102\000\
\\152\000\101\000\153\000\100\000\158\000\002\000\165\000\001\000\000\000\
\\129\000\125\000\130\000\124\000\131\000\123\000\145\000\122\000\
\\148\000\103\000\150\000\121\000\151\000\120\000\000\000\
\\094\000\129\000\109\000\128\000\126\000\127\000\000\000\
\\094\000\132\000\096\000\131\000\104\000\130\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\030\000\022\000\042\000\021\000\046\000\020\000\047\000\133\000\
\\048\000\018\000\052\000\017\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\114\000\008\000\115\000\007\000\
\\134\000\006\000\135\000\005\000\136\000\004\000\157\000\003\000\
\\158\000\002\000\165\000\001\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\134\000\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\033\000\136\000\084\000\135\000\000\000\
\\062\000\141\000\064\000\140\000\066\000\139\000\094\000\129\000\
\\126\000\138\000\000\000\
\\062\000\015\000\063\000\014\000\069\000\142\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\000\000\
\\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\145\000\043\000\144\000\045\000\143\000\046\000\020\000\
\\060\000\016\000\062\000\015\000\063\000\014\000\069\000\013\000\
\\070\000\012\000\071\000\011\000\094\000\010\000\095\000\009\000\
\\157\000\003\000\158\000\002\000\165\000\001\000\000\000\
\\030\000\022\000\052\000\017\000\114\000\149\000\115\000\007\000\
\\116\000\148\000\117\000\147\000\000\000\
\\028\000\154\000\029\000\153\000\030\000\152\000\031\000\151\000\
\\052\000\017\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\158\000\044\000\157\000\046\000\020\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\069\000\013\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\165\000\001\000\000\000\
\\038\000\166\000\039\000\165\000\051\000\164\000\059\000\163\000\
\\074\000\162\000\094\000\161\000\095\000\160\000\000\000\
\\033\000\170\000\000\000\
\\033\000\171\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\172\000\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\158\000\044\000\173\000\046\000\020\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\069\000\013\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\165\000\001\000\000\000\
\\051\000\176\000\059\000\175\000\074\000\162\000\094\000\161\000\
\\095\000\160\000\000\000\
\\050\000\179\000\053\000\178\000\094\000\177\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\186\000\009\000\185\000\
\\010\000\184\000\011\000\183\000\014\000\108\000\015\000\023\000\
\\058\000\182\000\060\000\016\000\062\000\015\000\063\000\014\000\
\\071\000\105\000\078\000\181\000\094\000\010\000\095\000\009\000\
\\148\000\103\000\151\000\180\000\158\000\002\000\165\000\001\000\000\000\
\\073\000\190\000\077\000\189\000\078\000\188\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\191\000\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\013\000\196\000\034\000\195\000\037\000\194\000\076\000\193\000\
\\094\000\010\000\095\000\009\000\156\000\192\000\157\000\080\000\
\\158\000\079\000\000\000\
\\000\000\
\\022\000\205\000\023\000\204\000\024\000\203\000\025\000\202\000\
\\026\000\201\000\027\000\200\000\086\000\199\000\148\000\103\000\
\\150\000\198\000\151\000\120\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\206\000\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\022\000\208\000\025\000\202\000\026\000\201\000\027\000\200\000\
\\148\000\103\000\150\000\207\000\151\000\120\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\010\000\095\000\009\000\156\000\081\000\157\000\080\000\
\\158\000\079\000\159\000\209\000\000\000\
\\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\210\000\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\073\000\211\000\077\000\189\000\078\000\188\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\217\000\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\225\000\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\228\000\128\000\227\000\000\000\
\\000\000\
\\007\000\231\000\094\000\230\000\000\000\
\\007\000\232\000\094\000\230\000\000\000\
\\007\000\233\000\094\000\230\000\000\000\
\\094\000\228\000\128\000\234\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\104\000\
\\094\000\010\000\095\000\009\000\152\000\101\000\153\000\239\000\
\\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\245\000\014\000\108\000\
\\015\000\023\000\060\000\016\000\062\000\015\000\063\000\014\000\
\\071\000\105\000\094\000\010\000\095\000\009\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\247\000\
\\089\000\246\000\094\000\010\000\095\000\009\000\158\000\002\000\
\\165\000\001\000\000\000\
\\062\000\015\000\063\000\014\000\069\000\249\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\253\000\
\\083\000\252\000\094\000\010\000\095\000\009\000\148\000\251\000\
\\149\000\250\000\158\000\002\000\165\000\001\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\253\000\
\\083\000\254\000\094\000\010\000\095\000\009\000\158\000\002\000\
\\165\000\001\000\000\000\
\\051\000\004\001\059\000\175\000\074\000\162\000\081\000\003\001\
\\082\000\002\001\094\000\001\001\095\000\000\001\156\000\255\000\
\\157\000\080\000\158\000\079\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\253\000\
\\083\000\008\001\094\000\010\000\095\000\009\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\094\000\220\000\095\000\219\000\143\000\009\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\148\000\251\000\149\000\250\000\000\000\
\\099\000\011\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\010\000\095\000\009\000\156\000\015\001\157\000\080\000\
\\158\000\079\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\141\000\064\000\140\000\066\000\016\001\094\000\129\000\
\\126\000\138\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\079\000\019\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\030\000\022\000\052\000\017\000\114\000\149\000\115\000\007\000\
\\116\000\023\001\117\000\147\000\000\000\
\\030\000\022\000\052\000\017\000\114\000\149\000\115\000\007\000\
\\116\000\024\001\117\000\147\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\028\000\154\000\029\000\153\000\030\000\152\000\031\000\026\001\
\\052\000\017\000\000\000\
\\028\000\154\000\029\000\153\000\030\000\152\000\031\000\027\001\
\\052\000\017\000\000\000\
\\028\000\154\000\029\000\153\000\030\000\152\000\031\000\028\001\
\\052\000\017\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\017\000\031\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\186\000\009\000\185\000\
\\010\000\184\000\011\000\183\000\014\000\108\000\015\000\023\000\
\\058\000\039\001\060\000\016\000\062\000\015\000\063\000\014\000\
\\071\000\105\000\078\000\181\000\094\000\010\000\095\000\009\000\
\\158\000\002\000\165\000\001\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\186\000\009\000\185\000\
\\010\000\040\001\014\000\108\000\015\000\023\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\094\000\010\000\
\\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\017\000\043\001\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\046\001\
\\087\000\045\001\088\000\044\001\094\000\010\000\095\000\009\000\
\\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\035\000\048\001\036\000\047\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\013\000\052\001\094\000\010\000\095\000\009\000\156\000\192\000\
\\157\000\080\000\158\000\079\000\000\000\
\\094\000\220\000\095\000\219\000\143\000\053\001\000\000\
\\000\000\
\\000\000\
\\164\000\054\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\220\000\095\000\219\000\143\000\058\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\060\001\094\000\220\000\095\000\219\000\
\\143\000\214\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\064\001\139\000\216\000\140\000\215\000\
\\141\000\063\001\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\051\000\067\001\059\000\175\000\074\000\162\000\094\000\161\000\
\\095\000\160\000\132\000\066\001\133\000\065\001\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\069\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\094\000\228\000\128\000\071\001\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\072\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\007\000\073\001\094\000\230\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\078\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\079\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\080\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\081\001\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\253\000\
\\083\000\252\000\094\000\010\000\095\000\009\000\158\000\002\000\
\\165\000\001\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\082\001\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\083\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\008\000\085\001\
\\014\000\108\000\015\000\023\000\020\000\084\001\021\000\106\000\
\\060\000\016\000\062\000\015\000\063\000\014\000\071\000\105\000\
\\094\000\010\000\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\086\001\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\094\000\010\000\
\\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\247\000\
\\089\000\088\001\094\000\010\000\095\000\009\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\012\000\092\001\000\000\
\\000\000\
\\017\000\095\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\129\000\125\000\131\000\101\001\148\000\103\000\150\000\121\000\
\\151\000\120\000\000\000\
\\000\000\
\\094\000\132\000\100\000\106\001\101\000\105\001\102\000\104\001\
\\104\000\103\001\000\000\
\\094\000\132\000\100\000\108\001\101\000\105\001\102\000\104\001\
\\104\000\103\001\000\000\
\\094\000\132\000\101\000\109\001\102\000\104\001\104\000\103\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\112\001\045\000\111\001\046\000\020\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\069\000\013\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\165\000\001\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\114\001\043\000\113\001\046\000\020\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\069\000\013\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\165\000\001\000\000\000\
\\030\000\022\000\052\000\017\000\114\000\149\000\115\000\007\000\
\\116\000\115\001\117\000\147\000\000\000\
\\000\000\
\\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\112\001\045\000\116\001\046\000\020\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\069\000\013\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\158\000\044\000\118\001\046\000\020\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\069\000\013\000\070\000\012\000\
\\071\000\011\000\094\000\010\000\095\000\009\000\157\000\003\000\
\\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\119\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\120\001\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\038\000\166\000\039\000\121\001\051\000\164\000\059\000\163\000\
\\074\000\162\000\094\000\161\000\095\000\160\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\122\001\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\049\000\128\001\093\000\127\001\094\000\129\000\106\000\126\001\
\\107\000\125\001\108\000\124\001\126\000\123\001\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\186\000\009\000\185\000\
\\010\000\184\000\011\000\183\000\014\000\108\000\015\000\023\000\
\\058\000\138\001\060\000\016\000\062\000\015\000\063\000\014\000\
\\071\000\105\000\078\000\181\000\094\000\010\000\095\000\009\000\
\\158\000\002\000\165\000\001\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\186\000\009\000\185\000\
\\010\000\139\001\014\000\108\000\015\000\023\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\094\000\010\000\
\\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\143\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\061\000\145\001\062\000\015\000\063\000\014\000\069\000\144\001\
\\070\000\012\000\071\000\011\000\094\000\010\000\095\000\009\000\
\\157\000\003\000\158\000\002\000\000\000\
\\013\000\196\000\034\000\195\000\037\000\147\001\076\000\193\000\
\\094\000\010\000\095\000\009\000\156\000\192\000\157\000\080\000\
\\158\000\079\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\129\000\125\000\130\000\124\000\131\000\123\000\145\000\149\001\
\\148\000\103\000\150\000\121\000\151\000\120\000\000\000\
\\025\000\202\000\027\000\150\001\148\000\103\000\150\000\207\000\
\\151\000\120\000\000\000\
\\073\000\151\001\077\000\189\000\078\000\188\000\000\000\
\\000\000\
\\028\000\154\000\029\000\153\000\030\000\152\000\031\000\153\001\
\\052\000\017\000\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\156\001\139\000\155\001\140\000\154\001\143\000\214\000\
\\148\000\212\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\157\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\165\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\167\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\168\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\169\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\170\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\148\000\251\000\149\000\177\001\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\178\001\
\\094\000\010\000\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\075\000\179\001\000\000\
\\000\000\
\\051\000\004\001\059\000\175\000\074\000\162\000\081\000\003\001\
\\082\000\181\001\094\000\001\001\095\000\000\001\156\000\255\000\
\\157\000\080\000\158\000\079\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\182\001\
\\094\000\010\000\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\183\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\050\000\192\001\062\000\141\000\064\000\191\001\094\000\190\001\
\\110\000\189\001\121\000\188\001\122\000\187\001\123\000\186\001\
\\124\000\185\001\125\000\184\001\126\000\138\000\000\000\
\\000\000\
\\000\000\
\\162\000\196\001\163\000\195\001\000\000\
\\000\000\
\\093\000\127\001\106\000\126\001\107\000\125\001\108\000\198\001\000\000\
\\000\000\
\\097\000\199\001\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\202\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\079\000\019\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\028\000\154\000\029\000\153\000\030\000\152\000\031\000\205\001\
\\052\000\017\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\093\000\127\001\106\000\126\001\107\000\125\001\108\000\208\001\000\000\
\\000\000\
\\000\000\
\\094\000\010\000\095\000\009\000\154\000\212\001\155\000\211\001\
\\156\000\210\001\157\000\080\000\158\000\079\000\000\000\
\\129\000\125\000\130\000\124\000\131\000\123\000\145\000\216\001\
\\146\000\215\001\147\000\214\001\148\000\103\000\150\000\213\001\
\\151\000\120\000\000\000\
\\094\000\129\000\118\000\218\001\126\000\217\001\000\000\
\\062\000\141\000\064\000\220\001\065\000\219\001\094\000\129\000\
\\126\000\138\000\000\000\
\\093\000\127\001\106\000\126\001\107\000\125\001\108\000\222\001\000\000\
\\094\000\132\000\100\000\224\001\101\000\105\001\102\000\104\001\
\\104\000\223\001\000\000\
\\013\000\227\001\040\000\226\001\041\000\225\001\094\000\010\000\
\\095\000\009\000\156\000\192\000\157\000\080\000\158\000\079\000\000\000\
\\146\000\215\001\147\000\229\001\148\000\103\000\150\000\228\001\
\\151\000\120\000\000\000\
\\022\000\205\000\023\000\230\001\024\000\203\000\025\000\202\000\
\\026\000\201\000\027\000\200\000\086\000\199\000\148\000\103\000\
\\150\000\198\000\151\000\120\000\000\000\
\\000\000\
\\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\231\001\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\046\001\
\\087\000\045\001\088\000\232\001\094\000\010\000\095\000\009\000\
\\158\000\002\000\165\000\001\000\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\233\001\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\061\000\234\001\062\000\015\000\063\000\014\000\069\000\144\001\
\\070\000\012\000\071\000\011\000\094\000\010\000\095\000\009\000\
\\157\000\003\000\158\000\002\000\000\000\
\\000\000\
\\077\000\235\001\078\000\188\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\077\000\235\001\078\000\188\000\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\060\001\094\000\220\000\095\000\219\000\
\\143\000\214\000\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\238\001\094\000\220\000\095\000\219\000\
\\143\000\214\000\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\240\001\139\000\216\000\140\000\215\000\
\\141\000\239\001\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\051\000\067\001\059\000\175\000\074\000\162\000\094\000\161\000\
\\095\000\160\000\132\000\066\001\133\000\241\001\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\242\001\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\250\001\015\000\023\000\019\000\249\001\060\000\016\000\
\\094\000\248\001\165\000\001\000\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\104\000\
\\094\000\010\000\095\000\009\000\152\000\251\001\158\000\002\000\
\\165\000\001\000\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\008\000\252\001\
\\014\000\108\000\015\000\023\000\020\000\084\001\021\000\106\000\
\\060\000\016\000\062\000\015\000\063\000\014\000\071\000\105\000\
\\094\000\010\000\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\073\000\253\001\077\000\189\000\078\000\188\000\000\000\
\\000\000\
\\012\000\254\001\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\255\001\
\\094\000\010\000\095\000\009\000\158\000\002\000\165\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\113\000\000\002\000\000\
\\111\000\004\002\113\000\003\002\162\000\002\002\163\000\195\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\006\000\008\002\000\000\
\\030\000\022\000\052\000\017\000\114\000\149\000\115\000\007\000\
\\116\000\010\002\117\000\147\000\000\000\
\\030\000\022\000\052\000\017\000\114\000\149\000\115\000\007\000\
\\116\000\011\002\117\000\147\000\000\000\
\\000\000\
\\000\000\
\\161\000\012\002\000\000\
\\000\000\
\\000\000\
\\161\000\015\002\000\000\
\\094\000\132\000\096\000\016\002\104\000\130\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\026\000\005\000\025\000\014\000\024\000\015\000\023\000\
\\042\000\019\002\046\000\020\000\060\000\016\000\062\000\015\000\
\\063\000\014\000\069\000\013\000\070\000\012\000\071\000\011\000\
\\094\000\010\000\095\000\009\000\157\000\003\000\158\000\002\000\
\\165\000\001\000\000\000\
\\094\000\132\000\100\000\020\002\101\000\105\001\102\000\104\001\
\\104\000\103\001\000\000\
\\000\000\
\\099\000\021\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\220\000\095\000\219\000\143\000\024\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\029\002\068\000\028\002\094\000\220\000\
\\095\000\219\000\143\000\214\000\000\000\
\\000\000\
\\094\000\132\000\104\000\031\002\105\000\030\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\142\000\033\002\000\000\
\\094\000\220\000\095\000\219\000\143\000\035\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\013\000\196\000\016\000\038\002\018\000\037\002\076\000\036\002\
\\094\000\010\000\095\000\009\000\156\000\192\000\157\000\080\000\
\\158\000\079\000\000\000\
\\062\000\222\000\067\000\039\002\094\000\220\000\095\000\219\000\
\\143\000\214\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\129\000\109\000\042\002\126\000\127\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\161\000\043\002\000\000\
\\094\000\132\000\101\000\044\002\102\000\104\001\104\000\103\001\000\000\
\\094\000\132\000\101\000\045\002\102\000\104\001\104\000\103\001\000\000\
\\000\000\
\\030\000\022\000\050\000\192\001\052\000\017\000\062\000\141\000\
\\064\000\191\001\094\000\190\001\114\000\149\000\115\000\007\000\
\\116\000\049\002\117\000\147\000\121\000\048\002\122\000\047\002\
\\124\000\046\002\125\000\184\001\126\000\138\000\000\000\
\\000\000\
\\000\000\
\\160\000\053\002\163\000\052\002\000\000\
\\148\000\103\000\150\000\055\002\151\000\120\000\000\000\
\\000\000\
\\097\000\057\002\098\000\056\002\000\000\
\\000\000\
\\062\000\015\000\063\000\014\000\069\000\060\002\070\000\012\000\
\\071\000\011\000\072\000\059\002\094\000\010\000\095\000\009\000\
\\157\000\003\000\158\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\062\002\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\094\000\010\000\095\000\009\000\154\000\212\001\155\000\063\002\
\\156\000\210\001\157\000\080\000\158\000\079\000\000\000\
\\000\000\
\\146\000\215\001\147\000\064\002\148\000\103\000\150\000\228\001\
\\151\000\120\000\000\000\
\\094\000\132\000\101\000\065\002\102\000\104\001\104\000\103\001\000\000\
\\062\000\141\000\064\000\067\002\065\000\066\002\094\000\129\000\
\\126\000\138\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\132\000\104\000\031\002\105\000\069\002\000\000\
\\013\000\227\001\040\000\226\001\041\000\070\002\094\000\010\000\
\\095\000\009\000\156\000\192\000\157\000\080\000\158\000\079\000\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\071\002\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\111\000\003\000\110\000\004\000\109\000\014\000\108\000\
\\015\000\023\000\020\000\107\000\021\000\106\000\060\000\016\000\
\\062\000\015\000\063\000\014\000\071\000\105\000\080\000\247\000\
\\089\000\074\002\094\000\010\000\095\000\009\000\158\000\002\000\
\\165\000\001\000\000\000\
\\000\000\
\\111\000\076\002\112\000\075\002\113\000\003\002\160\000\053\002\
\\163\000\052\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\162\000\002\002\163\000\195\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\192\001\062\000\141\000\064\000\191\001\094\000\190\001\
\\121\000\080\002\122\000\047\002\124\000\046\002\125\000\184\001\
\\126\000\138\000\000\000\
\\000\000\
\\000\000\
\\161\000\081\002\000\000\
\\062\000\222\000\067\000\082\002\094\000\220\000\095\000\219\000\
\\143\000\214\000\000\000\
\\000\000\
\\000\000\
\\094\000\132\000\096\000\016\002\104\000\130\000\161\000\083\002\000\000\
\\000\000\
\\000\000\
\\050\000\192\001\054\000\087\002\062\000\141\000\064\000\191\001\
\\094\000\190\001\121\000\188\001\122\000\086\002\123\000\085\002\
\\124\000\185\001\125\000\184\001\126\000\138\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\119\000\088\002\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\092\002\068\000\091\002\094\000\220\000\
\\095\000\219\000\143\000\214\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\093\002\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\013\000\196\000\016\000\038\002\018\000\094\002\076\000\036\002\
\\094\000\010\000\095\000\009\000\156\000\192\000\157\000\080\000\
\\158\000\079\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\094\000\129\000\109\000\042\002\126\000\127\000\161\000\095\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\160\000\098\002\163\000\097\002\000\000\
\\000\000\
\\097\000\057\002\098\000\100\002\000\000\
\\062\000\015\000\063\000\014\000\069\000\060\002\070\000\012\000\
\\071\000\011\000\072\000\101\002\094\000\010\000\095\000\009\000\
\\157\000\003\000\158\000\002\000\000\000\
\\057\000\102\002\000\000\
\\055\000\105\002\057\000\104\002\162\000\002\002\163\000\195\001\000\000\
\\000\000\
\\000\000\
\\161\000\107\002\000\000\
\\094\000\129\000\118\000\108\002\126\000\217\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\111\000\076\002\112\000\109\002\113\000\003\002\160\000\098\002\
\\163\000\097\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\062\000\222\000\067\000\221\000\094\000\220\000\095\000\219\000\
\\137\000\218\000\138\000\110\002\139\000\216\000\140\000\215\000\
\\143\000\214\000\144\000\213\000\148\000\212\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\179\000\053\000\111\002\094\000\177\000\000\000\
\\000\000\
\\000\000\
\\161\000\112\002\000\000\
\\119\000\114\002\120\000\113\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\055\000\117\002\056\000\116\002\057\000\104\002\160\000\053\002\
\\163\000\052\002\000\000\
\\000\000\
\\000\000\
\\094\000\129\000\118\000\108\002\126\000\217\001\161\000\119\002\000\000\
\\000\000\
\\000\000\
\\050\000\179\000\053\000\111\002\094\000\177\000\161\000\120\002\000\000\
\\119\000\114\002\120\000\121\002\000\000\
\\055\000\117\002\056\000\122\002\057\000\104\002\160\000\098\002\
\\163\000\097\002\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 636
val numrules = 354
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
       fun f i =
            if i=numstates then g i
            else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in f 0 handle Pervasive.General.Subscript => ()
          end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(Pervasive.List.map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = SourcePos.t
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit ->  unit | SHOW_BASIS of unit ->  (File.t) | WORD of unit ->  ({ digits:string,radix:StringCvt.radix } ) | TYVAR of unit ->  (string) | STRING of unit ->  (IntInf.t vector) | REAL of unit ->  (string) | LONGSYMID of unit ->  (string) | LONGALPHANUMID of unit ->  (string) | SHORTSYMID of unit ->  (string) | SHORTALPHANUMID of unit ->  (string) | INT of unit ->  ({ digits:string,extended:bool,negate:bool,radix:StringCvt.radix } ) | CHAR of unit ->  (IntInf.t) | word of unit ->  (IntInf.t) | withtypes of unit ->  (TypBind.t) | whereeqns' of unit ->  (WhereEquation.t list) | whereeqns of unit ->  (WhereEquation.t vector) | whereeqn of unit ->  ( ( SourcePos.t -> WhereEquation.t ) ) | whereandeqns of unit ->  (WhereEquation.t list) | vids of unit ->  (Vid.t list) | vidNoEqual of unit ->  (Vid.t) | vidEqual of unit ->  (Vid.t) | vid of unit ->  (Vid.t) | valdescs of unit ->  (valdesc list) | valdesc of unit ->  (valdesc) | valbindTop of unit ->  (vb vector*rvb vector) | valbind of unit ->  (vb list*rvb list) | tyvarseq of unit ->  (Tyvar.t vector) | tyvars of unit ->  (Tyvar.t vector) | tyvar_pc of unit ->  (Tyvar.t list) | tyvar of unit ->  (Tyvar.t) | typdescs of unit ->  (typdesc list) | typdesc of unit ->  (typdesc) | typBind of unit ->  (TypBind.t) | tynode of unit ->  (Type.node) | tycon of unit ->  (Tycon.t) | tyOpt of unit ->  (Type.t option) | ty0_pc of unit ->  (Type.t list) | ty'node of unit ->  (Type.node) | ty' of unit ->  (Type.t) | ty of unit ->  (Type.t) | tuple_ty of unit ->  (Type.t list) | topdecs of unit ->  (Topdec.t list list) | topdecnode of unit ->  (Topdec.node) | topdec of unit ->  (Topdec.t) | tlabels of unit ->  ( ( Field.t * (Region.t * Type.t) )  list) | tlabel of unit ->  ( ( Field.t * (Region.t * Type.t) ) ) | tbs' of unit ->  (tb list) | tbs of unit ->  (tb vector) | tb of unit ->  (tb) | symattributes of unit ->  (PrimKind.SymbolAttribute.t list) | string of unit ->  (string) | strid of unit ->  (Strid.t) | strexpnode of unit ->  (Strexp.node) | strexp2node of unit ->  (Strexp.node) | strexp2 of unit ->  (Strexp.t) | strexp1 of unit ->  (Strexp.t* ( Sigexp.t -> SigConst.t ) *Sigexp.t) | strexp of unit ->  (Strexp.t) | strdescs'' of unit ->  (strdesc whereAndEqns) | strdescs' of unit ->  (strdesc whereAndEqns) | strdescs of unit ->  (strdesc list) | strdecsnode of unit ->  (Strdec.node) | strdecs of unit ->  (Strdec.t) | strdecnode of unit ->  (Strdec.node) | strdec of unit ->  (Strdec.t) | strbinds'2 of unit ->  (strbind list) | strbinds'1' of unit ->  (strbind whereAndEqns) | strbinds'1 of unit ->  (strbind whereAndEqns) | strbinds' of unit ->  (Strexp.t*strbind list) | strbinds of unit ->  (strbind list) | specs of unit ->  (Spec.t) | specnode of unit ->  (Spec.node) | spec of unit ->  (Spec.t) | sigids of unit ->  (Sigid.t list) | sigid of unit ->  (Sigid.t) | sigexpnode of unit ->  (Sigexp.node) | sigexp'node of unit ->  (Sigexp.node) | sigexp' of unit ->  (Sigexp.t) | sigexp of unit ->  (Sigexp.t) | sigconst of unit ->  (SigConst.t) | sigbinds'' of unit ->  (sigbind whereAndEqns) | sigbinds' of unit ->  (sigbind whereAndEqns) | sigbinds of unit ->  (sigbind list) | shortSymId of unit ->  (Symbol.t*Region.t) | shortAlphanumId of unit ->  (Symbol.t*Region.t) | sharespec of unit ->  (SharingEquation.node) | sdecsPlus of unit ->  (Dec.t) | sdecs of unit ->  (Dec.t) | sdec of unit ->  (Dec.t) | rvalbind of unit ->  (rvb list) | rules of unit ->  (rule list) | rule of unit ->  (rule) | repl of unit ->  (DatatypeRhs.node) | program of unit ->  (Program.t) | priority of unit ->  (Priority.t) | pats of unit ->  (Pat.t list) | patitems of unit ->  ( ( (Field.t * Region.t * Pat.Item.t) list * bool ) ) | patitem of unit ->  ( ( Field.t * Region.t * Pat.Item.t ) ) | pat of unit ->  (Pat.t) | optsemicolon of unit ->  (unit) | optbar' of unit ->  (unit) | optbar of unit ->  (unit) | opcon of unit ->  (Con.t) | opaspat of unit ->  (Pat.t option) | numericField of unit ->  (int) | match of unit ->  (Match.t) | longvidands of unit ->  (Longvid.t list) | longvidNoEqual of unit ->  (Longvid.t) | longvidEqual of unit ->  (Longvid.t) | longvid of unit ->  (Longvid.t) | longtyconeqns of unit ->  (Longtycon.t list) | longtycon of unit ->  (Longtycon.t) | longstrids of unit ->  (Longstrid.t list) | longstrideqns of unit ->  (Longstrid.t list) | longstrid of unit ->  (Longstrid.t) | longSymId of unit ->  (Symbol.t list*Region.t) | longAlphanumId of unit ->  (Symbol.t list*Region.t) | longcon of unit ->  (Longcon.t) | int of unit ->  (IntInf.t) | idField of unit ->  (Symbol.t*Region.t) | funs of unit ->  (clauses list) | funbinds'2 of unit ->  (funbind list) | funbinds'1' of unit ->  (funbind whereAndEqns) | funbinds'1 of unit ->  (funbind whereAndEqns) | funbinds' of unit ->  (Strexp.t*funbind list) | funbinds of unit ->  (funbind list) | fixity of unit ->  (Fixity.t) | field of unit ->  (Field.t) | fctid of unit ->  (Fctid.t) | fctarg of unit ->  (FctArg.node) | expsAndTopdecs' of unit ->  (Topdec.t list list) | expsAndTopdecs of unit ->  (Topdec.t list list) | expnode of unit ->  (Exp.node) | exp_ps of unit ->  (Exp.t list) | exp_list of unit ->  (Exp.t list) | exp_2c of unit ->  (Exp.t list) | exp of unit ->  (Exp.t) | exndescs of unit ->  (exndesc list) | exndesc of unit ->  (exndesc) | elabels of unit ->  ( ( Field.t * (Region.t * Exp.t) )  list) | elabel of unit ->  ( ( Field.t * (Region.t * Exp.t) ) ) | ebs of unit ->  (eb list) | ebrhsnode of unit ->  (EbRhs.node) | ebrhs of unit ->  (EbRhs.t) | eb of unit ->  (eb) | digit of unit ->  (int) | decsnode of unit ->  (Dec.node) | decs of unit ->  (Dec.t) | decnolocal of unit ->  (Dec.node) | decnode of unit ->  (Dec.node) | dec of unit ->  (Dec.t) | dbs' of unit ->  (db list) | dbs of unit ->  (db vector) | db of unit ->  (db) | datatypeRhsnode of unit ->  (DatatypeRhs.node) | datatypeRhs of unit ->  (DatatypeRhs.t) | datBind of unit ->  (DatBind.t) | cpatnode of unit ->  (Pat.node) | cpat of unit ->  (Pat.t) | constOrBool of unit ->  (Const.t) | constrs of unit ->  ( ( Con.t * Type.t option )  list) | constraint of unit ->  (Type.t option) | constr of unit ->  (Con.t*Type.t option) | const' of unit ->  (Const.node) | const of unit ->  (Const.t) | con of unit ->  (Con.t) | commapats of unit ->  (Pat.t list) | clausesTop of unit ->  (clauses) | clauses of unit ->  (clause list) | clause of unit ->  (clause) | barcpats of unit ->  (Pat.t list) | ieattributes of unit ->  (PrimKind.ImportExportAttribute.t list) | arg_fct of unit ->  (Strexp.t) | app_exp of unit ->  (Exp.t list) | apats of unit ->  (Pat.t list) | apatnode of unit ->  (Pat.node) | apat of unit ->  (Pat.t) | aexp of unit ->  (Exp.node)
end
type svalue = MlyValue.svalue
type result = Program.t
end
structure EC=
struct
open LrTable
infix 5 $$
fun x $$ y = y::x
val is_keyword =
fn (T 10) => true | (T 11) => true | (T 14) => true | (T 17) => true | (T 21) => true | (T 22) => true | (T 23) => true | (T 24) => true | (T 27) => true | (T 28) => true | (T 29) => true | (T 30) => true | (T 31) => true | (T 32) => true | (T 33) => true | (T 34) => true | (T 37) => true | (T 38) => true | (T 39) => true | (T 40) => true | (T 41) => true | (T 44) => true | (T 45) => true | (T 47) => true | (T 49) => true | (T 50) => true | (T 51) => true | (T 52) => true | (T 53) => true | (T 56) => true | (T 59) => true | (T 60) => true | (T 61) => true | (T 62) => true | (T 63) => true | (T 64) => true | (T 65) => true | (T 66) => true | (T 68) => true | (T 67) => true | (T 70) => true | (T 71) => true | (T 48) => true | (T 12) => true | _ => false
val preferred_change : (term list * term list) list = 
(nil
,nil
 $$ (T 66))::
(nil
,nil
 $$ (T 64))::
(nil
,nil
 $$ (T 23))::
(nil
,nil
 $$ (T 46))::
(nil
,nil
 $$ (T 58))::
(nil
 $$ (T 30),nil
 $$ (T 26))::
(nil
 $$ (T 26),nil
 $$ (T 30))::
(nil
 $$ (T 11),nil
 $$ (T 12))::
(nil
 $$ (T 18),nil
 $$ (T 49))::
(nil
 $$ (T 58),nil
 $$ (T 20))::
(nil
 $$ (T 20),nil
 $$ (T 58))::
(nil
,nil
 $$ (T 24) $$ (T 2) $$ (T 38))::
(nil
,nil
 $$ (T 2) $$ (T 23))::
nil
val noShift = 
fn (T 25) => true | _ => false
val showTerminal =
fn (T 0) => "CHAR"
  | (T 1) => "INT"
  | (T 2) => "SHORTALPHANUMID"
  | (T 3) => "SHORTSYMID"
  | (T 4) => "LONGALPHANUMID"
  | (T 5) => "LONGSYMID"
  | (T 6) => "REAL"
  | (T 7) => "STRING"
  | (T 8) => "TYVAR"
  | (T 9) => "WORD"
  | (T 10) => "ABSTYPE"
  | (T 11) => "AND"
  | (T 12) => "ANDALSO"
  | (T 13) => "ARROW"
  | (T 14) => "AS"
  | (T 15) => "ASTERISK"
  | (T 16) => "BAR"
  | (T 17) => "CASE"
  | (T 18) => "COLON"
  | (T 19) => "COLONGT"
  | (T 20) => "COMMA"
  | (T 21) => "DATATYPE"
  | (T 22) => "DOTDOTDOT"
  | (T 23) => "ELSE"
  | (T 24) => "END"
  | (T 25) => "EOF"
  | (T 26) => "EQUALOP"
  | (T 27) => "EQTYPE"
  | (T 28) => "EXCEPTION"
  | (T 29) => "DO"
  | (T 30) => "DARROW"
  | (T 31) => "FN"
  | (T 32) => "FUN"
  | (T 33) => "FUNCTOR"
  | (T 34) => "HANDLE"
  | (T 35) => "HASH"
  | (T 36) => "HASHLBRACKET"
  | (T 37) => "IF"
  | (T 38) => "IN"
  | (T 39) => "INCLUDE"
  | (T 40) => "INFIX"
  | (T 41) => "INFIXR"
  | (T 42) => "LBRACE"
  | (T 43) => "LBRACKET"
  | (T 44) => "LET"
  | (T 45) => "LOCAL"
  | (T 46) => "LPAREN"
  | (T 47) => "NONFIX"
  | (T 48) => "ORELSE"
  | (T 49) => "OF"
  | (T 50) => "OP"
  | (T 51) => "OPEN"
  | (T 52) => "OVERLOAD"
  | (T 53) => "RAISE"
  | (T 54) => "RBRACE"
  | (T 55) => "RBRACKET"
  | (T 56) => "REC"
  | (T 57) => "RPAREN"
  | (T 58) => "SEMICOLON"
  | (T 59) => "SHARING"
  | (T 60) => "SIG"
  | (T 61) => "SIGNATURE"
  | (T 62) => "STRUCT"
  | (T 63) => "STRUCTURE"
  | (T 64) => "THEN"
  | (T 65) => "TYPE"
  | (T 66) => "VAL"
  | (T 67) => "WHERE"
  | (T 68) => "WHILE"
  | (T 69) => "WILD"
  | (T 70) => "WITH"
  | (T 71) => "WITHTYPE"
  | (T 72) => "BUILD_CONST"
  | (T 73) => "COMMAND_LINE_CONST"
  | (T 74) => "CONST"
  | (T 75) => "ADDRESS"
  | (T 76) => "EXPORT"
  | (T 77) => "IMPORT"
  | (T 78) => "SYMBOL"
  | (T 79) => "PRIM"
  | (T 80) => "SHOW_BASIS"
  | _ => "bogus-term"
local open Header in
val errtermvalue=
fn (T 0) => MlyValue.CHAR(fn () => (IntInf.fromInt (Char.ord #"a"))) | 
(T 1) => MlyValue.INT(fn () => ({digits = "0", extended = false, negate = false, radix = StringCvt.DEC})) | 
(T 2) => MlyValue.SHORTALPHANUMID(fn () => ("bogus")) | 
(T 6) => MlyValue.REAL(fn () => ("13.0")) | 
(T 7) => MlyValue.STRING(fn () => (Vector.fromList [])) | 
(T 8) => MlyValue.TYVAR(fn () => ("'a")) | 
(T 9) => MlyValue.WORD(fn () => ({digits = "0", radix = StringCvt.DEC})) | 
_ => MlyValue.VOID
end
val terms : term list = nil
 $$ (T 79) $$ (T 78) $$ (T 77) $$ (T 76) $$ (T 75) $$ (T 74) $$ (T 73) $$ (T 72) $$ (T 71) $$ (T 70) $$ (T 69) $$ (T 68) $$ (T 67) $$ (T 66) $$ (T 65) $$ (T 64) $$ (T 63) $$ (T 62) $$ (T 61) $$ (T 60) $$ (T 59) $$ (T 58) $$ (T 57) $$ (T 56) $$ (T 55) $$ (T 54) $$ (T 53) $$ (T 52) $$ (T 51) $$ (T 50) $$ (T 49) $$ (T 48) $$ (T 47) $$ (T 46) $$ (T 45) $$ (T 44) $$ (T 43) $$ (T 42) $$ (T 41) $$ (T 40) $$ (T 39) $$ (T 38) $$ (T 37) $$ (T 36) $$ (T 35) $$ (T 34) $$ (T 33) $$ (T 32) $$ (T 31) $$ (T 30) $$ (T 29) $$ (T 28) $$ (T 27) $$ (T 26) $$ (T 25) $$ (T 24) $$ (T 23) $$ (T 22) $$ (T 21) $$ (T 20) $$ (T 19) $$ (T 18) $$ (T 17) $$ (T 16) $$ (T 15) $$ (T 14) $$ (T 13) $$ (T 12) $$ (T 11) $$ (T 10)end
structure Actions =
struct 
exception mlyAction of int
local open Header in
val actions = 
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of  ( 0, ( ( _, ( MlyValue.expsAndTopdecs expsAndTopdecs1, expsAndTopdecs1left, expsAndTopdecs1right)) :: rest671)) => let val  result = MlyValue.program (fn _ => let val  (expsAndTopdecs as expsAndTopdecs1) = expsAndTopdecs1 ()
 in ((*#line 478.26 "ml.grm"*)Program.T expsAndTopdecs(*#line 2284.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 84, ( result, expsAndTopdecs1left, expsAndTopdecs1right), rest671)
end
|  ( 1, ( ( _, ( MlyValue.expsAndTopdecs' expsAndTopdecs'1, _, expsAndTopdecs'1right)) :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.expsAndTopdecs (fn _ => let val  (exp as exp1) = exp1 ()
 val  (expsAndTopdecs' as expsAndTopdecs'1) = expsAndTopdecs'1 ()
 in ((*#line 481.26 "ml.grm"*)consTopdec (Topdec.fromExp exp, expsAndTopdecs')(*#line 2290.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 46, ( result, exp1left, expsAndTopdecs'1right), rest671)
end
|  ( 2, ( ( _, ( MlyValue.topdecs topdecs1, topdecs1left, topdecs1right)) :: rest671)) => let val  result = MlyValue.expsAndTopdecs (fn _ => let val  (topdecs as topdecs1) = topdecs1 ()
 in ((*#line 482.14 "ml.grm"*)topdecs(*#line 2297.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 46, ( result, topdecs1left, topdecs1right), rest671)
end
|  ( 3, ( rest671)) => let val  result = MlyValue.expsAndTopdecs' (fn _ => ((*#line 485.8 "ml.grm"*)[](*#line 2303.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 47, ( result, defaultPos, defaultPos), rest671)
end
|  ( 4, ( ( _, ( MlyValue.expsAndTopdecs expsAndTopdecs1, _, expsAndTopdecs1right)) :: ( _, ( _, SEMICOLON1left, _)) :: rest671)) => let val  result = MlyValue.expsAndTopdecs' (fn _ => let val  (expsAndTopdecs as expsAndTopdecs1) = expsAndTopdecs1 ()
 in ((*#line 486.31 "ml.grm"*)[] :: expsAndTopdecs(*#line 2307.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 47, ( result, SEMICOLON1left, expsAndTopdecs1right), rest671)
end
|  ( 5, ( ( _, ( MlyValue.topdecs topdecs1, _, topdecs1right)) :: ( _, ( MlyValue.topdec topdec1, topdec1left, _)) :: rest671)) => let val  result = MlyValue.topdecs (fn _ => let val  (topdec as topdec1) = topdec1 ()
 val  (topdecs as topdecs1) = topdecs1 ()
 in ((*#line 489.21 "ml.grm"*)consTopdec (topdec, topdecs)(*#line 2313.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 135, ( result, topdec1left, topdecs1right), rest671)
end
|  ( 6, ( ( _, ( MlyValue.expsAndTopdecs' expsAndTopdecs'1, expsAndTopdecs'1left, expsAndTopdecs'1right)) :: rest671)) => let val  result = MlyValue.topdecs (fn _ => let val  (expsAndTopdecs' as expsAndTopdecs'1) = expsAndTopdecs'1 ()
 in ((*#line 490.22 "ml.grm"*)expsAndTopdecs'(*#line 2320.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 135, ( result, expsAndTopdecs'1left, expsAndTopdecs'1right), rest671)
end
|  ( 7, ( ( _, ( MlyValue.topdecnode topdecnode1, (topdecnodeleft as topdecnode1left), (topdecnoderight as topdecnode1right))) :: rest671)) => let val  result = MlyValue.topdec (fn _ => let val  (topdecnode as topdecnode1) = topdecnode1 ()
 in ((*#line 492.22 "ml.grm"*)Topdec.makeRegion' (topdecnode,
                                         topdecnodeleft,
                                         topdecnoderight)(*#line 2326.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 133, ( result, topdecnode1left, topdecnode1right), rest671)
end
|  ( 8, ( ( _, ( MlyValue.strdec strdec1, strdec1left, strdec1right)) :: rest671)) => let val  result = MlyValue.topdecnode (fn _ => let val  (strdec as strdec1) = strdec1 ()
 in ((*#line 498.7 "ml.grm"*)Topdec.Strdec strdec(*#line 2334.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 134, ( result, strdec1left, strdec1right), rest671)
end
|  ( 9, ( ( _, ( MlyValue.sigbinds sigbinds1, _, sigbinds1right)) :: ( _, ( _, SIGNATURE1left, _)) :: rest671)) => let val  result = MlyValue.topdecnode (fn _ => let val  (sigbinds as sigbinds1) = sigbinds1 ()
 in ((*#line 500.7 "ml.grm"*)let
         val sigbinds = Vector.fromList sigbinds
         val d = Topdec.Signature sigbinds
      in
         d
      end(*#line 2340.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 134, ( result, SIGNATURE1left, sigbinds1right), rest671)
end
|  ( 10, ( ( _, ( MlyValue.funbinds funbinds1, _, funbinds1right)) :: ( _, ( _, FUNCTOR1left, _)) :: rest671)) => let val  result = MlyValue.topdecnode (fn _ => let val  (funbinds as funbinds1) = funbinds1 ()
 in ((*#line 507.7 "ml.grm"*)Topdec.Functor (Vector.fromList funbinds)(*#line 2351.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 134, ( result, FUNCTOR1left, funbinds1right), rest671)
end
|  ( 11, ( ( _, ( MlyValue.strdecsnode strdecsnode1, (strdecsnodeleft as strdecsnode1left), (strdecsnoderight as strdecsnode1right))) :: rest671)) => let val  result = MlyValue.strdecs (fn _ => let val  (strdecsnode as strdecsnode1) = strdecsnode1 ()
 in ((*#line 513.24 "ml.grm"*)Strdec.makeRegion'
                       (strdecsnode, strdecsnodeleft, strdecsnoderight)(*#line 2357.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 115, ( result, strdecsnode1left, strdecsnode1right), rest671)
end
|  ( 12, ( rest671)) => let val  result = MlyValue.strdecsnode (fn _ => ((*#line 516.35 "ml.grm"*)Strdec.Seq [](*#line 2364.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 116, ( result, defaultPos, defaultPos), rest671)
end
|  ( 13, ( ( _, ( MlyValue.strdecs strdecs1, _, strdecs1right)) :: ( _, ( _, SEMICOLON1left, _)) :: rest671)) => let val  result = MlyValue.strdecsnode (fn _ => let val  (strdecs as strdecs1) = strdecs1 ()
 in ((*#line 517.35 "ml.grm"*)Strdec.Seq [strdecs](*#line 2368.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 116, ( result, SEMICOLON1left, strdecs1right), rest671)
end
|  ( 14, ( ( _, ( MlyValue.strdecs strdecs1, _, strdecs1right)) :: ( _, ( MlyValue.strdec strdec1, strdec1left, _)) :: rest671)) => let val  result = MlyValue.strdecsnode (fn _ => let val  (strdec as strdec1) = strdec1 ()
 val  (strdecs as strdecs1) = strdecs1 ()
 in ((*#line 518.35 "ml.grm"*)Strdec.Seq [strdec, strdecs](*#line 2374.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 116, ( result, strdec1left, strdecs1right), rest671)
end
|  ( 15, ( ( _, ( MlyValue.strdecnode strdecnode1, (strdecnodeleft as strdecnode1left), (strdecnoderight as strdecnode1right))) :: rest671)) => let val  result = MlyValue.strdec (fn _ => let val  (strdecnode as strdecnode1) = strdecnode1 ()
 in ((*#line 520.22 "ml.grm"*)Strdec.makeRegion' (strdecnode,
                                         strdecnodeleft, strdecnoderight)(*#line 2381.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 113, ( result, strdecnode1left, strdecnode1right), rest671)
end
|  ( 16, ( ( _, ( MlyValue.strbinds strbinds1, _, strbinds1right)) :: ( _, ( _, STRUCTURE1left, _)) :: rest671)) => let val  result = MlyValue.strdecnode (fn _ => let val  (strbinds as strbinds1) = strbinds1 ()
 in ((*#line 525.7 "ml.grm"*)let
         val strbinds = Vector.fromList strbinds
         val d = Strdec.Structure strbinds
      in
         d
      end(*#line 2388.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 114, ( result, STRUCTURE1left, strbinds1right), rest671)
end
|  ( 17, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.strdecs strdecs2, _, _)) :: _ :: ( _, ( MlyValue.strdecs strdecs1, _, _)) :: ( _, ( _, LOCAL1left, _)) :: rest671)) => let val  result = MlyValue.strdecnode (fn _ => let val  strdecs1 = strdecs1 ()
 val  strdecs2 = strdecs2 ()
 in ((*#line 531.37 "ml.grm"*)Strdec.Local (strdecs1, strdecs2)(*#line 2399.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 114, ( result, LOCAL1left, END1right), rest671)
end
|  ( 18, ( ( _, ( MlyValue.decnolocal decnolocal1, (decnolocalleft as decnolocal1left), (decnolocalright as decnolocal1right))) :: rest671)) => let val  result = MlyValue.strdecnode (fn _ => let val  (decnolocal as decnolocal1) = decnolocal1 ()
 in ((*#line 533.7 "ml.grm"*)Strdec.Core (Dec.makeRegion' (decnolocal,
                                    decnolocalleft, decnolocalright))(*#line 2406.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 114, ( result, decnolocal1left, decnolocal1right), rest671)
end
|  ( 19, ( ( _, ( MlyValue.SHOW_BASIS SHOW_BASIS1, SHOW_BASIS1left, SHOW_BASIS1right)) :: rest671)) => let val  result = MlyValue.strdecnode (fn _ => let val  (SHOW_BASIS as SHOW_BASIS1) = SHOW_BASIS1 ()
 in ((*#line 535.37 "ml.grm"*)Strdec.ShowBasis SHOW_BASIS(*#line 2413.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 114, ( result, SHOW_BASIS1left, SHOW_BASIS1right), rest671)
end
|  ( 20, ( ( _, ( MlyValue.strbinds' strbinds'1, _, strbinds'1right)) :: _ :: ( _, ( MlyValue.sigconst sigconst1, _, _)) :: ( _, ( MlyValue.strid strid1, strid1left, _)) :: rest671)) => let val  result = MlyValue.strbinds (fn _ => let val  (strid as strid1) = strid1 ()
 val  (sigconst as sigconst1) = sigconst1 ()
 val  (strbinds' as strbinds'1) = strbinds'1 ()
 in ((*#line 539.13 "ml.grm"*)let val (def,strbinds) = strbinds'
            in {name = strid, def = def, constraint = sigconst}
               :: strbinds
            end(*#line 2419.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 108, ( result, strid1left, strbinds'1right), rest671)
end
|  ( 21, ( ( _, ( MlyValue.strbinds'1 strbinds'11, _, strbinds'11right)) :: ( _, ( MlyValue.strexp1 strexp11, strexp11left, _)) :: rest671)) => let val  result = MlyValue.strbinds' (fn _ => let val  (strexp1 as strexp11) = strexp11 ()
 val  (strbinds'1 as strbinds'11) = strbinds'11 ()
 in ((*#line 544.36 "ml.grm"*)augment1 (strexp1, strbinds'1)(*#line 2430.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 109, ( result, strexp11left, strbinds'11right), rest671)
end
|  ( 22, ( ( _, ( MlyValue.strbinds'2 strbinds'21, _, strbinds'21right)) :: ( _, ( MlyValue.strexp2 strexp21, strexp21left, _)) :: rest671)) => let val  result = MlyValue.strbinds' (fn _ => let val  (strexp2 as strexp21) = strexp21 ()
 val  (strbinds'2 as strbinds'21) = strbinds'21 ()
 in ((*#line 545.36 "ml.grm"*)(strexp2,strbinds'2)(*#line 2437.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 109, ( result, strexp21left, strbinds'21right), rest671)
end
|  ( 23, ( ( _, ( MlyValue.strbinds'2 strbinds'21, strbinds'21left, strbinds'21right)) :: rest671)) => let val  result = MlyValue.strbinds'1 (fn _ => let val  (strbinds'2 as strbinds'21) = strbinds'21 ()
 in ((*#line 547.43 "ml.grm"*)([], strbinds'2)(*#line 2444.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 110, ( result, strbinds'21left, strbinds'21right), rest671)
end
|  ( 24, ( ( _, ( MlyValue.strbinds'1' strbinds'1'1, _, strbinds'1'1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (WHEREleft as WHERE1left), _)) :: rest671)) => let val  result = MlyValue.strbinds'1 (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (strbinds'1' as strbinds'1'1) = strbinds'1'1 ()
 in ((*#line 548.43 "ml.grm"*)cons1 (whereeqn WHEREleft, strbinds'1')(*#line 2450.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 110, ( result, WHERE1left, strbinds'1'1right), rest671)
end
|  ( 25, ( ( _, ( MlyValue.strbinds'1 strbinds'11, strbinds'11left, strbinds'11right)) :: rest671)) => let val  result = MlyValue.strbinds'1' (fn _ => let val  (strbinds'1 as strbinds'11) = strbinds'11 ()
 in ((*#line 550.42 "ml.grm"*)strbinds'1(*#line 2457.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 111, ( result, strbinds'11left, strbinds'11right), rest671)
end
|  ( 26, ( ( _, ( MlyValue.strbinds'1' strbinds'1'1, _, strbinds'1'1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (ANDleft as AND1left), _)) :: rest671)) => let val  result = MlyValue.strbinds'1' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (strbinds'1' as strbinds'1'1) = strbinds'1'1 ()
 in ((*#line 551.42 "ml.grm"*)cons1 (whereeqn ANDleft, strbinds'1')(*#line 2463.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 111, ( result, AND1left, strbinds'1'1right), rest671)
end
|  ( 27, ( rest671)) => let val  result = MlyValue.strbinds'2 (fn _ => ((*#line 553.29 "ml.grm"*)[](*#line 2470.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 112, ( result, defaultPos, defaultPos), rest671)
end
|  ( 28, ( ( _, ( MlyValue.strbinds strbinds1, _, strbinds1right)) :: ( _, ( _, AND1left, _)) :: rest671)) => let val  result = MlyValue.strbinds'2 (fn _ => let val  (strbinds as strbinds1) = strbinds1 ()
 in ((*#line 554.29 "ml.grm"*)strbinds(*#line 2474.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 112, ( result, AND1left, strbinds1right), rest671)
end
|  ( 29, ( ( _, ( MlyValue.strexpnode strexpnode1, (strexpnodeleft as strexpnode1left), (strexpnoderight as strexpnode1right))) :: rest671)) => let val  result = MlyValue.strexp (fn _ => let val  (strexpnode as strexpnode1) = strexpnode1 ()
 in ((*#line 556.22 "ml.grm"*)Strexp.makeRegion' (strexpnode,
                                         strexpnodeleft, strexpnoderight)(*#line 2480.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 120, ( result, strexpnode1left, strexpnode1right), rest671)
end
|  ( 30, ( ( _, ( MlyValue.strexp1 strexp11, strexp11left, strexp11right)) :: rest671)) => let val  result = MlyValue.strexpnode (fn _ => let val  (strexp1 as strexp11) = strexp11 ()
 in ((*#line 561.6 "ml.grm"*)let
        val (strexp, sigconst, sigexp) = strexp1
     in
        Strexp.Constrained (strexp, sigconst sigexp)
     end(*#line 2487.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 124, ( result, strexp11left, strexp11right), rest671)
end
|  ( 31, ( ( _, ( MlyValue.whereeqns whereeqns1, _, whereeqns1right)) :: ( _, ( MlyValue.strexp1 strexp11, strexp11left, _)) :: rest671)) => let val  result = MlyValue.strexpnode (fn _ => let val  (strexp1 as strexp11) = strexp11 ()
 val  (whereeqns as whereeqns1) = whereeqns1 ()
 in ((*#line 567.6 "ml.grm"*)let
        val (strexp,sigconst,sigexp) = strexp1
        val sigexp = Sigexp.wheree (sigexp, whereeqns)
     in
        Strexp.Constrained
        (strexp, sigconst sigexp)
     end(*#line 2497.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 124, ( result, strexp11left, whereeqns1right), rest671)
end
|  ( 32, ( ( _, ( MlyValue.strexp2node strexp2node1, strexp2node1left, strexp2node1right)) :: rest671)) => let val  result = MlyValue.strexpnode (fn _ => let val  (strexp2node as strexp2node1) = strexp2node1 ()
 in ((*#line 575.6 "ml.grm"*)strexp2node(*#line 2510.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 124, ( result, strexp2node1left, strexp2node1right), rest671)
end
|  ( 33, ( ( _, ( MlyValue.sigexp' sigexp'1, _, sigexp'1right)) :: _ :: ( _, ( MlyValue.strexp strexp1, strexp1left, _)) :: rest671)) => let val  result = MlyValue.strexp1 (fn _ => let val  (strexp as strexp1) = strexp1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 in ((*#line 577.36 "ml.grm"*)(strexp,SigConst.Transparent,sigexp')(*#line 2516.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 121, ( result, strexp1left, sigexp'1right), rest671)
end
|  ( 34, ( ( _, ( MlyValue.sigexp' sigexp'1, _, sigexp'1right)) :: _ :: ( _, ( MlyValue.strexp strexp1, strexp1left, _)) :: rest671)) => let val  result = MlyValue.strexp1 (fn _ => let val  (strexp as strexp1) = strexp1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 in ((*#line 578.36 "ml.grm"*)(strexp,SigConst.Opaque,sigexp')(*#line 2523.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 121, ( result, strexp1left, sigexp'1right), rest671)
end
|  ( 35, ( ( _, ( MlyValue.strexp2node strexp2node1, (strexp2nodeleft as strexp2node1left), (strexp2noderight as strexp2node1right))) :: rest671)) => let val  result = MlyValue.strexp2 (fn _ => let val  (strexp2node as strexp2node1) = strexp2node1 ()
 in ((*#line 580.24 "ml.grm"*)Strexp.makeRegion'
                       (strexp2node, strexp2nodeleft, strexp2noderight)(*#line 2530.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 122, ( result, strexp2node1left, strexp2node1right), rest671)
end
|  ( 36, ( ( _, ( MlyValue.longstrid longstrid1, longstrid1left, longstrid1right)) :: rest671)) => let val  result = MlyValue.strexp2node (fn _ => let val  (longstrid as longstrid1) = longstrid1 ()
 in ((*#line 584.39 "ml.grm"*)Strexp.Var longstrid(*#line 2537.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 123, ( result, longstrid1left, longstrid1right), rest671)
end
|  ( 37, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.strdecs strdecs1, _, _)) :: ( _, ( _, STRUCT1left, _)) :: rest671)) => let val  result = MlyValue.strexp2node (fn _ => let val  (strdecs as strdecs1) = strdecs1 ()
 in ((*#line 585.39 "ml.grm"*)Strexp.Struct strdecs(*#line 2543.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 123, ( result, STRUCT1left, END1right), rest671)
end
|  ( 38, ( ( _, ( MlyValue.arg_fct arg_fct1, _, arg_fct1right)) :: ( _, ( MlyValue.fctid fctid1, fctid1left, _)) :: rest671)) => let val  result = MlyValue.strexp2node (fn _ => let val  (fctid as fctid1) = fctid1 ()
 val  (arg_fct as arg_fct1) = arg_fct1 ()
 in ((*#line 586.39 "ml.grm"*)Strexp.App (fctid, arg_fct)(*#line 2549.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 123, ( result, fctid1left, arg_fct1right), rest671)
end
|  ( 39, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.strexp strexp1, _, _)) :: _ :: ( _, ( MlyValue.strdecs strdecs1, _, _)) :: ( _, ( _, LET1left, _)) :: rest671)) => let val  result = MlyValue.strexp2node (fn _ => let val  (strdecs as strdecs1) = strdecs1 ()
 val  (strexp as strexp1) = strexp1 ()
 in ((*#line 587.39 "ml.grm"*)Strexp.Let (strdecs, strexp)(*#line 2556.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 123, ( result, LET1left, END1right), rest671)
end
|  ( 40, ( ( _, ( _, _, (RPARENright as RPAREN1right))) :: ( _, ( MlyValue.strexp strexp1, _, _)) :: ( _, ( _, (LPARENleft as LPAREN1left), _)) :: rest671)) => let val  result = MlyValue.arg_fct (fn _ => let val  (strexp as strexp1) = strexp1 ()
 in ((*#line 589.35 "ml.grm"*)Strexp.makeRegion'
                                  (Strexp.node strexp,
                                   LPARENleft, RPARENright)(*#line 2563.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 5, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 41, ( ( _, ( _, _, (RPARENright as RPAREN1right))) :: ( _, ( MlyValue.strdecs strdecs1, _, _)) :: ( _, ( _, (LPARENleft as LPAREN1left), _)) :: rest671)) => let val  result = MlyValue.arg_fct (fn _ => let val  (strdecs as strdecs1) = strdecs1 ()
 in ((*#line 592.35 "ml.grm"*)Strexp.makeRegion'
                                  (Strexp.Struct strdecs,
                                   LPARENleft, RPARENright)(*#line 2571.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 5, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 42, ( ( _, ( MlyValue.sigexp' sigexp'1, sigexp'1left, sigexp'1right)) :: rest671)) => let val  result = MlyValue.sigexp (fn _ => let val  (sigexp' as sigexp'1) = sigexp'1 ()
 in ((*#line 601.25 "ml.grm"*)sigexp'(*#line 2579.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 99, ( result, sigexp'1left, sigexp'1right), rest671)
end
|  ( 43, ( ( _, ( MlyValue.whereeqns whereeqns1, _, whereeqns1right)) :: ( _, ( MlyValue.sigexp' sigexp'1, sigexp'1left, _)) :: rest671)) => let val  result = MlyValue.sigexp (fn _ => let val  (sigexp' as sigexp'1) = sigexp'1 ()
 val  (whereeqns as whereeqns1) = whereeqns1 ()
 in ((*#line 602.25 "ml.grm"*)Sigexp.wheree (sigexp', whereeqns)(*#line 2585.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 99, ( result, sigexp'1left, whereeqns1right), rest671)
end
|  ( 44, ( ( _, ( MlyValue.whereeqns' whereeqns'1, whereeqns'1left, whereeqns'1right)) :: rest671)) => let val  result = MlyValue.whereeqns (fn _ => let val  (whereeqns' as whereeqns'1) = whereeqns'1 ()
 in ((*#line 604.25 "ml.grm"*)Vector.fromList whereeqns'(*#line 2592.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 161, ( result, whereeqns'1left, whereeqns'1right), rest671)
end
|  ( 45, ( ( _, ( MlyValue.whereeqn whereeqn1, _, whereeqn1right)) :: ( _, ( _, (WHEREleft as WHERE1left), _)) :: rest671)) => let val  result = MlyValue.whereeqns' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 in ((*#line 607.35 "ml.grm"*)[whereeqn WHEREleft](*#line 2598.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 162, ( result, WHERE1left, whereeqn1right), rest671)
end
|  ( 46, ( ( _, ( MlyValue.whereeqns' whereeqns'1, _, whereeqns'1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (WHEREleft as WHERE1left), _)) :: rest671)) => let val  result = MlyValue.whereeqns' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (whereeqns' as whereeqns'1) = whereeqns'1 ()
 in ((*#line 608.35 "ml.grm"*)whereeqn WHEREleft :: whereeqns'(*#line 2604.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 162, ( result, WHERE1left, whereeqns'1right), rest671)
end
|  ( 47, ( ( _, ( MlyValue.whereandeqns whereandeqns1, _, whereandeqns1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (WHEREleft as WHERE1left), _)) :: rest671)) => let val  result = MlyValue.whereeqns' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (whereandeqns as whereandeqns1) = whereandeqns1 ()
 in ((*#line 609.35 "ml.grm"*)whereeqn WHEREleft :: whereandeqns(*#line 2611.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 162, ( result, WHERE1left, whereandeqns1right), rest671)
end
|  ( 48, ( ( _, ( MlyValue.whereeqn whereeqn1, _, whereeqn1right)) :: ( _, ( _, (ANDleft as AND1left), _)) :: rest671)) => let val  result = MlyValue.whereandeqns (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 in ((*#line 612.33 "ml.grm"*)[whereeqn ANDleft](*#line 2618.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 159, ( result, AND1left, whereeqn1right), rest671)
end
|  ( 49, ( ( _, ( MlyValue.whereandeqns whereandeqns1, _, whereandeqns1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (ANDleft as AND1left), _)) :: rest671)) => let val  result = MlyValue.whereandeqns (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (whereandeqns as whereandeqns1) = whereandeqns1 ()
 in ((*#line 613.33 "ml.grm"*)whereeqn ANDleft :: whereandeqns(*#line 2624.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 159, ( result, AND1left, whereandeqns1right), rest671)
end
|  ( 50, ( ( _, ( MlyValue.whereeqns' whereeqns'1, _, whereeqns'1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (ANDleft as AND1left), _)) :: rest671)) => let val  result = MlyValue.whereandeqns (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (whereeqns' as whereeqns'1) = whereeqns'1 ()
 in ((*#line 614.33 "ml.grm"*)whereeqn ANDleft :: whereeqns'(*#line 2631.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 159, ( result, AND1left, whereeqns'1right), rest671)
end
|  ( 51, ( ( _, ( MlyValue.sigbinds' sigbinds'1, _, sigbinds'1right)) :: ( _, ( MlyValue.sigexp' sigexp'1, _, _)) :: _ :: ( _, ( MlyValue.sigid sigid1, sigid1left, _)) :: rest671)) => let val  result = MlyValue.sigbinds (fn _ => let val  (sigid as sigid1) = sigid1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 val  (sigbinds' as sigbinds'1) = sigbinds'1 ()
 in ((*#line 616.45 "ml.grm"*)augment (sigid, sigexp', sigbinds')(*#line 2638.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 95, ( result, sigid1left, sigbinds'1right), rest671)
end
|  ( 52, ( ( _, ( MlyValue.sigexp'node sigexp'node1, (sigexp'nodeleft as sigexp'node1left), (sigexp'noderight as sigexp'node1right))) :: rest671)) => let val  result = MlyValue.sigexp' (fn _ => let val  (sigexp'node as sigexp'node1) = sigexp'node1 ()
 in ((*#line 618.24 "ml.grm"*)Sigexp.makeRegion' (sigexp'node,
                                           sigexp'nodeleft,
                                           sigexp'noderight)(*#line 2646.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 100, ( result, sigexp'node1left, sigexp'node1right), rest671)
end
|  ( 53, ( ( _, ( MlyValue.sigid sigid1, sigid1left, sigid1right)) :: rest671)) => let val  result = MlyValue.sigexp'node (fn _ => let val  (sigid as sigid1) = sigid1 ()
 in ((*#line 622.43 "ml.grm"*)Sigexp.Var sigid(*#line 2654.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 101, ( result, sigid1left, sigid1right), rest671)
end
|  ( 54, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.specs specs1, _, _)) :: ( _, ( _, SIG1left, _)) :: rest671)) => let val  result = MlyValue.sigexp'node (fn _ => let val  (specs as specs1) = specs1 ()
 in ((*#line 623.43 "ml.grm"*)Sigexp.Spec specs(*#line 2660.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 101, ( result, SIG1left, END1right), rest671)
end
|  ( 55, ( rest671)) => let val  result = MlyValue.sigbinds' (fn _ => ((*#line 625.40 "ml.grm"*)([], [])(*#line 2666.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 96, ( result, defaultPos, defaultPos), rest671)
end
|  ( 56, ( ( _, ( MlyValue.sigbinds sigbinds1, _, sigbinds1right)) :: ( _, ( _, AND1left, _)) :: rest671)) => let val  result = MlyValue.sigbinds' (fn _ => let val  (sigbinds as sigbinds1) = sigbinds1 ()
 in ((*#line 626.40 "ml.grm"*)([], sigbinds)(*#line 2670.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 96, ( result, AND1left, sigbinds1right), rest671)
end
|  ( 57, ( ( _, ( MlyValue.sigbinds'' sigbinds''1, _, sigbinds''1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (WHEREleft as WHERE1left), _)) :: rest671)) => let val  result = MlyValue.sigbinds' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (sigbinds'' as sigbinds''1) = sigbinds''1 ()
 in ((*#line 627.40 "ml.grm"*)cons1 (whereeqn WHEREleft, sigbinds'')(*#line 2676.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 96, ( result, WHERE1left, sigbinds''1right), rest671)
end
|  ( 58, ( ( _, ( MlyValue.sigbinds' sigbinds'1, sigbinds'1left, sigbinds'1right)) :: rest671)) => let val  result = MlyValue.sigbinds'' (fn _ => let val  (sigbinds' as sigbinds'1) = sigbinds'1 ()
 in ((*#line 629.40 "ml.grm"*)sigbinds'(*#line 2683.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 97, ( result, sigbinds'1left, sigbinds'1right), rest671)
end
|  ( 59, ( ( _, ( MlyValue.sigbinds'' sigbinds''1, _, sigbinds''1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (ANDleft as AND1left), _)) :: rest671)) => let val  result = MlyValue.sigbinds'' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (sigbinds'' as sigbinds''1) = sigbinds''1 ()
 in ((*#line 630.40 "ml.grm"*)cons1 (whereeqn ANDleft, sigbinds'')(*#line 2689.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 97, ( result, AND1left, sigbinds''1right), rest671)
end
|  ( 60, ( ( _, ( MlyValue.ty ty1, _, (tyright as ty1right))) :: _ :: ( _, ( MlyValue.longtycon longtycon1, _, _)) :: ( _, ( MlyValue.tyvars tyvars1, _, _)) :: ( _, ( _, TYPE1left, _)) :: rest671)) => let val  result = MlyValue.whereeqn (fn _ => let val  (tyvars as tyvars1) = tyvars1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 632.48 "ml.grm"*)fn eqnleft =>
                                               WhereEquation.makeRegion'
                                               (WhereEquation.Type {tyvars = tyvars,
                                                                    longtycon = longtycon,
                                                                    ty = ty},
                                                eqnleft,
                                                tyright)(*#line 2696.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 160, ( result, TYPE1left, ty1right), rest671)
end
|  ( 61, ( rest671)) => let val  result = MlyValue.sigconst (fn _ => ((*#line 640.29 "ml.grm"*)SigConst.None(*#line 2710.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 98, ( result, defaultPos, defaultPos), rest671)
end
|  ( 62, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: ( _, ( _, COLON1left, _)) :: rest671)) => let val  result = MlyValue.sigconst (fn _ => let val  (sigexp as sigexp1) = sigexp1 ()
 in ((*#line 641.29 "ml.grm"*)SigConst.Transparent sigexp(*#line 2714.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 98, ( result, COLON1left, sigexp1right), rest671)
end
|  ( 63, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: ( _, ( _, COLONGT1left, _)) :: rest671)) => let val  result = MlyValue.sigconst (fn _ => let val  (sigexp as sigexp1) = sigexp1 ()
 in ((*#line 642.29 "ml.grm"*)SigConst.Opaque sigexp(*#line 2720.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 98, ( result, COLONGT1left, sigexp1right), rest671)
end
|  ( 64, ( rest671)) => let val  result = MlyValue.specs (fn _ => ((*#line 644.29 "ml.grm"*)Spec.makeRegion (Spec.Empty, Region.bogus)(*#line 2726.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 107, ( result, defaultPos, defaultPos), rest671)
end
|  ( 65, ( ( _, ( MlyValue.specs specs1, _, specs1right)) :: ( _, ( _, SEMICOLON1left, _)) :: rest671)) => let val  result = MlyValue.specs (fn _ => let val  (specs as specs1) = specs1 ()
 in ((*#line 645.29 "ml.grm"*)specs(*#line 2730.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 107, ( result, SEMICOLON1left, specs1right), rest671)
end
|  ( 66, ( ( _, ( MlyValue.specs specs1, _, specs1right)) :: ( _, ( MlyValue.spec spec1, spec1left, _)) :: rest671)) => let val  result = MlyValue.specs (fn _ => let val  (spec as spec1) = spec1 ()
 val  (specs as specs1) = specs1 ()
 in ((*#line 646.29 "ml.grm"*)Spec.seq (spec, specs)(*#line 2736.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 107, ( result, spec1left, specs1right), rest671)
end
|  ( 67, ( ( _, ( MlyValue.specnode specnode1, (specnodeleft as specnode1left), (specnoderight as specnode1right))) :: rest671)) => let val  result = MlyValue.spec (fn _ => let val  (specnode as specnode1) = specnode1 ()
 in ((*#line 648.18 "ml.grm"*)Spec.makeRegion' (specnode, specnodeleft, specnoderight)(*#line 2743.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 105, ( result, specnode1left, specnode1right), rest671)
end
|  ( 68, ( ( _, ( MlyValue.valdescs valdescs1, _, valdescs1right)) :: ( _, ( _, VAL1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (valdescs as valdescs1) = valdescs1 ()
 in ((*#line 650.34 "ml.grm"*)Spec.Val (Vector.fromList valdescs)(*#line 2749.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, VAL1left, valdescs1right), rest671)
end
|  ( 69, ( ( _, ( MlyValue.typdescs typdescs1, _, typdescs1right)) :: ( _, ( _, TYPE1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (typdescs as typdescs1) = typdescs1 ()
 in ((*#line 651.34 "ml.grm"*)Spec.Type (Vector.fromList typdescs)(*#line 2755.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, TYPE1left, typdescs1right), rest671)
end
|  ( 70, ( ( _, ( MlyValue.typBind typBind1, _, typBind1right)) :: ( _, ( _, TYPE1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (typBind as typBind1) = typBind1 ()
 in ((*#line 652.34 "ml.grm"*)Spec.TypeDefs typBind(*#line 2761.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, TYPE1left, typBind1right), rest671)
end
|  ( 71, ( ( _, ( MlyValue.typdescs typdescs1, _, typdescs1right)) :: ( _, ( _, EQTYPE1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (typdescs as typdescs1) = typdescs1 ()
 in ((*#line 653.34 "ml.grm"*)Spec.Eqtype (Vector.fromList typdescs)(*#line 2767.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, EQTYPE1left, typdescs1right), rest671)
end
|  ( 72, ( ( _, ( MlyValue.datatypeRhs datatypeRhs1, _, datatypeRhs1right)) :: ( _, ( _, DATATYPE1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (datatypeRhs as datatypeRhs1) = datatypeRhs1 ()
 in ((*#line 654.34 "ml.grm"*)Spec.Datatype datatypeRhs(*#line 2773.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, DATATYPE1left, datatypeRhs1right), rest671)
end
|  ( 73, ( ( _, ( MlyValue.exndescs exndescs1, _, exndescs1right)) :: ( _, ( _, EXCEPTION1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (exndescs as exndescs1) = exndescs1 ()
 in ((*#line 655.34 "ml.grm"*)Spec.Exception (Vector.fromList exndescs)(*#line 2779.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, EXCEPTION1left, exndescs1right), rest671)
end
|  ( 74, ( ( _, ( MlyValue.strdescs strdescs1, _, strdescs1right)) :: ( _, ( _, STRUCTURE1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (strdescs as strdescs1) = strdescs1 ()
 in ((*#line 656.34 "ml.grm"*)Spec.Structure (Vector.fromList strdescs)(*#line 2785.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, STRUCTURE1left, strdescs1right), rest671)
end
|  ( 75, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: ( _, ( _, INCLUDE1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (sigexp as sigexp1) = sigexp1 ()
 in ((*#line 657.34 "ml.grm"*)Spec.IncludeSigexp sigexp(*#line 2791.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, INCLUDE1left, sigexp1right), rest671)
end
|  ( 76, ( ( _, ( MlyValue.sigids sigids1, _, sigids1right)) :: ( _, ( MlyValue.sigid sigid1, _, _)) :: ( _, ( _, INCLUDE1left, _)) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (sigid as sigid1) = sigid1 ()
 val  (sigids as sigids1) = sigids1 ()
 in ((*#line 659.13 "ml.grm"*)Spec.IncludeSigids (Vector.fromList (sigid :: sigids)) (*#line 2797.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, INCLUDE1left, sigids1right), rest671)
end
|  ( 77, ( ( _, ( MlyValue.sharespec sharespec1, (sharespecleft as sharespec1left), (sharespecright as sharespec1right))) :: rest671)) => let val  result = MlyValue.specnode (fn _ => let val  (sharespec as sharespec1) = sharespec1 ()
 in ((*#line 661.13 "ml.grm"*)Spec.Sharing {spec = Spec.makeRegion' (Spec.Empty,
                                                   sharespecleft,
                                                   sharespecright),
                          equation = (SharingEquation.makeRegion'
                                      (sharespec,
                                       sharespecleft,
                                       sharespecright))}(*#line 2804.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 106, ( result, sharespec1left, sharespec1right), rest671)
end
|  ( 78, ( ( _, ( MlyValue.longtyconeqns longtyconeqns1, _, longtyconeqns1right)) :: _ :: ( _, ( _, SHARING1left, _)) :: rest671)) => let val  result = MlyValue.sharespec (fn _ => let val  (longtyconeqns as longtyconeqns1) = longtyconeqns1 ()
 in ((*#line 669.41 "ml.grm"*)SharingEquation.Type longtyconeqns(*#line 2816.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 92, ( result, SHARING1left, longtyconeqns1right), rest671)
end
|  ( 79, ( ( _, ( MlyValue.longstrideqns longstrideqns1, _, longstrideqns1right)) :: ( _, ( _, SHARING1left, _)) :: rest671)) => let val  result = MlyValue.sharespec (fn _ => let val  (longstrideqns as longstrideqns1) = longstrideqns1 ()
 in ((*#line 670.41 "ml.grm"*)SharingEquation.Structure longstrideqns(*#line 2822.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 92, ( result, SHARING1left, longstrideqns1right), rest671)
end
|  ( 80, ( ( _, ( MlyValue.longstrid longstrid2, _, longstrid2right)) :: _ :: ( _, ( MlyValue.longstrid longstrid1, longstrid1left, _)) :: rest671)) => let val  result = MlyValue.longstrideqns (fn _ => let val  longstrid1 = longstrid1 ()
 val  longstrid2 = longstrid2 ()
 in ((*#line 672.46 "ml.grm"*)[longstrid1,longstrid2](*#line 2828.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 64, ( result, longstrid1left, longstrid2right), rest671)
end
|  ( 81, ( ( _, ( MlyValue.longstrideqns longstrideqns1, _, longstrideqns1right)) :: _ :: ( _, ( MlyValue.longstrid longstrid1, longstrid1left, _)) :: rest671)) => let val  result = MlyValue.longstrideqns (fn _ => let val  (longstrid as longstrid1) = longstrid1 ()
 val  (longstrideqns as longstrideqns1) = longstrideqns1 ()
 in ((*#line 673.50 "ml.grm"*)longstrid :: longstrideqns(*#line 2835.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 64, ( result, longstrid1left, longstrideqns1right), rest671)
end
|  ( 82, ( ( _, ( MlyValue.longtycon longtycon2, _, longtycon2right)) :: _ :: ( _, ( MlyValue.longtycon longtycon1, longtycon1left, _)) :: rest671)) => let val  result = MlyValue.longtyconeqns (fn _ => let val  longtycon1 = longtycon1 ()
 val  longtycon2 = longtycon2 ()
 in ((*#line 675.46 "ml.grm"*)[longtycon1,longtycon2](*#line 2842.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 67, ( result, longtycon1left, longtycon2right), rest671)
end
|  ( 83, ( ( _, ( MlyValue.longtyconeqns longtyconeqns1, _, longtyconeqns1right)) :: _ :: ( _, ( MlyValue.longtycon longtycon1, longtycon1left, _)) :: rest671)) => let val  result = MlyValue.longtyconeqns (fn _ => let val  (longtycon as longtycon1) = longtycon1 ()
 val  (longtyconeqns as longtyconeqns1) = longtyconeqns1 ()
 in ((*#line 676.50 "ml.grm"*)longtycon :: longtyconeqns(*#line 2849.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 67, ( result, longtycon1left, longtyconeqns1right), rest671)
end
|  ( 84, ( ( _, ( MlyValue.strdescs' strdescs'1, _, strdescs'1right)) :: ( _, ( MlyValue.sigexp' sigexp'1, _, _)) :: _ :: ( _, ( MlyValue.strid strid1, strid1left, _)) :: rest671)) => let val  result = MlyValue.strdescs (fn _ => let val  (strid as strid1) = strid1 ()
 val  (sigexp' as sigexp'1) = sigexp'1 ()
 val  (strdescs' as strdescs'1) = strdescs'1 ()
 in ((*#line 678.44 "ml.grm"*)augment (strid, sigexp', strdescs')(*#line 2856.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 117, ( result, strid1left, strdescs'1right), rest671)
end
|  ( 85, ( rest671)) => let val  result = MlyValue.strdescs' (fn _ => ((*#line 680.41 "ml.grm"*)([], [])(*#line 2864.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 118, ( result, defaultPos, defaultPos), rest671)
end
|  ( 86, ( ( _, ( MlyValue.strdescs strdescs1, _, strdescs1right)) :: ( _, ( _, AND1left, _)) :: rest671)) => let val  result = MlyValue.strdescs' (fn _ => let val  (strdescs as strdescs1) = strdescs1 ()
 in ((*#line 681.41 "ml.grm"*)([], strdescs)(*#line 2868.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 118, ( result, AND1left, strdescs1right), rest671)
end
|  ( 87, ( ( _, ( MlyValue.strdescs'' strdescs''1, _, strdescs''1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (WHEREleft as WHERE1left), _)) :: rest671)) => let val  result = MlyValue.strdescs' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (strdescs'' as strdescs''1) = strdescs''1 ()
 in ((*#line 682.41 "ml.grm"*)cons1 (whereeqn WHEREleft, strdescs'')(*#line 2874.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 118, ( result, WHERE1left, strdescs''1right), rest671)
end
|  ( 88, ( ( _, ( MlyValue.strdescs' strdescs'1, strdescs'1left, strdescs'1right)) :: rest671)) => let val  result = MlyValue.strdescs'' (fn _ => let val  (strdescs' as strdescs'1) = strdescs'1 ()
 in ((*#line 684.40 "ml.grm"*)strdescs'(*#line 2881.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 119, ( result, strdescs'1left, strdescs'1right), rest671)
end
|  ( 89, ( ( _, ( MlyValue.strdescs'' strdescs''1, _, strdescs''1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (ANDleft as AND1left), _)) :: rest671)) => let val  result = MlyValue.strdescs'' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (strdescs'' as strdescs''1) = strdescs''1 ()
 in ((*#line 685.40 "ml.grm"*)cons1 (whereeqn ANDleft, strdescs'')(*#line 2887.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 119, ( result, AND1left, strdescs''1right), rest671)
end
|  ( 90, ( ( _, ( MlyValue.typdesc typdesc1, typdesc1left, typdesc1right)) :: rest671)) => let val  result = MlyValue.typdescs (fn _ => let val  (typdesc as typdesc1) = typdesc1 ()
 in ((*#line 687.35 "ml.grm"*)[typdesc](*#line 2894.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 146, ( result, typdesc1left, typdesc1right), rest671)
end
|  ( 91, ( ( _, ( MlyValue.typdescs typdescs1, _, typdescs1right)) :: _ :: ( _, ( MlyValue.typdesc typdesc1, typdesc1left, _)) :: rest671)) => let val  result = MlyValue.typdescs (fn _ => let val  (typdesc as typdesc1) = typdesc1 ()
 val  (typdescs as typdescs1) = typdescs1 ()
 in ((*#line 688.35 "ml.grm"*)typdesc :: typdescs(*#line 2900.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 146, ( result, typdesc1left, typdescs1right), rest671)
end
|  ( 92, ( ( _, ( MlyValue.tycon tycon1, _, tycon1right)) :: ( _, ( MlyValue.tyvars tyvars1, tyvars1left, _)) :: rest671)) => let val  result = MlyValue.typdesc (fn _ => let val  (tyvars as tyvars1) = tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 in ((*#line 690.25 "ml.grm"*){tyvars = tyvars,
                         tycon = tycon}(*#line 2907.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 145, ( result, tyvars1left, tycon1right), rest671)
end
|  ( 93, ( ( _, ( MlyValue.valdesc valdesc1, valdesc1left, valdesc1right)) :: rest671)) => let val  result = MlyValue.valdescs (fn _ => let val  (valdesc as valdesc1) = valdesc1 ()
 in ((*#line 693.36 "ml.grm"*)[valdesc](*#line 2915.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 154, ( result, valdesc1left, valdesc1right), rest671)
end
|  ( 94, ( ( _, ( MlyValue.valdescs valdescs1, _, valdescs1right)) :: _ :: ( _, ( MlyValue.valdesc valdesc1, valdesc1left, _)) :: rest671)) => let val  result = MlyValue.valdescs (fn _ => let val  (valdesc as valdesc1) = valdesc1 ()
 val  (valdescs as valdescs1) = valdescs1 ()
 in ((*#line 694.36 "ml.grm"*)valdesc :: valdescs(*#line 2921.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 154, ( result, valdesc1left, valdescs1right), rest671)
end
|  ( 95, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( MlyValue.vid vid1, vid1left, _)) :: rest671)) => let val  result = MlyValue.valdesc (fn _ => let val  (vid as vid1) = vid1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 696.26 "ml.grm"*)Vid.toVar vid, ty(*#line 2928.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 153, ( result, vid1left, ty1right), rest671)
end
|  ( 96, ( ( _, ( MlyValue.exndesc exndesc1, exndesc1left, exndesc1right)) :: rest671)) => let val  result = MlyValue.exndescs (fn _ => let val  (exndesc as exndesc1) = exndesc1 ()
 in ((*#line 698.36 "ml.grm"*)[exndesc](*#line 2935.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 40, ( result, exndesc1left, exndesc1right), rest671)
end
|  ( 97, ( ( _, ( MlyValue.exndescs exndescs1, _, exndescs1right)) :: _ :: ( _, ( MlyValue.exndesc exndesc1, exndesc1left, _)) :: rest671)) => let val  result = MlyValue.exndescs (fn _ => let val  (exndesc as exndesc1) = exndesc1 ()
 val  (exndescs as exndescs1) = exndescs1 ()
 in ((*#line 699.36 "ml.grm"*)exndesc :: exndescs(*#line 2941.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 40, ( result, exndesc1left, exndescs1right), rest671)
end
|  ( 98, ( ( _, ( MlyValue.tyOpt tyOpt1, _, tyOpt1right)) :: ( _, ( MlyValue.con con1, con1left, _)) :: rest671)) => let val  result = MlyValue.exndesc (fn _ => let val  (con as con1) = con1 ()
 val  (tyOpt as tyOpt1) = tyOpt1 ()
 in ((*#line 701.23 "ml.grm"*)con, tyOpt(*#line 2948.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 39, ( result, con1left, tyOpt1right), rest671)
end
|  ( 99, ( rest671)) => let val  result = MlyValue.tyOpt (fn _ => ((*#line 703.18 "ml.grm"*)NONE(*#line 2955.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 141, ( result, defaultPos, defaultPos), rest671)
end
|  ( 100, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: ( _, ( _, OF1left, _)) :: rest671)) => let val  result = MlyValue.tyOpt (fn _ => let val  (ty as ty1) = ty1 ()
 in ((*#line 704.18 "ml.grm"*)SOME ty(*#line 2959.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 141, ( result, OF1left, ty1right), rest671)
end
|  ( 101, ( ( _, ( MlyValue.funbinds' funbinds'1, _, funbinds'1right)) :: _ :: ( _, ( MlyValue.sigconst sigconst1, _, _)) :: _ :: ( _, ( MlyValue.fctarg fctarg1, fctargleft, fctargright)) :: _ :: ( _, ( MlyValue.fctid fctid1, fctid1left, _)) :: rest671)) => let val  result = MlyValue.funbinds (fn _ => let val  (fctid as fctid1) = fctid1 ()
 val  (fctarg as fctarg1) = fctarg1 ()
 val  (sigconst as sigconst1) = sigconst1 ()
 val  (funbinds' as funbinds'1) = funbinds'1 ()
 in ((*#line 711.13 "ml.grm"*)let val (strexp,funbinds) = funbinds'
            in {name = fctid,
                arg = FctArg.makeRegion' (fctarg, fctargleft, fctargright),
                result = sigconst,
                body = strexp}
               :: funbinds
            end(*#line 2965.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 52, ( result, fctid1left, funbinds'1right), rest671)
end
|  ( 102, ( ( _, ( MlyValue.funbinds'1 funbinds'11, _, funbinds'11right)) :: ( _, ( MlyValue.strexp1 strexp11, strexp11left, _)) :: rest671)) => let val  result = MlyValue.funbinds' (fn _ => let val  (strexp1 as strexp11) = strexp11 ()
 val  (funbinds'1 as funbinds'11) = funbinds'11 ()
 in ((*#line 719.34 "ml.grm"*)augment1 (strexp1, funbinds'1)(*#line 2980.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 53, ( result, strexp11left, funbinds'11right), rest671)
end
|  ( 103, ( ( _, ( MlyValue.funbinds'2 funbinds'21, _, funbinds'21right)) :: ( _, ( MlyValue.strexp2 strexp21, strexp21left, _)) :: rest671)) => let val  result = MlyValue.funbinds' (fn _ => let val  (strexp2 as strexp21) = strexp21 ()
 val  (funbinds'2 as funbinds'21) = funbinds'21 ()
 in ((*#line 720.34 "ml.grm"*)(strexp2, funbinds'2)(*#line 2987.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 53, ( result, strexp21left, funbinds'21right), rest671)
end
|  ( 104, ( ( _, ( MlyValue.funbinds'2 funbinds'21, funbinds'21left, funbinds'21right)) :: rest671)) => let val  result = MlyValue.funbinds'1 (fn _ => let val  (funbinds'2 as funbinds'21) = funbinds'21 ()
 in ((*#line 722.43 "ml.grm"*)[], funbinds'2(*#line 2994.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 54, ( result, funbinds'21left, funbinds'21right), rest671)
end
|  ( 105, ( ( _, ( MlyValue.funbinds'1' funbinds'1'1, _, funbinds'1'1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (WHEREleft as WHERE1left), _)) :: rest671)) => let val  result = MlyValue.funbinds'1 (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (funbinds'1' as funbinds'1'1) = funbinds'1'1 ()
 in ((*#line 723.43 "ml.grm"*)cons1 (whereeqn WHEREleft, funbinds'1')(*#line 3000.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 54, ( result, WHERE1left, funbinds'1'1right), rest671)
end
|  ( 106, ( rest671)) => let val  result = MlyValue.funbinds'2 (fn _ => ((*#line 725.29 "ml.grm"*)[](*#line 3007.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 56, ( result, defaultPos, defaultPos), rest671)
end
|  ( 107, ( ( _, ( MlyValue.funbinds funbinds1, _, funbinds1right)) :: ( _, ( _, AND1left, _)) :: rest671)) => let val  result = MlyValue.funbinds'2 (fn _ => let val  (funbinds as funbinds1) = funbinds1 ()
 in ((*#line 726.29 "ml.grm"*)funbinds(*#line 3011.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 56, ( result, AND1left, funbinds1right), rest671)
end
|  ( 108, ( ( _, ( MlyValue.funbinds'1 funbinds'11, funbinds'11left, funbinds'11right)) :: rest671)) => let val  result = MlyValue.funbinds'1' (fn _ => let val  (funbinds'1 as funbinds'11) = funbinds'11 ()
 in ((*#line 728.42 "ml.grm"*)funbinds'1(*#line 3017.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 55, ( result, funbinds'11left, funbinds'11right), rest671)
end
|  ( 109, ( ( _, ( MlyValue.funbinds'1' funbinds'1'1, _, funbinds'1'1right)) :: ( _, ( MlyValue.whereeqn whereeqn1, _, _)) :: ( _, ( _, (ANDleft as AND1left), _)) :: rest671)) => let val  result = MlyValue.funbinds'1' (fn _ => let val  (whereeqn as whereeqn1) = whereeqn1 ()
 val  (funbinds'1' as funbinds'1'1) = funbinds'1'1 ()
 in ((*#line 729.42 "ml.grm"*)cons1 (whereeqn ANDleft, funbinds'1')(*#line 3023.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 55, ( result, AND1left, funbinds'1'1right), rest671)
end
|  ( 110, ( ( _, ( MlyValue.sigexp sigexp1, _, sigexp1right)) :: _ :: ( _, ( MlyValue.strid strid1, strid1left, _)) :: rest671)) => let val  result = MlyValue.fctarg (fn _ => let val  (strid as strid1) = strid1 ()
 val  (sigexp as sigexp1) = sigexp1 ()
 in ((*#line 731.31 "ml.grm"*)FctArg.Structure (strid, sigexp)(*#line 3030.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 48, ( result, strid1left, sigexp1right), rest671)
end
|  ( 111, ( ( _, ( MlyValue.specs specs1, specs1left, specs1right)) :: rest671)) => let val  result = MlyValue.fctarg (fn _ => let val  (specs as specs1) = specs1 ()
 in ((*#line 732.31 "ml.grm"*)FctArg.Spec specs(*#line 3037.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 48, ( result, specs1left, specs1right), rest671)
end
|  ( 112, ( rest671)) => let val  result = MlyValue.decs (fn _ => ((*#line 738.26 "ml.grm"*)Dec.makeRegion' (Dec.SeqDec (Vector.new0 ()),
                                          defaultPos, defaultPos)(*#line 3043.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 30, ( result, defaultPos, defaultPos), rest671)
end
|  ( 113, ( ( _, ( MlyValue.decs decs1, _, decs1right)) :: ( _, ( MlyValue.dec dec1, dec1left, _)) :: rest671)) => let val  result = MlyValue.decs (fn _ => let val  (dec as dec1) = dec1 ()
 val  (decs as decs1) = decs1 ()
 in ((*#line 740.26 "ml.grm"*)Dec.sequence (dec,decs)(*#line 3048.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 30, ( result, dec1left, decs1right), rest671)
end
|  ( 114, ( ( _, ( MlyValue.decs decs1, _, decs1right)) :: ( _, ( _, SEMICOLON1left, _)) :: rest671)) => let val  result = MlyValue.decs (fn _ => let val  (decs as decs1) = decs1 ()
 in ((*#line 741.26 "ml.grm"*)decs(*#line 3055.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 30, ( result, SEMICOLON1left, decs1right), rest671)
end
|  ( 115, ( ( _, ( MlyValue.decnode decnode1, (decnodeleft as decnode1left), (decnoderight as decnode1right))) :: rest671)) => let val  result = MlyValue.dec (fn _ => let val  (decnode as decnode1) = decnode1 ()
 in ((*#line 743.16 "ml.grm"*)Dec.makeRegion' (decnode, decnodeleft, decnoderight)(*#line 3061.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 27, ( result, decnode1left, decnode1right), rest671)
end
|  ( 116, ( ( _, ( MlyValue.decnolocal decnolocal1, decnolocal1left, decnolocal1right)) :: rest671)) => let val  result = MlyValue.decnode (fn _ => let val  (decnolocal as decnolocal1) = decnolocal1 ()
 in ((*#line 745.36 "ml.grm"*)decnolocal(*#line 3067.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 28, ( result, decnolocal1left, decnolocal1right), rest671)
end
|  ( 117, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.decs decs2, _, _)) :: _ :: ( _, ( MlyValue.decs decs1, _, _)) :: ( _, ( _, LOCAL1left, _)) :: rest671)) => let val  result = MlyValue.decnode (fn _ => let val  decs1 = decs1 ()
 val  decs2 = decs2 ()
 in ((*#line 746.36 "ml.grm"*)Dec.Local (decs1,decs2)(*#line 3073.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 28, ( result, LOCAL1left, END1right), rest671)
end
|  ( 118, ( ( _, ( MlyValue.valbindTop valbindTop1, _, valbindTop1right)) :: ( _, ( _, VAL1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (valbindTop as valbindTop1) = valbindTop1 ()
 in ((*#line 749.36 "ml.grm"*)Dec.Val {tyvars = Vector.new0 (),
                                            vbs = #1 valbindTop,
                                            rvbs = #2 valbindTop}(*#line 3080.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, VAL1left, valbindTop1right), rest671)
end
|  ( 119, ( ( _, ( MlyValue.valbindTop valbindTop1, _, valbindTop1right)) :: ( _, ( MlyValue.tyvarseq tyvarseq1, _, _)) :: ( _, ( _, VAL1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (tyvarseq as tyvarseq1) = tyvarseq1 ()
 val  (valbindTop as valbindTop1) = valbindTop1 ()
 in ((*#line 752.37 "ml.grm"*)Dec.Val {tyvars = tyvarseq,
                                             vbs = #1 valbindTop,
                                             rvbs = #2 valbindTop}(*#line 3088.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, VAL1left, valbindTop1right), rest671)
end
|  ( 120, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: ( _, ( _, DO1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (exp as exp1) = exp1 ()
 in ((*#line 755.34 "ml.grm"*)Dec.DoDec exp(*#line 3097.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, DO1left, exp1right), rest671)
end
|  ( 121, ( ( _, ( MlyValue.funs funs1, _, funs1right)) :: ( _, ( _, FUN1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (funs as funs1) = funs1 ()
 in ((*#line 756.34 "ml.grm"*)Dec.Fun {tyvars = Vector.new0 (), fbs = Vector.fromList funs}(*#line 3103.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, FUN1left, funs1right), rest671)
end
|  ( 122, ( ( _, ( MlyValue.funs funs1, _, funs1right)) :: ( _, ( MlyValue.tyvarseq tyvarseq1, _, _)) :: ( _, ( _, FUN1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (tyvarseq as tyvarseq1) = tyvarseq1 ()
 val  (funs as funs1) = funs1 ()
 in ((*#line 757.34 "ml.grm"*)Dec.Fun {tyvars = tyvarseq, fbs = Vector.fromList funs}(*#line 3109.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, FUN1left, funs1right), rest671)
end
|  ( 123, ( ( _, ( MlyValue.typBind typBind1, _, typBind1right)) :: ( _, ( _, TYPE1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (typBind as typBind1) = typBind1 ()
 in ((*#line 758.34 "ml.grm"*)Dec.Type typBind(*#line 3116.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, TYPE1left, typBind1right), rest671)
end
|  ( 124, ( ( _, ( MlyValue.datatypeRhs datatypeRhs1, _, datatypeRhs1right)) :: ( _, ( _, DATATYPE1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (datatypeRhs as datatypeRhs1) = datatypeRhs1 ()
 in ((*#line 759.34 "ml.grm"*)Dec.Datatype datatypeRhs(*#line 3122.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, DATATYPE1left, datatypeRhs1right), rest671)
end
|  ( 125, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.decs decs1, _, _)) :: _ :: ( _, ( MlyValue.datBind datBind1, _, _)) :: ( _, ( _, ABSTYPE1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (datBind as datBind1) = datBind1 ()
 val  (decs as decs1) = decs1 ()
 in ((*#line 760.44 "ml.grm"*)Dec.Abstype {datBind = datBind,
                                                        body = decs}(*#line 3128.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, ABSTYPE1left, END1right), rest671)
end
|  ( 126, ( ( _, ( MlyValue.ebs ebs1, _, ebs1right)) :: ( _, ( _, EXCEPTION1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (ebs as ebs1) = ebs1 ()
 in ((*#line 762.34 "ml.grm"*)Dec.Exception (Vector.fromList ebs)(*#line 3136.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, EXCEPTION1left, ebs1right), rest671)
end
|  ( 127, ( ( _, ( MlyValue.longstrids longstrids1, _, longstrids1right)) :: ( _, ( _, OPEN1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (longstrids as longstrids1) = longstrids1 ()
 in ((*#line 763.34 "ml.grm"*)Dec.Open (Vector.fromList longstrids)(*#line 3142.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, OPEN1left, longstrids1right), rest671)
end
|  ( 128, ( ( _, ( MlyValue.vids vids1, _, vids1right)) :: ( _, ( MlyValue.fixity fixity1, fixity1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (fixity as fixity1) = fixity1 ()
 val  (vids as vids1) = vids1 ()
 in ((*#line 764.34 "ml.grm"*)Dec.Fix {fixity = fixity,
                                          ops = Vector.fromList vids}(*#line 3148.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, fixity1left, vids1right), rest671)
end
|  ( 129, ( ( _, ( MlyValue.longvidands longvidands1, _, longvidands1right)) :: _ :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.vid vid1, _, _)) :: ( _, ( MlyValue.priority priority1, _, _)) :: ( _, ( _, OVERLOAD1left, _)) :: rest671)) => let val  result = MlyValue.decnolocal (fn _ => let val  (priority as priority1) = priority1 ()
 val  (vid as vid1) = vid1 ()
 val  (ty as ty1) = ty1 ()
 val  (longvidands as longvidands1) = longvidands1 ()
 in ((*#line 767.34 "ml.grm"*)Dec.Overload (priority, 
                                               Vid.toVar vid,
                                               Vector.new0 (),
                                               ty,
                                               Vector.fromList longvidands)(*#line 3156.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 29, ( result, OVERLOAD1left, longvidands1right), rest671)
end
|  ( 130, ( ( _, ( MlyValue.valbind valbind1, valbind1left, valbind1right)) :: rest671)) => let val  result = MlyValue.valbindTop (fn _ => let val  (valbind as valbind1) = valbind1 ()
 in ((*#line 773.23 "ml.grm"*)let
                         val (vbs, rvbs) = valbind
                      in
                         (Vector.fromList vbs,
                          Vector.fromList rvbs)
                      end(*#line 3169.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 152, ( result, valbind1left, valbind1right), rest671)
end
|  ( 131, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: _ :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = MlyValue.valbind (fn _ => let val  (pat as pat1) = pat1 ()
 val  (exp as exp1) = exp1 ()
 in ((*#line 781.15 "ml.grm"*)([{pat = pat, exp = exp}], [])(*#line 3180.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 151, ( result, pat1left, exp1right), rest671)
end
|  ( 132, ( ( _, ( MlyValue.valbind valbind1, _, valbind1right)) :: _ :: ( _, ( MlyValue.exp exp1, _, _)) :: _ :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = MlyValue.valbind (fn _ => let val  (pat as pat1) = pat1 ()
 val  (exp as exp1) = exp1 ()
 val  (valbind as valbind1) = valbind1 ()
 in ((*#line 783.15 "ml.grm"*)let
                 val (vbs, rvbs) = valbind
              in
                 ({pat = pat, exp = exp} :: vbs,
                  rvbs)
              end(*#line 3187.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 151, ( result, pat1left, valbind1right), rest671)
end
|  ( 133, ( ( _, ( MlyValue.rvalbind rvalbind1, _, rvalbind1right)) :: ( _, ( _, REC1left, _)) :: rest671)) => let val  result = MlyValue.valbind (fn _ => let val  (rvalbind as rvalbind1) = rvalbind1 ()
 in ((*#line 789.41 "ml.grm"*)([], rvalbind)(*#line 3200.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 151, ( result, REC1left, rvalbind1right), rest671)
end
|  ( 134, ( ( _, ( MlyValue.rvalbind rvalbind1, _, rvalbind1right)) :: ( _, ( _, REC1left, _)) :: rest671)) => let val  result = MlyValue.rvalbind (fn _ => let val  (rvalbind as rvalbind1) = rvalbind1 ()
 in ((*#line 791.41 "ml.grm"*)rvalbind(*#line 3206.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 88, ( result, REC1left, rvalbind1right), rest671)
end
|  ( 135, ( ( _, ( MlyValue.match match1, _, match1right)) :: _ :: _ :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = MlyValue.rvalbind (fn _ => let val  (pat as pat1) = pat1 ()
 val  (match as match1) = match1 ()
 in ((*#line 793.15 "ml.grm"*)[{pat = pat, match = match}](*#line 3212.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 88, ( result, pat1left, match1right), rest671)
end
|  ( 136, ( ( _, ( MlyValue.rvalbind rvalbind1, _, rvalbind1right)) :: _ :: ( _, ( MlyValue.match match1, _, _)) :: _ :: _ :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = MlyValue.rvalbind (fn _ => let val  (pat as pat1) = pat1 ()
 val  (match as match1) = match1 ()
 val  (rvalbind as rvalbind1) = rvalbind1 ()
 in ((*#line 795.15 "ml.grm"*){pat = pat, match = match} :: rvalbind(*#line 3219.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 88, ( result, pat1left, rvalbind1right), rest671)
end
|  ( 137, ( rest671)) => let val  result = MlyValue.constraint (fn _ => ((*#line 797.34 "ml.grm"*)NONE(*#line 3227.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 16, ( result, defaultPos, defaultPos), rest671)
end
|  ( 138, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: ( _, ( _, COLON1left, _)) :: rest671)) => let val  result = MlyValue.constraint (fn _ => let val  (ty as ty1) = ty1 ()
 in ((*#line 798.34 "ml.grm"*)SOME ty(*#line 3231.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 16, ( result, COLON1left, ty1right), rest671)
end
|  ( 139, ( ( _, ( MlyValue.clausesTop clausesTop1, clausesTop1left, clausesTop1right)) :: rest671)) => let val  result = MlyValue.funs (fn _ => let val  (clausesTop as clausesTop1) = clausesTop1 ()
 in ((*#line 800.37 "ml.grm"*)[clausesTop](*#line 3237.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 57, ( result, clausesTop1left, clausesTop1right), rest671)
end
|  ( 140, ( ( _, ( MlyValue.funs funs1, _, funs1right)) :: _ :: ( _, ( MlyValue.clausesTop clausesTop1, clausesTop1left, _)) :: rest671)) => let val  result = MlyValue.funs (fn _ => let val  (clausesTop as clausesTop1) = clausesTop1 ()
 val  (funs as funs1) = funs1 ()
 in ((*#line 801.37 "ml.grm"*)clausesTop :: funs(*#line 3243.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 57, ( result, clausesTop1left, funs1right), rest671)
end
|  ( 141, ( ( _, ( MlyValue.clauses clauses1, clauses1left, clauses1right)) :: rest671)) => let val  result = MlyValue.clausesTop (fn _ => let val  (clauses as clauses1) = clauses1 ()
 in ((*#line 803.22 "ml.grm"*)Vector.fromList clauses(*#line 3250.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 10, ( result, clauses1left, clauses1right), rest671)
end
|  ( 142, ( ( _, ( MlyValue.clauses clauses1, _, clauses1right)) :: ( _, ( MlyValue.optbar' optbar'1, optbar'1left, _)) :: rest671)) => let val  result = MlyValue.clausesTop (fn _ => let val  optbar'1 = optbar'1 ()
 val  (clauses as clauses1) = clauses1 ()
 in ((*#line 804.30 "ml.grm"*)Vector.fromList clauses(*#line 3256.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 10, ( result, optbar'1left, clauses1right), rest671)
end
|  ( 143, ( ( _, ( MlyValue.clause clause1, clause1left, clause1right)) :: rest671)) => let val  result = MlyValue.clauses (fn _ => let val  (clause as clause1) = clause1 ()
 in ((*#line 806.34 "ml.grm"*)[clause](*#line 3263.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 9, ( result, clause1left, clause1right), rest671)
end
|  ( 144, ( ( _, ( MlyValue.clauses clauses1, _, clauses1right)) :: _ :: ( _, ( MlyValue.clause clause1, clause1left, _)) :: rest671)) => let val  result = MlyValue.clauses (fn _ => let val  (clause as clause1) = clause1 ()
 val  (clauses as clauses1) = clauses1 ()
 in ((*#line 807.34 "ml.grm"*)clause :: clauses(*#line 3269.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 9, ( result, clause1left, clauses1right), rest671)
end
|  ( 145, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: _ :: ( _, ( MlyValue.constraint constraint1, _, _)) :: ( _, ( MlyValue.apats apats1, apats1left, _)) :: rest671)) => let val  result = MlyValue.clause (fn _ => let val  (apats as apats1) = apats1 ()
 val  (constraint as constraint1) = constraint1 ()
 val  (exp as exp1) = exp1 ()
 in ((*#line 809.42 "ml.grm"*){pats = Vector.fromList apats,
                                          resultType = constraint,
                                          body = exp}(*#line 3276.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 8, ( result, apats1left, exp1right), rest671)
end
|  ( 146, ( ( _, ( MlyValue.tbs tbs1, (tbsleft as tbs1left), (tbsright as tbs1right))) :: rest671)) => let val  result = MlyValue.typBind (fn _ => let val  (tbs as tbs1) = tbs1 ()
 in ((*#line 814.12 "ml.grm"*)TypBind.makeRegion' (TypBind.T tbs, tbsleft, tbsright)(*#line 3286.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 144, ( result, tbs1left, tbs1right), rest671)
end
|  ( 147, ( ( _, ( MlyValue.tbs' tbs'1, tbs'1left, tbs'1right)) :: rest671)) => let val  result = MlyValue.tbs (fn _ => let val  (tbs' as tbs'1) = tbs'1 ()
 in ((*#line 816.14 "ml.grm"*)Vector.fromList tbs'(*#line 3292.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 129, ( result, tbs'1left, tbs'1right), rest671)
end
|  ( 148, ( ( _, ( MlyValue.tb tb1, tb1left, tb1right)) :: rest671)) => let val  result = MlyValue.tbs' (fn _ => let val  (tb as tb1) = tb1 ()
 in ((*#line 818.22 "ml.grm"*)[tb](*#line 3298.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 130, ( result, tb1left, tb1right), rest671)
end
|  ( 149, ( ( _, ( MlyValue.tbs' tbs'1, _, tbs'1right)) :: _ :: ( _, ( MlyValue.tb tb1, tb1left, _)) :: rest671)) => let val  result = MlyValue.tbs' (fn _ => let val  (tb as tb1) = tb1 ()
 val  (tbs' as tbs'1) = tbs'1 ()
 in ((*#line 819.22 "ml.grm"*)tb :: tbs'(*#line 3304.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 130, ( result, tb1left, tbs'1right), rest671)
end
|  ( 150, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( MlyValue.tycon tycon1, _, _)) :: ( _, ( MlyValue.tyvars tyvars1, tyvars1left, _)) :: rest671)) => let val  result = MlyValue.tb (fn _ => let val  (tyvars as tyvars1) = tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 822.7 "ml.grm"*){def = ty,
       tycon = tycon,
       tyvars = tyvars}(*#line 3311.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 128, ( result, tyvars1left, ty1right), rest671)
end
|  ( 151, ( ( _, ( MlyValue.tyvarseq tyvarseq1, tyvarseq1left, tyvarseq1right)) :: rest671)) => let val  result = MlyValue.tyvars (fn _ => let val  (tyvarseq as tyvarseq1) = tyvarseq1 ()
 in ((*#line 826.21 "ml.grm"*)tyvarseq(*#line 3321.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 149, ( result, tyvarseq1left, tyvarseq1right), rest671)
end
|  ( 152, ( rest671)) => let val  result = MlyValue.tyvars (fn _ => ((*#line 827.21 "ml.grm"*)Vector.new0 ()(*#line 3327.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 149, ( result, defaultPos, defaultPos), rest671)
end
|  ( 153, ( ( _, ( MlyValue.tyvar tyvar1, tyvar1left, tyvar1right)) :: rest671)) => let val  result = MlyValue.tyvarseq (fn _ => let val  (tyvar as tyvar1) = tyvar1 ()
 in ((*#line 829.36 "ml.grm"*)Vector.new1 tyvar(*#line 3331.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 150, ( result, tyvar1left, tyvar1right), rest671)
end
|  ( 154, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.tyvar_pc tyvar_pc1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.tyvarseq (fn _ => let val  (tyvar_pc as tyvar_pc1) = tyvar_pc1 ()
 in ((*#line 830.36 "ml.grm"*)Vector.fromList tyvar_pc(*#line 3337.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 150, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 155, ( ( _, ( MlyValue.tyvar tyvar1, tyvar1left, tyvar1right)) :: rest671)) => let val  result = MlyValue.tyvar_pc (fn _ => let val  (tyvar as tyvar1) = tyvar1 ()
 in ((*#line 832.33 "ml.grm"*)[tyvar](*#line 3343.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 148, ( result, tyvar1left, tyvar1right), rest671)
end
|  ( 156, ( ( _, ( MlyValue.tyvar_pc tyvar_pc1, _, tyvar_pc1right)) :: _ :: ( _, ( MlyValue.tyvar tyvar1, tyvar1left, _)) :: rest671)) => let val  result = MlyValue.tyvar_pc (fn _ => let val  (tyvar as tyvar1) = tyvar1 ()
 val  (tyvar_pc as tyvar_pc1) = tyvar_pc1 ()
 in ((*#line 833.33 "ml.grm"*)tyvar :: tyvar_pc(*#line 3349.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 148, ( result, tyvar1left, tyvar_pc1right), rest671)
end
|  ( 157, ( ( _, ( MlyValue.constr constr1, constr1left, constr1right)) :: rest671)) => let val  result = MlyValue.constrs (fn _ => let val  (constr as constr1) = constr1 ()
 in ((*#line 835.34 "ml.grm"*)[constr](*#line 3356.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 17, ( result, constr1left, constr1right), rest671)
end
|  ( 158, ( ( _, ( MlyValue.constrs constrs1, _, constrs1right)) :: _ :: ( _, ( MlyValue.constr constr1, constr1left, _)) :: rest671)) => let val  result = MlyValue.constrs (fn _ => let val  (constr as constr1) = constr1 ()
 val  (constrs as constrs1) = constrs1 ()
 in ((*#line 836.34 "ml.grm"*)constr :: constrs(*#line 3362.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 17, ( result, constr1left, constrs1right), rest671)
end
|  ( 159, ( ( _, ( MlyValue.opcon opcon1, opcon1left, opcon1right)) :: rest671)) => let val  result = MlyValue.constr (fn _ => let val  (opcon as opcon1) = opcon1 ()
 in ((*#line 838.26 "ml.grm"*)opcon, NONE(*#line 3369.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 15, ( result, opcon1left, opcon1right), rest671)
end
|  ( 160, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( MlyValue.opcon opcon1, opcon1left, _)) :: rest671)) => let val  result = MlyValue.constr (fn _ => let val  (opcon as opcon1) = opcon1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 839.26 "ml.grm"*)opcon, SOME ty(*#line 3375.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 15, ( result, opcon1left, ty1right), rest671)
end
|  ( 161, ( ( _, ( MlyValue.con con1, con1left, con1right)) :: rest671)) => let val  result = MlyValue.opcon (fn _ => let val  (con as con1) = con1 ()
 in ((*#line 841.26 "ml.grm"*)con(*#line 3382.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 75, ( result, con1left, con1right), rest671)
end
|  ( 162, ( ( _, ( MlyValue.con con1, _, con1right)) :: ( _, ( _, OP1left, _)) :: rest671)) => let val  result = MlyValue.opcon (fn _ => let val  (con as con1) = con1 ()
 in ((*#line 842.26 "ml.grm"*)con(*#line 3388.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 75, ( result, OP1left, con1right), rest671)
end
|  ( 163, ( ( _, ( MlyValue.eb eb1, eb1left, eb1right)) :: rest671)) => let val  result = MlyValue.ebs (fn _ => let val  (eb as eb1) = eb1 ()
 in ((*#line 844.28 "ml.grm"*)[eb](*#line 3394.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 36, ( result, eb1left, eb1right), rest671)
end
|  ( 164, ( ( _, ( MlyValue.ebs ebs1, _, ebs1right)) :: _ :: ( _, ( MlyValue.eb eb1, eb1left, _)) :: rest671)) => let val  result = MlyValue.ebs (fn _ => let val  (eb as eb1) = eb1 ()
 val  (ebs as ebs1) = ebs1 ()
 in ((*#line 845.28 "ml.grm"*)eb::ebs(*#line 3400.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 36, ( result, eb1left, ebs1right), rest671)
end
|  ( 165, ( ( _, ( MlyValue.ebrhs ebrhs1, _, ebrhs1right)) :: ( _, ( MlyValue.opcon opcon1, opcon1left, _)) :: rest671)) => let val  result = MlyValue.eb (fn _ => let val  (opcon as opcon1) = opcon1 ()
 val  (ebrhs as ebrhs1) = ebrhs1 ()
 in ((*#line 847.28 "ml.grm"*)opcon, ebrhs(*#line 3407.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 33, ( result, opcon1left, ebrhs1right), rest671)
end
|  ( 166, ( ( _, ( MlyValue.ebrhsnode ebrhsnode1, (ebrhsnodeleft as ebrhsnode1left), (ebrhsnoderight as ebrhsnode1right))) :: rest671)) => let val  result = MlyValue.ebrhs (fn _ => let val  (ebrhsnode as ebrhsnode1) = ebrhsnode1 ()
 in ((*#line 849.20 "ml.grm"*)EbRhs.makeRegion' (ebrhsnode,
                                     ebrhsnodeleft, ebrhsnoderight)(*#line 3414.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 34, ( result, ebrhsnode1left, ebrhsnode1right), rest671)
end
|  ( 167, ( rest671)) => let val  result = MlyValue.ebrhsnode (fn _ => ((*#line 852.35 "ml.grm"*)EbRhs.Gen NONE(*#line 3421.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 35, ( result, defaultPos, defaultPos), rest671)
end
|  ( 168, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: ( _, ( _, OF1left, _)) :: rest671)) => let val  result = MlyValue.ebrhsnode (fn _ => let val  (ty as ty1) = ty1 ()
 in ((*#line 853.35 "ml.grm"*)EbRhs.Gen (SOME ty)(*#line 3425.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 35, ( result, OF1left, ty1right), rest671)
end
|  ( 169, ( ( _, ( MlyValue.longcon longcon1, _, longcon1right)) :: ( _, ( _, EQUALOP1left, _)) :: rest671)) => let val  result = MlyValue.ebrhsnode (fn _ => let val  (longcon as longcon1) = longcon1 ()
 in ((*#line 854.35 "ml.grm"*)EbRhs.Def longcon(*#line 3431.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 35, ( result, EQUALOP1left, longcon1right), rest671)
end
|  ( 170, ( ( _, ( MlyValue.longcon longcon1, _, longcon1right)) :: _ :: ( _, ( _, EQUALOP1left, _)) :: rest671)) => let val  result = MlyValue.ebrhsnode (fn _ => let val  (longcon as longcon1) = longcon1 ()
 in ((*#line 855.35 "ml.grm"*)EbRhs.Def longcon(*#line 3437.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 35, ( result, EQUALOP1left, longcon1right), rest671)
end
|  ( 171, ( ( _, ( _, INFIX1left, INFIX1right)) :: rest671)) => let val  result = MlyValue.fixity (fn _ => ((*#line 857.34 "ml.grm"*)Fixity.Infix NONE(*#line 3443.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 51, ( result, INFIX1left, INFIX1right), rest671)
end
|  ( 172, ( ( _, ( MlyValue.digit digit1, _, digit1right)) :: ( _, ( _, INFIX1left, _)) :: rest671)) => let val  result = MlyValue.fixity (fn _ => let val  (digit as digit1) = digit1 ()
 in ((*#line 858.34 "ml.grm"*)Fixity.Infix (SOME digit)(*#line 3447.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 51, ( result, INFIX1left, digit1right), rest671)
end
|  ( 173, ( ( _, ( _, INFIXR1left, INFIXR1right)) :: rest671)) => let val  result = MlyValue.fixity (fn _ => ((*#line 859.34 "ml.grm"*)Fixity.Infixr NONE(*#line 3453.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 51, ( result, INFIXR1left, INFIXR1right), rest671)
end
|  ( 174, ( ( _, ( MlyValue.digit digit1, _, digit1right)) :: ( _, ( _, INFIXR1left, _)) :: rest671)) => let val  result = MlyValue.fixity (fn _ => let val  (digit as digit1) = digit1 ()
 in ((*#line 860.34 "ml.grm"*)Fixity.Infixr (SOME digit)(*#line 3457.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 51, ( result, INFIXR1left, digit1right), rest671)
end
|  ( 175, ( ( _, ( _, NONFIX1left, NONFIX1right)) :: rest671)) => let val  result = MlyValue.fixity (fn _ => ((*#line 861.34 "ml.grm"*)Fixity.Nonfix(*#line 3463.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 51, ( result, NONFIX1left, NONFIX1right), rest671)
end
|  ( 176, ( rest671)) => let val  result = MlyValue.priority (fn _ => ((*#line 863.34 "ml.grm"*)Priority.T NONE(*#line 3467.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 83, ( result, defaultPos, defaultPos), rest671)
end
|  ( 177, ( ( _, ( MlyValue.digit digit1, digit1left, digit1right)) :: rest671)) => let val  result = MlyValue.priority (fn _ => let val  (digit as digit1) = digit1 ()
 in ((*#line 864.34 "ml.grm"*)Priority.T (SOME digit)(*#line 3471.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 83, ( result, digit1left, digit1right), rest671)
end
|  ( 178, ( ( _, ( MlyValue.INT INT1, INT1left, INT1right)) :: rest671)) => let val  result = MlyValue.int (fn _ => let val  (INT as INT1) = INT1 ()
 in ((*#line 867.5 "ml.grm"*)let
       val {digits, negate, radix, ...} = INT
    in
       case StringCvt.scanString (fn r => IntInf.scan (radix, r)) digits of
          NONE => Error.bug "parser saw invalid int"
        | SOME i => if negate then ~ i else i
    end(*#line 3477.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 59, ( result, INT1left, INT1right), rest671)
end
|  ( 179, ( ( _, ( MlyValue.WORD WORD1, WORD1left, WORD1right)) :: rest671)) => let val  result = MlyValue.word (fn _ => let val  (WORD as WORD1) = WORD1 ()
 in ((*#line 876.5 "ml.grm"*)let
       val {digits, radix} = WORD
    in
       case StringCvt.scanString (fn r => IntInf.scan (radix, r)) digits of
          NONE => Error.bug "parser saw invalid word"
        | SOME i => i
    end(*#line 3489.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 164, ( result, WORD1left, WORD1right), rest671)
end
|  ( 180, ( ( _, ( MlyValue.INT INT1, (INTleft as INT1left), (INTright as INT1right))) :: rest671)) => let val  result = MlyValue.digit (fn _ => let val  (INT as INT1) = INT1 ()
 in ((*#line 885.5 "ml.grm"*)let
       val {digits, extended, negate, radix} = INT
    in
       if 1 = String.size digits andalso not extended andalso not negate andalso radix = StringCvt.DEC
          then valOf (Int.fromString digits)
       else let
               open Layout
               val _ = 
                  Control.error (reg (INTleft, INTright),
                                 str "invalid digit in infix declaration",
                                 empty)
            in
               0
            end
    end(*#line 3501.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 32, ( result, INT1left, INT1right), rest671)
end
|  ( 181, ( ( _, ( MlyValue.INT INT1, (INTleft as INT1left), (INTright as INT1right))) :: rest671)) => let val  result = MlyValue.numericField (fn _ => let val  (INT as INT1) = INT1 ()
 in ((*#line 902.5 "ml.grm"*)let
       val {digits, extended, negate, radix} = INT
       fun err () =
          let
             open Layout
             val _ =
                Control.error (reg (INTleft, INTright),
                               str "invalid numeric label",
                               empty)
          in
             1
          end
    in
       if String.sub (digits, 0) <> #"0" andalso not extended andalso not negate andalso radix = StringCvt.DEC
          then case StringCvt.scanString (fn r => IntInf.scan (radix, r)) digits of
                  NONE => Error.bug "parser saw invalid int"
                | SOME i => (IntInf.toInt (if negate then ~ i else i)
                             handle Exn.Overflow => err ())
       else err ()
    end(*#line 3521.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 73, ( result, INT1left, INT1right), rest671)
end
|  ( 182, ( ( _, ( MlyValue.datatypeRhsnode datatypeRhsnode1, (datatypeRhsnodeleft as datatypeRhsnode1left), (datatypeRhsnoderight as datatypeRhsnode1right))) :: rest671)) => let val  result = MlyValue.datatypeRhs (fn _ => let val  (datatypeRhsnode as datatypeRhsnode1) = datatypeRhsnode1 ()
 in ((*#line 925.7 "ml.grm"*)DatatypeRhs.makeRegion' (datatypeRhsnode,
                               datatypeRhsnodeleft, datatypeRhsnoderight)(*#line 3546.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 22, ( result, datatypeRhsnode1left, datatypeRhsnode1right), rest671)
end
|  ( 183, ( ( _, ( MlyValue.repl repl1, repl1left, repl1right)) :: rest671)) => let val  result = MlyValue.datatypeRhsnode (fn _ => let val  (repl as repl1) = repl1 ()
 in ((*#line 929.25 "ml.grm"*)repl(*#line 3553.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 23, ( result, repl1left, repl1right), rest671)
end
|  ( 184, ( ( _, ( MlyValue.datBind datBind1, datBind1left, datBind1right)) :: rest671)) => let val  result = MlyValue.datatypeRhsnode (fn _ => let val  (datBind as datBind1) = datBind1 ()
 in ((*#line 930.25 "ml.grm"*)DatatypeRhs.DatBind datBind(*#line 3559.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 23, ( result, datBind1left, datBind1right), rest671)
end
|  ( 185, ( ( _, ( MlyValue.longtycon longtycon1, _, longtycon1right)) :: _ :: _ :: ( _, ( MlyValue.tycon tycon1, _, _)) :: ( _, ( MlyValue.tyvars tyvars1, (tyvarsleft as tyvars1left), tyvarsright)) :: rest671)) => let val  result = MlyValue.repl (fn _ => let val  (tyvars as tyvars1) = tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 in ((*#line 933.9 "ml.grm"*)if Vector.isEmpty tyvars
           then ()
        else error (reg (tyvarsleft, tyvarsright),
                    "nonempty tyvars in datatype repl")
        ; DatatypeRhs.Repl {lhs = tycon, rhs = longtycon}(*#line 3565.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 85, ( result, tyvars1left, longtycon1right), rest671)
end
|  ( 186, ( ( _, ( MlyValue.dbs dbs1, (dbsleft as dbs1left), (dbsright as dbs1right))) :: rest671)) => let val  result = MlyValue.datBind (fn _ => let val  (dbs as dbs1) = dbs1 ()
 in ((*#line 941.7 "ml.grm"*)DatBind.make (dbs, TypBind.empty, dbsleft, dbsright)(*#line 3577.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 21, ( result, dbs1left, dbs1right), rest671)
end
|  ( 187, ( ( _, ( MlyValue.withtypes withtypes1, _, (withtypesright as withtypes1right))) :: ( _, ( MlyValue.dbs dbs1, (dbsleft as dbs1left), _)) :: rest671)) => let val  result = MlyValue.datBind (fn _ => let val  (dbs as dbs1) = dbs1 ()
 val  (withtypes as withtypes1) = withtypes1 ()
 in ((*#line 943.7 "ml.grm"*)DatBind.make (dbs, withtypes, dbsleft, withtypesright)(*#line 3583.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 21, ( result, dbs1left, withtypes1right), rest671)
end
|  ( 188, ( ( _, ( MlyValue.dbs' dbs'1, dbs'1left, dbs'1right)) :: rest671)) => let val  result = MlyValue.dbs (fn _ => let val  (dbs' as dbs'1) = dbs'1 ()
 in ((*#line 945.13 "ml.grm"*)Vector.fromList dbs'(*#line 3590.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 25, ( result, dbs'1left, dbs'1right), rest671)
end
|  ( 189, ( ( _, ( MlyValue.db db1, db1left, db1right)) :: rest671)) => let val  result = MlyValue.dbs' (fn _ => let val  (db as db1) = db1 ()
 in ((*#line 947.22 "ml.grm"*)[db](*#line 3596.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 26, ( result, db1left, db1right), rest671)
end
|  ( 190, ( ( _, ( MlyValue.dbs' dbs'1, _, dbs'1right)) :: _ :: ( _, ( MlyValue.db db1, db1left, _)) :: rest671)) => let val  result = MlyValue.dbs' (fn _ => let val  (db as db1) = db1 ()
 val  (dbs' as dbs'1) = dbs'1 ()
 in ((*#line 948.22 "ml.grm"*)db :: dbs'(*#line 3602.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 26, ( result, db1left, dbs'1right), rest671)
end
|  ( 191, ( ( _, ( MlyValue.constrs constrs1, _, constrs1right)) :: ( _, ( MlyValue.optbar optbar1, _, _)) :: _ :: ( _, ( MlyValue.tycon tycon1, _, _)) :: ( _, ( MlyValue.tyvars tyvars1, tyvars1left, _)) :: rest671)) => let val  result = MlyValue.db (fn _ => let val  (tyvars as tyvars1) = tyvars1 ()
 val  (tycon as tycon1) = tycon1 ()
 val  optbar1 = optbar1 ()
 val  (constrs as constrs1) = constrs1 ()
 in ((*#line 951.7 "ml.grm"*){cons = Vector.fromList constrs,
       tycon = tycon,
       tyvars = tyvars}(*#line 3609.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 24, ( result, tyvars1left, constrs1right), rest671)
end
|  ( 192, ( ( _, ( MlyValue.typBind typBind1, _, typBind1right)) :: ( _, ( _, WITHTYPE1left, _)) :: rest671)) => let val  result = MlyValue.withtypes (fn _ => let val  (typBind as typBind1) = typBind1 ()
 in ((*#line 955.32 "ml.grm"*)typBind(*#line 3620.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 163, ( result, WITHTYPE1left, typBind1right), rest671)
end
|  ( 193, ( ( _, ( MlyValue.longvid longvid1, longvid1left, longvid1right)) :: rest671)) => let val  result = MlyValue.longvidands (fn _ => let val  (longvid as longvid1) = longvid1 ()
 in ((*#line 957.25 "ml.grm"*)[longvid](*#line 3626.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 71, ( result, longvid1left, longvid1right), rest671)
end
|  ( 194, ( ( _, ( MlyValue.longvidands longvidands1, _, longvidands1right)) :: _ :: ( _, ( MlyValue.longvid longvid1, longvid1left, _)) :: rest671)) => let val  result = MlyValue.longvidands (fn _ => let val  (longvid as longvid1) = longvid1 ()
 val  (longvidands as longvidands1) = longvidands1 ()
 in ((*#line 958.40 "ml.grm"*)longvid :: longvidands(*#line 3632.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 71, ( result, longvid1left, longvidands1right), rest671)
end
|  ( 195, ( ( _, ( MlyValue.rules rules1, rulesleft, (rulesright as rules1right))) :: ( _, ( MlyValue.optbar optbar1, optbar1left, _)) :: rest671)) => let val  result = MlyValue.match (fn _ => let val  optbar1 = optbar1 ()
 val  (rules as rules1) = rules1 ()
 in ((*#line 960.26 "ml.grm"*)Match.makeRegion' (Match.T (Vector.fromList rules),
                                            rulesleft, rulesright)(*#line 3639.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 72, ( result, optbar1left, rules1right), rest671)
end
|  ( 196, ( ( _, ( MlyValue.rule rule1, rule1left, rule1right)) :: rest671)) => let val  result = MlyValue.rules (fn _ => let val  (rule as rule1) = rule1 ()
 in ((*#line 963.26 "ml.grm"*)[rule](*#line 3647.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 87, ( result, rule1left, rule1right), rest671)
end
|  ( 197, ( ( _, ( MlyValue.rules rules1, _, rules1right)) :: _ :: ( _, ( MlyValue.rule rule1, rule1left, _)) :: rest671)) => let val  result = MlyValue.rules (fn _ => let val  (rule as rule1) = rule1 ()
 val  (rules as rules1) = rules1 ()
 in ((*#line 964.26 "ml.grm"*)rule :: rules(*#line 3653.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 87, ( result, rule1left, rules1right), rest671)
end
|  ( 198, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: _ :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = MlyValue.rule (fn _ => let val  (pat as pat1) = pat1 ()
 val  (exp as exp1) = exp1 ()
 in ((*#line 966.34 "ml.grm"*)(pat,exp)(*#line 3660.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 86, ( result, pat1left, exp1right), rest671)
end
|  ( 199, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: _ :: ( _, ( MlyValue.field field1, (fieldleft as field1left), fieldright)) :: rest671)) => let val  result = MlyValue.elabel (fn _ => let val  (field as field1) = field1 ()
 val  (exp as exp1) = exp1 ()
 in ((*#line 968.34 "ml.grm"*)field, (reg (fieldleft, fieldright), exp)(*#line 3667.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 37, ( result, field1left, exp1right), rest671)
end
|  ( 200, ( ( _, ( MlyValue.constraint constraint1, _, (constraintright as constraint1right))) :: ( _, ( MlyValue.idField idField1, (idFieldleft as idField1left), idFieldright)) :: rest671)) => let val  result = MlyValue.elabel (fn _ => let val  (idField as idField1) = idField1 ()
 val  (constraint as constraint1) = constraint1 ()
 in ((*#line 969.34 "ml.grm"*)if allowRecordPunExps ()
                                    then ()
                                    else error (reg (idFieldleft, idFieldright), "Record punning expressions disallowed, compile with -default-ann 'allowRecordPunExps true'")
                                 ; (Field.Symbol (#1 idField),
                                    (reg (idFieldleft, idFieldright),
                                     let
                                        val exp =
                                           Exp.makeRegion'
                                           (Exp.FlatApp
                                            (Vector.new1
                                             (Exp.makeRegion'
                                              (Exp.Var {name = Longvid.short (Vid.fromSymbol idField),
                                                        fixop = Fixop.None},
                                               idFieldleft, idFieldright))),
                                            idFieldleft, idFieldright)
                                        val exp =
                                           case constraint of
                                              NONE => exp
                                            | SOME ty =>
                                                 Exp.makeRegion'
                                                 (Exp.Constraint (exp, ty),
                                                  idFieldleft, constraintright)
                                     in
                                        exp
                                     end))(*#line 3674.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 37, ( result, idField1left, constraint1right), rest671)
end
|  ( 201, ( ( _, ( MlyValue.elabels elabels1, _, elabels1right)) :: _ :: ( _, ( MlyValue.elabel elabel1, elabel1left, _)) :: rest671)) => let val  result = MlyValue.elabels (fn _ => let val  (elabel as elabel1) = elabel1 ()
 val  (elabels as elabels1) = elabels1 ()
 in ((*#line 995.34 "ml.grm"*)elabel :: elabels(*#line 3705.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 38, ( result, elabel1left, elabels1right), rest671)
end
|  ( 202, ( ( _, ( MlyValue.elabel elabel1, elabel1left, elabel1right)) :: rest671)) => let val  result = MlyValue.elabels (fn _ => let val  (elabel as elabel1) = elabel1 ()
 in ((*#line 996.34 "ml.grm"*)[elabel](*#line 3712.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 38, ( result, elabel1left, elabel1right), rest671)
end
|  ( 203, ( ( _, ( MlyValue.optsemicolon optsemicolon1, _, optsemicolon1right)) :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.exp_ps (fn _ => let val  (exp as exp1) = exp1 ()
 val  optsemicolon1 = optsemicolon1 ()
 in ((*#line 998.34 "ml.grm"*)[exp](*#line 3718.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 44, ( result, exp1left, optsemicolon1right), rest671)
end
|  ( 204, ( ( _, ( MlyValue.exp_ps exp_ps1, _, exp_ps1right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.exp_ps (fn _ => let val  (exp as exp1) = exp1 ()
 val  (exp_ps as exp_ps1) = exp_ps1 ()
 in ((*#line 999.34 "ml.grm"*)exp :: exp_ps(*#line 3725.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 44, ( result, exp1left, exp_ps1right), rest671)
end
|  ( 205, ( ( _, ( MlyValue.expnode expnode1, (expnodeleft as expnode1left), (expnoderight as expnode1right))) :: rest671)) => let val  result = MlyValue.exp (fn _ => let val  (expnode as expnode1) = expnode1 ()
 in ((*#line 1001.16 "ml.grm"*)Exp.makeRegion' (expnode, expnodeleft, expnoderight)(*#line 3732.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 41, ( result, expnode1left, expnode1right), rest671)
end
|  ( 206, ( ( _, ( MlyValue.match match1, _, match1right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  (exp as exp1) = exp1 ()
 val  (match as match1) = match1 ()
 in ((*#line 1003.34 "ml.grm"*)Exp.Handle (exp, match)(*#line 3738.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, exp1left, match1right), rest671)
end
|  ( 207, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in ((*#line 1004.34 "ml.grm"*)Exp.Orelse (exp1, exp2)(*#line 3745.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, exp1left, exp2right), rest671)
end
|  ( 208, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in ((*#line 1005.34 "ml.grm"*)Exp.Andalso (exp1, exp2)(*#line 3752.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, exp1left, exp2right), rest671)
end
|  ( 209, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  (exp as exp1) = exp1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1006.34 "ml.grm"*)Exp.Constraint (exp, ty)(*#line 3759.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, exp1left, ty1right), rest671)
end
|  ( 210, ( ( _, ( MlyValue.app_exp app_exp1, app_exp1left, app_exp1right)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  (app_exp as app_exp1) = app_exp1 ()
 in ((*#line 1007.34 "ml.grm"*)Exp.FlatApp (Vector.fromList app_exp)(*#line 3766.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, app_exp1left, app_exp1right), rest671)
end
|  ( 211, ( ( _, ( MlyValue.match match1, _, match1right)) :: ( _, ( _, FN1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  (match as match1) = match1 ()
 in ((*#line 1008.34 "ml.grm"*)Exp.Fn match(*#line 3772.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, FN1left, match1right), rest671)
end
|  ( 212, ( ( _, ( MlyValue.match match1, _, match1right)) :: _ :: ( _, ( MlyValue.exp exp1, _, _)) :: ( _, ( _, CASE1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  (exp as exp1) = exp1 ()
 val  (match as match1) = match1 ()
 in ((*#line 1009.34 "ml.grm"*)Exp.Case (exp, match)(*#line 3778.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, CASE1left, match1right), rest671)
end
|  ( 213, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( MlyValue.exp exp1, _, _)) :: ( _, ( _, WHILE1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in ((*#line 1010.34 "ml.grm"*)Exp.While {test = exp1, expr = exp2}(*#line 3785.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, WHILE1left, exp2right), rest671)
end
|  ( 214, ( ( _, ( MlyValue.exp exp3, _, exp3right)) :: _ :: ( _, ( MlyValue.exp exp2, _, _)) :: _ :: ( _, ( MlyValue.exp exp1, _, _)) :: ( _, ( _, IF1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 val  exp3 = exp3 ()
 in ((*#line 1011.37 "ml.grm"*)Exp.If (exp1, exp2, exp3)(*#line 3792.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, IF1left, exp3right), rest671)
end
|  ( 215, ( ( _, ( MlyValue.exp exp1, _, exp1right)) :: ( _, ( _, RAISE1left, _)) :: rest671)) => let val  result = MlyValue.expnode (fn _ => let val  (exp as exp1) = exp1 ()
 in ((*#line 1012.34 "ml.grm"*)Exp.Raise exp(*#line 3800.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 45, ( result, RAISE1left, exp1right), rest671)
end
|  ( 216, ( ( _, ( MlyValue.aexp aexp1, (aexpleft as aexp1left), (aexpright as aexp1right))) :: rest671)) => let val  result = MlyValue.app_exp (fn _ => let val  (aexp as aexp1) = aexp1 ()
 in ((*#line 1014.29 "ml.grm"*)[Exp.makeRegion' (aexp, aexpleft, aexpright)](*#line 3806.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 4, ( result, aexp1left, aexp1right), rest671)
end
|  ( 217, ( ( _, ( MlyValue.app_exp app_exp1, _, app_exp1right)) :: ( _, ( MlyValue.aexp aexp1, (aexpleft as aexp1left), aexpright)) :: rest671)) => let val  result = MlyValue.app_exp (fn _ => let val  (aexp as aexp1) = aexp1 ()
 val  (app_exp as app_exp1) = app_exp1 ()
 in ((*#line 1015.29 "ml.grm"*)Exp.makeRegion' (aexp, aexpleft, aexpright)
                            :: app_exp(*#line 3812.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 4, ( result, aexp1left, app_exp1right), rest671)
end
|  ( 218, ( ( _, ( MlyValue.longvid longvid1, (longvidleft as longvid1left), (longvidright as longvid1right))) :: rest671)) => let val  result = MlyValue.app_exp (fn _ => let val  (longvid as longvid1) = longvid1 ()
 in ((*#line 1017.29 "ml.grm"*)[Exp.makeRegion' (Exp.Var {name = longvid,
                                                       fixop = Fixop.None},
                                              longvidleft, longvidright)](*#line 3820.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 4, ( result, longvid1left, longvid1right), rest671)
end
|  ( 219, ( ( _, ( MlyValue.app_exp app_exp1, _, app_exp1right)) :: ( _, ( MlyValue.longvid longvid1, (longvidleft as longvid1left), longvidright)) :: rest671)) => let val  result = MlyValue.app_exp (fn _ => let val  (longvid as longvid1) = longvid1 ()
 val  (app_exp as app_exp1) = app_exp1 ()
 in ((*#line 1020.29 "ml.grm"*)Exp.makeRegion' (Exp.Var {name = longvid,
                                                      fixop = Fixop.None},
                                             longvidleft, longvidright)
                            :: app_exp(*#line 3828.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 4, ( result, longvid1left, app_exp1right), rest671)
end
|  ( 220, ( ( _, ( MlyValue.longvid longvid1, _, longvid1right)) :: ( _, ( _, OP1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (longvid as longvid1) = longvid1 ()
 in ((*#line 1025.34 "ml.grm"*)Exp.Var {name = longvid,
                                          fixop = Fixop.Op}(*#line 3838.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, OP1left, longvid1right), rest671)
end
|  ( 221, ( ( _, ( MlyValue.const const1, const1left, const1right)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (const as const1) = const1 ()
 in ((*#line 1027.34 "ml.grm"*)Exp.Const const(*#line 3845.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, const1left, const1right), rest671)
end
|  ( 222, ( ( _, ( MlyValue.field field1, _, field1right)) :: ( _, ( _, HASH1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (field as field1) = field1 ()
 in ((*#line 1028.34 "ml.grm"*)Exp.Selector field(*#line 3851.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, HASH1left, field1right), rest671)
end
|  ( 223, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( MlyValue.exp_list exp_list1, _, _)) :: ( _, ( _, HASHLBRACKET1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (exp_list as exp_list1) = exp_list1 ()
 in ((*#line 1029.43 "ml.grm"*)Exp.Vector (Vector.fromList exp_list)(*#line 3857.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, HASHLBRACKET1left, RBRACKET1right), rest671)
end
|  ( 224, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( _, HASHLBRACKET1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => ((*#line 1030.43 "ml.grm"*)Exp.Vector (Vector.new0 ())(*#line 3863.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 0, ( result, HASHLBRACKET1left, RBRACKET1right), rest671)
end
|  ( 225, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.elabels elabels1, _, _)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (elabels as elabels1) = elabels1 ()
 in ((*#line 1032.12 "ml.grm"*)Exp.Record (Record.fromVector (Vector.fromList elabels))(*#line 3867.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 226, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => ((*#line 1033.34 "ml.grm"*)Exp.unit(*#line 3873.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 0, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 227, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => ((*#line 1034.34 "ml.grm"*)Exp.unit(*#line 3877.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 0, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 228, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.exp_ps exp_ps1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (exp_ps as exp_ps1) = exp_ps1 ()
 in ((*#line 1036.14 "ml.grm"*)case exp_ps of
                [exp] => Exp.Paren exp
              | _ => Exp.Seq (Vector.fromList exp_ps)(*#line 3881.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 229, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.exp_2c exp_2c1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (exp_2c as exp_2c1) = exp_2c1 ()
 in ((*#line 1039.34 "ml.grm"*)Exp.tuple (Vector.fromList exp_2c)(*#line 3889.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 230, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( MlyValue.exp_list exp_list1, _, _)) :: ( _, ( _, LBRACKET1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (exp_list as exp_list1) = exp_list1 ()
 in ((*#line 1040.40 "ml.grm"*)Exp.List (Vector.fromList exp_list)(*#line 3895.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, LBRACKET1left, RBRACKET1right), rest671)
end
|  ( 231, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( _, LBRACKET1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => ((*#line 1041.40 "ml.grm"*)Exp.List (Vector.new0 ())(*#line 3901.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 0, ( result, LBRACKET1left, RBRACKET1right), rest671)
end
|  ( 232, ( ( _, ( _, _, END1right)) :: ( _, ( MlyValue.exp_ps exp_ps1, exp_psleft, exp_psright)) :: _ :: ( _, ( MlyValue.decs decs1, _, _)) :: ( _, ( _, LET1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (decs as decs1) = decs1 ()
 val  (exp_ps as exp_ps1) = exp_ps1 ()
 in ((*#line 1043.14 "ml.grm"*)Exp.Let (decs,
                      case exp_ps of
                         [exp] => exp
                       | _ => Exp.makeRegion' (Exp.Seq (Vector.fromList exp_ps),
                                               exp_psleft, exp_psright))(*#line 3905.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, LET1left, END1right), rest671)
end
|  ( 233, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.symattributes symattributes1, _, _)) :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, ADDRESS1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (symattributes as symattributes1) = symattributes1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1049.12 "ml.grm"*)Exp.Prim (PrimKind.Address {attributes = symattributes,
                                       name = string,
                                       ty = ty})(*#line 3916.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, ADDRESS1left, SEMICOLON1right), rest671)
end
|  ( 234, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, BUILD_CONST1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1053.12 "ml.grm"*)Exp.Prim (PrimKind.BuildConst {name = string, ty = ty})(*#line 3926.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, BUILD_CONST1left, SEMICOLON1right), rest671)
end
|  ( 235, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.constOrBool constOrBool1, _, _)) :: _ :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, COMMAND_LINE_CONST1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 val  (constOrBool as constOrBool1) = constOrBool1 ()
 in ((*#line 1055.12 "ml.grm"*)Exp.Prim (PrimKind.CommandLineConst {name = string,
                                                ty = ty,
                                                value = constOrBool})(*#line 3933.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, COMMAND_LINE_CONST1left, SEMICOLON1right), rest671)
end
|  ( 236, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, CONST1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1059.12 "ml.grm"*)Exp.Prim (PrimKind.Const {name = string, ty = ty})(*#line 3943.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, CONST1left, SEMICOLON1right), rest671)
end
|  ( 237, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.ieattributes ieattributes1, _, _)) :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, EXPORT1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (ieattributes as ieattributes1) = ieattributes1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1061.12 "ml.grm"*)Exp.Prim (PrimKind.Export {attributes = ieattributes,
                                      name = string,
                                      ty = ty})(*#line 3950.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, EXPORT1left, SEMICOLON1right), rest671)
end
|  ( 238, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.ieattributes ieattributes1, _, _)) :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, IMPORT1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (ieattributes as ieattributes1) = ieattributes1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1065.12 "ml.grm"*)Exp.Prim (PrimKind.Import {attributes = ieattributes,
                                      name = string,
                                      ty = ty})(*#line 3960.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, IMPORT1left, SEMICOLON1right), rest671)
end
|  ( 239, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.ieattributes ieattributes1, _, _)) :: _ :: ( _, ( _, IMPORT1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (ieattributes as ieattributes1) = ieattributes1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1069.12 "ml.grm"*)Exp.Prim (PrimKind.IImport {attributes = ieattributes,
                                       ty = ty})(*#line 3970.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, IMPORT1left, SEMICOLON1right), rest671)
end
|  ( 240, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, PRIM1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1072.12 "ml.grm"*)Exp.Prim (PrimKind.Prim {name = string,
                                    ty = ty})(*#line 3978.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, PRIM1left, SEMICOLON1right), rest671)
end
|  ( 241, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: ( _, ( MlyValue.symattributes symattributes1, _, _)) :: ( _, ( MlyValue.string string1, _, _)) :: ( _, ( _, SYMBOL1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (string as string1) = string1 ()
 val  (symattributes as symattributes1) = symattributes1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1075.12 "ml.grm"*)Exp.Prim (PrimKind.Symbol {attributes = symattributes,
                                      name = string,
                                      ty = ty})(*#line 3986.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, SYMBOL1left, SEMICOLON1right), rest671)
end
|  ( 242, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: _ :: _ :: ( _, ( _, SYMBOL1left, _)) :: rest671)) => let val  result = MlyValue.aexp (fn _ => let val  (ty as ty1) = ty1 ()
 in ((*#line 1079.12 "ml.grm"*)Exp.Prim (PrimKind.ISymbol {ty = ty})(*#line 3996.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 0, ( result, SYMBOL1left, SEMICOLON1right), rest671)
end
|  ( 243, ( rest671)) => let val  result = MlyValue.ieattributes (fn _ => ((*#line 1083.7 "ml.grm"*)[](*#line 4002.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 6, ( result, defaultPos, defaultPos), rest671)
end
|  ( 244, ( ( _, ( MlyValue.ieattributes ieattributes1, _, ieattributes1right)) :: ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, _)) :: rest671)) => let val  result = MlyValue.ieattributes (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 val  (ieattributes as ieattributes1) = ieattributes1 ()
 in ((*#line 1085.7 "ml.grm"*)let
         val (id, reg) = shortAlphanumId
      in
         case Symbol.toString id of
            "cdecl" => PrimKind.ImportExportAttribute.Cdecl :: ieattributes
          | "external" => PrimKind.ImportExportAttribute.External :: ieattributes
          | "impure" => PrimKind.ImportExportAttribute.Impure :: ieattributes
          | "inline" => PrimKind.ImportExportAttribute.Inline :: ieattributes
          | "private" => PrimKind.ImportExportAttribute.Private :: ieattributes
          | "public" => PrimKind.ImportExportAttribute.Public :: ieattributes
          | "pure" => PrimKind.ImportExportAttribute.Pure :: ieattributes
          | "reentrant" => PrimKind.ImportExportAttribute.Reentrant :: ieattributes
          | "runtime" => PrimKind.ImportExportAttribute.Runtime :: ieattributes
          | "stdcall" => PrimKind.ImportExportAttribute.Stdcall :: ieattributes
          | id => (error (reg, concat ["invalid attribute: ", id])
                   ; ieattributes)
      end(*#line 4006.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 6, ( result, shortAlphanumId1left, ieattributes1right), rest671)
end
|  ( 245, ( rest671)) => let val  result = MlyValue.symattributes (fn _ => ((*#line 1105.7 "ml.grm"*)[](*#line 4029.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 127, ( result, defaultPos, defaultPos), rest671)
end
|  ( 246, ( ( _, ( MlyValue.symattributes symattributes1, _, symattributes1right)) :: ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, _)) :: rest671)) => let val  result = MlyValue.symattributes (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 val  (symattributes as symattributes1) = symattributes1 ()
 in ((*#line 1107.7 "ml.grm"*)let
         val (id, reg) = shortAlphanumId
      in
         case Symbol.toString id of
            "alloc" => PrimKind.SymbolAttribute.Alloc :: symattributes
          | "external" => PrimKind.SymbolAttribute.External :: symattributes
          | "private" => PrimKind.SymbolAttribute.Private :: symattributes
          | "public" => PrimKind.SymbolAttribute.Public :: symattributes
          | id => (error (reg, concat ["invalid attribute: ", id])
                   ; symattributes)
      end(*#line 4033.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 127, ( result, shortAlphanumId1left, symattributes1right), rest671)
end
|  ( 247, ( ( _, ( MlyValue.exp_2c exp_2c1, _, exp_2c1right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.exp_2c (fn _ => let val  (exp as exp1) = exp1 ()
 val  (exp_2c as exp_2c1) = exp_2c1 ()
 in ((*#line 1119.34 "ml.grm"*)exp :: exp_2c(*#line 4050.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 42, ( result, exp1left, exp_2c1right), rest671)
end
|  ( 248, ( ( _, ( MlyValue.exp exp2, _, exp2right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.exp_2c (fn _ => let val  exp1 = exp1 ()
 val  exp2 = exp2 ()
 in ((*#line 1120.34 "ml.grm"*)[exp1, exp2](*#line 4057.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 42, ( result, exp1left, exp2right), rest671)
end
|  ( 249, ( ( _, ( MlyValue.exp exp1, exp1left, exp1right)) :: rest671)) => let val  result = MlyValue.exp_list (fn _ => let val  (exp as exp1) = exp1 ()
 in ((*#line 1122.34 "ml.grm"*)[exp](*#line 4064.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 43, ( result, exp1left, exp1right), rest671)
end
|  ( 250, ( ( _, ( MlyValue.exp_list exp_list1, _, exp_list1right)) :: _ :: ( _, ( MlyValue.exp exp1, exp1left, _)) :: rest671)) => let val  result = MlyValue.exp_list (fn _ => let val  (exp as exp1) = exp1 ()
 val  (exp_list as exp_list1) = exp_list1 ()
 in ((*#line 1123.34 "ml.grm"*)exp :: exp_list(*#line 4070.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 43, ( result, exp1left, exp_list1right), rest671)
end
|  ( 251, ( ( _, ( MlyValue.barcpats barcpats1, _, (barcpatsright as barcpats1right))) :: _ :: ( _, ( MlyValue.cpat cpat1, (cpatleft as cpat1left), _)) :: rest671)) => let val  result = MlyValue.pat (fn _ => let val  (cpat as cpat1) = cpat1 ()
 val  (barcpats as barcpats1) = barcpats1 ()
 in ((*#line 1129.27 "ml.grm"*)Pat.makeRegion' (Pat.Or (Vector.fromList (cpat::barcpats)),
                                           cpatleft, barcpatsright)(*#line 4077.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 79, ( result, cpat1left, barcpats1right), rest671)
end
|  ( 252, ( ( _, ( MlyValue.cpat cpat1, cpat1left, cpat1right)) :: rest671)) => let val  result = MlyValue.pat (fn _ => let val  (cpat as cpat1) = cpat1 ()
 in ((*#line 1131.27 "ml.grm"*)cpat(*#line 4085.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 79, ( result, cpat1left, cpat1right), rest671)
end
|  ( 253, ( ( _, ( MlyValue.cpatnode cpatnode1, (cpatnodeleft as cpatnode1left), (cpatnoderight as cpatnode1right))) :: rest671)) => let val  result = MlyValue.cpat (fn _ => let val  (cpatnode as cpatnode1) = cpatnode1 ()
 in ((*#line 1133.18 "ml.grm"*)Pat.makeRegion' (cpatnode, cpatnodeleft, cpatnoderight)(*#line 4091.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 19, ( result, cpatnode1left, cpatnode1right), rest671)
end
|  ( 254, ( ( _, ( MlyValue.cpat cpat2, _, cpat2right)) :: _ :: ( _, ( MlyValue.cpat cpat1, cpat1left, _)) :: rest671)) => let val  result = MlyValue.cpatnode (fn _ => let val  cpat1 = cpat1 ()
 val  cpat2 = cpat2 ()
 in ((*#line 1135.28 "ml.grm"*)Pat.makeAs (cpat1, cpat2)(*#line 4097.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 20, ( result, cpat1left, cpat2right), rest671)
end
|  ( 255, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( MlyValue.cpat cpat1, cpat1left, _)) :: rest671)) => let val  result = MlyValue.cpatnode (fn _ => let val  (cpat as cpat1) = cpat1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1136.28 "ml.grm"*)Pat.Constraint (cpat, ty)(*#line 4104.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 20, ( result, cpat1left, ty1right), rest671)
end
|  ( 256, ( ( _, ( MlyValue.apats apats1, apats1left, apats1right)) :: rest671)) => let val  result = MlyValue.cpatnode (fn _ => let val  (apats as apats1) = apats1 ()
 in ((*#line 1137.28 "ml.grm"*)Pat.FlatApp (Vector.fromList apats)(*#line 4111.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 20, ( result, apats1left, apats1right), rest671)
end
|  ( 257, ( ( _, ( MlyValue.apat apat1, apat1left, apat1right)) :: rest671)) => let val  result = MlyValue.apats (fn _ => let val  (apat as apat1) = apat1 ()
 in ((*#line 1139.22 "ml.grm"*)[apat](*#line 4117.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 3, ( result, apat1left, apat1right), rest671)
end
|  ( 258, ( ( _, ( MlyValue.apats apats1, _, apats1right)) :: ( _, ( MlyValue.apat apat1, apat1left, _)) :: rest671)) => let val  result = MlyValue.apats (fn _ => let val  (apat as apat1) = apat1 ()
 val  (apats as apats1) = apats1 ()
 in ((*#line 1140.22 "ml.grm"*)apat :: apats(*#line 4123.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 3, ( result, apat1left, apats1right), rest671)
end
|  ( 259, ( ( _, ( MlyValue.apatnode apatnode1, (apatnodeleft as apatnode1left), (apatnoderight as apatnode1right))) :: rest671)) => let val  result = MlyValue.apat (fn _ => let val  (apatnode as apatnode1) = apatnode1 ()
 in ((*#line 1143.15 "ml.grm"*)Pat.makeRegion' (apatnode,
                               apatnodeleft,
                               apatnoderight)(*#line 4130.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 1, ( result, apatnode1left, apatnode1right), rest671)
end
|  ( 260, ( ( _, ( MlyValue.longvidNoEqual longvidNoEqual1, longvidNoEqual1left, longvidNoEqual1right)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (longvidNoEqual as longvidNoEqual1) = longvidNoEqual1 ()
 in ((*#line 1148.34 "ml.grm"*)Pat.Var {name = longvidNoEqual,
                                          fixop = Fixop.None}(*#line 4138.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, longvidNoEqual1left, longvidNoEqual1right), rest671)
end
|  ( 261, ( ( _, ( MlyValue.longvid longvid1, _, longvid1right)) :: ( _, ( _, OP1left, _)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (longvid as longvid1) = longvid1 ()
 in ((*#line 1150.34 "ml.grm"*)Pat.Var {name = longvid,
                                          fixop = Fixop.Op}(*#line 4145.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, OP1left, longvid1right), rest671)
end
|  ( 262, ( ( _, ( MlyValue.const const1, const1left, const1right)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (const as const1) = const1 ()
 in ((*#line 1153.8 "ml.grm"*)let
          val _ =
             case Const.node const of
                Const.Real r =>
                   let
                      open Layout
                   in
                      Control.error
                      (Const.region const,
                       seq [str "real constants not allowed in patterns: ",
                            Const.layout const],
                       empty)
                   end
              | _ => ()
       in
          Pat.Const const
       end(*#line 4152.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, const1left, const1right), rest671)
end
|  ( 263, ( ( _, ( _, WILD1left, WILD1right)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => ((*#line 1170.34 "ml.grm"*)Pat.Wild(*#line 4174.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 2, ( result, WILD1left, WILD1right), rest671)
end
|  ( 264, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.pats pats1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (pats as pats1) = pats1 ()
 in ((*#line 1171.34 "ml.grm"*)Pat.tuple (Vector.fromList pats)(*#line 4178.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 265, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( MlyValue.pats pats1, _, _)) :: ( _, ( _, LBRACKET1left, _)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (pats as pats1) = pats1 ()
 in ((*#line 1172.34 "ml.grm"*)Pat.List (Vector.fromList pats)(*#line 4184.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, LBRACKET1left, RBRACKET1right), rest671)
end
|  ( 266, ( ( _, ( _, _, RBRACKET1right)) :: ( _, ( MlyValue.pats pats1, _, _)) :: ( _, ( _, HASHLBRACKET1left, _)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (pats as pats1) = pats1 ()
 in ((*#line 1173.34 "ml.grm"*)Pat.Vector (Vector.fromList pats)(*#line 4190.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, HASHLBRACKET1left, RBRACKET1right), rest671)
end
|  ( 267, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => ((*#line 1174.34 "ml.grm"*)Pat.unit(*#line 4196.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 2, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 268, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.patitems patitems1, _, _)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let val  result = MlyValue.apatnode (fn _ => let val  (patitems as patitems1) = patitems1 ()
 in ((*#line 1176.8 "ml.grm"*)let
          val (items, flexible) = patitems
       in
          Pat.Record {flexible = flexible,
                      items = Vector.fromList items}
       end(*#line 4200.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 2, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 269, ( rest671)) => let val  result = MlyValue.pats (fn _ => ((*#line 1183.9 "ml.grm"*)[](*#line 4211.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 82, ( result, defaultPos, defaultPos), rest671)
end
|  ( 270, ( ( _, ( MlyValue.commapats commapats1, _, commapats1right)) :: ( _, ( MlyValue.pat pat1, pat1left, _)) :: rest671)) => let val  result = MlyValue.pats (fn _ => let val  (pat as pat1) = pat1 ()
 val  (commapats as commapats1) = commapats1 ()
 in ((*#line 1184.23 "ml.grm"*)pat :: commapats(*#line 4215.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 82, ( result, pat1left, commapats1right), rest671)
end
|  ( 271, ( ( _, ( MlyValue.cpat cpat1, cpat1left, cpat1right)) :: rest671)) => let val  result = MlyValue.barcpats (fn _ => let val  (cpat as cpat1) = cpat1 ()
 in ((*#line 1186.18 "ml.grm"*)[cpat](*#line 4222.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 7, ( result, cpat1left, cpat1right), rest671)
end
|  ( 272, ( ( _, ( MlyValue.barcpats barcpats1, _, barcpats1right)) :: _ :: ( _, ( MlyValue.cpat cpat1, cpat1left, _)) :: rest671)) => let val  result = MlyValue.barcpats (fn _ => let val  (cpat as cpat1) = cpat1 ()
 val  (barcpats as barcpats1) = barcpats1 ()
 in ((*#line 1187.31 "ml.grm"*)cpat :: barcpats(*#line 4228.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 7, ( result, cpat1left, barcpats1right), rest671)
end
|  ( 273, ( rest671)) => let val  result = MlyValue.commapats (fn _ => ((*#line 1189.14 "ml.grm"*)[](*#line 4235.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 11, ( result, defaultPos, defaultPos), rest671)
end
|  ( 274, ( ( _, ( MlyValue.commapats commapats1, _, commapats1right)) :: ( _, ( MlyValue.pat pat1, _, _)) :: ( _, ( _, COMMA1left, _)) :: rest671)) => let val  result = MlyValue.commapats (fn _ => let val  (pat as pat1) = pat1 ()
 val  (commapats as commapats1) = commapats1 ()
 in ((*#line 1190.34 "ml.grm"*)pat :: commapats(*#line 4239.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 11, ( result, COMMA1left, commapats1right), rest671)
end
|  ( 275, ( ( _, ( MlyValue.patitems patitems1, _, patitems1right)) :: _ :: ( _, ( MlyValue.patitem patitem1, patitem1left, _)) :: rest671)) => let val  result = MlyValue.patitems (fn _ => let val  (patitem as patitem1) = patitem1 ()
 val  (patitems as patitems1) = patitems1 ()
 in ((*#line 1192.37 "ml.grm"*)let val (items, f) = patitems
                                    in (patitem :: items, f)
                                    end(*#line 4246.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 81, ( result, patitem1left, patitems1right), rest671)
end
|  ( 276, ( ( _, ( MlyValue.patitem patitem1, patitem1left, patitem1right)) :: rest671)) => let val  result = MlyValue.patitems (fn _ => let val  (patitem as patitem1) = patitem1 ()
 in ((*#line 1195.34 "ml.grm"*)[patitem], false(*#line 4255.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 81, ( result, patitem1left, patitem1right), rest671)
end
|  ( 277, ( ( _, ( _, DOTDOTDOT1left, DOTDOTDOT1right)) :: rest671)) => let val  result = MlyValue.patitems (fn _ => ((*#line 1196.34 "ml.grm"*)[], true(*#line 4261.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 81, ( result, DOTDOTDOT1left, DOTDOTDOT1right), rest671)
end
|  ( 278, ( ( _, ( MlyValue.pat pat1, _, pat1right)) :: _ :: ( _, ( MlyValue.field field1, (fieldleft as field1left), fieldright)) :: rest671)) => let val  result = MlyValue.patitem (fn _ => let val  (field as field1) = field1 ()
 val  (pat as pat1) = pat1 ()
 in ((*#line 1200.7 "ml.grm"*)(field, reg (fieldleft, fieldright), Pat.Item.Field pat)(*#line 4265.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 80, ( result, field1left, pat1right), rest671)
end
|  ( 279, ( ( _, ( MlyValue.opaspat opaspat1, _, opaspat1right)) :: ( _, ( MlyValue.constraint constraint1, _, _)) :: ( _, ( MlyValue.vid vid1, (vidleft as vid1left), vidright)) :: rest671)) => let val  result = MlyValue.patitem (fn _ => let val  (vid as vid1) = vid1 ()
 val  (constraint as constraint1) = constraint1 ()
 val  (opaspat as opaspat1) = opaspat1 ()
 in ((*#line 1202.7 "ml.grm"*)Field.Symbol (Vid.toSymbol vid),
      reg (vidleft, vidright),
      Pat.Item.Vid (vid, constraint, opaspat)(*#line 4272.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 80, ( result, vid1left, opaspat1right), rest671)
end
|  ( 280, ( rest671)) => let val  result = MlyValue.opaspat (fn _ => ((*#line 1206.20 "ml.grm"*)NONE(*#line 4282.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 74, ( result, defaultPos, defaultPos), rest671)
end
|  ( 281, ( ( _, ( MlyValue.pat pat1, _, pat1right)) :: ( _, ( _, AS1left, _)) :: rest671)) => let val  result = MlyValue.opaspat (fn _ => let val  (pat as pat1) = pat1 ()
 in ((*#line 1207.20 "ml.grm"*)SOME pat(*#line 4286.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 74, ( result, AS1left, pat1right), rest671)
end
|  ( 282, ( ( _, ( MlyValue.tynode tynode1, (tynodeleft as tynode1left), (tynoderight as tynode1right))) :: rest671)) => let val  result = MlyValue.ty (fn _ => let val  (tynode as tynode1) = tynode1 ()
 in ((*#line 1213.14 "ml.grm"*)Type.makeRegion' (tynode, tynodeleft, tynoderight)(*#line 4292.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 137, ( result, tynode1left, tynode1right), rest671)
end
|  ( 283, ( ( _, ( MlyValue.tuple_ty tuple_ty1, tuple_ty1left, tuple_ty1right)) :: rest671)) => let val  result = MlyValue.tynode (fn _ => let val  (tuple_ty as tuple_ty1) = tuple_ty1 ()
 in ((*#line 1215.26 "ml.grm"*)Type.tuple (Vector.fromList tuple_ty)(*#line 4298.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 143, ( result, tuple_ty1left, tuple_ty1right), rest671)
end
|  ( 284, ( ( _, ( MlyValue.ty ty2, _, ty2right)) :: _ :: ( _, ( MlyValue.ty ty1, ty1left, _)) :: rest671)) => let val  result = MlyValue.tynode (fn _ => let val  ty1 = ty1 ()
 val  ty2 = ty2 ()
 in ((*#line 1216.26 "ml.grm"*)Type.arrow (ty1, ty2)(*#line 4304.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 143, ( result, ty1left, ty2right), rest671)
end
|  ( 285, ( ( _, ( MlyValue.ty'node ty'node1, ty'node1left, ty'node1right)) :: rest671)) => let val  result = MlyValue.tynode (fn _ => let val  (ty'node as ty'node1) = ty'node1 ()
 in ((*#line 1217.26 "ml.grm"*)ty'node(*#line 4311.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 143, ( result, ty'node1left, ty'node1right), rest671)
end
|  ( 286, ( ( _, ( MlyValue.ty'node ty'node1, (ty'nodeleft as ty'node1left), (ty'noderight as ty'node1right))) :: rest671)) => let val  result = MlyValue.ty' (fn _ => let val  (ty'node as ty'node1) = ty'node1 ()
 in ((*#line 1219.16 "ml.grm"*)Type.makeRegion' (ty'node, ty'nodeleft, ty'noderight)(*#line 4317.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 138, ( result, ty'node1left, ty'node1right), rest671)
end
|  ( 287, ( ( _, ( MlyValue.tyvar tyvar1, tyvar1left, tyvar1right)) :: rest671)) => let val  result = MlyValue.ty'node (fn _ => let val  (tyvar as tyvar1) = tyvar1 ()
 in ((*#line 1221.44 "ml.grm"*)Type.Var tyvar(*#line 4323.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 139, ( result, tyvar1left, tyvar1right), rest671)
end
|  ( 288, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.tlabels tlabels1, _, _)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let val  result = MlyValue.ty'node (fn _ => let val  (tlabels as tlabels1) = tlabels1 ()
 in ((*#line 1223.12 "ml.grm"*)Type.Record (Record.fromVector (Vector.fromList tlabels))(*#line 4329.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 139, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 289, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let val  result = MlyValue.ty'node (fn _ => ((*#line 1224.44 "ml.grm"*)Type.unit(*#line 4335.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 139, ( result, LBRACE1left, RBRACE1right), rest671)
end
|  ( 290, ( ( _, ( MlyValue.longtycon longtycon1, _, longtycon1right)) :: _ :: ( _, ( MlyValue.ty0_pc ty0_pc1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.ty'node (fn _ => let val  (ty0_pc as ty0_pc1) = ty0_pc1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 in ((*#line 1225.44 "ml.grm"*)Type.Con (longtycon,
                                                     Vector.fromList ty0_pc)(*#line 4339.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 139, ( result, LPAREN1left, longtycon1right), rest671)
end
|  ( 291, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.ty ty1, _, _)) :: ( _, ( _, LPAREN1left, _)) :: rest671)) => let val  result = MlyValue.ty'node (fn _ => let val  (ty as ty1) = ty1 ()
 in ((*#line 1227.44 "ml.grm"*)Type.Paren ty(*#line 4347.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 139, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 292, ( ( _, ( MlyValue.longtycon longtycon1, _, longtycon1right)) :: ( _, ( MlyValue.ty' ty'1, ty'1left, _)) :: rest671)) => let val  result = MlyValue.ty'node (fn _ => let val  (ty' as ty'1) = ty'1 ()
 val  (longtycon as longtycon1) = longtycon1 ()
 in ((*#line 1228.44 "ml.grm"*)Type.Con (longtycon,
                                                     Vector.new1 ty')(*#line 4353.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 139, ( result, ty'1left, longtycon1right), rest671)
end
|  ( 293, ( ( _, ( MlyValue.longtycon longtycon1, longtycon1left, longtycon1right)) :: rest671)) => let val  result = MlyValue.ty'node (fn _ => let val  (longtycon as longtycon1) = longtycon1 ()
 in ((*#line 1230.44 "ml.grm"*)Type.Con (longtycon,
                                                     Vector.new0 ())(*#line 4361.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 139, ( result, longtycon1left, longtycon1right), rest671)
end
|  ( 294, ( ( _, ( MlyValue.ty ty1, _, ty1right)) :: _ :: ( _, ( MlyValue.field field1, (fieldleft as field1left), fieldright)) :: rest671)) => let val  result = MlyValue.tlabel (fn _ => let val  (field as field1) = field1 ()
 val  (ty as ty1) = ty1 ()
 in ((*#line 1233.34 "ml.grm"*)field, (reg (fieldleft, fieldright), ty)(*#line 4368.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 131, ( result, field1left, ty1right), rest671)
end
|  ( 295, ( ( _, ( MlyValue.tlabels tlabels1, _, tlabels1right)) :: _ :: ( _, ( MlyValue.tlabel tlabel1, tlabel1left, _)) :: rest671)) => let val  result = MlyValue.tlabels (fn _ => let val  (tlabel as tlabel1) = tlabel1 ()
 val  (tlabels as tlabels1) = tlabels1 ()
 in ((*#line 1235.34 "ml.grm"*)tlabel :: tlabels(*#line 4375.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 132, ( result, tlabel1left, tlabels1right), rest671)
end
|  ( 296, ( ( _, ( MlyValue.tlabel tlabel1, tlabel1left, tlabel1right)) :: rest671)) => let val  result = MlyValue.tlabels (fn _ => let val  (tlabel as tlabel1) = tlabel1 ()
 in ((*#line 1236.34 "ml.grm"*)[tlabel](*#line 4382.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 132, ( result, tlabel1left, tlabel1right), rest671)
end
|  ( 297, ( ( _, ( MlyValue.tuple_ty tuple_ty1, _, tuple_ty1right)) :: _ :: ( _, ( MlyValue.ty' ty'1, ty'1left, _)) :: rest671)) => let val  result = MlyValue.tuple_ty (fn _ => let val  (ty' as ty'1) = ty'1 ()
 val  (tuple_ty as tuple_ty1) = tuple_ty1 ()
 in ((*#line 1238.42 "ml.grm"*)ty' :: tuple_ty(*#line 4388.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 136, ( result, ty'1left, tuple_ty1right), rest671)
end
|  ( 298, ( ( _, ( MlyValue.ty' ty'2, _, ty'2right)) :: _ :: ( _, ( MlyValue.ty' ty'1, ty'1left, _)) :: rest671)) => let val  result = MlyValue.tuple_ty (fn _ => let val  ty'1 = ty'1 ()
 val  ty'2 = ty'2 ()
 in ((*#line 1239.42 "ml.grm"*)[ty'1, ty'2](*#line 4395.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 136, ( result, ty'1left, ty'2right), rest671)
end
|  ( 299, ( ( _, ( MlyValue.ty ty2, _, ty2right)) :: _ :: ( _, ( MlyValue.ty ty1, ty1left, _)) :: rest671)) => let val  result = MlyValue.ty0_pc (fn _ => let val  ty1 = ty1 ()
 val  ty2 = ty2 ()
 in ((*#line 1241.34 "ml.grm"*)[ty1, ty2](*#line 4402.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 140, ( result, ty1left, ty2right), rest671)
end
|  ( 300, ( ( _, ( MlyValue.ty0_pc ty0_pc1, _, ty0_pc1right)) :: _ :: ( _, ( MlyValue.ty ty1, ty1left, _)) :: rest671)) => let val  result = MlyValue.ty0_pc (fn _ => let val  (ty as ty1) = ty1 ()
 val  (ty0_pc as ty0_pc1) = ty0_pc1 ()
 in ((*#line 1242.34 "ml.grm"*)ty :: ty0_pc(*#line 4409.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 140, ( result, ty1left, ty0_pc1right), rest671)
end
|  ( 301, ( rest671)) => let val  result = MlyValue.optbar (fn _ => ((*#line 1249.19 "ml.grm"*)(*#line 4416.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 76, ( result, defaultPos, defaultPos), rest671)
end
|  ( 302, ( ( _, ( MlyValue.optbar' optbar'1, optbar'1left, optbar'1right)) :: rest671)) => let val  result = MlyValue.optbar (fn _ => let val  optbar'1 = optbar'1 ()
 in ((*#line 1250.19 "ml.grm"*)(*#line 4420.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 76, ( result, optbar'1left, optbar'1right), rest671)
end
|  ( 303, ( ( _, ( _, (BARleft as BAR1left), (BARright as BAR1right))) :: rest671)) => let val  result = MlyValue.optbar' (fn _ => ((*#line 1253.19 "ml.grm"*)if allowOptBar ()
                    then ()
                    else error (reg (BARleft, BARright), "Optional bar disallowed, compile with -default-ann 'allowOptBar true'")(*#line 4426.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 77, ( result, BAR1left, BAR1right), rest671)
end
|  ( 304, ( rest671)) => let val  result = MlyValue.optsemicolon (fn _ => ((*#line 1258.19 "ml.grm"*)(*#line 4432.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 78, ( result, defaultPos, defaultPos), rest671)
end
|  ( 305, ( ( _, ( _, (SEMICOLONleft as SEMICOLON1left), (SEMICOLONright as SEMICOLON1right))) :: rest671)) => let val  result = MlyValue.optsemicolon (fn _ => ((*#line 1259.19 "ml.grm"*)if allowOptSemicolon ()
                    then ()
                    else error (reg (SEMICOLONleft, SEMICOLONright), "Optional semicolon disallowed, compile with -default-ann 'allowOptSemicolon true'")(*#line 4436.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 78, ( result, SEMICOLON1left, SEMICOLON1right), rest671)
end
|  ( 306, ( ( _, ( MlyValue.const const1, const1left, const1right)) :: rest671)) => let val  result = MlyValue.constOrBool (fn _ => let val  (const as const1) = const1 ()
 in ((*#line 1264.13 "ml.grm"*)const(*#line 4442.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 18, ( result, const1left, const1right), rest671)
end
|  ( 307, ( ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, shortAlphanumId1right)) :: rest671)) => let val  result = MlyValue.constOrBool (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 in ((*#line 1266.10 "ml.grm"*)let
            fun ok b = Const.makeRegion (Const.Bool b, #2 shortAlphanumId)
         in            
            case Symbol.toString (#1 shortAlphanumId) of
               "false" => ok false
             | "true" => ok true
             | s => (error (#2 shortAlphanumId, concat ["unknown boolean constant: ", s])
                     ; ok false)
         end(*#line 4448.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 18, ( result, shortAlphanumId1left, shortAlphanumId1right), rest671)
end
|  ( 308, ( ( _, ( MlyValue.const' const'1, (const'left as const'1left), (const'right as const'1right))) :: rest671)) => let val  result = MlyValue.const (fn _ => let val  (const' as const'1) = const'1 ()
 in ((*#line 1276.34 "ml.grm"*)Const.makeRegion
                                 (const', reg (const'left, const'right))(*#line 4462.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 13, ( result, const'1left, const'1right), rest671)
end
|  ( 309, ( ( _, ( MlyValue.int int1, int1left, int1right)) :: rest671)) => let val  result = MlyValue.const' (fn _ => let val  (int as int1) = int1 ()
 in ((*#line 1279.34 "ml.grm"*)Const.Int int(*#line 4469.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 14, ( result, int1left, int1right), rest671)
end
|  ( 310, ( ( _, ( MlyValue.word word1, word1left, word1right)) :: rest671)) => let val  result = MlyValue.const' (fn _ => let val  (word as word1) = word1 ()
 in ((*#line 1280.34 "ml.grm"*)Const.Word word(*#line 4475.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 14, ( result, word1left, word1right), rest671)
end
|  ( 311, ( ( _, ( MlyValue.REAL REAL1, REAL1left, REAL1right)) :: rest671)) => let val  result = MlyValue.const' (fn _ => let val  (REAL as REAL1) = REAL1 ()
 in ((*#line 1281.34 "ml.grm"*)Const.Real REAL(*#line 4481.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 14, ( result, REAL1left, REAL1right), rest671)
end
|  ( 312, ( ( _, ( MlyValue.STRING STRING1, STRING1left, STRING1right)) :: rest671)) => let val  result = MlyValue.const' (fn _ => let val  (STRING as STRING1) = STRING1 ()
 in ((*#line 1282.34 "ml.grm"*)Const.String STRING(*#line 4487.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 14, ( result, STRING1left, STRING1right), rest671)
end
|  ( 313, ( ( _, ( MlyValue.CHAR CHAR1, CHAR1left, CHAR1right)) :: rest671)) => let val  result = MlyValue.const' (fn _ => let val  (CHAR as CHAR1) = CHAR1 ()
 in ((*#line 1283.34 "ml.grm"*)Const.Char CHAR(*#line 4493.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 14, ( result, CHAR1left, CHAR1right), rest671)
end
|  ( 314, ( ( _, ( MlyValue.STRING STRING1, STRING1left, STRING1right)) :: rest671)) => let val  result = MlyValue.string (fn _ => let val  (STRING as STRING1) = STRING1 ()
 in ((*#line 1285.19 "ml.grm"*)CharVector.tabulate
                  (Vector.length STRING, fn i =>
                   Char.fromInt (Int.fromIntInf (Vector.sub (STRING, i))))(*#line 4499.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 126, ( result, STRING1left, STRING1right), rest671)
end
|  ( 315, ( ( _, ( MlyValue.SHORTALPHANUMID SHORTALPHANUMID1, (SHORTALPHANUMIDleft as SHORTALPHANUMID1left), (SHORTALPHANUMIDright as SHORTALPHANUMID1right))) :: rest671)) => let val  result = MlyValue.shortAlphanumId (fn _ => let val  (SHORTALPHANUMID as SHORTALPHANUMID1) = SHORTALPHANUMID1 ()
 in ((*#line 1292.6 "ml.grm"*)shortIdFromTok (SHORTALPHANUMID, SHORTALPHANUMIDleft, SHORTALPHANUMIDright)(*#line 4507.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 93, ( result, SHORTALPHANUMID1left, SHORTALPHANUMID1right), rest671)
end
|  ( 316, ( ( _, ( MlyValue.SHORTSYMID SHORTSYMID1, (SHORTSYMIDleft as SHORTSYMID1left), (SHORTSYMIDright as SHORTSYMID1right))) :: rest671)) => let val  result = MlyValue.shortSymId (fn _ => let val  (SHORTSYMID as SHORTSYMID1) = SHORTSYMID1 ()
 in ((*#line 1295.6 "ml.grm"*)shortIdFromTok (SHORTSYMID, SHORTSYMIDleft, SHORTSYMIDright)(*#line 4513.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 94, ( result, SHORTSYMID1left, SHORTSYMID1right), rest671)
end
|  ( 317, ( ( _, ( MlyValue.LONGALPHANUMID LONGALPHANUMID1, (LONGALPHANUMIDleft as LONGALPHANUMID1left), (LONGALPHANUMIDright as LONGALPHANUMID1right))) :: rest671)) => let val  result = MlyValue.longAlphanumId (fn _ => let val  (LONGALPHANUMID as LONGALPHANUMID1) = LONGALPHANUMID1 ()
 in ((*#line 1298.6 "ml.grm"*)longIdFromTok (LONGALPHANUMID, LONGALPHANUMIDleft, LONGALPHANUMIDright)(*#line 4519.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 61, ( result, LONGALPHANUMID1left, LONGALPHANUMID1right), rest671)
end
|  ( 318, ( ( _, ( MlyValue.LONGSYMID LONGSYMID1, (LONGSYMIDleft as LONGSYMID1left), (LONGSYMIDright as LONGSYMID1right))) :: rest671)) => let val  result = MlyValue.longSymId (fn _ => let val  (LONGSYMID as LONGSYMID1) = LONGSYMID1 ()
 in ((*#line 1301.6 "ml.grm"*)longIdFromTok (LONGSYMID, LONGSYMIDleft, LONGSYMIDright)(*#line 4525.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 62, ( result, LONGSYMID1left, LONGSYMID1right), rest671)
end
|  ( 319, ( ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, shortAlphanumId1right)) :: rest671)) => let val  result = MlyValue.vidNoEqual (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 in ((*#line 1303.32 "ml.grm"*)Vid.fromSymbol shortAlphanumId(*#line 4531.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 157, ( result, shortAlphanumId1left, shortAlphanumId1right), rest671)
end
|  ( 320, ( ( _, ( MlyValue.shortSymId shortSymId1, shortSymId1left, shortSymId1right)) :: rest671)) => let val  result = MlyValue.vidNoEqual (fn _ => let val  (shortSymId as shortSymId1) = shortSymId1 ()
 in ((*#line 1304.32 "ml.grm"*)Vid.fromSymbol shortSymId(*#line 4537.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 157, ( result, shortSymId1left, shortSymId1right), rest671)
end
|  ( 321, ( ( _, ( _, (ASTERISKleft as ASTERISK1left), (ASTERISKright as ASTERISK1right))) :: rest671)) => let val  result = MlyValue.vidNoEqual (fn _ => ((*#line 1305.32 "ml.grm"*)Vid.fromSymbol (Symbol.asterisk,
                                               reg (ASTERISKleft, ASTERISKright))(*#line 4543.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 157, ( result, ASTERISK1left, ASTERISK1right), rest671)
end
|  ( 322, ( ( _, ( _, (EQUALOPleft as EQUALOP1left), (EQUALOPright as EQUALOP1right))) :: rest671)) => let val  result = MlyValue.vidEqual (fn _ => ((*#line 1307.32 "ml.grm"*)Vid.fromSymbol (Symbol.equal,
                                               reg (EQUALOPleft, EQUALOPright))(*#line 4548.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 156, ( result, EQUALOP1left, EQUALOP1right), rest671)
end
|  ( 323, ( ( _, ( MlyValue.vidNoEqual vidNoEqual1, vidNoEqual1left, vidNoEqual1right)) :: rest671)) => let val  result = MlyValue.vid (fn _ => let val  (vidNoEqual as vidNoEqual1) = vidNoEqual1 ()
 in ((*#line 1309.20 "ml.grm"*)vidNoEqual(*#line 4553.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 155, ( result, vidNoEqual1left, vidNoEqual1right), rest671)
end
|  ( 324, ( ( _, ( MlyValue.vidEqual vidEqual1, vidEqual1left, vidEqual1right)) :: rest671)) => let val  result = MlyValue.vid (fn _ => let val  (vidEqual as vidEqual1) = vidEqual1 ()
 in ((*#line 1310.20 "ml.grm"*)vidEqual(*#line 4559.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 155, ( result, vidEqual1left, vidEqual1right), rest671)
end
|  ( 325, ( ( _, ( MlyValue.vidNoEqual vidNoEqual1, vidNoEqual1left, vidNoEqual1right)) :: rest671)) => let val  result = MlyValue.longvidNoEqual (fn _ => let val  (vidNoEqual as vidNoEqual1) = vidNoEqual1 ()
 in ((*#line 1311.35 "ml.grm"*)Longvid.short vidNoEqual(*#line 4565.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 70, ( result, vidNoEqual1left, vidNoEqual1right), rest671)
end
|  ( 326, ( ( _, ( MlyValue.longAlphanumId longAlphanumId1, longAlphanumId1left, longAlphanumId1right)) :: rest671)) => let val  result = MlyValue.longvidNoEqual (fn _ => let val  (longAlphanumId as longAlphanumId1) = longAlphanumId1 ()
 in ((*#line 1312.35 "ml.grm"*)Longvid.fromSymbols longAlphanumId(*#line 4571.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 70, ( result, longAlphanumId1left, longAlphanumId1right), rest671)
end
|  ( 327, ( ( _, ( MlyValue.longSymId longSymId1, longSymId1left, longSymId1right)) :: rest671)) => let val  result = MlyValue.longvidNoEqual (fn _ => let val  (longSymId as longSymId1) = longSymId1 ()
 in ((*#line 1313.35 "ml.grm"*)Longvid.fromSymbols longSymId(*#line 4577.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 70, ( result, longSymId1left, longSymId1right), rest671)
end
|  ( 328, ( ( _, ( MlyValue.vidEqual vidEqual1, vidEqual1left, vidEqual1right)) :: rest671)) => let val  result = MlyValue.longvidEqual (fn _ => let val  (vidEqual as vidEqual1) = vidEqual1 ()
 in ((*#line 1314.33 "ml.grm"*)Longvid.short vidEqual(*#line 4583.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 69, ( result, vidEqual1left, vidEqual1right), rest671)
end
|  ( 329, ( ( _, ( MlyValue.longvidNoEqual longvidNoEqual1, longvidNoEqual1left, longvidNoEqual1right)) :: rest671)) => let val  result = MlyValue.longvid (fn _ => let val  (longvidNoEqual as longvidNoEqual1) = longvidNoEqual1 ()
 in ((*#line 1315.28 "ml.grm"*)longvidNoEqual(*#line 4589.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 68, ( result, longvidNoEqual1left, longvidNoEqual1right), rest671)
end
|  ( 330, ( ( _, ( MlyValue.longvidEqual longvidEqual1, longvidEqual1left, longvidEqual1right)) :: rest671)) => let val  result = MlyValue.longvid (fn _ => let val  (longvidEqual as longvidEqual1) = longvidEqual1 ()
 in ((*#line 1316.28 "ml.grm"*)longvidEqual(*#line 4595.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 68, ( result, longvidEqual1left, longvidEqual1right), rest671)
end
|  ( 331, ( ( _, ( MlyValue.vid vid1, vid1left, vid1right)) :: rest671)) => let val  result = MlyValue.con (fn _ => let val  (vid as vid1) = vid1 ()
 in ((*#line 1318.13 "ml.grm"*)Vid.toCon vid(*#line 4601.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 12, ( result, vid1left, vid1right), rest671)
end
|  ( 332, ( ( _, ( MlyValue.longvid longvid1, longvid1left, longvid1right)) :: rest671)) => let val  result = MlyValue.longcon (fn _ => let val  (longvid as longvid1) = longvid1 ()
 in ((*#line 1319.21 "ml.grm"*)Longvid.toLongcon longvid(*#line 4607.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 60, ( result, longvid1left, longvid1right), rest671)
end
|  ( 333, ( ( _, ( MlyValue.TYVAR TYVAR1, (TYVARleft as TYVAR1left), (TYVARright as TYVAR1right))) :: rest671)) => let val  result = MlyValue.tyvar (fn _ => let val  (TYVAR as TYVAR1) = TYVAR1 ()
 in ((*#line 1321.17 "ml.grm"*)Tyvar.fromSymbol (Symbol.fromString TYVAR, reg (TYVARleft, TYVARright))(*#line 4613.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 147, ( result, TYVAR1left, TYVAR1right), rest671)
end
|  ( 334, ( ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, shortAlphanumId1right)) :: rest671)) => let val  result = MlyValue.tycon (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 in ((*#line 1323.27 "ml.grm"*)Tycon.fromSymbol shortAlphanumId(*#line 4619.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 142, ( result, shortAlphanumId1left, shortAlphanumId1right), rest671)
end
|  ( 335, ( ( _, ( MlyValue.shortSymId shortSymId1, shortSymId1left, shortSymId1right)) :: rest671)) => let val  result = MlyValue.tycon (fn _ => let val  (shortSymId as shortSymId1) = shortSymId1 ()
 in ((*#line 1324.27 "ml.grm"*)Tycon.fromSymbol shortSymId(*#line 4625.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 142, ( result, shortSymId1left, shortSymId1right), rest671)
end
|  ( 336, ( ( _, ( MlyValue.tycon tycon1, tycon1left, tycon1right)) :: rest671)) => let val  result = MlyValue.longtycon (fn _ => let val  (tycon as tycon1) = tycon1 ()
 in ((*#line 1325.30 "ml.grm"*)Longtycon.short tycon(*#line 4631.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 66, ( result, tycon1left, tycon1right), rest671)
end
|  ( 337, ( ( _, ( MlyValue.longAlphanumId longAlphanumId1, longAlphanumId1left, longAlphanumId1right)) :: rest671)) => let val  result = MlyValue.longtycon (fn _ => let val  (longAlphanumId as longAlphanumId1) = longAlphanumId1 ()
 in ((*#line 1326.30 "ml.grm"*)Longtycon.fromSymbols longAlphanumId(*#line 4637.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 66, ( result, longAlphanumId1left, longAlphanumId1right), rest671)
end
|  ( 338, ( ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, shortAlphanumId1right)) :: rest671)) => let val  result = MlyValue.idField (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 in ((*#line 1328.29 "ml.grm"*)shortAlphanumId(*#line 4643.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 58, ( result, shortAlphanumId1left, shortAlphanumId1right), rest671)
end
|  ( 339, ( ( _, ( MlyValue.shortSymId shortSymId1, shortSymId1left, shortSymId1right)) :: rest671)) => let val  result = MlyValue.idField (fn _ => let val  (shortSymId as shortSymId1) = shortSymId1 ()
 in ((*#line 1329.29 "ml.grm"*)shortSymId(*#line 4649.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 58, ( result, shortSymId1left, shortSymId1right), rest671)
end
|  ( 340, ( ( _, ( _, (ASTERISKleft as ASTERISK1left), (ASTERISKright as ASTERISK1right))) :: rest671)) => let val  result = MlyValue.idField (fn _ => ((*#line 1330.29 "ml.grm"*)(Symbol.asterisk,
                             reg (ASTERISKleft, ASTERISKright))(*#line 4655.1 "ml.grm.sml"*)
))
 in ( LrTable.NT 58, ( result, ASTERISK1left, ASTERISK1right), rest671)
end
|  ( 341, ( ( _, ( MlyValue.idField idField1, idField1left, idField1right)) :: rest671)) => let val  result = MlyValue.field (fn _ => let val  (idField as idField1) = idField1 ()
 in ((*#line 1332.29 "ml.grm"*)Field.Symbol (#1 idField)(*#line 4660.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 50, ( result, idField1left, idField1right), rest671)
end
|  ( 342, ( ( _, ( MlyValue.numericField numericField1, numericField1left, numericField1right)) :: rest671)) => let val  result = MlyValue.field (fn _ => let val  (numericField as numericField1) = numericField1 ()
 in ((*#line 1333.29 "ml.grm"*)Field.Int (numericField - 1)(*#line 4666.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 50, ( result, numericField1left, numericField1right), rest671)
end
|  ( 343, ( ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, shortAlphanumId1right)) :: rest671)) => let val  result = MlyValue.strid (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 in ((*#line 1335.27 "ml.grm"*)Strid.fromSymbol shortAlphanumId(*#line 4672.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 125, ( result, shortAlphanumId1left, shortAlphanumId1right), rest671)
end
|  ( 344, ( ( _, ( MlyValue.strid strid1, strid1left, strid1right)) :: rest671)) => let val  result = MlyValue.longstrid (fn _ => let val  (strid as strid1) = strid1 ()
 in ((*#line 1336.30 "ml.grm"*)Longstrid.short strid(*#line 4678.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 63, ( result, strid1left, strid1right), rest671)
end
|  ( 345, ( ( _, ( MlyValue.longAlphanumId longAlphanumId1, longAlphanumId1left, longAlphanumId1right)) :: rest671)) => let val  result = MlyValue.longstrid (fn _ => let val  (longAlphanumId as longAlphanumId1) = longAlphanumId1 ()
 in ((*#line 1337.30 "ml.grm"*)Longstrid.fromSymbols longAlphanumId(*#line 4684.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 63, ( result, longAlphanumId1left, longAlphanumId1right), rest671)
end
|  ( 346, ( ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, shortAlphanumId1right)) :: rest671)) => let val  result = MlyValue.sigid (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 in ((*#line 1339.27 "ml.grm"*)Sigid.fromSymbol shortAlphanumId(*#line 4690.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 103, ( result, shortAlphanumId1left, shortAlphanumId1right), rest671)
end
|  ( 347, ( ( _, ( MlyValue.shortAlphanumId shortAlphanumId1, shortAlphanumId1left, shortAlphanumId1right)) :: rest671)) => let val  result = MlyValue.fctid (fn _ => let val  (shortAlphanumId as shortAlphanumId1) = shortAlphanumId1 ()
 in ((*#line 1340.27 "ml.grm"*)Fctid.fromSymbol shortAlphanumId(*#line 4696.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 49, ( result, shortAlphanumId1left, shortAlphanumId1right), rest671)
end
|  ( 348, ( ( _, ( MlyValue.vid vid1, vid1left, vid1right)) :: rest671)) => let val  result = MlyValue.vids (fn _ => let val  (vid as vid1) = vid1 ()
 in ((*#line 1342.33 "ml.grm"*)[vid](*#line 4702.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 158, ( result, vid1left, vid1right), rest671)
end
|  ( 349, ( ( _, ( MlyValue.vids vids1, _, vids1right)) :: ( _, ( MlyValue.vid vid1, vid1left, _)) :: rest671)) => let val  result = MlyValue.vids (fn _ => let val  (vid as vid1) = vid1 ()
 val  (vids as vids1) = vids1 ()
 in ((*#line 1343.33 "ml.grm"*)vid::vids(*#line 4708.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 158, ( result, vid1left, vids1right), rest671)
end
|  ( 350, ( ( _, ( MlyValue.sigid sigid1, sigid1left, sigid1right)) :: rest671)) => let val  result = MlyValue.sigids (fn _ => let val  (sigid as sigid1) = sigid1 ()
 in ((*#line 1345.33 "ml.grm"*)[sigid](*#line 4715.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 104, ( result, sigid1left, sigid1right), rest671)
end
|  ( 351, ( ( _, ( MlyValue.sigids sigids1, _, sigids1right)) :: ( _, ( MlyValue.sigid sigid1, sigid1left, _)) :: rest671)) => let val  result = MlyValue.sigids (fn _ => let val  (sigid as sigid1) = sigid1 ()
 val  (sigids as sigids1) = sigids1 ()
 in ((*#line 1346.33 "ml.grm"*)sigid :: sigids(*#line 4721.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 104, ( result, sigid1left, sigids1right), rest671)
end
|  ( 352, ( ( _, ( MlyValue.longstrid longstrid1, longstrid1left, longstrid1right)) :: rest671)) => let val  result = MlyValue.longstrids (fn _ => let val  (longstrid as longstrid1) = longstrid1 ()
 in ((*#line 1348.37 "ml.grm"*)[longstrid](*#line 4728.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 65, ( result, longstrid1left, longstrid1right), rest671)
end
|  ( 353, ( ( _, ( MlyValue.longstrids longstrids1, _, longstrids1right)) :: ( _, ( MlyValue.longstrid longstrid1, longstrid1left, _)) :: rest671)) => let val  result = MlyValue.longstrids (fn _ => let val  (longstrid as longstrid1) = longstrid1 ()
 val  (longstrids as longstrids1) = longstrids1 ()
 in ((*#line 1349.37 "ml.grm"*)longstrid :: longstrids(*#line 4734.1 "ml.grm.sml"*)
)
end)
 in ( LrTable.NT 65, ( result, longstrid1left, longstrids1right), rest671)
end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.program x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a ()
end
end
structure Tokens : ML_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun CHAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(ParserData.MlyValue.CHAR (fn () => i),p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(ParserData.MlyValue.INT (fn () => i),p1,p2))
fun SHORTALPHANUMID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(ParserData.MlyValue.SHORTALPHANUMID (fn () => i),p1,p2))
fun SHORTSYMID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(ParserData.MlyValue.SHORTSYMID (fn () => i),p1,p2))
fun LONGALPHANUMID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(ParserData.MlyValue.LONGALPHANUMID (fn () => i),p1,p2))
fun LONGSYMID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(ParserData.MlyValue.LONGSYMID (fn () => i),p1,p2))
fun REAL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(ParserData.MlyValue.REAL (fn () => i),p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(ParserData.MlyValue.STRING (fn () => i),p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(ParserData.MlyValue.TYVAR (fn () => i),p1,p2))
fun WORD (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(ParserData.MlyValue.WORD (fn () => i),p1,p2))
fun ABSTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(ParserData.MlyValue.VOID,p1,p2))
fun ANDALSO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(ParserData.MlyValue.VOID,p1,p2))
fun AS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(ParserData.MlyValue.VOID,p1,p2))
fun ASTERISK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(ParserData.MlyValue.VOID,p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(ParserData.MlyValue.VOID,p1,p2))
fun COLONGT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(ParserData.MlyValue.VOID,p1,p2))
fun DOTDOTDOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(ParserData.MlyValue.VOID,p1,p2))
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(ParserData.MlyValue.VOID,p1,p2))
fun EQUALOP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(ParserData.MlyValue.VOID,p1,p2))
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(ParserData.MlyValue.VOID,p1,p2))
fun DARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(ParserData.MlyValue.VOID,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(ParserData.MlyValue.VOID,p1,p2))
fun FUN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(ParserData.MlyValue.VOID,p1,p2))
fun HANDLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(ParserData.MlyValue.VOID,p1,p2))
fun HASHLBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(ParserData.MlyValue.VOID,p1,p2))
fun LBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(ParserData.MlyValue.VOID,p1,p2))
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(ParserData.MlyValue.VOID,p1,p2))
fun ORELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(ParserData.MlyValue.VOID,p1,p2))
fun OVERLOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(ParserData.MlyValue.VOID,p1,p2))
fun RAISE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(ParserData.MlyValue.VOID,p1,p2))
fun RBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(ParserData.MlyValue.VOID,p1,p2))
fun REC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(ParserData.MlyValue.VOID,p1,p2))
fun WHERE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(ParserData.MlyValue.VOID,p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(ParserData.MlyValue.VOID,p1,p2))
fun WILD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 69,(ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 70,(ParserData.MlyValue.VOID,p1,p2))
fun WITHTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 71,(ParserData.MlyValue.VOID,p1,p2))
fun BUILD_CONST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 72,(ParserData.MlyValue.VOID,p1,p2))
fun COMMAND_LINE_CONST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 73,(ParserData.MlyValue.VOID,p1,p2))
fun CONST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 74,(ParserData.MlyValue.VOID,p1,p2))
fun ADDRESS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 75,(ParserData.MlyValue.VOID,p1,p2))
fun EXPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 76,(ParserData.MlyValue.VOID,p1,p2))
fun IMPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 77,(ParserData.MlyValue.VOID,p1,p2))
fun SYMBOL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 78,(ParserData.MlyValue.VOID,p1,p2))
fun PRIM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 79,(ParserData.MlyValue.VOID,p1,p2))
fun SHOW_BASIS (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 80,(ParserData.MlyValue.SHOW_BASIS (fn () => i),p1,p2))
end
end
