dnl
dnl Check for Qt 6
dnl

qt_min_ver=6.1.0

check_qt6() {
  AC_ARG_WITH(qmake6,
    AC_HELP_STRING([--with-qmake6=prog],[use prog instead of looking for qmake6]),
    [ QMAKE6="$with_qmake6" ],)

  if ! test -z "$QMAKE6"; then
    AC_MSG_CHECKING(for qmake6)
    AC_MSG_RESULT(using supplied $QMAKE6)
  else
    AC_PATH_TOOL(QMAKE6, qmake6,, $PATH)
  fi

  if test x"$QMAKE6" = x; then
    AC_MSG_CHECKING(for Qt 6)
    AC_MSG_RESULT(no: qmake6 not found)
    return
  fi

  qmake_dir="`mktemp -d`"

  touch "$qmake_dir/configure.cpp" "$qmake_dir/configure.h"

  cat > "$qmake_dir/configure.ui" <<EOT
<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
</ui>
EOT

  cat > "$qmake_dir/configure.qrc" <<EOT
<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE RCC>
<RCC version='1.0'>
 <qresource>
  <file>configure.pro</file>
 </qresource>
</RCC>
EOT

  cat > "$qmake_dir/configure.pro" <<EOT
QT = core dbus gui widgets network concurrent

FORMS = configure.ui
RESOURCES = configure.qrc
HEADERS = configure.h
SOURCES = configure.cpp
EOT

  old_wd="$PWD"
  cd "$qmake_dir"

  "$QMAKE6" -makefile -nocache configure.pro > /dev/null
  result=$?

  "$QMAKE6" -query > "$qmake_dir/configure.properties"
  result2=$?

  cd "$old_wd"

  if test $result != 0 -o $result2 != 0; then
    AC_MSG_CHECKING(for Qt 6)
    AC_MSG_RESULT(no: qmake6 couldn't be run for a dummy project)

    rm -f "$qmake_dir"/configure.* "$qmake_dir"/Makefile "$qmake_dir"/.qmake.stash
    rmdir "$qmake_dir"

    return
  fi

  dnl Check its version.
  qmake6_ver="`$ac_cv_path_EGREP '^QT_VERSION:' "$qmake_dir/configure.properties" | sed 's/^QT_VERSION://'`"

  AC_MSG_CHECKING(for qmake6's version)
  if test -z "qmake6_ver"; then
    AC_MSG_RESULT(unknown; please contact the author)
    return
  elif ! check_version $qt_min_ver $qmake6_ver; then
    AC_MSG_RESULT(too old: $qmake6_ver, neet at least $qt_mIN-ver)
    return
  else
    AC_MSG_RESULT($qmake6_ver)
  fi

  qt_bindir="`$ac_cv_path_EGREP '^QT_INSTALL_BINS:' "$qmake_dir/configure.properties" | sed 's/^QT_INSTALL_BINS://'`"
  qt_libexecdir="`$ac_cv_path_EGREP '^QT_INSTALL_LIBEXECS:' "$qmake_dir/configure.properties" | sed 's/^QT_INSTALL_LIBEXECS://'`"
  qt_searchpath="$qt_libexecdir:$qt_bindir:$PATH"

  QT_CFLAGS="`$ac_cv_path_EGREP '^DEFINES *=' "$qmake_dir/Makefile" | sed 's/^DEFINES *= *//'`"
  QT_CFLAGS="$QT_CFLAGS `$ac_cv_path_EGREP '^CXXFLAGS *=' "$qmake_dir/Makefile" | sed -e 's/^CXXFLAGS *= *//' -e 's/-pipe//g' -e 's/-O.//g' -e 's/ -W[[^ ]]*//g' -e 's/-std=[[^ ]]*//g' -e 's/\$(DEFINES)//g'`"
  QT_CFLAGS="$QT_CFLAGS `$ac_cv_path_EGREP '^INCPATH *=' "$qmake_dir/Makefile" | sed -e 's/^INCPATH *= *//' -e 's:-I[[^/]][[^ ]]*::g'`"
  QT_LIBS="`$ac_cv_path_EGREP '^LFLAGS *=' "$qmake_dir/Makefile" | sed -e 's/^LFLAGS *= *//' -e 's/-Wl,-O[[^ ]]*//g'`"
  QT_LIBS="$QT_LIBS `$ac_cv_path_EGREP '^LIBS *=' "$qmake_dir/Makefile" | sed -e 's/^LIBS *= *//' -e 's/\$(SUBLIBS)//g' -e 's:-L[[^/]][[^ ]]*::g'`"

  rm -f "$qmake_dir"/configure.* "$qmake_dir"/Makefile "$qmake_dir"/.qmake.stash
  rmdir "$qmake_dir"

  if test x"$QT_CFLAGS" = x -o x"$QT_LIBS" = x; then
    AC_MSG_CHECKING(for Qt 6)
    AC_MSG_RESULT(no: could not extract one or more compiler flags from Makefile generated by qmake6)
    return
  fi

  AC_PATH_PROG(LCONVERT, lconvert,, [$qt_searchpath])
  AC_PATH_PROG(MOC, moc,, [$qt_searchpath])
  AC_PATH_PROG(RCC, rcc,, [$qt_searchpath])
  AC_PATH_PROG(UIC, uic,, [$qt_searchpath])

  if test x"$MOC" = x; then
    AC_MSG_CHECKING(for Qt 6)
    AC_MSG_RESULT(no: could not find the moc executable)
    return

  elif test x"$RCC" = x; then
    AC_MSG_CHECKING(for Qt 6)
    AC_MSG_RESULT(no: could not find the rcc executable)
    return

  elif test x"$UIC" = x; then
    AC_MSG_CHECKING(for Qt 6)
    AC_MSG_RESULT(no: could not find the uic executable)
    return
  fi

  dnl compile test program
  AC_LANG_PUSH(C++)
  AC_CACHE_VAL(am_cv_qt6_compilation, [
    ac_save_CXXFLAGS="$CXXFLAGS"
    ac_save_LIBS="$LIBS"
    CXXFLAGS="$STD_CXX $CXXFLAGS $QT_CFLAGS -fPIC"
    LIBS="$LDFLAGS $QT_LIBS"
    unset ac_cv_qt_compilation

    AC_TRY_LINK([
#include <QtCore>
#include <QCoreApplication>
class Config : public QCoreApplication {
public:
Config(int &argc, char **argv);
};
Config::Config(int &argc, char **argv)
: QCoreApplication(argc,argv) {setApplicationName("config");}
      ], [
int ai = 0;
char **ac = 0;
Config app(ai,ac);
return 0;
      ], [ am_cv_qt6_compilation=1 ], [ am_cv_qt6_compilation=0 ])

    CXXFLAGS="$ac_save_CXXFLAGS"
    LIBS="$ac_save_LIBS"
  ])
  AC_LANG_POP()

  if test x"$am_cv_qt6_compilation" != x1; then
    AC_MSG_CHECKING(for Qt 6)
    AC_MSG_RESULT(no: could not compile a test program)
    return
  fi

  AC_DEFINE(HAVE_QT, 1, [Define if Qt is present])
  AC_MSG_CHECKING(for Qt 6)
  AC_MSG_RESULT(yes)
  have_qt6=yes
  USE_QT=yes
}

AC_ARG_ENABLE([qt6],
  AC_HELP_STRING([--enable-qt6],[compile the Qt-based MKVToolNix GUI with Qt 6 (yes)]),
  [],[enable_qt6=yes])

have_qt6=no

if test x"$enable_qt6" != "xyes"; then
  AC_MSG_CHECKING(for Qt 6)
  AC_MSG_RESULT(no: disabled by user request)

else
  check_qt6

  unset qmake_dir qt_bindir qt_libdir qt_searchpath

  if test $have_qt6 != yes; then
    unset QT_CFLAGS QT_LIBS LCONVERT MOC RCC UIC ac_cv_path_LCONVERT ac_cv_path_MOC ac_cv_path_RCC ac_cv_path_UIC
  fi
fi

AC_SUBST(QT_CFLAGS)
AC_SUBST(QT_LIBS)
AC_SUBST(USE_QT)
