/*
 * pin_map.h - Pin map table used for bad pin contact check.
 *
 * This file is a part of Minipro.
 *
 * Minipro is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Minipro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/* Note, this file really isn't copyrightable. */

{    // 0x00
    .zero_c = 0x01,
    .zero_t = {0x13, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    }
},
{    // 0x01
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x02
    .zero_c = 0x01,
    .zero_t = {0x00, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,
    }
},
{    // 0x03
    .zero_c = 0x01,
    .zero_t = {0x21, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    }
},
{    // 0x04
    .zero_c = 0x01,
    .zero_t = {0x0D, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x05
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x06
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x07
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x08
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x09
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x0A
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x0B
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x0C
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x0D
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x0E
    .zero_c = 0x02,
    .zero_t = {0x0F, 0x21, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x0F
    .zero_c = 0x02,
    .zero_t = {0x0F, 0x21, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x10
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x01,0x01,0x00,0x00,0x00,0x00,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,
    }
},
{    // 0x11
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,
    }
},
{    // 0x12
    .zero_c = 0x01,
    .zero_t = {0x0D, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x13
    .zero_c = 0x01,
    .zero_t = {0x0D, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x14
    .zero_c = 0x01,
    .zero_t = {0x0D, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x15
    .zero_c = 0x01,
    .zero_t = {0x0D, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x16
    .zero_c = 0x01,
    .zero_t = {0x0D, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x17
    .zero_c = 0x01,
    .zero_t = {0x0B, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x18
    .zero_c = 0x02,
    .zero_t = {0x0A, 0x1D, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x19
    .zero_c = 0x02,
    .zero_t = {0x0A, 0x1D, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x1A
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x01,
    }
},
{    // 0x1B
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x1C
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x1D
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x1E
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x01,0x00,0x01,0x01,
    }
},
{    // 0x1F
    .zero_c = 0x01,
    .zero_t = {0x0F, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x20
    .zero_c = 0x01,
    .zero_t = {0x13, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x21
    .zero_c = 0x01,
    .zero_t = {0x09, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x22
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x23
    .zero_c = 0x01,
    .zero_t = {0x27, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    }
},
{    // 0x24
    .zero_c = 0x02,
    .zero_t = {0x0A, 0x1E, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x25
    .zero_c = 0x02,
    .zero_t = {0x07, 0x21, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x26
    .zero_c = 0x01,
    .zero_t = {0x09, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x27
    .zero_c = 0x02,
    .zero_t = {0x05, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x28
    .zero_c = 0x01,
    .zero_t = {0x13, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    }
},
{    // 0x29
    .zero_c = 0x02,
    .zero_t = {0x04, 0x1C, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x01,
    }
},
{    // 0x2A
    .zero_c = 0x01,
    .zero_t = {0x07, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x01,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    }
},
{    // 0x2B
    .zero_c = 0x01,
    .zero_t = {0x0B, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x01,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    }
},
{    // 0x2C
    .zero_c = 0x01,
    .zero_t = {0x04, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,
    }
},
{    // 0x2D
    .zero_c = 0x01,
    .zero_t = {0x26, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,
    }
},
{    // 0x2E
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
    }
},
{    // 0x2F
    .zero_c = 0x01,
    .zero_t = {0x04, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x00,0x00,0x00,0x00,
    }
},
{    // 0x30
    .zero_c = 0x01,
    .zero_t = {0x27, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x00,
    }
},
{    // 0x31
    .zero_c = 0x01,
    .zero_t = {0x04, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x01,
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x32
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x33
    .zero_c = 0x01,
    .zero_t = {0x09, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x34
    .zero_c = 0x01,
    .zero_t = {0x0B, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x35
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x36
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x00,
    }
},
{    // 0x37
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x38
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x39
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x00,
    }
},
{    // 0x3A
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x00,
    }
},
{    // 0x3B
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x00,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x00,
    }
},
{    // 0x3C
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x3D
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x00,
    }
},
{    // 0x3E
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x3F
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x40
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x00,
    }
},
{    // 0x41
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x00,
    }
},
{    // 0x42
    .zero_c = 0x02,
    .zero_t = {0x1F, 0x06, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x00,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x00,
    }
},
{    // 0x43
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x44
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x45
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x46
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x47
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x48
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x49
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x01,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x4A
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x00,0x01,0x01,0x01,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x4B
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x00,0x00,0x01,0x01,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,
    }
},
{    // 0x4C
    .zero_c = 0x02,
    .zero_t = {0x22, 0x23, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x00,0x00,0x01,0x01,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x00,0x00,0x00,0x00,0x01,0x01,
    }
},
{    // 0x4D
    .zero_c = 0x02,
    .zero_t = {0x24, 0x27, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x00,
    }
},
{    // 0x4E
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x4F
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x00,0x01,0x01,0x00,
    }
},
{    // 0x50
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x00,0x01,0x01,0x01,
    }
},
{    // 0x51
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
    0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x01,
    }
},
{    // 0x52
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x01,
    }
},
{    // 0x53
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x01,
    }
},
{    // 0x54
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x00,0x00,0x01,0x01,0x01,
    }
},
{    // 0x55
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x00,0x01,0x01,0x01,
    }
},
{    // 0x56
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x57
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x58
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x59
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x5A
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x5B
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    }
},
{    // 0x5C
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
    0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x01,
    }
},
{    // 0x5D
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x01,
    }
},
{    // 0x5E
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x00,0x01,0x01,0x00,0x01,0x01,0x01,
    }
},
{    // 0x5F
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x01,0x00,0x01,0x01,0x01,
    }
},
{    // 0x60
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x00,0x01,0x01,0x01,
    }
},
{    // 0x61
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    }
},
{    // 0x62
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,
    0x01,0x00,0x01,0x00,0x00,0x01,0x01,0x00,
    }
},
{    // 0x63
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,
    0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x00,
    }
},
{    // 0x64
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x00,
    }
},
{    // 0x65
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x00,0x01,0x00,0x00,0x01,0x01,0x00,
    }
},
{    // 0x66
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x00,
    }
},
{    // 0x67
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x00,0x00,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x01,
    0x01,0x01,0x01,0x00,0x00,0x01,0x01,0x00,
    }
},
{    // 0x68
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    }
},
{    // 0x69
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x00,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    }
},
{    // 0x6A
    .zero_c = 0x03,
    .zero_t = {0x05, 0x09, 0x0B, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x01,0x00,0x01,0x01,
    0x01,0x00,0x01,0x00,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x00,0x01,0x01,0x01,0x00,
    }
},
{    // 0x6B
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
    }
},
{    // 0x6C
    .zero_c = 0x01,
    .zero_t = {0x24, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
    }
},
{    // 0x6D
    .zero_c = 0x01,
    .zero_t = {0x26, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
    }
},
{    // 0x6E
    .zero_c = 0x01,
    .zero_t = {0x22, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x01,0x01,0x00,0x01,0x01,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,
    }
},
{    // 0x6F
    .zero_c = 0x01,
    .zero_t = {0x13, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x01,0x00,0x00,0x00,0x01,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
    }
},
{    // 0x70
    .zero_c = 0x01,
    .zero_t = {0x13, 0x00, 0x00, 0x00},
    .mask = {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00,
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,
    0x00,0x01,0x01,0x00,0x00,0x00,0x00,0x01,
    }
},
{    // 0x71
    .zero_c = 0x01,
    .zero_t = {0x26, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
    }
},
{    // 0x72
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
    }
},
{    // 0x73
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
    }
},
{    // 0x74
    .zero_c = 0x01,
    .zero_t = {0x03, 0x00, 0x00, 0x00},
    .mask = {
    0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x01,0x01,0x00,0x01,
    }
},
