/*-
 * Copyright 2003 John-Mark Gurney.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: ct.c,v 1.2 2003/09/15 23:37:19 jmg Exp $
 *
 */

#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include <ct.h>

int
ct_cmpct(const char *ct, const char *fct)
{
	char *semicolon;

	while (isspace(*ct))
		ct++;

	if ((semicolon = strchr(ct, ';')) == NULL)
		semicolon = strchr(ct, '\x0');

	while (isspace(*(semicolon - 1)))
		semicolon--;

	if (strlen(fct) != semicolon - ct)
		return -1;

	return strncasecmp(ct, fct, semicolon - ct);
}

int
ct_cmptype(const char *ct, const char *type)
{
	char *slash;

	while (isspace(*ct))
		ct++;

	if ((slash = strchr(ct, '/')) == NULL)
		return -1;

	if (strlen(type) != slash - ct)
		return 1;

	return strncasecmp(ct, type, slash - ct);
}

int
ct_cmpsubtype(const char *ct, const char *subtype)
{
	char *end;

	if ((ct = strchr(ct, '/')) == NULL)
		return -1;

	ct++;

	if ((end = strchr(ct, ';')) == NULL) {
		end = strchr(ct, '\0');
		while (isspace(*(end - 1)))
			end--;
	}

	if (strlen(subtype) != end - ct)
		return 1;

	return strncasecmp(ct, subtype, end - ct);
}
