/*
 * This file is part of the MicroPython project, http://micropython.org/
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2021 Damien P. George
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MICROPY_INCLUDED_SAMD_MODMACHINE_H
#define MICROPY_INCLUDED_SAMD_MODMACHINE_H

#include "py/obj.h"
#include "shared/timeutils/timeutils.h"

#if MICROPY_PY_MACHINE_ADC
extern const mp_obj_type_t machine_adc_type;
#endif
#if MICROPY_PY_MACHINE_DAC
extern const mp_obj_type_t machine_dac_type;
#endif
#if MICROPY_PY_MACHINE_I2C
extern const mp_obj_type_t machine_i2c_type;
#endif
extern const mp_obj_type_t machine_pin_type;
#if MICROPY_PY_MACHINE_PWM
extern const mp_obj_type_t machine_pwm_type;
#endif
#if MICROPY_PY_MACHINE_SPI
extern const mp_obj_type_t machine_spi_type;
#endif
extern const mp_obj_type_t machine_timer_type;
#if MICROPY_PY_MACHINE_UART
extern const mp_obj_type_t machine_uart_type;
#endif
extern const mp_obj_type_t machine_wdt_type;
#if MICROPY_PY_MACHINE_RTC
extern const mp_obj_type_t machine_rtc_type;
#endif

NORETURN mp_obj_t machine_bootloader(size_t n_args, const mp_obj_t *args);

void rtc_gettime(timeutils_struct_time_t *tm);

#endif // MICROPY_INCLUDED_SAMD_MODMACHINE_H
