/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.interactive.completers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import jline.console.completer.Completer;
import jline.internal.Preconditions;

public class SortedAggregateCompleter
implements Completer {
    private final List<Completer> completers = new ArrayList<Completer>();

    public SortedAggregateCompleter() {
    }

    public SortedAggregateCompleter(Collection<Completer> completers) {
        Preconditions.checkNotNull(completers);
        this.completers.addAll(completers);
    }

    public SortedAggregateCompleter(Completer ... completers) {
        this(Arrays.asList(completers));
    }

    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        ArrayList<Completion> completions = new ArrayList<Completion>(this.completers.size());
        int max = -1;
        for (Completer completer : this.completers) {
            Completion completion = new Completion(candidates);
            completion.complete(completer, buffer, cursor);
            max = Math.max(max, completion.cursor);
            completions.add(completion);
        }
        TreeSet<CharSequence> allCandidates = new TreeSet<CharSequence>();
        for (Completion completion : completions) {
            if (completion.cursor != max) continue;
            allCandidates.addAll(completion.candidates);
        }
        candidates.addAll(allCandidates);
        return max;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{completers=" + this.completers + '}';
    }

    private class Completion {
        final List<CharSequence> candidates;
        int cursor;

        public Completion(List<CharSequence> candidates) {
            Preconditions.checkNotNull(candidates);
            this.candidates = new LinkedList<CharSequence>(candidates);
        }

        public void complete(Completer completer, String buffer, int cursor) {
            Preconditions.checkNotNull(completer);
            this.cursor = completer.complete(buffer, cursor, this.candidates);
        }
    }
}

