/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.dependencies;

import org.springframework.boot.cli.compiler.dependencies.ArtifactCoordinatesResolver;
import org.springframework.boot.cli.compiler.dependencies.Dependency;
import org.springframework.boot.cli.compiler.dependencies.DependencyManagement;
import org.springframework.boot.cli.compiler.dependencies.SpringBootDependenciesDependencyManagement;
import org.springframework.util.StringUtils;

public class DependencyManagementArtifactCoordinatesResolver
implements ArtifactCoordinatesResolver {
    private final DependencyManagement dependencyManagement;

    public DependencyManagementArtifactCoordinatesResolver() {
        this(new SpringBootDependenciesDependencyManagement());
    }

    public DependencyManagementArtifactCoordinatesResolver(DependencyManagement dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
    }

    @Override
    public String getGroupId(String artifactId) {
        Dependency dependency = this.find(artifactId);
        return dependency == null ? null : dependency.getGroupId();
    }

    @Override
    public String getArtifactId(String id) {
        Dependency dependency = this.find(id);
        return dependency == null ? null : dependency.getArtifactId();
    }

    private Dependency find(String id) {
        if (StringUtils.countOccurrencesOf(id, ":") == 2) {
            String[] tokens = id.split(":");
            return new Dependency(tokens[0], tokens[1], tokens[2]);
        }
        if (id != null) {
            if (id.startsWith("spring-boot")) {
                return new Dependency("org.springframework.boot", id, this.dependencyManagement.getSpringBootVersion());
            }
            return this.dependencyManagement.find(id);
        }
        return null;
    }

    @Override
    public String getVersion(String module) {
        Dependency dependency = this.find(module);
        return dependency == null ? null : dependency.getVersion();
    }
}

