/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.net.AbstractServerDeactivator;
import org.globus.net.ServerSocketFactory;
import org.globus.net.SocketFactory;
import org.globus.util.Util;
import org.globus.util.deactivator.Deactivator;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public abstract class BaseServer
implements Runnable {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$net$BaseServer == null ? (class$org$globus$net$BaseServer = BaseServer.class$("org.globus.net.BaseServer")) : class$org$globus$net$BaseServer).getName());
    public static final int SO_TIMEOUT = 300000;
    protected boolean accept;
    protected ServerSocket _server = null;
    private boolean secure = true;
    protected String url = null;
    private Thread serverThread = null;
    protected GSSCredential credentials = null;
    protected Authorization authorization = null;
    protected Integer gssMode = GSIConstants.MODE_SSL;
    protected int timeout = 300000;
    protected AbstractServerDeactivator deactivator = null;
    static /* synthetic */ Class class$org$globus$net$BaseServer;

    public BaseServer() throws IOException {
        this(null, 0);
    }

    public BaseServer(int port) throws IOException {
        this(null, port);
    }

    public BaseServer(GSSCredential cred, int port) throws IOException {
        this.credentials = cred;
        this._server = ServerSocketFactory.getDefault().createServerSocket(port);
        this.secure = true;
        this.initialize();
    }

    public BaseServer(boolean secure, int port) throws IOException {
        this.credentials = null;
        this._server = ServerSocketFactory.getDefault().createServerSocket(port);
        this.secure = secure;
        this.initialize();
    }

    protected void initialize() {
        this.setAuthorization(SelfAuthorization.getInstance());
        this.start();
    }

    protected void start() {
        if (this.serverThread == null) {
            this.accept = true;
            this.serverThread = new Thread(this);
            this.serverThread.start();
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void shutdown() {
        block13: {
            this.accept = false;
            try {
                this._server.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            factory = SocketFactory.getDefault();
            s = null;
            try {
                s = factory.createSocket(InetAddress.getLocalHost(), this.getPort());
                s.getInputStream();
                var5_4 = null;
                ** if (s == null) goto lbl-1000
            }
            catch (Throwable var4_11) {
                var5_6 = null;
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var4_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (Exception var3_10) {
                    var5_5 = null;
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        this.serverThread = null;
        this._server = null;
    }

    public GSSCredential getCredentials() {
        return this.credentials;
    }

    public String getProtocol() {
        return this.secure ? "https" : "http";
    }

    public String getURL() {
        if (this.url == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getProtocol()).append("://").append(this.getHost()).append(":").append(String.valueOf(this.getPort()));
            this.url = buf.toString();
        }
        return this.url;
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    public String getHostname() {
        return Util.getLocalHostAddress();
    }

    public String getHost() {
        String host = Util.getLocalHostAddress();
        try {
            URL u = new URL("http", host, 80, "/");
            return u.getHost();
        }
        catch (MalformedURLException e) {
            return host;
        }
    }

    public void run() {
        Socket socket = null;
        while (this.accept) {
            try {
                socket = this._server.accept();
                if (!this.accept) break;
                socket.setSoTimeout(this.getTimeout());
            }
            catch (IOException e) {
                if (!this.accept) break;
                logger.error((Object)("Server died: " + e.getMessage()), (Throwable)e);
                break;
            }
            if (this.secure) {
                try {
                    socket = this.wrapSocket(socket);
                }
                catch (GSSException e) {
                    logger.error((Object)"Failed to secure the socket", (Throwable)e);
                    break;
                }
            }
            this.handleConnection(socket);
        }
        logger.debug((Object)"server thread stopped");
    }

    protected Socket wrapSocket(Socket socket) throws GSSException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(this.credentials);
        context.setOption(GSSConstants.GSS_MODE, this.gssMode);
        GssSocketFactory factory = GssSocketFactory.getDefault();
        GssSocket gsiSocket = (GssSocket)factory.createSocket(socket, null, 0, context);
        gsiSocket.setUseClientMode(false);
        gsiSocket.setAuthorization(this.authorization);
        return gsiSocket;
    }

    public void setGssMode(Integer mode) {
        this.gssMode = mode;
    }

    public void setAuthorization(Authorization auth) {
        this.authorization = auth;
    }

    protected abstract void handleConnection(Socket var1);

    public void registerDefaultDeactivator() {
        if (this.deactivator == null) {
            this.deactivator = new AbstractServerDeactivator(this);
        }
        Deactivator.registerDeactivation(this.deactivator);
    }

    public void unregisterDefaultDeactivator() {
        if (this.deactivator == null) {
            return;
        }
        Deactivator.unregisterDeactivation(this.deactivator);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

