/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.dashboard.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateHelper {
    static final int MILLISECONDS_PER_DAY = 86400000;
    protected static Log log = LogFactory.getLog((String)DateHelper.class.getName());

    public static Date subtractDay(Date date) {
        return DateHelper.addDays(date, -1);
    }

    public static Date addDays(Date date, int numDays) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        cal1.add(5, numDays);
        return cal1.getTime();
    }

    public static Date subtractMonth(Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        cal1.add(2, -1);
        return cal1.getTime();
    }

    public static Date parseDate(String date) throws ParseException {
        if (date == null) {
            throw new ParseException("null is not a valid value", 1);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy", Locale.US);
        Date returnDate = null;
        returnDate = formatter.parse(date);
        return returnDate;
    }

    public static Date parseDateWithSpaces(String date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy MM dd", Locale.US);
        Date returnDate = null;
        try {
            returnDate = formatter.parse(date);
        }
        catch (Exception e) {
            log.error((Object)("Impossible to parse date: " + date), (Throwable)e);
        }
        return returnDate;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy", Locale.US);
        return formatter.format(date);
    }

    public static boolean compareDates(Date d1, Date d2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(d1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(d2);
        if (cal1.get(5) == cal2.get(5) && cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2)) {
            log.debug((Object)("Date comparison with " + d1 + " and " + d2 + " retunring true"));
            return true;
        }
        log.debug((Object)("Date comparison with " + d1 + " and " + d2 + " retunring false"));
        return false;
    }

    public static int getOffsetDays(Date date1, Date date2) {
        long diff = date1.getTime() - date2.getTime();
        long numberOfDays = diff / 86400000L;
        return (int)numberOfDays;
    }

    public static boolean isOneDayOffset(Date d1, Date d2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(d1);
        cal1.add(5, 1);
        return DateHelper.compareDates(cal1.getTime(), d2);
    }

    public static Date getStartDate() {
        Date toDay = new Date();
        return DateHelper.subtractMonth(toDay);
    }

    public static Date getEndDate() {
        return new Date();
    }

    public static boolean containsString(String[] str, String value) {
        for (int i = 0; i < str.length; ++i) {
            if (!str[i].equals(value)) continue;
            return true;
        }
        return false;
    }
}

