/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import java.util.List;
import java.util.Map;
import org.globus.rsl.ParseException;
import org.globus.rsl.RslAttributes;
import org.globus.rsl.RslNode;

public class GramAttributes
extends RslAttributes {
    public static final int JOBTYPE_SINGLE = 1;
    public static final int JOBTYPE_MULTIPLE = 2;
    public static final int JOBTYPE_MPI = 3;
    public static final int JOBTYPE_CONDOR = 4;

    public GramAttributes() {
    }

    public GramAttributes(String rsl) throws ParseException {
        super(rsl);
    }

    public GramAttributes(RslNode rslTree) {
        super(rslTree);
    }

    public void setExecutable(String executable) {
        this.set("executable", executable);
    }

    public String getExecutable() {
        return this.getSingle("executable");
    }

    public void setDirectory(String directory) {
        this.set("directory", directory);
    }

    public String getDirectory() {
        return this.getSingle("directory");
    }

    public void setStdout(String stdout) {
        this.set("stdout", stdout);
    }

    public String getStdout() {
        return this.getSingle("stdout");
    }

    public void setStderr(String stderr) {
        this.set("stderr", stderr);
    }

    public String getStderr() {
        return this.getSingle("stderr");
    }

    public void setStdin(String stdin) {
        this.set("stdin", stdin);
    }

    public String getStdin() {
        return this.getSingle("stdin");
    }

    public void setDryRun(boolean enable) {
        this.set("dryrun", enable ? "yes" : "no");
    }

    public boolean isDryRun() {
        String run = this.getSingle("dryrun");
        if (run == null) {
            return false;
        }
        return run.equalsIgnoreCase("yes");
    }

    public void setQueue(String queue) {
        this.set("queue", queue);
    }

    public String getQueue() {
        return this.getSingle("queue");
    }

    public void setProject(String project) {
        this.set("project", project);
    }

    public String getProject() {
        return this.getSingle("project");
    }

    public void setJobType(int jobType) {
        String type = null;
        switch (jobType) {
            case 1: {
                type = "single";
                break;
            }
            case 2: {
                type = "multiple";
                break;
            }
            case 3: {
                type = "mpi";
                break;
            }
            case 4: {
                type = "condor";
            }
        }
        if (type != null) {
            this.set("jobtype", type);
        }
    }

    public int getJobType() {
        String jobType = this.getSingle("jobtype");
        if (jobType == null) {
            return -1;
        }
        if (jobType.equalsIgnoreCase("single")) {
            return 1;
        }
        if (jobType.equalsIgnoreCase("multiple")) {
            return 2;
        }
        if (jobType.equalsIgnoreCase("mpi")) {
            return 3;
        }
        if (jobType.equalsIgnoreCase("condor")) {
            return 4;
        }
        return -1;
    }

    public void setMinMemory(int minmemory) {
        this.set("minmemory", String.valueOf(minmemory));
    }

    public int getMinMemory() {
        String value = this.getSingle("minmemory");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setNumProcs(int numprocs) {
        this.set("count", String.valueOf(numprocs));
    }

    public int getNumProcs() {
        String value = this.getSingle("count");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setMaxWallTime(int maxwalltime) {
        this.set("maxwalltime", String.valueOf(maxwalltime));
    }

    public int getMaxWallTime() {
        String value = this.getSingle("maxwalltime");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setMaxCPUTime(int maxcputime) {
        this.set("maxcputime", String.valueOf(maxcputime));
    }

    public int getMaxCPUTime() {
        String value = this.getSingle("maxcputime");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setMaxMemory(int maxmemory) {
        this.set("maxmemory", String.valueOf(maxmemory));
    }

    public int getMaxMemory() {
        String value = this.getSingle("maxmemory");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void addArgument(String argument) {
        this.add("arguments", argument);
    }

    public boolean deleteArgument(String argument) {
        return this.remove("arguments", argument);
    }

    public List getArguments() {
        return this.getMulti("arguments");
    }

    public void addEnvVariable(String varName, String value) {
        this.addMulti("environment", new String[]{varName, value});
    }

    public boolean deleteEnvVariable(String varName) {
        return this.removeMap("environment", varName);
    }

    public Map getEnvironment() {
        return this.getMap("environment");
    }
}

