/*
 * Decompiled with CFR 0.152.
 */
package org.inria.genouest.opal.tools.typedwsdl.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class OpalTypedWSDLGenerator {
    private static Logger logger = Logger.getLogger((String)OpalTypedWSDLGenerator.class.getName());
    static String servicesUrl;
    static String configFilesPath;
    static String targetWSDLPath;
    static String targetWSDLUrl;
    static File tmpOriginalWSDLFile;
    private static String configFilePath;

    public static void main(String[] args) {
        OpalTypedWSDLGenerator.loadConfig();
        CommandLine line = OpalTypedWSDLGenerator.createProgramOptions(args);
        InputStream xsltFile = OpalTypedWSDLGenerator.checkXSLTPath();
        OpalTypedWSDLGenerator.prepareConfigFile(line);
        String serviceUrl = OpalTypedWSDLGenerator.downloadOriginalWSDL(line);
        String targetFullWSDLUrl = targetWSDLUrl + line.getOptionValue("s") + ".wsdl";
        String targetFullWSDLPath = targetWSDLPath + line.getOptionValue("s") + ".wsdl";
        OpalTypedWSDLGenerator.applyXSLTTransformation(xsltFile, targetFullWSDLPath);
        OpalTypedWSDLGenerator.showResult(serviceUrl, targetFullWSDLUrl, targetFullWSDLPath);
    }

    private static void loadConfig() {
        String buildConfigPath = "build.properties";
        String opalConfigPath = "etc" + File.separator + "opal.properties";
        try {
            Properties buildConfigFile = new Properties();
            FileInputStream buildConfigContent = new FileInputStream(buildConfigPath);
            buildConfigFile.load(buildConfigContent);
            Properties opalConfigFile = new Properties();
            FileInputStream opalConfigContent = new FileInputStream(opalConfigPath);
            opalConfigFile.load(opalConfigContent);
            String tomcatUrl = opalConfigFile.getProperty("tomcat.url");
            String catalina = buildConfigFile.getProperty("catalina.home");
            String typedDir = buildConfigFile.getProperty("typedservices.dir");
            if (tomcatUrl == null || catalina == null || typedDir == null) {
                throw new Exception("Missing value in config file. Aborting typed service generation.");
            }
            servicesUrl = tomcatUrl + "/opal2/services/";
            configFilesPath = "configs" + File.separator;
            targetWSDLPath = catalina + File.separator + "webapps" + File.separator + typedDir + File.separator;
            File td = new File(targetWSDLPath);
            if (!td.exists()) {
                td.mkdir();
            }
            targetWSDLUrl = tomcatUrl + "/" + typedDir + "/";
            tmpOriginalWSDLFile = File.createTempFile("typedwsdlgenerator_tmp_original_WSDL_file", ".xml");
            tmpOriginalWSDLFile.deleteOnExit();
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't load some config file (" + buildConfigPath + "; " + opalConfigPath + ")."));
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static InputStream checkXSLTPath() {
        InputStream xsltStream = OpalTypedWSDLGenerator.class.getResourceAsStream("/xslt/opalWSDL2TypedWSDL.xsl");
        if (xsltStream == null) {
            logger.error((Object)"The XSLT file could not be found.");
            System.exit(1);
        }
        return xsltStream;
    }

    private static void prepareConfigFile(CommandLine line) {
        File configFile;
        String fileName = line.getOptionValue("c");
        configFilePath = configFilesPath + fileName;
        if (fileName.indexOf(File.separator) != -1) {
            configFilePath = fileName;
        }
        if (!(configFile = new File(configFilePath)).canRead()) {
            logger.error((Object)("The given config file (" + configFilePath + ") does not exist or is not readable."));
            System.exit(1);
        }
    }

    private static String downloadOriginalWSDL(CommandLine line) {
        String serviceUrl = servicesUrl + line.getOptionValue("s") + "?wsdl";
        try {
            OpalTypedWSDLGenerator.downloadFile(serviceUrl, tmpOriginalWSDLFile);
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Could not download service WSDL file (" + serviceUrl + ") to tmp dir (" + tmpOriginalWSDLFile.getAbsolutePath() + "). Problem with Url."));
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            logger.error((Object)("Could not download service WSDL file (" + serviceUrl + ") to tmp dir (" + tmpOriginalWSDLFile.getAbsolutePath() + ")."));
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            logger.error((Object)("Could not download service WSDL file (" + serviceUrl + ") to tmp dir (" + tmpOriginalWSDLFile.getAbsolutePath() + ")."));
            e.printStackTrace();
            System.exit(1);
        }
        return serviceUrl;
    }

    private static void applyXSLTTransformation(InputStream xsltFile, String targetFullWSDLPath) throws TransformerFactoryConfigurationError {
        try {
            TransformerFactory transfoFact = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(xsltFile);
            Transformer transformer = transfoFact.newTransformer(stylesource);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setParameter("configPath", configFilePath);
            DocumentBuilderFactory docBFact = DocumentBuilderFactory.newInstance();
            docBFact.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBFact.newDocumentBuilder();
            Document document = docBuilder.parse(tmpOriginalWSDLFile);
            DOMSource source = new DOMSource(document);
            File fileWSDL = new File(targetFullWSDLPath);
            StreamResult result = new StreamResult(fileWSDL);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            logger.error((Object)"Error while applying XSLT stylesheet.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void showResult(String serviceUrl, String targetFullWSDLUrl, String targetFullWSDLPath) {
        logger.info((Object)("Autogenerated WSDL file is available at: " + targetFullWSDLUrl));
        logger.info((Object)("It has been created on file at : " + targetFullWSDLPath));
        logger.info((Object)("The untyped WSDL file is still available at: " + serviceUrl));
    }

    private static CommandLine createProgramOptions(String[] args) {
        Options options = new Options();
        OptionBuilder.withArgName((String)"service_name");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"Deployed service name.");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"config_filename");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)("The config file name (it must be located in " + configFilesPath + ")."));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"c"));
        logger.debug((Object)"Reading command line arguments");
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java org.inria.genouest.opal.tools.typedwsdl.generator.OpalTypedWSDLGenerator", options);
            System.exit(1);
        }
        return line;
    }

    private static void downloadFile(String filePath, File destination) throws IOException, MalformedURLException {
        URLConnection connection = null;
        BufferedInputStream is = null;
        FileOutputStream destinationFile = null;
        URL url = new URL(filePath);
        connection = url.openConnection();
        destinationFile = new FileOutputStream(destination);
        is = new BufferedInputStream(connection.getInputStream());
        int currentBit = 0;
        while ((currentBit = ((InputStream)is).read()) != -1) {
            destinationFile.write(currentBit);
        }
        ((InputStream)is).close();
        destinationFile.flush();
        destinationFile.close();
    }
}

