/*
 * Decompiled with CFR 0.152.
 */
package org.inria.genouest.opal.tools.soaprequest.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.inria.genouest.opal.tools.soaprequest.filter.XmlPartInputStream;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SoapInputStream
extends ServletInputStream {
    private InputStream rawRequest;
    private boolean isMultipartRequest;
    private String multipartBoundary = "";
    private String cachedLine = "";
    private String cachedXmlLine = "";
    private StringReader cachedXmlLineReader;
    private BufferedReader transformedXML = null;
    private boolean isInMultipartSectionHeader = false;
    private boolean isInXmlContentHeader = false;
    private boolean isInXmlContent = false;
    private int previousDataChunk;
    private String cachedXmlEOL = "";
    private boolean stopParsing = false;
    private static final Logger logger = Logger.getLogger(SoapInputStream.class);
    private String serviceName;
    private ServletContext context;
    static String wsddNameSpace = "http://xml.apache.org/axis/wsdd/";

    public SoapInputStream(ServletInputStream requestStream, boolean isMultipart, String serviceName, ServletContext context) {
        this.rawRequest = requestStream;
        this.isMultipartRequest = isMultipart;
        this.context = context;
        this.serviceName = serviceName;
        if (!this.isMultipartRequest) {
            XmlPartInputStream xmlStream = new XmlPartInputStream(this);
            try {
                this.transformedXML = this.applyXSLTTransformation(xmlStream);
            }
            catch (Exception e) {
                logger.warn((Object)"Could not apply XSLT stylesheet to incoming xml.");
                this.transformedXML = null;
            }
            try {
                xmlStream.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Problem closing incoming xml stream.");
                logger.error((Object)e);
            }
        }
    }

    public int read() throws IOException {
        int dataChunk = 0;
        if (this.isMultipartRequest) {
            if (this.transformedXML != null) {
                dataChunk = this.transformedXML.read();
            }
            if (this.transformedXML == null ^ dataChunk < 0 && this.cachedXmlLineReader != null) {
                dataChunk = this.cachedXmlLineReader.read();
                this.transformedXML = null;
            }
            if ((this.transformedXML == null && this.cachedXmlLineReader == null) ^ dataChunk < 0) {
                dataChunk = this.rawRequest.read();
                this.transformedXML = null;
                this.cachedXmlLineReader = null;
            }
            if (!this.stopParsing) {
                if (dataChunk == 10 && this.previousDataChunk == 13) {
                    this.cachedLine = "";
                    if (this.isInXmlContent) {
                        logger.debug((Object)"Launching SOAP XSLT transformation");
                        XmlPartInputStream xmlStream = new XmlPartInputStream(this);
                        try {
                            this.transformedXML = this.applyXSLTTransformation(xmlStream);
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Could not apply XSLT stylesheet to incoming SOAP request.");
                            this.transformedXML = null;
                            this.stopParsing = true;
                        }
                        xmlStream.close();
                    }
                } else if (dataChunk >= 0 && dataChunk != 13 && dataChunk != 10) {
                    this.cachedLine = this.cachedLine + (char)dataChunk;
                } else if (dataChunk < 0) {
                    this.cachedLine = "";
                } else {
                    logger.trace((Object)("SOAP request line finished with content: " + this.cachedLine + (char)dataChunk));
                    if (this.multipartBoundary.length() == 0) {
                        if (this.cachedLine.length() > 0) {
                            this.multipartBoundary = this.cachedLine;
                            logger.debug((Object)("Found boundary for multipart request: " + this.multipartBoundary));
                            this.isInMultipartSectionHeader = true;
                        }
                    } else if (!this.isInMultipartSectionHeader && this.multipartBoundary.equals(this.cachedLine)) {
                        this.isInMultipartSectionHeader = true;
                        this.isInXmlContentHeader = false;
                        logger.debug((Object)"Getting into a part header of a multipart request");
                    } else if (this.isInMultipartSectionHeader && this.cachedLine.length() == 0) {
                        this.isInMultipartSectionHeader = false;
                        if (this.isInXmlContentHeader) {
                            logger.debug((Object)"Leaving an XML part header of a multipart request");
                            this.isInXmlContentHeader = false;
                            this.isInXmlContent = true;
                        } else {
                            logger.debug((Object)"Leaving a part header of a multipart request");
                        }
                    } else if (this.isInMultipartSectionHeader && (this.cachedLine.indexOf("Content-Type: text/xml") >= 0 || this.cachedLine.indexOf("application/xop+xml") >= 0)) {
                        logger.debug((Object)"Found an XML part to try to transform in incoming multipart request!");
                        this.isInXmlContentHeader = true;
                    }
                    this.cachedLine = "";
                }
                this.previousDataChunk = dataChunk;
            }
        } else {
            dataChunk = this.transformedXML != null ? this.transformedXML.read() : this.rawRequest.read();
        }
        return dataChunk;
    }

    public int readXml() throws IOException {
        int dataChunk;
        if (this.isMultipartRequest) {
            if (this.multipartBoundary.length() == 0) {
                logger.warn((Object)"Asking Xml content from multipart request without knowing boundary.");
                return -1;
            }
            if (!this.isInXmlContent) {
                return -1;
            }
            try {
                this.fillXmlCache();
            }
            catch (Exception e) {
                return -1;
            }
            dataChunk = this.cachedXmlLineReader.read();
            if (dataChunk < 0) {
                this.cachedXmlLine = "";
                this.cachedXmlLineReader.close();
                try {
                    this.fillXmlCache();
                }
                catch (Exception e) {
                    return -1;
                }
                dataChunk = this.cachedXmlLineReader.read();
            }
        } else {
            dataChunk = this.rawRequest.read();
        }
        return dataChunk;
    }

    private void fillXmlCache() throws Exception {
        if (this.cachedXmlLine.length() == 0) {
            int dataChunk = this.rawRequest.read();
            if (dataChunk < 0) {
                this.cachedXmlLine = this.cachedXmlEOL;
                this.cachedXmlEOL = "";
            }
            while (dataChunk >= 0) {
                if (dataChunk == 13 || dataChunk == 10) {
                    if (this.cachedXmlEOL.length() >= 2 || this.cachedXmlEOL.equals(Character.toString((char)dataChunk)) || !this.cachedXmlEOL.endsWith("\n") && !this.cachedXmlEOL.endsWith("\r")) {
                        this.cachedXmlLine = this.cachedXmlEOL + this.cachedXmlLine;
                        this.cachedXmlEOL = "";
                    }
                    if (this.isMultipartRequest && this.cachedXmlLine.indexOf(this.multipartBoundary) >= 0 && !this.isInMultipartSectionHeader) {
                        this.isInMultipartSectionHeader = true;
                        this.isInXmlContentHeader = false;
                        logger.debug((Object)"Getting into a new part header: Xml part is finished!");
                        this.cachedXmlLine = this.cachedXmlLine + (char)dataChunk;
                        this.cachedXmlEOL = "";
                        this.cachedXmlLineReader = new StringReader(this.cachedXmlLine);
                        this.isInXmlContent = false;
                        throw new Exception("No more Xml data in xml part of http request.");
                    }
                    this.cachedXmlEOL = this.cachedXmlEOL + (char)dataChunk;
                    break;
                }
                this.cachedXmlLine = this.cachedXmlLine + (char)dataChunk;
                dataChunk = this.rawRequest.read();
            }
            if (dataChunk < 0 && this.isMultipartRequest && this.cachedXmlLine.indexOf(this.multipartBoundary) >= 0 && !this.isInMultipartSectionHeader) {
                this.isInMultipartSectionHeader = false;
                this.isInXmlContentHeader = false;
                logger.debug((Object)"End of the request: Xml part is finished!");
                this.cachedXmlLine = this.cachedXmlEOL + this.cachedXmlLine;
                this.cachedXmlEOL = "";
                this.cachedXmlLineReader = new StringReader(this.cachedXmlLine);
                this.isInXmlContent = false;
                throw new Exception("No more Xml data in xml part of http request.");
            }
            logger.trace((Object)("New Xml content in cache containing: " + this.cachedXmlLine));
            this.cachedXmlLineReader = new StringReader(this.cachedXmlLine);
        }
    }

    private BufferedReader applyXSLTTransformation(InputStream inputXmlStream) throws TransformerFactoryConfigurationError, Exception {
        InputStream xsltStream = ((Object)((Object)this)).getClass().getResourceAsStream("/xslt/typedSOAP2OpalSOAP.xsl");
        if (xsltStream == null) {
            logger.error((Object)"The XSLT file could not be found.");
            throw new Exception("The XSLT file could not be found.");
        }
        TransformerFactory transfoFact = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(xsltStream);
        Transformer transformer = transfoFact.newTransformer(stylesource);
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("encoding", "UTF-8");
        StreamSource source = new StreamSource(inputXmlStream);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        if ("".equals(this.serviceName)) {
            logger.error((Object)"Unknown service name.");
            throw new Exception("Unknown service name.");
        }
        String serviceConfigFilePath = this.getServiceConfigFilePath(this.serviceName);
        if (serviceConfigFilePath == null) {
            logger.warn((Object)"No config file found for asked service. Aborting XSLT transformation.");
            throw new Exception("No config file found for asked service. Aborting XSLT transformation.");
        }
        transformer.setParameter("configPath", serviceConfigFilePath);
        transformer.transform(source, result);
        writer.flush();
        writer.close();
        xsltStream.close();
        logger.debug((Object)("Transformation of incoming SOAP request finished with result in string: " + writer.toString()));
        String resultStr = writer.toString();
        if (resultStr.trim().endsWith("Envelope>")) {
            logger.debug((Object)"SOAP request successfully transformed. Stopping parsing of whole request.");
            this.stopParsing = true;
        }
        BufferedReader transformedResult = new BufferedReader(new StringReader(resultStr));
        return transformedResult;
    }

    public void close() throws IOException {
        this.rawRequest.close();
        if (this.transformedXML != null) {
            this.transformedXML.close();
        }
        if (this.cachedXmlLineReader != null) {
            this.cachedXmlLineReader.close();
        }
    }

    public long skip(long n) throws IOException {
        throw new IOException("Skip is not supported by SoapInputStream.");
    }

    private String getServiceConfigFilePath(String serviceName) {
        String configFileName = null;
        try {
            String path = this.context.getRealPath("/") + "WEB-INF" + File.separator + "server-config.wsdd";
            DocumentBuilderFactory docBFact = DocumentBuilderFactory.newInstance();
            docBFact.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBFact.newDocumentBuilder();
            FileReader reader = new FileReader(path);
            Document document = docBuilder.parse(new InputSource(reader));
            XPathFactory xpathFact = XPathFactory.newInstance();
            XPath xpath = xpathFact.newXPath();
            NamespaceContext namespace = new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if (prefix.equals("dd")) {
                        return wsddNameSpace;
                    }
                    return "";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    if (namespaceURI.equals(wsddNameSpace)) {
                        return "dd";
                    }
                    return "";
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (namespaceURI.equals(wsddNameSpace)) {
                        list.add("dd");
                    }
                    return list.iterator();
                }
            };
            xpath.setNamespaceContext(namespace);
            XPathExpression exp = xpath.compile("/dd:deployment/dd:service[@name='" + serviceName + "']/dd:parameter[@name='appConfig']/@value");
            configFileName = (String)exp.evaluate(document, XPathConstants.STRING);
            if (configFileName == null) {
                logger.error((Object)"Required parameter appConfig not found in WSDD");
                return null;
            }
        }
        catch (XPathExpressionException xpee) {
            logger.error((Object)xpee);
        }
        catch (Exception e) {
            logger.warn((Object)"We could not get the service list from the Axis Engine...");
            logger.warn((Object)e);
        }
        return configFileName;
    }
}

