/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.condorAPI;

import condor.classad.Constant;
import condor.classad.RecordExpr;
import edu.sdsc.nbcr.opal.manager.condorAPI.EventType;
import edu.sdsc.nbcr.opal.manager.condorAPI.Job;
import edu.sdsc.nbcr.opal.manager.condorAPI.JobId;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventCheckpointed;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventExecutableError;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventExecute;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventGeneric;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventGlobusResourceDown;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventGlobusResourceUp;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventGlobusSubmit;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventGlobusSubmitFailed;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventImageSize;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobAborted;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobDisconnected;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobEvicted;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobHeld;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobReconnectFailed;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobReconnected;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobReleased;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobSuspended;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobTerminated;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventJobUnsuspended;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventNodeExecute;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventNodeTerminated;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventPostScriptTerminated;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventRemoteError;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventShadowException;
import edu.sdsc.nbcr.opal.manager.condorAPI.event.EventSubmit;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Event
implements EventType {
    JobId jobId;
    Job job;
    protected int type;
    Date date;
    static DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");

    protected Event(RecordExpr expr) {
        this.jobId = new JobId(((Constant)expr.lookup("Cluster")).intValue(), ((Constant)expr.lookup("Proc")).intValue());
        String eventTime = ((Constant)expr.lookup("EventTime")).stringValue();
        try {
            this.date = format.parse(eventTime);
        }
        catch (ParseException e) {
            this.date = new Date();
        }
    }

    public JobId getJobId() {
        return (JobId)this.jobId.clone();
    }

    public Job getJob() {
        return this.job;
    }

    static Event getEvent(RecordExpr expr) {
        int type = ((Constant)expr.lookup("EventTypeNumber")).intValue();
        Event tmpEvent = null;
        switch (type) {
            case 0: {
                tmpEvent = new EventSubmit(expr);
                break;
            }
            case 1: {
                tmpEvent = new EventExecute(expr);
                break;
            }
            case 2: {
                tmpEvent = new EventExecutableError(expr);
                break;
            }
            case 3: {
                tmpEvent = new EventCheckpointed(expr);
                break;
            }
            case 4: {
                tmpEvent = new EventJobEvicted(expr);
                break;
            }
            case 5: {
                tmpEvent = new EventJobTerminated(expr);
                break;
            }
            case 6: {
                tmpEvent = new EventImageSize(expr);
                break;
            }
            case 7: {
                tmpEvent = new EventShadowException(expr);
                break;
            }
            case 8: {
                tmpEvent = new EventGeneric(expr);
                break;
            }
            case 9: {
                tmpEvent = new EventJobAborted(expr);
                break;
            }
            case 10: {
                tmpEvent = new EventJobSuspended(expr);
                break;
            }
            case 11: {
                tmpEvent = new EventJobUnsuspended(expr);
                break;
            }
            case 12: {
                tmpEvent = new EventJobHeld(expr);
                break;
            }
            case 13: {
                tmpEvent = new EventJobReleased(expr);
                break;
            }
            case 14: {
                tmpEvent = new EventNodeExecute(expr);
                break;
            }
            case 15: {
                tmpEvent = new EventNodeTerminated(expr);
                break;
            }
            case 16: {
                tmpEvent = new EventPostScriptTerminated(expr);
                break;
            }
            case 17: {
                tmpEvent = new EventGlobusSubmit(expr);
                break;
            }
            case 18: {
                tmpEvent = new EventGlobusSubmitFailed(expr);
                break;
            }
            case 19: {
                tmpEvent = new EventGlobusResourceUp(expr);
                break;
            }
            case 20: {
                tmpEvent = new EventGlobusResourceDown(expr);
                break;
            }
            case 21: {
                tmpEvent = new EventRemoteError(expr);
                break;
            }
            case 22: {
                tmpEvent = new EventJobDisconnected(expr);
                break;
            }
            case 23: {
                tmpEvent = new EventJobReconnected(expr);
                break;
            }
            case 24: {
                tmpEvent = new EventJobReconnectFailed(expr);
            }
        }
        return tmpEvent;
    }

    public String toString() {
        return this.jobId + " " + this.date + " " + EventNames[this.type];
    }
}

