/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CSFJobManager
implements OpalJobManager {
    private static Logger logger = Logger.getLogger((String)CSFJobManager.class.getName());
    private Properties props;
    private AppConfigType config;
    private Process proc_submit_job;
    private Process proc_check_status;
    private Process proc;
    private StatusOutputType status;
    private String handle;
    private Thread stdoutThread;
    private Thread stderrThread;
    private boolean started = false;
    private volatile boolean done = false;
    private String[] envp = new String[8];
    private String csf_job_id = null;
    private String wd;

    @Override
    public void initialize(Properties props, AppConfigType config, String handle) throws JobManagerException {
        logger.info((Object)"called");
        this.props = props;
        this.config = config;
        this.handle = handle;
        this.envp[0] = new String("CLASSPATH=" + System.getenv("CSF_CLASSPATH"));
        this.envp[1] = new String("SHLIB_PATH=" + System.getenv("SHLIB_PATH"));
        this.envp[2] = new String("GLOBUS_PATH=" + System.getenv("GLOBUS_PATH"));
        this.envp[3] = new String("PATH=" + System.getenv("PATH"));
        this.envp[4] = new String("MANPATH=" + System.getenv("MANPATH"));
        this.envp[5] = new String("LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH"));
        this.envp[6] = new String("DYLD_LIBRARY_PATH=" + System.getenv("DYLD_LIBRARY_PATH"));
        this.envp[7] = new String("LIBPATH=" + System.getenv("LIBPATH"));
        logger.debug((Object)"GT/CSF4 Environment Variables:");
        logger.debug((Object)this.envp[0]);
        logger.debug((Object)this.envp[1]);
        logger.debug((Object)this.envp[2]);
        logger.debug((Object)this.envp[3]);
        logger.debug((Object)this.envp[4]);
        logger.debug((Object)this.envp[5]);
        logger.debug((Object)this.envp[6]);
        logger.debug((Object)this.envp[7]);
        this.status = new StatusOutputType();
    }

    @Override
    public void destroyJobManager() throws JobManagerException {
        logger.info((Object)"called");
        throw new JobManagerException("destroyJobManager() method not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String launchJob(String argList, Integer numProcs, String workingDir) throws JobManagerException {
        logger.info((Object)"called");
        this.wd = workingDir;
        if (this.config == null) {
            String msg = "Can't find application configuration - Plugin not initialized correctly";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String args = this.config.getDefaultArgs();
        if (args == null) {
            args = argList;
        } else {
            String userArgs = argList;
            if (userArgs != null) {
                args = args + " " + userArgs;
            }
        }
        if (args != null) {
            args = args.trim();
        }
        logger.debug((Object)("Argument list: " + args));
        String systemProcsString = this.props.getProperty("num.procs");
        int systemProcs = 0;
        if (systemProcsString != null) {
            systemProcs = Integer.parseInt(systemProcsString);
        }
        String cmd = null;
        String rsl = new String();
        if (args != null && !args.equals("")) {
            logger.debug((Object)("Appending arguments: " + args));
        }
        logger.debug((Object)("CMD: " + cmd));
        String localIP = null;
        String[] wd_tokens = workingDir.split("/");
        String jobID = wd_tokens[wd_tokens.length - 1];
        String csf4WD = this.props.getProperty("csf4.workingDir");
        if (csf4WD == null) {
            logger.fatal((Object)"Can't find property: csf4.workingDir");
        }
        String remoteDir = csf4WD + "/" + jobID;
        try {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.error((Object)("Can't figure out IP address for localhost: " + e.getMessage()));
            logger.error((Object)("Can't figure out IP address for localhost: " + e.getMessage()));
        }
        String fullBinLocation = this.config.getBinaryLocation();
        int index = fullBinLocation.indexOf(":");
        String appName = null;
        String binLocation = null;
        if (index > 0) {
            appName = fullBinLocation.substring(0, index);
            binLocation = fullBinLocation.substring(index + 1, fullBinLocation.length());
        } else {
            binLocation = fullBinLocation;
        }
        rsl = "&";
        if (appName != null) {
            rsl = rsl + "(application=" + appName + ")";
        }
        rsl = rsl + "(executable=" + binLocation + ")" + "(directory=opal_runs/" + jobID + ")" + "(stdout=csf_stdout.txt)" + "(stderr=csf_stderr.txt)" + "(stagein=\"" + workingDir + "->opal_runs/" + jobID + "/\")" + "(stageout=\"" + remoteDir + "/->" + workingDir + "\")";
        if (this.config.isParallel()) {
            if (numProcs == null) {
                String msg = "Number of processes unspecified for parallel job";
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            if (numProcs > systemProcs) {
                String msg = "Processors required - " + numProcs + ", available - " + systemProcs;
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            rsl = rsl + "(jobtype=\"mpi\")(count=" + numProcs + ")";
        }
        if (args != null) {
            args = "\"" + args + "\"";
            args = args.replaceAll("[\\s]+", "\" \"");
            rsl = rsl + "(arguments=" + args + ")";
        }
        logger.debug((Object)("RSL: " + rsl));
        String rslfile = new String(workingDir + "/job.rsl");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(rslfile));
            out.write(rsl);
            out.close();
        }
        catch (IOException e) {
            System.out.println("There was a problem:" + e);
        }
        cmd = "csf-job-create -r " + rslfile + " " + "-sub";
        try {
            logger.debug((Object)("Working directory: " + workingDir));
            this.proc_submit_job = Runtime.getRuntime().exec(cmd, this.envp, new File(workingDir));
            this.stdoutThread = this.writeStdOut(this.proc_submit_job, workingDir, "stdout.txt");
            this.stderrThread = this.writeStdErr(this.proc_submit_job, workingDir, "stderr.txt");
        }
        catch (IOException ioe) {
            String msg = "Error while running executable via fork - " + ioe.getMessage();
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.status.setCode(1);
        this.status.setMessage("Execution in progress");
        System.out.println("CSF Job Submitting.");
        this.started = true;
        CSFJobManager cSFJobManager = this;
        synchronized (cSFJobManager) {
            this.notifyAll();
        }
        return this.proc_submit_job.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusOutputType waitForActivation() throws JobManagerException {
        logger.info((Object)"called");
        if (this.proc_submit_job == null) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        while (!this.started) {
            try {
                CSFJobManager msg = this;
                synchronized (msg) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                logger.error((Object)ie.getMessage());
            }
        }
        return this.status;
    }

    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        logger.info((Object)"called");
        if (this.proc_submit_job == null) {
            String msg = "Can't wait for a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        int exitValue = 0;
        try {
            exitValue = this.proc_submit_job.waitFor();
        }
        catch (InterruptedException ie) {
            String msg = "Exception while waiting for process to finish";
            logger.error((Object)msg, (Throwable)ie);
            throw new JobManagerException(msg + " - " + ie.getMessage());
        }
        if (exitValue == 0) {
            logger.debug((Object)"CSF Job Submitted.");
            this.status.setCode(2);
            int pdone_exit = 0;
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(this.wd + "/" + "stdout.txt");
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    if (!strLine.startsWith("Query Job Status By csf-job-status")) continue;
                    String[] str_tokens = strLine.split(" ");
                    this.csf_job_id = str_tokens[str_tokens.length - 1];
                    logger.debug((Object)("csf_job_id:" + this.csf_job_id));
                }
                in.close();
                String cmd = new String("csf-job-status " + this.csf_job_id);
                logger.debug((Object)("Working directory: " + this.wd));
                while (pdone_exit == 0) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        logger.error((Object)ie.getMessage());
                        continue;
                    }
                    logger.debug((Object)"Check CSF Job Status.");
                    this.proc_check_status = Runtime.getRuntime().exec(cmd, this.envp, new File(this.wd));
                    DataInputStream status_in = new DataInputStream(this.proc_check_status.getInputStream());
                    BufferedReader status_br = new BufferedReader(new InputStreamReader(status_in));
                    BufferedWriter out = null;
                    try {
                        out = new BufferedWriter(new FileWriter(this.wd + "csf_status_out.txt"));
                    }
                    catch (IOException e) {
                        System.out.println("There was a problem:" + e);
                    }
                    block14: while ((strLine = status_br.readLine()) != null) {
                        logger.debug((Object)strLine);
                        try {
                            out.write(strLine + "\n");
                        }
                        catch (IOException e) {
                            System.out.println("There was a problem:" + e);
                        }
                        if (strLine.indexOf("PDone") < 0 && strLine.indexOf("PExit") < 0 && strLine.indexOf("Run") < 0 && strLine.indexOf("Forwarded") < 0 && strLine.indexOf("Created") < 0 && strLine.indexOf("Pending") < 0 && strLine.indexOf("Unknown") < 0) continue;
                        String[] str_tokens = strLine.split(" ");
                        for (int i = 0; i < str_tokens.length - 1; ++i) {
                            if (str_tokens[i].equals("PDone")) {
                                logger.debug((Object)str_tokens[i]);
                                this.status.setCode(8);
                                logger.debug((Object)"CSF Job Status:PDone");
                                pdone_exit = 1;
                                continue block14;
                            }
                            if (str_tokens[i].equals("PExit")) {
                                logger.debug((Object)str_tokens[i]);
                                this.status.setCode(4);
                                logger.debug((Object)"CSF Job Status:PExit");
                                pdone_exit = 2;
                                continue block14;
                            }
                            if (str_tokens[i].equals("Run")) {
                                logger.debug((Object)str_tokens[i]);
                                this.status.setCode(2);
                                logger.debug((Object)"CSF Job Status:Run");
                                continue block14;
                            }
                            if (str_tokens[i].equals("Forwarded")) {
                                logger.debug((Object)str_tokens[i]);
                                this.status.setCode(2);
                                logger.debug((Object)"CSF Job Status:Forwarded");
                                continue block14;
                            }
                            if (str_tokens[i].equals("Created")) {
                                logger.debug((Object)str_tokens[i]);
                                this.status.setCode(2);
                                logger.debug((Object)"CSF Job Status:Created");
                                continue block14;
                            }
                            if (!str_tokens[i].equals("Unknown")) continue;
                            logger.debug((Object)str_tokens[i]);
                            this.status.setCode(1);
                            logger.debug((Object)"CSF Job Status:Unknown");
                            continue block14;
                        }
                    }
                    in.close();
                    out.close();
                    this.proc_check_status.destroy();
                }
            }
            catch (IOException ioe) {
                String msg = "Error while running executable CSF - " + ioe.getMessage();
                logger.error((Object)msg);
                throw new JobManagerException(msg);
            }
            if (pdone_exit == 1) {
                this.proc_submit_job.destroy();
                logger.debug((Object)"CSF Job Status:PDone, Job Completed");
                this.status.setMessage("Execution complete - check outputs to verify successful execution");
            } else {
                this.proc_submit_job.destroy();
                logger.debug((Object)"CSF Job Status:PExit, Job failed");
                this.status.setMessage("Execution failed - process exited with value -1");
            }
        } else {
            this.status.setCode(4);
            this.status.setMessage("Execution failed - process exited with value " + exitValue);
        }
        this.done = true;
        try {
            logger.debug((Object)"Waiting for all outputs to be written out");
            this.stdoutThread.join();
            this.stderrThread.join();
            logger.debug((Object)"All outputs successfully written out");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.status;
    }

    @Override
    public StatusOutputType destroyJob() throws JobManagerException {
        logger.info((Object)"called");
        if (this.proc == null) {
            String msg = "Can't destroy a process that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        this.proc.destroy();
        this.status.setCode(4);
        this.status.setMessage("Process destroyed on user request");
        return this.status;
    }

    private Thread writeStdOut(Process p, String outputDirName, String outputFileName) {
        File outputDir = new File(outputDirName);
        final InputStreamReader isr = new InputStreamReader(p.getInputStream());
        final String outfileName = outputDir.getAbsolutePath() + File.separator + outputFileName;
        Thread t_input = new Thread(){

            @Override
            public void run() {
                FileWriter fw;
                try {
                    fw = new FileWriter(outfileName);
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                int bytes = 0;
                char[] buf = new char[256];
                while (!CSFJobManager.this.done || bytes >= 0) {
                    try {
                        bytes = isr.read(buf);
                        if (bytes <= 0) continue;
                        fw.write(buf, 0, bytes);
                        fw.flush();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    fw.close();
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                logger.debug((Object)"Done writing standard output");
            }
        };
        t_input.start();
        return t_input;
    }

    private Thread writeStdErr(Process p, String outputDirName, String outputFileName) {
        File outputDir = new File(outputDirName);
        final InputStreamReader isr = new InputStreamReader(p.getErrorStream());
        final String errfileName = outputDir.getAbsolutePath() + File.separator + outputFileName;
        Thread t_error = new Thread(){

            @Override
            public void run() {
                FileWriter fw;
                try {
                    fw = new FileWriter(errfileName);
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                int bytes = 0;
                char[] buf = new char[256];
                while (!CSFJobManager.this.done || bytes >= 0) {
                    try {
                        bytes = isr.read(buf);
                        if (bytes <= 0) continue;
                        fw.write(buf, 0, bytes);
                        fw.flush();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    fw.close();
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe);
                    return;
                }
                logger.debug((Object)"Done writing standard error");
            }
        };
        t_error.start();
        return t_error;
    }
}

