/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class NameValue {
    protected String attribute;
    protected List values;

    public NameValue(String attribute) {
        this.setAttribute(attribute);
    }

    public void setAttribute(String attrib) {
        this.attribute = attrib;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public List getValues() {
        return this.values;
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public boolean remove(Object value) {
        if (this.values == null) {
            return false;
        }
        return this.values.remove(value);
    }

    public String toRSL(boolean explicitConcat) {
        StringBuffer buf = new StringBuffer();
        this.toRSL(buf, explicitConcat);
        return buf.toString();
    }

    public abstract void toRSL(StringBuffer var1, boolean var2);

    public Object getFirstValue() {
        if (this.values == null || this.values.size() == 0) {
            return null;
        }
        return this.values.get(0);
    }

    public boolean merge(NameValue nv) {
        if (!this.getAttribute().equalsIgnoreCase(nv.getAttribute())) {
            return false;
        }
        List nvValues = nv.getValues();
        if (nvValues == null) {
            return false;
        }
        if (this.values == null) {
            this.values = new LinkedList();
        }
        Iterator iter = nvValues.iterator();
        while (iter.hasNext()) {
            this.values.add(iter.next());
        }
        return true;
    }

    public String toString() {
        return this.toRSL(true);
    }
}

