/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.globus.gsi.bc.BouncyCastleUtil;

public class X509Extension {
    protected boolean critical;
    protected byte[] value;
    protected String oid;

    public X509Extension(String oid) {
        this(oid, false, null);
    }

    public X509Extension(String oid, byte[] value) {
        this(oid, false, value);
    }

    public X509Extension(String oid, boolean critical, byte[] value) {
        if (oid == null) {
            throw new IllegalArgumentException("oid == null");
        }
        this.oid = oid;
        this.critical = critical;
        this.value = value;
    }

    public void setOid(String oid) {
        if (oid == null) {
            throw new IllegalArgumentException("oid == null");
        }
        this.oid = oid;
    }

    public String getOid() {
        return this.oid;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public static byte[] getExtensionValue(X509Certificate cert, String oid) throws IOException {
        if (cert == null) {
            throw new IllegalArgumentException("cert == null");
        }
        if (oid == null) {
            throw new IllegalArgumentException("oid == null");
        }
        byte[] value = cert.getExtensionValue(oid);
        if (value == null) {
            return null;
        }
        return BouncyCastleUtil.getExtensionValue(value);
    }
}

