/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.util;

import edu.sdsc.nbcr.common.TypeDeserializer;
import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.state.HibernateUtil;
import edu.sdsc.nbcr.opal.state.ServiceStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public class Deploy {
    private static Logger logger = Logger.getLogger((String)Deploy.class.getName());

    public static void main(String[] args) throws Exception {
        String finalVersion;
        String wsddFinal;
        String appConfig = System.getProperty("appConfig");
        if (appConfig == null) {
            logger.info((Object)"System property appConfig not set!");
            System.exit(1);
        } else {
            logger.info((Object)("Property appConfig set to: " + appConfig));
        }
        String serviceName = System.getProperty("serviceName");
        if (serviceName == null) {
            logger.error((Object)"System property serviceName not set!");
            System.exit(1);
        } else {
            logger.info((Object)("Property serviceName set to: " + serviceName));
        }
        String userVersion = System.getProperty("appVersion");
        if (userVersion.equals("")) {
            userVersion = null;
        }
        if (userVersion == null) {
            logger.info((Object)"Version number not supplied by user");
        } else {
            logger.info((Object)("Property appVersion set to: " + userVersion));
        }
        String wsddTemplate = System.getProperty("wsddTemplate");
        if (wsddTemplate == null) {
            logger.error((Object)"System property wsddTemplate not set!");
            System.exit(1);
        } else {
            logger.info((Object)("Property wsddTemplate set to: " + wsddTemplate));
        }
        File f = new File(wsddTemplate);
        if (!f.exists()) {
            logger.error((Object)("WSDD template file " + wsddTemplate + " does not exist"));
            System.exit(1);
        }
        if ((wsddFinal = System.getProperty("wsddFinal")) == null) {
            logger.error((Object)"System property wsddFinal not set!");
            System.exit(1);
        } else {
            logger.info((Object)("Property wsddFinal set to: " + wsddFinal));
        }
        File configFile = new File(appConfig);
        if (!configFile.exists()) {
            logger.error((Object)("Application configuration file " + appConfig + " does not exist"));
        }
        AppConfigType config = null;
        try {
            config = (AppConfigType)TypeDeserializer.getValue(appConfig, new AppConfigType());
        }
        catch (Exception e) {
            logger.error((Object)e);
            String msg = "Can't read application configuration from: " + appConfig;
            logger.error((Object)msg);
            System.exit(1);
        }
        String configVersion = null;
        if (config.getMetadata() != null) {
            configVersion = config.getMetadata().getVersion();
        }
        if (configVersion != null && userVersion != null && !configVersion.equals(userVersion)) {
            logger.error((Object)"Version number supplied by user doesn't match with version number in appConfig file");
            System.exit(1);
        }
        if ((finalVersion = userVersion) == null) {
            finalVersion = configVersion;
        }
        if (finalVersion != null) {
            serviceName = serviceName + "_" + finalVersion;
        }
        logger.info((Object)("Service name used for deployment: " + serviceName));
        byte[] data = new byte[(int)f.length()];
        FileInputStream fIn = new FileInputStream(f);
        fIn.read(data);
        fIn.close();
        String templateData = new String(data);
        String finalData = templateData.replaceAll("@SERVICE_NAME@", serviceName);
        String configLoc = configFile.getAbsolutePath().replace('\\', '/');
        finalData = finalData.replaceAll("@CONFIG_LOCATION@", configLoc);
        logger.info((Object)("Using location of config file: " + configLoc));
        FileOutputStream fOut = new FileOutputStream(wsddFinal);
        fOut.write(finalData.getBytes());
        fOut.close();
        logger.info((Object)"Updating service status in database to ACTIVE");
        ServiceStatus serviceStatus = new ServiceStatus();
        serviceStatus.setServiceName(serviceName);
        serviceStatus.setStatus("ACTIVE");
        HibernateUtil.saveServiceStatus(serviceStatus);
    }
}

