/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.dashboard.servlet;

import edu.sdsc.nbcr.opal.dashboard.persistence.DBManager;
import edu.sdsc.nbcr.opal.dashboard.util.DateHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.PatternSyntaxException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class PlotterServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog((String)PlotterServlet.class.getName());
    private DBManager dbManager = null;
    private boolean initialized = false;
    Color defaultBGColor = new Color(255, 255, 255);
    private static final String exectime = "exectime";
    private static final String hits = "hits";
    private static final String error = "error";
    private static final String runningjobs = "runningjobs";

    public final String getServletInfo() {
        return "generates a graph image of gama usage based on input parameters";
    }

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.dbManager = (DBManager)config.getServletContext().getAttribute("dbManager");
        this.initialized = this.dbManager != null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XYLineAndShapeRenderer renderer;
        XYPlot plot;
        Color bg = this.calculateColor(request.getParameter("bgcolor"));
        int width = 300;
        int height = 200;
        Date startDate = null;
        Date endDate = null;
        String type = hits;
        String[] servicesName = null;
        if (!this.initialized) {
            this.doError("No connection to the database", request, response);
            return;
        }
        try {
            width = Integer.parseInt(request.getParameter("width"));
            height = Integer.parseInt(request.getParameter("height"));
        }
        catch (Exception ex) {
            this.doError("Error parsing width and height parameters: " + ex.getMessage(), request, response);
            return;
        }
        String tmp = request.getParameter("type");
        if (!(tmp.equals(hits) || tmp.equals(exectime) || tmp.equals(error) || tmp.equals(runningjobs))) {
            this.doError("Error parsing type parameter not an accepted type", request, response);
            return;
        }
        type = tmp;
        servicesName = request.getParameterValues("servicesName");
        if (servicesName == null) {
            servicesName = this.dbManager.getServicesList();
        }
        String startDateStr = request.getParameter("startDate");
        String endDateStr = request.getParameter("endDate");
        if (startDateStr != null) {
            try {
                startDate = DateHelper.parseDate(startDateStr);
            }
            catch (ParseException ex) {
                this.doError("Error parsing the start date: " + ex.getMessage(), request, response);
                return;
            }
        }
        if (endDateStr != null) {
            try {
                endDate = DateHelper.parseDate(endDateStr);
            }
            catch (ParseException ex) {
                this.doError("Error parsing the end date: " + ex.getMessage(), request, response);
                return;
            }
        }
        if (startDate == null || endDate == null) {
            log.debug((Object)"No start and end date provided.");
            endDate = DateHelper.getEndDate();
            startDate = DateHelper.getStartDate();
        }
        log.debug((Object)("Going to generate a chart (" + type + ") " + width + "x" + height + " with beginning date " + startDate + " and end date " + endDate));
        String xAxisTitle = "";
        String yAxisTitle = "";
        String title = "";
        TimeSeriesCollection dataset = null;
        DefaultCategoryDataset barDataset = null;
        if (type.equals(runningjobs)) {
            barDataset = new DefaultCategoryDataset();
            for (int i = 0; i < servicesName.length; ++i) {
                int running = this.dbManager.getRunningJobs(servicesName[i]);
                if (running == -1) {
                    this.doError("impossible to retrive the data from the Data Base", request, response);
                }
                if (running == 0) continue;
                barDataset.addValue((double)running, (Comparable)((Object)servicesName[i]), (Comparable)((Object)servicesName[i]));
            }
        } else {
            dataset = new TimeSeriesCollection();
            TimeSeries series = null;
            double[] temp = null;
            for (int i = 0; i < servicesName.length; ++i) {
                temp = this.dbManager.getResultsTimeseries(startDate, endDate, servicesName[i], type);
                if (temp != null) {
                    series = new TimeSeries((Comparable)((Object)servicesName[i]), Day.class);
                    Date iterator = (Date)startDate.clone();
                    for (int k = 0; k < temp.length; ++k) {
                        series.add((RegularTimePeriod)new Day(iterator), temp[k]);
                        iterator = DateHelper.addDays(iterator, 1);
                    }
                } else if (temp == null) {
                    log.error((Object)("The query to the data base for service: " + servicesName[i] + " returned a null set of values"));
                } else {
                    log.error((Object)("The data returned from the DB for the service: " + servicesName[i] + " was invalid."));
                }
                dataset.addSeries(series);
            }
        }
        xAxisTitle = "Date";
        if (type.equals(hits)) {
            yAxisTitle = "Numbers of hits";
            title = "Jobs executed per day";
        } else if (type.equals(exectime)) {
            yAxisTitle = "Execution time in seconds";
            title = "Daily average execution time for a job submission";
        } else if (type.equals(error)) {
            yAxisTitle = "Number of errors";
            title = "Number of failed executions per day";
        } else if (type.equals(runningjobs)) {
            yAxisTitle = "Number of jobs";
            title = "Number of jobs currently in execution";
            xAxisTitle = "Service name";
        }
        JFreeChart chart = null;
        if (type.equals(runningjobs)) {
            chart = ChartFactory.createBarChart3D((String)title, (String)xAxisTitle, (String)yAxisTitle, (CategoryDataset)barDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
            chart.getLegend().setMargin(0.0, 0.0, 10.0, 0.0);
            chart.getLegend().setPosition(RectangleEdge.BOTTOM);
            plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setOutlineVisible(false);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            renderer = (BarRenderer3D)plot.getRenderer();
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{1}", NumberFormat.getInstance()));
            renderer.setDrawBarOutline(false);
            renderer.setBaseItemLabelsVisible(true);
            renderer.setMaximumBarWidth(0.2);
            renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -0.39269908169872414));
            renderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -0.39269908169872414));
            CategoryAxis axis = plot.getDomainAxis();
            axis.setTickLabelsVisible(false);
        } else {
            chart = ChartFactory.createTimeSeriesChart((String)title, (String)xAxisTitle, (String)yAxisTitle, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
            plot = chart.getXYPlot();
            DateAxis axis = (DateAxis)plot.getDomainAxis();
            axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("MMM-dd-yyyy", Locale.US));
            renderer = (XYLineAndShapeRenderer)plot.getRenderer();
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            BasicStroke stroke = new BasicStroke(3.0f);
            renderer.setBaseStroke((Stroke)stroke);
        }
        BufferedImage bufferedImage = chart.createBufferedImage(width, height);
        if (bufferedImage == null) {
            log.error((Object)"The buffered immage is null maybe you are headless!!");
            log.error((Object)("your head is " + GraphicsEnvironment.isHeadless()));
        }
        byte[] imageByte = EncoderUtil.encode((BufferedImage)bufferedImage, (String)"jpeg");
        response.setContentType("image/jpeg");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(imageByte);
        outputStream.flush();
    }

    private void doError(String errorMsg, HttpServletRequest req, HttpServletResponse res) {
        log.error((Object)("We had an error: " + errorMsg));
        req.setAttribute(error, (Object)errorMsg);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/dashboard-jsp/error.jsp");
        try {
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            log.error((Object)"Impossible to forward to the error page...Don't know what else I can do....", (Throwable)e);
        }
    }

    private Color calculateColor(String bgcolor) {
        boolean valid = false;
        try {
            if (bgcolor != null && bgcolor.matches("#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]")) {
                log.debug((Object)"color valid");
                valid = true;
            }
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
        if (!valid) {
            return this.defaultBGColor;
        }
        String tmp = bgcolor.substring(1, 3);
        log.debug((Object)("tmp = " + tmp));
        int red = Integer.valueOf(tmp, 16);
        log.debug((Object)("int = " + red));
        tmp = bgcolor.substring(3, 5);
        log.debug((Object)("tmp = " + tmp));
        int green = Integer.valueOf(tmp, 16);
        log.debug((Object)("int = " + green));
        tmp = bgcolor.substring(5, 7);
        log.debug((Object)("tmp = " + tmp));
        int blue = Integer.valueOf(tmp, 16);
        log.debug((Object)("int = " + blue));
        return new Color(red, green, blue);
    }

    private XYDataset createDataset() {
        TimeSeries s1 = new TimeSeries((Comparable)((Object)"L&G European Index Trust"), Month.class);
        s1.add((RegularTimePeriod)new Month(2, 2001), 181.8);
        s1.add((RegularTimePeriod)new Month(3, 2001), 167.3);
        s1.add((RegularTimePeriod)new Month(4, 2001), 153.8);
        s1.add((RegularTimePeriod)new Month(5, 2001), 167.6);
        s1.add((RegularTimePeriod)new Month(6, 2001), 158.8);
        s1.add((RegularTimePeriod)new Month(7, 2001), 148.3);
        s1.add((RegularTimePeriod)new Month(8, 2001), 153.9);
        s1.add((RegularTimePeriod)new Month(9, 2001), 142.7);
        s1.add((RegularTimePeriod)new Month(10, 2001), 123.2);
        s1.add((RegularTimePeriod)new Month(11, 2001), 131.8);
        s1.add((RegularTimePeriod)new Month(12, 2001), 139.6);
        s1.add((RegularTimePeriod)new Month(1, 2002), 142.9);
        s1.add((RegularTimePeriod)new Month(2, 2002), 138.7);
        s1.add((RegularTimePeriod)new Month(3, 2002), 137.3);
        s1.add((RegularTimePeriod)new Month(4, 2002), 143.9);
        s1.add((RegularTimePeriod)new Month(5, 2002), 139.8);
        s1.add((RegularTimePeriod)new Month(6, 2002), 137.0);
        s1.add((RegularTimePeriod)new Month(7, 2002), 132.8);
        TimeSeries s2 = new TimeSeries((Comparable)((Object)"L&G UK Index Trust"), Month.class);
        s2.add((RegularTimePeriod)new Month(2, 2001), 129.6);
        s2.add((RegularTimePeriod)new Month(3, 2001), 123.2);
        s2.add((RegularTimePeriod)new Month(4, 2001), 117.2);
        s2.add((RegularTimePeriod)new Month(5, 2001), 124.1);
        s2.add((RegularTimePeriod)new Month(6, 2001), 122.6);
        s2.add((RegularTimePeriod)new Month(7, 2001), 119.2);
        s2.add((RegularTimePeriod)new Month(8, 2001), 116.5);
        s2.add((RegularTimePeriod)new Month(9, 2001), 112.7);
        s2.add((RegularTimePeriod)new Month(10, 2001), 101.5);
        s2.add((RegularTimePeriod)new Month(11, 2001), 106.1);
        s2.add((RegularTimePeriod)new Month(12, 2001), 110.3);
        s2.add((RegularTimePeriod)new Month(1, 2002), 111.7);
        s2.add((RegularTimePeriod)new Month(2, 2002), 111.0);
        s2.add((RegularTimePeriod)new Month(3, 2002), 109.6);
        s2.add((RegularTimePeriod)new Month(4, 2002), 113.2);
        s2.add((RegularTimePeriod)new Month(5, 2002), 111.6);
        s2.add((RegularTimePeriod)new Month(6, 2002), 108.8);
        s2.add((RegularTimePeriod)new Month(7, 2002), 101.6);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }
}

