/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.condorAPI;

import edu.sdsc.nbcr.opal.manager.condorAPI.Cluster;
import edu.sdsc.nbcr.opal.manager.condorAPI.Condor;
import edu.sdsc.nbcr.opal.manager.condorAPI.CondorException;
import edu.sdsc.nbcr.opal.manager.condorAPI.Handler;
import edu.sdsc.nbcr.opal.manager.condorAPI.HandlerSet;
import edu.sdsc.nbcr.opal.manager.condorAPI.Pair;
import edu.sdsc.nbcr.opal.manager.condorAPI.Queue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobDescription {
    List attributes = new ArrayList();
    HandlerSet handlers = new HandlerSet();
    String filename;
    boolean fileGiven = false;

    public JobDescription() {
    }

    public JobDescription(String filename) throws CondorException {
        if (!new File(filename).exists()) {
            throw new CondorException("File " + filename + " does not exist");
        }
        this.filename = filename;
        this.fileGiven = true;
    }

    public void addAttribute(String name, String val) throws CondorException {
        if (this.fileGiven) {
            throw new CondorException("The submit file is given");
        }
        this.attributes.add(new Pair(name, val));
    }

    public void addQueue(int val) throws CondorException {
        if (this.fileGiven) {
            throw new CondorException("The submit file is given");
        }
        this.attributes.add(new Queue(val));
    }

    public void addQueue() throws CondorException {
        if (this.fileGiven) {
            throw new CondorException("The submit file is given");
        }
        this.attributes.add(new Queue(1));
    }

    public void setHandlerOnFailure(Handler handler) {
        this.handlers.setHandlerOnFailure(handler);
    }

    public void setHandlerOnSuccess(Handler handler) {
        this.handlers.setHandlerOnSuccess(handler);
    }

    public void setHandler(int eventType, Handler handler) {
        this.handlers.setHandler(eventType, handler);
    }

    byte[] getByteArray() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(bs));
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            pw.println(iterator.next());
        }
        pw.close();
        return bs.toByteArray();
    }

    Cluster submit(Condor condor) throws CondorException {
        String tmpFilename = null;
        try {
            InputStream is = !this.fileGiven ? new ByteArrayInputStream(this.getByteArray()) : new FileInputStream(this.filename);
            tmpFilename = this.createTmpSubmit(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CondorException(e.toString());
        }
        Cluster cluster = condor.submitFile(tmpFilename);
        condor.startLogMonitor();
        cluster.setHandlerSet(this.handlers);
        return cluster;
    }

    private String createTmpSubmit(InputStream is) throws IOException {
        String tmp;
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
        File tmpFile = File.createTempFile("/condor", ".submit");
        PrintWriter pw = new PrintWriter(new FileWriter(tmpFile));
        String patternString = "^(\\S+)\\s*=\\s*(\\S+)$";
        Pattern pattern = Pattern.compile(patternString);
        while ((tmp = lnr.readLine()) != null) {
            Matcher matcher = pattern.matcher(tmp);
            if (!matcher.matches()) {
                pw.println(tmp);
                continue;
            }
            String key = matcher.group(1);
            pw.println(tmp);
        }
        pw.close();
        return tmpFile.getAbsolutePath();
    }
}

