/* Generated by re2c 0.13.5 on Mon Apr 15 20:58:05 2013 */
#line 1 "sjson.c"
/** 
 * sjson - fast string based JSON parser/generator
 *
 * Written by Ondrej Jirman <megous@megous.com>, 2013
 * WWW: https://github.com/megous/sjson
 */

#include <string.h>
#include <stdio.h>
#include "sjson.h"

enum
{
  TOK_NONE = 0, // no more tokens
  TOK_OBJ_START,
  TOK_OBJ_END,
  TOK_ARRAY_START,
  TOK_ARRAY_END,
  TOK_COLON,
  TOK_COMMA,
  TOK_STRING,
  TOK_NUMBER,
  TOK_FALSE,
  TOK_TRUE,
  TOK_NULL,
  TOK_INVALID
};

#line 49 "sjson.c"


static gint s_json_get_token(const gchar* json, const gchar** start, const gchar** end)
{
  g_return_val_if_fail(json != NULL, FALSE);

  const guchar* c = (const guchar*)json;
  const guchar* m = NULL;
  const guchar* s;
  gint token;

  while (TRUE)
  {
    s = c;


#line 49 "sjson.gen.c"
	{
		guchar yych;
		unsigned int yyaccept = 0;

		yych = (guchar)*c;
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy25;
					if (yych <= 0x08) goto yy27;
				} else {
					if (yych == '\r') goto yy2;
					if (yych <= 0x1F) goto yy27;
				}
			} else {
				if (yych <= ',') {
					if (yych == '"') goto yy12;
					if (yych <= '+') goto yy27;
					goto yy16;
				} else {
					if (yych <= '-') goto yy18;
					if (yych <= '/') goto yy27;
					if (yych <= '0') goto yy19;
					goto yy21;
				}
			}
		} else {
			if (yych <= 'm') {
				if (yych <= '\\') {
					if (yych <= ':') goto yy14;
					if (yych == '[') goto yy8;
					goto yy27;
				} else {
					if (yych <= ']') goto yy10;
					if (yych == 'f') goto yy23;
					goto yy27;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'n') goto yy24;
					if (yych == 't') goto yy22;
					goto yy27;
				} else {
					if (yych <= '{') goto yy4;
					if (yych == '}') goto yy6;
					goto yy27;
				}
			}
		}
yy2:
		++c;
		yych = (guchar)*c;
		goto yy62;
yy3:
#line 65 "sjson.c"
		{ 
      continue; 
    }
#line 108 "sjson.gen.c"
yy4:
		++c;
#line 69 "sjson.c"
		{
      token = TOK_OBJ_START;
      goto done;
    }
#line 116 "sjson.gen.c"
yy6:
		++c;
#line 74 "sjson.c"
		{
      token = TOK_OBJ_END;
      goto done;
    }
#line 124 "sjson.gen.c"
yy8:
		++c;
#line 79 "sjson.c"
		{
      token = TOK_ARRAY_START;
      goto done;
    }
#line 132 "sjson.gen.c"
yy10:
		++c;
#line 84 "sjson.c"
		{
      token = TOK_ARRAY_END;
      goto done;
    }
#line 140 "sjson.gen.c"
yy12:
		yyaccept = 0;
		yych = (guchar)*(m = ++c);
		goto yy53;
yy13:
#line 128 "sjson.c"
		{
      return TOK_INVALID;
    }
#line 150 "sjson.gen.c"
yy14:
		++c;
#line 94 "sjson.c"
		{
      token = TOK_COLON;
      goto done;
    }
#line 158 "sjson.gen.c"
yy16:
		++c;
#line 99 "sjson.c"
		{
      token = TOK_COMMA;
      goto done;
    }
#line 166 "sjson.gen.c"
yy18:
		yych = (guchar)*++c;
		if (yych <= '/') goto yy13;
		if (yych <= '0') goto yy51;
		if (yych <= '9') goto yy42;
		goto yy13;
yy19:
		yyaccept = 1;
		yych = (guchar)*(m = ++c);
		if (yych <= 'D') {
			if (yych == '.') goto yy44;
		} else {
			if (yych <= 'E') goto yy45;
			if (yych == 'e') goto yy45;
		}
yy20:
#line 104 "sjson.c"
		{
      token = TOK_NUMBER;
      goto done;
    }
#line 188 "sjson.gen.c"
yy21:
		yyaccept = 1;
		yych = (guchar)*(m = ++c);
		goto yy43;
yy22:
		yyaccept = 0;
		yych = (guchar)*(m = ++c);
		if (yych == 'r') goto yy38;
		goto yy13;
yy23:
		yyaccept = 0;
		yych = (guchar)*(m = ++c);
		if (yych == 'a') goto yy33;
		goto yy13;
yy24:
		yyaccept = 0;
		yych = (guchar)*(m = ++c);
		if (yych == 'u') goto yy28;
		goto yy13;
yy25:
		++c;
#line 124 "sjson.c"
		{ 
      return TOK_NONE;
    }
#line 214 "sjson.gen.c"
yy27:
		yych = (guchar)*++c;
		goto yy13;
yy28:
		yych = (guchar)*++c;
		if (yych == 'l') goto yy30;
yy29:
		c = m;
		if (yyaccept <= 0) {
			goto yy13;
		} else {
			goto yy20;
		}
yy30:
		yych = (guchar)*++c;
		if (yych != 'l') goto yy29;
		++c;
#line 119 "sjson.c"
		{
      token = TOK_NULL;
      goto done;
    }
#line 237 "sjson.gen.c"
yy33:
		yych = (guchar)*++c;
		if (yych != 'l') goto yy29;
		yych = (guchar)*++c;
		if (yych != 's') goto yy29;
		yych = (guchar)*++c;
		if (yych != 'e') goto yy29;
		++c;
#line 114 "sjson.c"
		{
      token = TOK_FALSE;
      goto done;
    }
#line 251 "sjson.gen.c"
yy38:
		yych = (guchar)*++c;
		if (yych != 'u') goto yy29;
		yych = (guchar)*++c;
		if (yych != 'e') goto yy29;
		++c;
#line 109 "sjson.c"
		{
      token = TOK_TRUE;
      goto done;
    }
#line 263 "sjson.gen.c"
yy42:
		yyaccept = 1;
		m = ++c;
		yych = (guchar)*c;
yy43:
		if (yych <= '9') {
			if (yych == '.') goto yy44;
			if (yych <= '/') goto yy20;
			goto yy42;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy20;
				goto yy45;
			} else {
				if (yych == 'e') goto yy45;
				goto yy20;
			}
		}
yy44:
		yych = (guchar)*++c;
		if (yych <= '/') goto yy29;
		if (yych <= '9') goto yy49;
		goto yy29;
yy45:
		yych = (guchar)*++c;
		if (yych <= ',') {
			if (yych != '+') goto yy29;
		} else {
			if (yych <= '-') goto yy46;
			if (yych <= '/') goto yy29;
			if (yych <= '9') goto yy47;
			goto yy29;
		}
yy46:
		yych = (guchar)*++c;
		if (yych <= '/') goto yy29;
		if (yych >= ':') goto yy29;
yy47:
		++c;
		yych = (guchar)*c;
		if (yych <= '/') goto yy20;
		if (yych <= '9') goto yy47;
		goto yy20;
yy49:
		yyaccept = 1;
		m = ++c;
		yych = (guchar)*c;
		if (yych <= 'D') {
			if (yych <= '/') goto yy20;
			if (yych <= '9') goto yy49;
			goto yy20;
		} else {
			if (yych <= 'E') goto yy45;
			if (yych == 'e') goto yy45;
			goto yy20;
		}
yy51:
		yyaccept = 1;
		yych = (guchar)*(m = ++c);
		if (yych <= 'D') {
			if (yych == '.') goto yy44;
			goto yy20;
		} else {
			if (yych <= 'E') goto yy45;
			if (yych == 'e') goto yy45;
			goto yy20;
		}
yy52:
		++c;
		yych = (guchar)*c;
yy53:
		if (yych == '"') goto yy55;
		if (yych != '\\') goto yy52;
		++c;
		yych = (guchar)*c;
		if (yych <= 'e') {
			if (yych <= '/') {
				if (yych == '"') goto yy52;
				if (yych <= '.') goto yy29;
				goto yy52;
			} else {
				if (yych <= '\\') {
					if (yych <= '[') goto yy29;
					goto yy52;
				} else {
					if (yych == 'b') goto yy52;
					goto yy29;
				}
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy52;
				if (yych == 'n') goto yy52;
				goto yy29;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy52;
					goto yy29;
				} else {
					if (yych <= 't') goto yy52;
					if (yych <= 'u') goto yy57;
					goto yy29;
				}
			}
		}
yy55:
		++c;
#line 89 "sjson.c"
		{
      token = TOK_STRING;
      goto done;
    }
#line 376 "sjson.gen.c"
yy57:
		++c;
		yych = (guchar)*c;
		if (yych <= '@') {
			if (yych <= '/') goto yy29;
			if (yych >= ':') goto yy29;
		} else {
			if (yych <= 'F') goto yy58;
			if (yych <= '`') goto yy29;
			if (yych >= 'g') goto yy29;
		}
yy58:
		++c;
		yych = (guchar)*c;
		if (yych <= '@') {
			if (yych <= '/') goto yy29;
			if (yych >= ':') goto yy29;
		} else {
			if (yych <= 'F') goto yy59;
			if (yych <= '`') goto yy29;
			if (yych >= 'g') goto yy29;
		}
yy59:
		++c;
		yych = (guchar)*c;
		if (yych <= '@') {
			if (yych <= '/') goto yy29;
			if (yych >= ':') goto yy29;
		} else {
			if (yych <= 'F') goto yy60;
			if (yych <= '`') goto yy29;
			if (yych >= 'g') goto yy29;
		}
yy60:
		++c;
		yych = (guchar)*c;
		if (yych <= '@') {
			if (yych <= '/') goto yy29;
			if (yych <= '9') goto yy52;
			goto yy29;
		} else {
			if (yych <= 'F') goto yy52;
			if (yych <= '`') goto yy29;
			if (yych <= 'f') goto yy52;
			goto yy29;
		}
yy61:
		++c;
		yych = (guchar)*c;
yy62:
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy3;
			if (yych <= '\n') goto yy61;
			goto yy3;
		} else {
			if (yych <= '\r') goto yy61;
			if (yych == ' ') goto yy61;
			goto yy3;
		}
	}
#line 131 "sjson.c"

  }

done:
  if (start)
    *start = s;
  if (end)
    *end = c;
  return token;
}

SJsonType token_to_type(gint token)
{
  switch (token)
  {
    case TOK_NONE        : return S_JSON_TYPE_NONE;
    case TOK_OBJ_START   : return S_JSON_TYPE_OBJECT;
    case TOK_ARRAY_START : return S_JSON_TYPE_ARRAY;
    case TOK_STRING      : return S_JSON_TYPE_STRING;
    case TOK_NUMBER      : return S_JSON_TYPE_NUMBER;
    case TOK_FALSE       : return S_JSON_TYPE_BOOL;
    case TOK_TRUE        : return S_JSON_TYPE_BOOL;
    case TOK_NULL        : return S_JSON_TYPE_NULL;
    default              : return S_JSON_TYPE_INVALID;
  }
}

// public api

static gboolean s_json_is_valid_inner(const gchar* json, const gchar** end)
{
  const gchar* next;
  gint token;

  g_return_val_if_fail(json != NULL, FALSE);
  
  token = s_json_get_token(json, NULL, &next);
  if (token == TOK_ARRAY_START)
  {
    const gchar* array_elem = next;
    const gchar* array_next = NULL;
    gboolean expect_comma = FALSE;

    while (TRUE)
    {
      // check end of array
      token = s_json_get_token(array_elem, NULL, &array_next);
      if (token == TOK_ARRAY_END)
      {
        if (end)
          *end = array_next;
        return TRUE;
      }

      if (expect_comma)
      {
        if (token == TOK_COMMA)
          array_elem = array_next; // skip comma
        else
          return FALSE;
      }

      // check element
      if (!s_json_is_valid_inner(array_elem, &array_elem))
        return FALSE;

      expect_comma = TRUE;
    }
  }
  else if (token == TOK_OBJ_START)
  {
    const gchar* obj_next = next;
    gboolean expect_comma = FALSE;

    while (TRUE)
    {
      // check end of object
      token = s_json_get_token(obj_next, NULL, &obj_next);
      if (token == TOK_OBJ_END)
      {
        if (end)
          *end = obj_next;

        return TRUE;
      }

      // eat comma
      if (expect_comma)
      {
        if (token != TOK_COMMA)
          return FALSE;

        token = s_json_get_token(obj_next, NULL, &obj_next);
      }

      // check member name and colon
      if (token != TOK_STRING)
        return FALSE;

      token = s_json_get_token(obj_next, NULL, &obj_next);
      if (token != TOK_COLON)
        return FALSE;

      // check member value
      if (!s_json_is_valid_inner(obj_next, &obj_next))
        return FALSE;

      expect_comma = TRUE;
    }
  }
  else if (token == TOK_STRING || token == TOK_NUMBER || token == TOK_FALSE || token == TOK_TRUE || token == TOK_NULL)
  {
    if (end)
      *end = next;
    return TRUE;
  }

  return FALSE;
}

gboolean s_json_is_valid(const gchar* json)
{
  const gchar* next;

  g_return_val_if_fail(json != NULL, FALSE);
  
  return s_json_is_valid_inner(json, &next) && s_json_get_token(next, NULL, NULL) == TOK_NONE;
}

gchar* s_json_get(const gchar* json)
{
  const gchar* next;
  const gchar* start = NULL;

  g_return_val_if_fail(json != NULL, NULL);
  
  if (s_json_is_valid_inner(json, &next))
  {
    s_json_get_token(json, &start, NULL);
    if (!start)
      return NULL;

    return g_strndup(start, next - start);
  }

  return NULL;
}

SJsonType s_json_get_type(const gchar* json)
{
  g_return_val_if_fail(json != NULL, S_JSON_TYPE_INVALID);

  return token_to_type(s_json_get_token(json, NULL, NULL));
}

const gchar* s_json_get_element(const gchar* json, guint index)
{
  const gchar* elem;
  const gchar* next_elem;
  gint token;

  g_return_val_if_fail(json != NULL, NULL);

  token = s_json_get_token(json, NULL, &next_elem);
  if (token != TOK_ARRAY_START)
    return NULL;

  while (TRUE)
  {
    elem = next_elem;
    if (!s_json_is_valid_inner(elem, &next_elem))
      return NULL;

    if (index-- == 0)
      return elem;

    token = s_json_get_token(next_elem, NULL, &next_elem);
    if (token != TOK_COMMA)
      return NULL;
  }
}

gchar** s_json_get_elements(const gchar* json)
{
  const gchar* elem;
  const gchar* next_elem;
  gint token;
  GPtrArray* arr;

  g_return_val_if_fail(json != NULL, NULL);

  token = s_json_get_token(json, NULL, &next_elem);
  if (token != TOK_ARRAY_START)
    return NULL;

  arr = g_ptr_array_sized_new(64);

  if (s_json_get_token(next_elem, NULL, NULL) == TOK_ARRAY_END)
  {
    g_ptr_array_add(arr, NULL);
    return (gchar**)g_ptr_array_free(arr, FALSE);
  }

  while (TRUE)
  {
    elem = next_elem;
    if (!s_json_is_valid_inner(elem, &next_elem))
    {
      g_ptr_array_free(arr, TRUE);
      return NULL;
    }

    g_ptr_array_add(arr, (gchar*)elem);

    token = s_json_get_token(next_elem, NULL, &next_elem);
    if (token != TOK_COMMA)
    {
      if (token == TOK_ARRAY_END)
      {
        g_ptr_array_add(arr, NULL);
        return (gchar**)g_ptr_array_free(arr, FALSE);
      }
      
      g_ptr_array_free(arr, TRUE);
      return NULL;
    }
  }
}

const gchar* s_json_get_member(const gchar* json, const gchar* name)
{
  const gchar* member;
  const gchar* next_member;
  gint token;

  g_return_val_if_fail(json != NULL, NULL);
  g_return_val_if_fail(name != NULL, NULL);

  token = s_json_get_token(json, NULL, &next_member);
  if (token != TOK_OBJ_START)
    return NULL;

  while (TRUE)
  {
    member = next_member;

    token = s_json_get_token(member, NULL, &next_member);
    if (token != TOK_STRING)
      return NULL;

    token = s_json_get_token(next_member, NULL, &next_member);
    if (token != TOK_COLON)
      return NULL;

    gchar* member_name = s_json_get_string(member);
    if (!member_name)
      return NULL;

    // match member name
    if (!strcmp(member_name, name))
    {
      g_free(member_name);
      return next_member;
    }

    g_free(member_name);

    if (!s_json_is_valid_inner(next_member, &next_member))
      return NULL;

    token = s_json_get_token(next_member, NULL, &next_member);
    if (token != TOK_COMMA)
      return NULL;
  }

  return NULL;
}

gchar* s_json_get_string(const gchar* json)
{
  const gchar* start;
  const gchar* end;
  gint token;

  g_return_val_if_fail(json != NULL, NULL);

  token = s_json_get_token(json, &start, &end);
  if (token != TOK_STRING)
    return NULL;

  GString* str = g_string_sized_new(end - start);
  const guchar* c = (const guchar*)start + 1;
  const guchar* m = NULL;
  const guchar* s;

  while (TRUE)
  {
    s = c;


#line 738 "sjson.gen.c"
	{
		guchar yych;
		yych = (guchar)*c;
		if (yych <= '!') {
			if (yych <= 0x00) goto yy65;
			if (yych == '\n') goto yy68;
			goto yy67;
		} else {
			if (yych <= '"') goto yy72;
			if (yych == '\\') goto yy70;
			goto yy67;
		}
yy65:
		++c;
		yych = (guchar)*c;
		goto yy69;
yy66:
#line 431 "sjson.c"
		{
      g_string_append_len(str, s, c - s);
      continue;
    }
#line 761 "sjson.gen.c"
yy67:
		yych = (guchar)*++c;
		goto yy69;
yy68:
		++c;
		yych = (guchar)*c;
yy69:
		if (yych == '"') goto yy66;
		if (yych == '\\') goto yy66;
		goto yy68;
yy70:
		yych = (guchar)*(m = ++c);
		if (yych <= 'e') {
			if (yych <= '/') {
				if (yych == '"') goto yy76;
				if (yych >= '/') goto yy76;
			} else {
				if (yych <= '\\') {
					if (yych >= '\\') goto yy76;
				} else {
					if (yych == 'b') goto yy76;
				}
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy76;
				if (yych == 'n') goto yy76;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy76;
				} else {
					if (yych <= 't') goto yy76;
					if (yych <= 'u') goto yy74;
				}
			}
		}
yy71:
#line 469 "sjson.c"
		{
      g_assert_not_reached();
    }
#line 803 "sjson.gen.c"
yy72:
		++c;
#line 460 "sjson.c"
		{
      return g_string_free(str, FALSE);
    }
#line 810 "sjson.gen.c"
yy74:
		yych = (guchar)*++c;
		if (yych <= '@') {
			if (yych <= '/') goto yy75;
			if (yych <= '9') goto yy78;
		} else {
			if (yych <= 'F') goto yy78;
			if (yych <= '`') goto yy75;
			if (yych <= 'f') goto yy78;
		}
yy75:
		c = m;
		goto yy71;
yy76:
		++c;
#line 436 "sjson.c"
		{
      gchar ch = (gchar)s[1];

      if (ch == 'b')
        g_string_append_c(str, '\b');
      else if (ch == 'n')
        g_string_append_c(str, '\n');
      else if (ch == 'r')
        g_string_append_c(str, '\r');
      else if (ch == 't')
        g_string_append_c(str, '\t');
      else
        g_string_append_c(str, ch);

      continue;
    }
#line 843 "sjson.gen.c"
yy78:
		yych = (guchar)*++c;
		if (yych <= '@') {
			if (yych <= '/') goto yy75;
			if (yych >= ':') goto yy75;
		} else {
			if (yych <= 'F') goto yy79;
			if (yych <= '`') goto yy75;
			if (yych >= 'g') goto yy75;
		}
yy79:
		yych = (guchar)*++c;
		if (yych <= '@') {
			if (yych <= '/') goto yy75;
			if (yych >= ':') goto yy75;
		} else {
			if (yych <= 'F') goto yy80;
			if (yych <= '`') goto yy75;
			if (yych >= 'g') goto yy75;
		}
yy80:
		yych = (guchar)*++c;
		if (yych <= '@') {
			if (yych <= '/') goto yy75;
			if (yych >= ':') goto yy75;
		} else {
			if (yych <= 'F') goto yy81;
			if (yych <= '`') goto yy75;
			if (yych >= 'g') goto yy75;
		}
yy81:
		++c;
#line 453 "sjson.c"
		{
      guint32 ch = 0;
      sscanf(s + 2, "%4x", &ch);
      g_string_append_unichar(str, ch);
      continue;
    }
#line 883 "sjson.gen.c"
	}
#line 472 "sjson.c"

  }

  return NULL;
}

gint64 s_json_get_int(const gchar* json, gint64 fallback)
{
  const gchar* start;
  const gchar* end;

  g_return_val_if_fail(json != NULL, fallback);

  if (s_json_get_token(json, &start, &end) != TOK_NUMBER)
    return fallback;

  gchar* str = g_alloca(end - start + 1);
  memcpy(str, start, end - start);
  str[end - start] = 0;

  gint64 v = fallback;
  sscanf(str, "%" G_GINT64_FORMAT, &v);
  return v;
}

gdouble s_json_get_double(const gchar* json, gdouble fallback)
{
  const gchar* start;
  const gchar* end;

  g_return_val_if_fail(json != NULL, fallback);

  if (s_json_get_token(json, &start, &end) != TOK_NUMBER)
    return fallback;

  gchar* str = g_alloca(end - start + 1);
  memcpy(str, start, end - start);
  str[end - start] = 0;

  gdouble v = fallback;
  sscanf(str, "%lf", &v);
  return v;
}

gboolean s_json_get_bool(const gchar* json)
{
  g_return_val_if_fail(json != NULL, FALSE);

  gint token = s_json_get_token(json, NULL, NULL);
  if (token == TOK_TRUE)
    return TRUE;

  return FALSE;
}

gboolean s_json_is_null(const gchar* json)
{
  g_return_val_if_fail(json != NULL, FALSE);

  gint token = s_json_get_token(json, NULL, NULL);
  if (token == TOK_NULL)
    return TRUE;

  return FALSE;
}

// helpers

gchar* s_json_get_member_string(const gchar* json, const gchar* name)
{
  g_return_val_if_fail(json != NULL, NULL);
  g_return_val_if_fail(name != NULL, NULL);

  const gchar* member = s_json_get_member(json, name);
  if (member)
    return s_json_get_string(member);

  return NULL;
}

gint64 s_json_get_member_int(const gchar* json, const gchar* name, gint64 fallback)
{
  g_return_val_if_fail(json != NULL, fallback);
  g_return_val_if_fail(name != NULL, fallback);

  const gchar* member = s_json_get_member(json, name);
  if (member)
    return s_json_get_int(member, fallback);

  return fallback;
}

gdouble s_json_get_member_double(const gchar* json, const gchar* name, gdouble fallback)
{
  g_return_val_if_fail(json != NULL, fallback);
  g_return_val_if_fail(name != NULL, fallback);

  const gchar* member = s_json_get_member(json, name);
  if (member)
    return s_json_get_double(member, fallback);

  return fallback;
}

gboolean s_json_get_member_bool(const gchar* json, const gchar* name)
{
  g_return_val_if_fail(json != NULL, FALSE);
  g_return_val_if_fail(name != NULL, FALSE);

  const gchar* member = s_json_get_member(json, name);
  if (member)
    return s_json_get_bool(member);

  return FALSE;
}

gboolean s_json_member_is_null(const gchar* json, const gchar* name)
{
  g_return_val_if_fail(json != NULL, FALSE);
  g_return_val_if_fail(name != NULL, FALSE);

  const gchar* member = s_json_get_member(json, name);
  if (member)
    return s_json_is_null(member);

  return TRUE;
}

// generator api

struct _SJsonGen
{
  GString* str;
};

SJsonGen* s_json_gen_new(void)
{
  SJsonGen* gen = g_slice_new(SJsonGen);
  gen->str = g_string_sized_new(512);
  return gen;
}

static void strip_comma(SJsonGen* json)
{
  if (json->str->len > 0)
  {
    if (json->str->str[json->str->len - 1] == ',')
      g_string_truncate(json->str, json->str->len - 1);
  }
}

void s_json_gen_start_object(SJsonGen* json)
{
  g_return_if_fail(json != NULL);

  g_string_append_c(json->str, '{');
}

void s_json_gen_end_object(SJsonGen* json)
{
  g_return_if_fail(json != NULL);

  strip_comma(json);
  g_string_append(json->str, "},");
}


void s_json_gen_start_array(SJsonGen* json)
{
  g_return_if_fail(json != NULL);

  g_string_append_c(json->str, '[');
}

void s_json_gen_end_array(SJsonGen* json)
{
  g_return_if_fail(json != NULL);

  strip_comma(json);
  g_string_append(json->str, "],");
}


static void escape_string(GString* str, const gchar* v)
{
  g_return_if_fail(str != NULL);
  g_return_if_fail(v != NULL);

  const guchar* c = (const guchar*)v;
  const guchar* m = NULL;
  const guchar* s;

  g_string_append_c(str, '"');

  while (TRUE)
  {
    s = c;


#line 1085 "sjson.gen.c"
	{
		guchar yych;
		yych = (guchar)*c;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy97;
				if (yych <= 0x07) goto yy99;
				goto yy89;
			} else {
				if (yych <= '\t') goto yy91;
				if (yych >= '\v') goto yy99;
			}
		} else {
			if (yych <= '"') {
				if (yych <= '\r') goto yy87;
				if (yych <= '!') goto yy99;
				goto yy93;
			} else {
				if (yych == '\\') goto yy95;
				goto yy99;
			}
		}
		++c;
#line 671 "sjson.c"
		{ g_string_append(str, "\\n"); continue; }
#line 1111 "sjson.gen.c"
yy87:
		++c;
#line 672 "sjson.c"
		{ g_string_append(str, "\\r"); continue; }
#line 1116 "sjson.gen.c"
yy89:
		++c;
#line 673 "sjson.c"
		{ g_string_append(str, "\\b"); continue; }
#line 1121 "sjson.gen.c"
yy91:
		++c;
#line 674 "sjson.c"
		{ g_string_append(str, "\\t"); continue; }
#line 1126 "sjson.gen.c"
yy93:
		++c;
#line 675 "sjson.c"
		{ g_string_append(str, "\\\""); continue; }
#line 1131 "sjson.gen.c"
yy95:
		++c;
#line 676 "sjson.c"
		{ g_string_append(str, "\\\\"); continue; }
#line 1136 "sjson.gen.c"
yy97:
		++c;
#line 678 "sjson.c"
		{ 
    break;
  }
#line 1143 "sjson.gen.c"
yy99:
		++c;
		yych = (guchar)*c;
		if (yych <= '\r') {
			if (yych <= 0x07) {
				if (yych >= 0x01) goto yy99;
			} else {
				if (yych <= '\n') goto yy101;
				if (yych <= '\f') goto yy99;
			}
		} else {
			if (yych <= '"') {
				if (yych <= '!') goto yy99;
			} else {
				if (yych != '\\') goto yy99;
			}
		}
yy101:
#line 682 "sjson.c"
		{
    g_string_append_len(str, (gchar*)s, c - s);
    continue;
  }
#line 1167 "sjson.gen.c"
	}
#line 686 "sjson.c"

  }

  g_string_append_c(str, '"');
}

void s_json_gen_build(SJsonGen* json, const gchar* fmt, ...)
{
  va_list args;
  gchar* v;

  g_return_if_fail(json != NULL);
  g_return_if_fail(fmt != NULL);

  va_start(args, fmt);
  v = s_json_buildv(fmt, args);
  va_end(args);

  s_json_gen_json(json, v);

  g_free(v);
}

void s_json_gen_json(SJsonGen* json, const gchar* v)
{
  g_return_if_fail(json != NULL);

  if (v)
  {
    g_string_append(json->str, v);
    g_string_append_c(json->str, ',');
  }
  else
    s_json_gen_null(json);
}

void s_json_gen_string(SJsonGen* json, const gchar* v)
{
  g_return_if_fail(json != NULL);

  if (v)
  {
    escape_string(json->str, v);
    g_string_append_c(json->str, ',');
  }
  else
    s_json_gen_null(json);
}

void s_json_gen_int(SJsonGen* json, gint64 v)
{
  g_return_if_fail(json != NULL);

  g_string_append_printf(json->str, "%" G_GINT64_FORMAT ",", v);
}

void s_json_gen_double(SJsonGen* json, gdouble v)
{
  g_return_if_fail(json != NULL);

  g_string_append_printf(json->str, "%lg,", v);
}

void s_json_gen_bool(SJsonGen* json, gboolean v)
{
  g_return_if_fail(json != NULL);

  g_string_append(json->str, v ? "true," : "false,");
}

void s_json_gen_null(SJsonGen* json)
{
  g_return_if_fail(json != NULL);

  g_string_append(json->str, "null,");
}


void s_json_gen_member_build(SJsonGen* json, const gchar* name, const gchar* fmt, ...)
{
  va_list args;
  gchar* v;

  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);
  g_return_if_fail(fmt != NULL);

  va_start(args, fmt);
  v = s_json_buildv(fmt, args);
  va_end(args);

  s_json_gen_member_json(json, name, v);

  g_free(v);
}

void s_json_gen_member_json(SJsonGen* json, const gchar* name, const gchar* v)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_json(json, v);
}

void s_json_gen_member_string(SJsonGen* json, const gchar* name, const gchar* v)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_string(json, v);
}

void s_json_gen_member_int(SJsonGen* json, const gchar* name, gint64 v)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_int(json, v);
}

void s_json_gen_member_double(SJsonGen* json, const gchar* name, gdouble v)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_double(json, v);
}

void s_json_gen_member_bool(SJsonGen* json, const gchar* name, gboolean v)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_bool(json, v);
}

void s_json_gen_member_null(SJsonGen* json, const gchar* name)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_null(json);
}

void s_json_gen_member_array(SJsonGen* json, const gchar* name)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_start_array(json);
}

void s_json_gen_member_object(SJsonGen* json, const gchar* name)
{
  g_return_if_fail(json != NULL);
  g_return_if_fail(name != NULL);

  s_json_gen_string(json, name);
  strip_comma(json);
  g_string_append_c(json->str, ':');
  s_json_gen_start_object(json);
}


gchar* s_json_gen_done(SJsonGen* json)
{
  g_return_val_if_fail(json != NULL, NULL);

  strip_comma(json);
  gchar* str = g_string_free(json->str, FALSE);
  g_slice_free(SJsonGen, json);
  return str;
}

// build

// formats:
// - % ? format
// format: sidbnjSJ

gchar* s_json_buildv(const gchar* format, va_list args)
{
  g_return_val_if_fail(format != NULL, NULL);

  GString* str = g_string_sized_new(strlen(format));
  const guchar* c = (const guchar*)format;
  const guchar* m = NULL;
  const guchar* s;

#define IS_NULLABLE (s[1] == '?')
#define FMT_FULL(arg_type, code_format, code_leave) \
  gboolean is_null = (IS_NULLABLE ? va_arg(args, gboolean) : FALSE); \
  gchar fmt = s[IS_NULLABLE ? 2 : 1]; \
  arg_type arg = va_arg(args, arg_type); \
  if (is_null) { \
    g_string_append(str, "null"); \
  } else { \
    code_format \
  } \
  code_leave \
  continue;

#define FMT(arg_type, code) FMT_FULL(arg_type, code, )

  while (TRUE)
  {
    s = c;


#line 1400 "sjson.gen.c"
	{
		guchar yych;
		yych = (guchar)*c;
		if (yych <= 0x00) goto yy108;
		if (yych != '%') goto yy106;
		yych = (guchar)*(m = ++c);
		if (yych <= 'a') {
			if (yych <= '?') {
				if (yych == '%') goto yy112;
				if (yych >= '?') goto yy114;
			} else {
				if (yych <= 'J') {
					if (yych >= 'J') goto yy122;
				} else {
					if (yych == 'S') goto yy124;
				}
			}
		} else {
			if (yych <= 'h') {
				if (yych <= 'b') goto yy116;
				if (yych == 'd') goto yy118;
			} else {
				if (yych <= 'j') {
					if (yych <= 'i') goto yy120;
					goto yy122;
				} else {
					if (yych == 's') goto yy124;
				}
			}
		}
yy105:
#line 952 "sjson.c"
		{
      g_string_append(str, "%");
      continue;
    }
#line 1437 "sjson.gen.c"
yy106:
		++c;
		yych = (guchar)*c;
		goto yy111;
yy107:
#line 957 "sjson.c"
		{
      g_string_append_len(str, s, c - s);
      continue;
    }
#line 1448 "sjson.gen.c"
yy108:
		++c;
#line 962 "sjson.c"
		{ 
      break;   
    }
#line 1455 "sjson.gen.c"
yy110:
		++c;
		yych = (guchar)*c;
yy111:
		if (yych <= 0x00) goto yy107;
		if (yych == '%') goto yy107;
		goto yy110;
yy112:
		++c;
#line 947 "sjson.c"
		{
      g_string_append(str, "%");
      continue;
    }
#line 1470 "sjson.gen.c"
yy114:
		yych = (guchar)*++c;
		if (yych <= 'c') {
			if (yych <= 'R') {
				if (yych == 'J') goto yy122;
			} else {
				if (yych <= 'S') goto yy124;
				if (yych == 'b') goto yy116;
			}
		} else {
			if (yych <= 'i') {
				if (yych <= 'd') goto yy118;
				if (yych >= 'i') goto yy120;
			} else {
				if (yych <= 'j') goto yy122;
				if (yych == 's') goto yy124;
			}
		}
		c = m;
		goto yy105;
yy116:
		++c;
#line 943 "sjson.c"
		{
      FMT(gboolean, g_string_append(str, arg ? "true" : "false");)
    }
#line 1497 "sjson.gen.c"
yy118:
		++c;
#line 939 "sjson.c"
		{
      FMT(gdouble, g_string_append_printf(str, "%lg" , arg);)
    }
#line 1504 "sjson.gen.c"
yy120:
		++c;
#line 935 "sjson.c"
		{
      FMT(gint64, g_string_append_printf(str, "%" G_GINT64_FORMAT, arg);)
    }
#line 1511 "sjson.gen.c"
yy122:
		++c;
#line 922 "sjson.c"
		{
      FMT_FULL(gchar*, 
        if (arg) {
          const gchar* end;
          if (s_json_is_valid_inner(arg, &end))
            g_string_append_len(str, arg, end - arg); 
          else
            g_string_append(str, "null");
        } else {
          g_string_append(str, "null");
        }, if (fmt == 'J') g_free(arg);)
    }
#line 1527 "sjson.gen.c"
yy124:
		++c;
#line 918 "sjson.c"
		{
      FMT_FULL(gchar*, if (arg) escape_string(str, arg); else g_string_append(str, "null");, if (fmt == 'S') g_free(arg);)
    }
#line 1534 "sjson.gen.c"
	}
#line 969 "sjson.c"

  }

  if (s_json_is_valid(str->str))
    return g_string_free(str, FALSE);

  g_string_free(str, TRUE);
  return NULL;
}

gchar* s_json_build(const gchar* format, ...)
{
  va_list args;
  gchar* json;

  g_return_val_if_fail(format != NULL, NULL);

  va_start(args, format);
  json = s_json_buildv(format, args);
  va_end(args);

  return json;
}

gchar* s_json_pretty(const gchar* json)
{
  const gchar* start;
  const gchar* end;
  GString *str, *ind;
  gchar* json_valid;

  g_return_val_if_fail(json != NULL, NULL);

  // validate and isolate
  json_valid = s_json_get(json);
  start = json_valid;

  str = g_string_sized_new(strlen(json) * 2);
  ind = g_string_sized_new(50);

#define PUSH_INDENT() g_string_append_c(ind, '\t')
#define POP_INDENT() g_string_truncate(ind, MAX(ind->len - 1, 0))
#define INDENT() g_string_append_len(str, ind->str, ind->len)

  gint prev_token = TOK_NONE;
  while (TRUE)
  {
    gint token = s_json_get_token(start, &start, &end);
    if (token == TOK_NONE)
      break;
    gint next_token = s_json_get_token(end, NULL, NULL);

    if ((token == TOK_OBJ_END && prev_token != TOK_OBJ_START) || (token == TOK_ARRAY_END && prev_token != TOK_ARRAY_START && prev_token != TOK_OBJ_END))
    {
      g_string_append_c(str, '\n');
      POP_INDENT();
      INDENT();
    }

    g_string_append_len(str, start, end - start);

    if ((token == TOK_OBJ_START && next_token != TOK_OBJ_END) || (token == TOK_ARRAY_START && next_token != TOK_OBJ_START && next_token != TOK_ARRAY_END))
    {
      g_string_append_c(str, '\n');
      PUSH_INDENT();
      INDENT();
    }
    else if (token == TOK_COMMA)
    {
      if ((prev_token == TOK_OBJ_END && next_token == TOK_OBJ_START) || (prev_token == TOK_ARRAY_END && next_token == TOK_ARRAY_START))
      {
        g_string_append_c(str, ' ');
      }
      else
      {
        g_string_append_c(str, '\n');
        INDENT();
      }
    }
    else if (token == TOK_COLON)
    {
      g_string_append_c(str, ' ');
    }

    prev_token = token;
    start = end;
  }

  g_string_free(ind, TRUE);
  g_free(json_valid);

  return g_string_free(str, FALSE);
}


const gchar* s_json_path(const gchar* json, const gchar* path)
{
  const guchar* c = (const guchar*)path;
  const guchar* m = NULL;
  const guchar* s;
  const gchar* cur_node = json;

  g_return_val_if_fail(json != NULL, NULL);
  g_return_val_if_fail(path != NULL, NULL);

#define CHECK_TYPE(type) \
  if (cur_node && s_json_get_type(cur_node) == type) \
    return cur_node; \
  if ((!cur_node || s_json_get_type(cur_node) == S_JSON_TYPE_NULL) && s[0] == '?') \
    return "null"; \
  return NULL;

  while (TRUE)
  {
    s = c;


#line 1654 "sjson.gen.c"
	{
		guchar yych;
		unsigned int yyaccept = 0;
		yych = (guchar)*c;
		if (yych <= '!') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy136;
				if (yych <= 0x08) goto yy138;
				if (yych >= '\v') goto yy138;
			} else {
				if (yych <= '\r') goto yy128;
				if (yych <= 0x1F) goto yy138;
				if (yych >= '!') goto yy135;
			}
		} else {
			if (yych <= '.') {
				if (yych == '$') goto yy130;
				if (yych <= '-') goto yy138;
				goto yy132;
			} else {
				if (yych <= '?') {
					if (yych <= '>') goto yy138;
					goto yy135;
				} else {
					if (yych == '[') goto yy134;
					goto yy138;
				}
			}
		}
yy128:
		++c;
		yych = (guchar)*c;
		goto yy192;
yy129:
#line 1088 "sjson.c"
		{
      // skip whitespace
      continue;
    }
#line 1694 "sjson.gen.c"
yy130:
		++c;
#line 1093 "sjson.c"
		{
      // root
      cur_node = json;
      continue;
    }
#line 1703 "sjson.gen.c"
yy132:
		++c;
		if ((yych = (guchar)*c) <= 'Z') {
			if (yych == '-') goto yy188;
			if (yych >= 'A') goto yy188;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy188;
			} else {
				if (yych <= '`') goto yy133;
				if (yych <= 'z') goto yy188;
			}
		}
yy133:
#line 1166 "sjson.c"
		{
      return NULL;
    }
#line 1722 "sjson.gen.c"
yy134:
		yyaccept = 0;
		yych = (guchar)*(m = ++c);
		if (yych <= '/') goto yy133;
		if (yych <= '0') goto yy183;
		if (yych <= '9') goto yy184;
		goto yy133;
yy135:
		yych = (guchar)*++c;
		switch (yych) {
		case 'a':	goto yy139;
		case 'b':	goto yy143;
		case 'i':	goto yy145;
		case 'n':	goto yy149;
		case 'o':	goto yy141;
		case 's':	goto yy147;
		default:	goto yy133;
		}
yy136:
		++c;
#line 1162 "sjson.c"
		{ 
      break;
    }
#line 1747 "sjson.gen.c"
yy138:
		yych = (guchar)*++c;
		goto yy133;
yy139:
		yyaccept = 1;
		yych = (guchar)*(m = ++c);
		if (yych == 'r') goto yy179;
yy140:
#line 1158 "sjson.c"
		{
      CHECK_TYPE(S_JSON_TYPE_ARRAY)
    }
#line 1760 "sjson.gen.c"
yy141:
		yyaccept = 2;
		yych = (guchar)*(m = ++c);
		if (yych == 'b') goto yy174;
yy142:
#line 1154 "sjson.c"
		{
      CHECK_TYPE(S_JSON_TYPE_OBJECT)
    }
#line 1770 "sjson.gen.c"
yy143:
		yyaccept = 3;
		yych = (guchar)*(m = ++c);
		if (yych == 'o') goto yy168;
yy144:
#line 1150 "sjson.c"
		{
      CHECK_TYPE(S_JSON_TYPE_BOOL)
    }
#line 1780 "sjson.gen.c"
yy145:
		yyaccept = 4;
		yych = (guchar)*(m = ++c);
		if (yych == 'n') goto yy162;
yy146:
#line 1133 "sjson.c"
		{
      if (cur_node && s_json_get_type(cur_node) == S_JSON_TYPE_NUMBER)
      {
        const gchar *int_start, *int_end, *i;
        g_assert(s_json_get_token(cur_node, &int_start, &int_end) == TOK_NUMBER);
        for (i = int_start; i < int_end; i++)
          if (*i > '9' || *i < '0')
            return NULL;
        return cur_node;
      }

      if ((!cur_node || s_json_get_type(cur_node) == S_JSON_TYPE_NULL) && s[0] == '?')
        return "null";

      return NULL;
    }
#line 1803 "sjson.gen.c"
yy147:
		yyaccept = 5;
		yych = (guchar)*(m = ++c);
		if (yych == 't') goto yy157;
yy148:
#line 1129 "sjson.c"
		{
      CHECK_TYPE(S_JSON_TYPE_STRING)
    }
#line 1813 "sjson.gen.c"
yy149:
		yyaccept = 6;
		yych = (guchar)*(m = ++c);
		if (yych == 'u') goto yy151;
yy150:
#line 1125 "sjson.c"
		{
      CHECK_TYPE(S_JSON_TYPE_NUMBER)
    }
#line 1823 "sjson.gen.c"
yy151:
		yych = (guchar)*++c;
		if (yych == 'm') goto yy153;
yy152:
		c = m;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy133;
				} else {
					goto yy140;
				}
			} else {
				if (yyaccept <= 2) {
					goto yy142;
				} else {
					goto yy144;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept <= 4) {
					goto yy146;
				} else {
					goto yy148;
				}
			} else {
				goto yy150;
			}
		}
yy153:
		yych = (guchar)*++c;
		if (yych != 'b') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'e') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'r') goto yy152;
		yych = (guchar)*++c;
		goto yy150;
yy157:
		yych = (guchar)*++c;
		if (yych != 'r') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'i') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'n') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'g') goto yy152;
		yych = (guchar)*++c;
		goto yy148;
yy162:
		yych = (guchar)*++c;
		if (yych != 't') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'e') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'g') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'e') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'r') goto yy152;
		yych = (guchar)*++c;
		goto yy146;
yy168:
		yych = (guchar)*++c;
		if (yych != 'o') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'l') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'e') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'a') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'n') goto yy152;
		yych = (guchar)*++c;
		goto yy144;
yy174:
		yych = (guchar)*++c;
		if (yych != 'j') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'e') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'c') goto yy152;
		yych = (guchar)*++c;
		if (yych != 't') goto yy152;
		yych = (guchar)*++c;
		goto yy142;
yy179:
		yych = (guchar)*++c;
		if (yych != 'r') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'a') goto yy152;
		yych = (guchar)*++c;
		if (yych != 'y') goto yy152;
		yych = (guchar)*++c;
		goto yy140;
yy183:
		yych = (guchar)*++c;
		if (yych == ']') goto yy186;
		goto yy152;
yy184:
		++c;
		yych = (guchar)*c;
		if (yych <= '/') goto yy152;
		if (yych <= '9') goto yy184;
		if (yych != ']') goto yy152;
yy186:
		++c;
#line 1112 "sjson.c"
		{
      if (!cur_node || s_json_get_type(cur_node) != S_JSON_TYPE_ARRAY)
        return NULL;

      guint index;
      sscanf(s + 1, "%u", &index);

      cur_node = s_json_get_element(cur_node, index);
      continue;
    }
#line 1943 "sjson.gen.c"
yy188:
		++c;
		yych = (guchar)*c;
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych >= '-') goto yy188;
			} else {
				if (yych <= '/') goto yy190;
				if (yych <= '9') goto yy188;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy188;
				if (yych >= '_') goto yy188;
			} else {
				if (yych <= '`') goto yy190;
				if (yych <= 'z') goto yy188;
			}
		}
yy190:
#line 1099 "sjson.c"
		{
      if (!cur_node || s_json_get_type(cur_node) != S_JSON_TYPE_OBJECT)
        return NULL;

      // zero terminate member name on stack
      gchar* name = g_alloca((c - s));
      memcpy(name, s + 1, c - (s + 1));
      name[c - (s + 1)] = '\0';

      cur_node = s_json_get_member(cur_node, name);
      continue;
    }
#line 1977 "sjson.gen.c"
yy191:
		++c;
		yych = (guchar)*c;
yy192:
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy129;
			if (yych <= '\n') goto yy191;
			goto yy129;
		} else {
			if (yych <= '\r') goto yy191;
			if (yych == ' ') goto yy191;
			goto yy129;
		}
	}
#line 1169 "sjson.c"

  }

  return cur_node;
}
