#!/bin/sh
#
# Create ~/.mediaserv and copy the static files we care about into it.

STATIC_DIR=`dirname "$0"`
STATIC_DIR=`cd "$STATIC_DIR"; pwd`

[ -d ~/.mediaserv ] || mkdir ~/.mediaserv || exit
[ -f ~/.mediaserv/config ] && touch ~/.mediaserv/config

cp -vup "${STATIC_DIR}/resources/"* ~/.mediaserv/

cp ~/.mediaserv/config ~/.mediaserv/config~
perl -e '
  open(IN, "<$ENV{HOME}/.mediaserv/config~");
  while(<IN>) { $settings{$1} = $2 if /^\s*(\w+)\s*=\s*(.*)$/; }
  close(IN);
  
  while(<>) {
    print;
    print "$1 = $settings{$1}\n" if /(\w+)\s*=\s*/ and $settings{$1};
  }
' "${STATIC_DIR}/resources/config" >~/.mediaserv/config

echo "Install of mediaserv complete."

