// vim:ts=4:sw=4
//
//  File autogenerated by gengetopt version 2.4  
//  generated with the following command:
//  gengetopt -l -imdate++.ggo 
//
//  The developers of gengetopt consider the fixed text that goes in all
//  gengetopt output files to be in the public domain:
//  we make no copyright claims on it.
//
// cmdline.cc - Copyright(c) under GPL 2003-2013 Sean Dwyer <ewe2@users.sourceforge.net>
// hacked around a bit from the original generated cmdline.c

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <cstring>
// If we use autoconf
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "cmdline.h"

#define STATIC_HELP

#include "mdate.h"

static char rcsid[] __attribute__ ((unused)) = "@(#) $Id: af8f300b6b40e5eb9602d6eb32acb04b84662af0 $";

using namespace std;

static struct option long_options[] = {
	{ "help",       0, NULL, 'h' },
	{ "version",    0, NULL, 'V' },
	{ "version", 0, NULL, 'v' },
	{ "lang",       1, NULL, 'L' },
	{ "correlation", 1, NULL, 'c' },
	{ "dmy",        1, NULL, 'd' },
  { "julian",     1, NULL, 'j' },
  { "longcount",  1, NULL, 'l' },
  { NULL, 0, NULL, 0 }
};

void
cmdline_parser_print_version (void)
{
	cout << PACKAGE << " " << VERSION << endl;
	cout << "Copyright(c) 1998-2013 Sean Dwyer <ewe2@users.sourceforge.net>" << endl;
}

void
cmdline_parser_print_help (void)
{
	cmdline_parser_print_version ();
	std::cout << helptext;
}

int
cmdline_parser (int argc, char *const *argv, struct gengetopt_args_info *args_info)
{
	int c;	// Character of the parsed option.
	int missing_required_options = 0;	 // hrmm..
	int n_args;

	args_info->help_given = 0 ;
	args_info->version_given = 0 ;
	args_info->correlation_given = 0 ;
	args_info->dmy_given = 0 ;
	args_info->julian_given = 0 ;
	args_info->longcount_given = 0 ;
	args_info->format_given = 0;

#define clear_args() { \
  args_info->dmy_arg1 = 0; \
  args_info->dmy_arg2 = 0;\
  args_info->dmy_arg3 = 0;\
  args_info->longcount_arg1 = 0;\
  args_info->longcount_arg2 = 0;\
  args_info->longcount_arg3 = 0;\
  args_info->longcount_arg4 = 0;\
  args_info->longcount_arg5 = 0;\
	args_info->format_arg = 0;\
}

	clear_args();

	optarg = 0;
	optind = 1;
	opterr = 1;
	optopt = '?';
// FIXME: why does mingw32 cross-compiler die here? is there a upstream patch
// that fixes it??
	while ((c = getopt_long (argc, argv, "hVvpgL:c:d:j:l:", long_options, NULL)) != -1)

      switch (c)
      {
		case 0:
			break;
        case 'h':	// Print help and exit.
          clear_args ();
          cmdline_parser_print_help ();
          ::exit (0);

        case 'V':	// Print version and exit.
        case 'v':
          clear_args ();
          cmdline_parser_print_version ();
          ::exit (0);

		case 'L':	// language selection.
		  set_lang(optarg);
		  break;
		  
        case 'c':	// optional correlation (default=no).
          if (args_info->correlation_given)
            {
              std::cerr << MSG_CERR;
              clear_args ();
              ::exit (1);
            }
          args_info->correlation_given = 1;
          args_info->correlation_arg = strtod (optarg, NULL);
          break;

        case 'd':	// day month year (Gregorian).
          if (args_info->dmy_given)
            {
              std::cerr << MSG_DERR;
              clear_args ();
              ::exit (1);
            }
          args_info->dmy_given = 1;
          args_info->dmy_arg1 = atoi(optarg);
          args_info->dmy_arg2 = atoi(optarg + 2);
          args_info->dmy_arg3 = atoi(optarg + 6);
          break;

        case 'j':	// julian day number.
          if (args_info->julian_given)
            {
              std::cerr << MSG_JERR;
              clear_args ();
              ::exit (1);
            }
          args_info->julian_given = 1;
          args_info->julian_arg = strtod (optarg, NULL);
          break;

        case 'l':	// long count.
          if (args_info->longcount_given)
            {
              std::cerr << MSG_LERR;
              clear_args ();
              ::exit (1);
            }
          args_info->longcount_given = 1;
          args_info->longcount_arg1 = atoi(optarg);
          args_info->longcount_arg2 = atoi(optarg + 2);
          args_info->longcount_arg3 = atoi(optarg + 6);
          args_info->longcount_arg4 = atoi(optarg + 9);
          args_info->longcount_arg5 = atoi(optarg + 12);
          break;

        case '?':	// Invalid option.
          // `getopt_long' already printed an error message.
          ::exit (1);

        default:	// bug: option not considered.
          cerr << MSG_OPTERR << c << endl;
          abort ();
      } // switch
    
  // while
	
	// now deal with formatting
	n_args = argc - optind;

	if (n_args > 1) {
		std::cerr << MSG_NONOPTERR;
		::exit(1);
	}

	if ((n_args == 1) && argv[optind][0] == '+') {
		if (args_info->format_given) {
			clear_args();
			std::cerr << MSG_NONOPTERR;
			::exit(1);
		}
		args_info->format_given = 1;
		args_info->format_arg = (n_args == 1 ? argv[optind] + 1: NULL);
	}

	if ((n_args == 1) && argv[optind][0] != '+') {
		clear_args();
		std::cerr << MSG_OPTERR << c << "\n";
		::exit(1);
	}

  if ( missing_required_options )
	::exit(0);

  return 0;
}
