/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.feature.Features;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.Scm;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.model.LifecycleBindingsInjector;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.internal.transformation.impl.PomBuilder;
import org.apache.maven.model.v4.MavenModelVersion;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class DefaultConsumerPomBuilder
implements PomBuilder {
    private static final String BOM_PACKAGING = "bom";
    public static final String POM_PACKAGING = "pom";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsumerPomBuilder.class);
    private final LifecycleBindingsInjector lifecycleBindingsInjector;

    @Inject
    DefaultConsumerPomBuilder(LifecycleBindingsInjector lifecycleBindingsInjector) {
        this.lifecycleBindingsInjector = lifecycleBindingsInjector;
    }

    @Override
    public Model build(RepositorySystemSession session, MavenProject project, ModelSource src) throws ModelBuilderException {
        Model model = project.getModel().getDelegate();
        boolean flattenEnabled = Features.consumerPomFlatten((Map)session.getConfigProperties());
        if (!flattenEnabled) {
            return this.buildPom(session, project, src);
        }
        String packaging = model.getPackaging();
        String originalPackaging = project.getOriginalModel().getPackaging();
        if (POM_PACKAGING.equals(packaging)) {
            if (BOM_PACKAGING.equals(originalPackaging)) {
                return this.buildBom(session, project, src);
            }
            return this.buildPom(session, project, src);
        }
        return this.buildNonPom(session, project, src);
    }

    protected Model buildPom(RepositorySystemSession session, MavenProject project, ModelSource src) throws ModelBuilderException {
        ModelBuilderResult result = this.buildModel(session, src);
        Model model = result.getRawModel();
        return DefaultConsumerPomBuilder.transformPom(model, project);
    }

    protected Model buildBom(RepositorySystemSession session, MavenProject project, ModelSource src) throws ModelBuilderException {
        ModelBuilderResult result = this.buildModel(session, src);
        Model model = result.getEffectiveModel();
        return DefaultConsumerPomBuilder.transformBom(model, project);
    }

    protected Model buildNonPom(RepositorySystemSession session, MavenProject project, ModelSource src) throws ModelBuilderException {
        Model model = this.buildEffectiveModel(session, src);
        return DefaultConsumerPomBuilder.transformNonPom(model, project);
    }

    private Model buildEffectiveModel(RepositorySystemSession session, ModelSource src) throws ModelBuilderException {
        InternalSession iSession = InternalSession.from((RepositorySystemSession)session);
        ModelBuilderResult result = this.buildModel(session, src);
        Model model = result.getEffectiveModel();
        if (model.getDependencyManagement() != null && !model.getDependencyManagement().getDependencies().isEmpty()) {
            ArtifactCoordinates artifact = iSession.createArtifactCoordinates(model.getGroupId(), model.getArtifactId(), model.getVersion(), null);
            Node node = iSession.collectDependencies(iSession.createDependencyCoordinates(artifact), PathScope.MAIN_RUNTIME);
            Map nodes = node.stream().collect(Collectors.toMap(n -> DefaultConsumerPomBuilder.getDependencyKey(n.getDependency()), Function.identity()));
            Map directDependencies = model.getDependencies().stream().filter(dependency -> !"import".equals(dependency.getScope())).collect(Collectors.toMap(DefaultConsumerPomBuilder::getDependencyKey, Function.identity(), this::merge, LinkedHashMap::new));
            Map managedDependencies = model.getDependencyManagement().getDependencies().stream().filter(dependency -> nodes.containsKey(DefaultConsumerPomBuilder.getDependencyKey(dependency)) && !"import".equals(dependency.getScope())).collect(Collectors.toMap(DefaultConsumerPomBuilder::getDependencyKey, Function.identity(), this::merge, LinkedHashMap::new));
            managedDependencies.keySet().retainAll(nodes.keySet());
            directDependencies.replaceAll((key, dependency) -> {
                Dependency managedDependency = (Dependency)managedDependencies.get(key);
                if (managedDependency != null) {
                    if (dependency.getVersion() == null && managedDependency.getVersion() != null) {
                        dependency = dependency.withVersion(managedDependency.getVersion());
                    }
                    if (dependency.getScope() == null && managedDependency.getScope() != null) {
                        dependency = dependency.withScope(managedDependency.getScope());
                    }
                    if (dependency.getOptional() == null && managedDependency.getOptional() != null) {
                        dependency = dependency.withOptional(managedDependency.getOptional());
                    }
                    if (dependency.getExclusions().isEmpty() && !managedDependency.getExclusions().isEmpty()) {
                        dependency = dependency.withExclusions((Collection)managedDependency.getExclusions());
                    }
                }
                return dependency;
            });
            directDependencies.values().removeIf(DefaultConsumerPomBuilder::hasDependencyScope);
            managedDependencies.keySet().removeAll(directDependencies.keySet());
            model = model.withDependencyManagement(managedDependencies.isEmpty() ? null : model.getDependencyManagement().withDependencies(managedDependencies.values())).withDependencies(directDependencies.isEmpty() ? null : directDependencies.values());
        } else {
            Map directDependencies = model.getDependencies().stream().filter(dependency -> !"import".equals(dependency.getScope())).collect(Collectors.toMap(DefaultConsumerPomBuilder::getDependencyKey, Function.identity(), this::merge, LinkedHashMap::new));
            directDependencies.values().removeIf(DefaultConsumerPomBuilder::hasDependencyScope);
            model = model.withDependencies(directDependencies.isEmpty() ? null : directDependencies.values());
        }
        return model;
    }

    private static boolean hasDependencyScope(Dependency dependency) {
        String scopeId = dependency.getScope();
        DependencyScope scope = scopeId == null || scopeId.isEmpty() ? DependencyScope.COMPILE : DependencyScope.forId((String)scopeId);
        return scope == null || !scope.isTransitive();
    }

    private Dependency merge(Dependency dep1, Dependency dep2) {
        throw new IllegalArgumentException("Duplicate dependency: " + DefaultConsumerPomBuilder.getDependencyKey(dep1));
    }

    private static String getDependencyKey(org.apache.maven.api.Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType().id() + ":" + dependency.getClassifier();
    }

    private static String getDependencyKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + (dependency.getType() != null ? dependency.getType() : "jar") + ":" + (dependency.getClassifier() != null ? dependency.getClassifier() : "");
    }

    private ModelBuilderResult buildModel(RepositorySystemSession session, ModelSource src) throws ModelBuilderException {
        InternalSession iSession = InternalSession.from((RepositorySystemSession)session);
        ModelBuilderRequest.ModelBuilderRequestBuilder request = ModelBuilderRequest.builder();
        request.requestType(ModelBuilderRequest.RequestType.BUILD_CONSUMER);
        request.session((Session)iSession);
        request.source(src);
        request.locationTracking(false);
        request.systemProperties(session.getSystemProperties());
        request.userProperties(session.getUserProperties());
        request.lifecycleBindingsInjector((arg_0, arg_1, arg_2) -> ((LifecycleBindingsInjector)this.lifecycleBindingsInjector).injectLifecycleBindings(arg_0, arg_1, arg_2));
        ModelBuilder.ModelBuilderSession mbSession = (ModelBuilder.ModelBuilderSession)iSession.getData().get(SessionData.key(ModelBuilder.ModelBuilderSession.class));
        return mbSession.build(request.build());
    }

    static Model transformNonPom(Model model, MavenProject project) {
        boolean preserveModelVersion = model.isPreserveModelVersion();
        Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).build(null), (ModelBase)model).mailingLists(null).issueManagement(null).scm(model.getScm() != null ? Scm.newBuilder((Scm)model.getScm(), (boolean)true).childScmConnectionInheritAppendPath(null).childScmUrlInheritAppendPath(null).childScmDeveloperConnectionInheritAppendPath(null).build() : null);
        builder.profiles(DefaultConsumerPomBuilder.prune(model.getProfiles()));
        model = builder.build();
        String modelVersion = new MavenModelVersion().getModelVersion(model);
        if (!"4.0.0".equals(modelVersion) && !preserveModelVersion) {
            DefaultConsumerPomBuilder.warnNotDowngraded(project);
        }
        model = model.withModelVersion(modelVersion);
        return model;
    }

    static Model transformBom(Model model, MavenProject project) {
        boolean preserveModelVersion = model.isPreserveModelVersion();
        Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).build(null), (ModelBase)model);
        builder.packaging(POM_PACKAGING);
        builder.profiles(DefaultConsumerPomBuilder.prune(model.getProfiles()));
        model = builder.build();
        String modelVersion = new MavenModelVersion().getModelVersion(model);
        if (!"4.0.0".equals(modelVersion) && !preserveModelVersion) {
            DefaultConsumerPomBuilder.warnNotDowngraded(project);
        }
        model = model.withModelVersion(modelVersion);
        return model;
    }

    static Model transformPom(Model model, MavenProject project) {
        boolean preserveModelVersion = model.isPreserveModelVersion();
        if ((model = model.withRoot(false).withModules(null).withSubprojects(null)).getParent() != null) {
            model = model.withParent(model.getParent().withRelativePath(null));
        }
        if (!preserveModelVersion) {
            model = model.withPreserveModelVersion(false);
            String modelVersion = new MavenModelVersion().getModelVersion(model);
            model = model.withModelVersion(modelVersion);
        }
        return model;
    }

    static void warnNotDowngraded(MavenProject project) {
        LOGGER.warn("The consumer POM for " + project.getId() + " cannot be downgraded to 4.0.0. If you intent your build to be consumed with Maven 3 projects, you need to remove the features that request a newer model version.  If you're fine with having the consumer POM not consumable with Maven 3, add the `preserve.model.version='true'` attribute on the <project> element of your POM.");
    }

    private static List<Profile> prune(List<Profile> profiles) {
        return profiles.stream().map(p -> {
            Profile.Builder builder = Profile.newBuilder((Profile)p, (boolean)true);
            DefaultConsumerPomBuilder.prune(builder, (ModelBase)p);
            return builder.build(null).build();
        }).filter(p -> !DefaultConsumerPomBuilder.isEmpty(p)).collect(Collectors.toList());
    }

    private static boolean isEmpty(Profile profile) {
        return profile.getActivation() == null && profile.getBuild() == null && profile.getDependencies().isEmpty() && (profile.getDependencyManagement() == null || profile.getDependencyManagement().getDependencies().isEmpty()) && profile.getDistributionManagement() == null && profile.getModules().isEmpty() && profile.getSubprojects().isEmpty() && profile.getProperties().isEmpty() && profile.getRepositories().isEmpty() && profile.getPluginRepositories().isEmpty() && profile.getReporting() == null;
    }

    private static <T extends ModelBase.Builder> T prune(T builder, ModelBase model) {
        builder.properties(null).reporting(null);
        if (model.getDistributionManagement() != null && model.getDistributionManagement().getRelocation() != null) {
            builder.distributionManagement(DistributionManagement.newBuilder().relocation(model.getDistributionManagement().getRelocation()).build());
        }
        builder.repositories(DefaultConsumerPomBuilder.pruneRepositories(model.getRepositories()));
        builder.pluginRepositories(null);
        return builder;
    }

    private static List<Repository> pruneRepositories(List<Repository> repositories) {
        return repositories.stream().filter(r -> !"central".equals(r.getId())).collect(Collectors.toList());
    }
}

