/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PathUtils {
    private static final Map<String, String> ILLEGAL_PATH_SEGMENT_REPLACEMENTS;

    private PathUtils() {
    }

    public static String stringToPathSegment(String string) {
        Objects.requireNonNull(string);
        StringBuilder result = new StringBuilder(string);
        for (Map.Entry<String, String> entry : ILLEGAL_PATH_SEGMENT_REPLACEMENTS.entrySet()) {
            String illegal = entry.getKey();
            int pos = result.indexOf(illegal);
            while (pos >= 0) {
                result.replace(pos, pos + illegal.length(), entry.getValue());
                pos = result.indexOf(illegal);
            }
        }
        return result.toString();
    }

    static {
        HashMap<String, String> illegalPathSegmentReplacements = new HashMap<String, String>();
        illegalPathSegmentReplacements.put("\\", "-BACKSLASH-");
        illegalPathSegmentReplacements.put("/", "-SLASH-");
        illegalPathSegmentReplacements.put(":", "-COLON-");
        illegalPathSegmentReplacements.put("\"", "-QUOTE-");
        illegalPathSegmentReplacements.put("<", "-LT-");
        illegalPathSegmentReplacements.put(">", "-GT-");
        illegalPathSegmentReplacements.put("|", "-PIPE-");
        illegalPathSegmentReplacements.put("?", "-QMARK-");
        illegalPathSegmentReplacements.put("*", "-ASTERISK-");
        ILLEGAL_PATH_SEGMENT_REPLACEMENTS = Collections.unmodifiableMap(illegalPathSegmentReplacements);
    }
}

