/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.ProviderInstanceBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.api.di.MojoExecutionScoped;
import org.apache.maven.api.di.SessionScoped;
import org.apache.maven.di.Injector;
import org.apache.maven.di.Key;
import org.apache.maven.di.Scope;
import org.apache.maven.di.impl.Binding;
import org.apache.maven.di.impl.DIException;
import org.apache.maven.di.impl.Dependency;
import org.apache.maven.di.impl.InjectorImpl;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;

@javax.inject.Named
public class SisuDiBridgeModule
extends AbstractModule {
    protected final boolean discover;
    protected InjectorImpl injector;

    public SisuDiBridgeModule() {
        this(true);
    }

    public SisuDiBridgeModule(boolean discover) {
        this.discover = discover;
    }

    protected void configure() {
        Provider containerProvider = this.getProvider(PlexusContainer.class);
        Provider beanLocatorProvider = this.getProvider(BeanLocator.class);
        this.injector = new BridgeInjectorImpl((javax.inject.Provider<BeanLocator>)beanLocatorProvider, this.binder());
        this.bindScope(this.injector, (javax.inject.Provider<PlexusContainer>)containerProvider, SessionScoped.class, SessionScope.class);
        this.bindScope(this.injector, (javax.inject.Provider<PlexusContainer>)containerProvider, MojoExecutionScoped.class, MojoExecutionScope.class);
        this.injector.bindInstance(Injector.class, (Object)this.injector);
        this.bind(Injector.class).toInstance((Object)this.injector);
        this.bind(SisuDiBridgeModule.class).toInstance((Object)this);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (this.discover) {
            this.injector.discover(classLoader);
        }
    }

    private void bindScope(InjectorImpl injector, javax.inject.Provider<PlexusContainer> containerProvider, Class<? extends Annotation> sa, Class<? extends Scope> ss) {
        injector.bindScope(sa, () -> {
            try {
                return (Scope)((PlexusContainer)containerProvider.get()).lookup(ss);
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static class BridgeInjectorImpl
    extends InjectorImpl {
        final javax.inject.Provider<BeanLocator> locator;
        final Binder binder;

        BridgeInjectorImpl(javax.inject.Provider<BeanLocator> locator, Binder binder) {
            this.locator = locator;
            this.binder = binder;
        }

        protected <U> Injector bind(Key<U> key, Binding<U> binding) {
            super.bind(key, binding);
            if (key.getQualifier() != null) {
                com.google.inject.Key<U> k = BridgeInjectorImpl.toGuiceKey(key);
                this.binder.bind(k).toProvider(new BridgeProvider<U>(binding));
            }
            return this;
        }

        private static <U> com.google.inject.Key<U> toGuiceKey(Key<U> key) {
            Object object = key.getQualifier();
            if (object instanceof String) {
                String s = (String)object;
                return com.google.inject.Key.get((Type)key.getType(), (Annotation)Names.named((String)s));
            }
            object = key.getQualifier();
            if (object instanceof Annotation) {
                Annotation a = (Annotation)object;
                return com.google.inject.Key.get((Type)key.getType(), (Annotation)a);
            }
            return com.google.inject.Key.get((Type)key.getType());
        }

        public <Q> Supplier<Q> getCompiledBinding(Dependency<Q> dep) {
            Key key = dep.key();
            Class rawType = key.getRawType();
            if (rawType == List.class) {
                return this.getListSupplier(key);
            }
            if (rawType == Map.class) {
                return this.getMapSupplier(key);
            }
            return this.getBeanSupplier(dep, key);
        }

        private <Q> Supplier<Q> getBeanSupplier(Dependency<Q> dep, Key<Q> key) {
            ArrayList<BindingToBeanEntry<Object>> list = new ArrayList<BindingToBeanEntry<Object>>();
            list.addAll(this.getBindings().getOrDefault(key, Set.of()));
            for (BeanEntry bean : ((BeanLocator)this.locator.get()).locate(BridgeInjectorImpl.toGuiceKey(key))) {
                if (!this.isPlexusBean(bean)) continue;
                list.add(new BindingToBeanEntry<Q>(key).toBeanEntry(bean));
            }
            if (!list.isEmpty()) {
                list.sort(BridgeInjectorImpl.getBindingComparator());
                return () -> this.getInstance((Binding)list.iterator().next());
            }
            if (dep.optional()) {
                return () -> null;
            }
            throw new DIException("No binding to construct an instance for key " + key.getDisplayString() + ".  Existing bindings:\n" + this.getBoundKeys().stream().map(Key::toString).map(String::trim).sorted().distinct().collect(Collectors.joining("\n - ", " - ", "")));
        }

        private <Q> Supplier<Q> getListSupplier(Key<Q> key) {
            Key elementType = key.getTypeParameter(0);
            return () -> {
                ArrayList list = new ArrayList();
                list.addAll(this.getBindings().getOrDefault(elementType, Set.of()));
                for (BeanEntry bean : ((BeanLocator)this.locator.get()).locate(BridgeInjectorImpl.toGuiceKey(elementType))) {
                    if (!this.isPlexusBean(bean)) continue;
                    list.add(new BindingToBeanEntry(elementType).toBeanEntry(bean));
                }
                return this.list(list.stream().sorted(BridgeInjectorImpl.getBindingComparator()).toList(), this::getInstance);
            };
        }

        private <Q> Supplier<Q> getMapSupplier(Key<Q> key) {
            Key keyType = key.getTypeParameter(0);
            Key valueType = key.getTypeParameter(1);
            if (keyType.getRawType() != String.class) {
                throw new DIException("Only String keys are supported for maps: " + key);
            }
            return () -> {
                Comparator<Binding<?>> comparator = BridgeInjectorImpl.getBindingComparator();
                HashMap<String, Binding> map = new HashMap<String, Binding>();
                for (Binding b : this.getBindings().getOrDefault(valueType, Set.of())) {
                    String s;
                    Object object;
                    String name = b.getOriginalKey() != null && (object = b.getOriginalKey().getQualifier()) instanceof String ? (s = (String)object) : "";
                    map.compute(name, (n, ob) -> ob == null || comparator.compare((Binding<?>)ob, (Binding<?>)b) < 0 ? b : ob);
                }
                for (BeanEntry bean : ((BeanLocator)this.locator.get()).locate(BridgeInjectorImpl.toGuiceKey(valueType))) {
                    String string;
                    if (!this.isPlexusBean(bean)) continue;
                    Binding b = new BindingToBeanEntry(valueType).toBeanEntry(bean).prioritize(bean.getRank());
                    Annotation annotation = bean.getKey();
                    if (annotation instanceof Named) {
                        Named n2 = (Named)annotation;
                        string = n2.value();
                    } else {
                        string = "";
                    }
                    String name = string;
                    map.compute(name, (n, ob) -> ob == null || ob.getPriority() < b.getPriority() ? b : ob);
                }
                return this.map(map, this::getInstance);
            };
        }

        private <Q> Q getInstance(Binding<Q> binding) {
            return (Q)this.compile(binding).get();
        }

        private static Comparator<Binding<?>> getBindingComparator() {
            Comparator<Binding> comparing = Comparator.comparing(Binding::getPriority);
            return comparing.reversed();
        }

        private <T> boolean isPlexusBean(BeanEntry<Annotation, T> entry) {
            try {
                if ("org.eclipse.sisu.inject.LazyBeanEntry".equals(entry.getClass().getName())) {
                    ProviderInstanceBinding pib;
                    Field f = entry.getClass().getDeclaredField("binding");
                    f.setAccessible(true);
                    Object b = f.get(entry);
                    return !(b instanceof ProviderInstanceBinding) || !((pib = (ProviderInstanceBinding)b).getUserSuppliedProvider() instanceof BridgeProvider);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        class BridgeProvider<T>
        implements javax.inject.Provider<T> {
            final Binding<T> binding;

            BridgeProvider(Binding<T> binding) {
                this.binding = binding;
            }

            public T get() {
                return BridgeInjectorImpl.this.compile(this.binding).get();
            }
        }

        static class BindingToBeanEntry<T>
        extends Binding<T> {
            private BeanEntry<Annotation, T> beanEntry;

            BindingToBeanEntry(Key<T> elementType) {
                super(elementType, Set.of());
            }

            public BindingToBeanEntry<T> toBeanEntry(BeanEntry<Annotation, T> beanEntry) {
                this.beanEntry = beanEntry;
                return this;
            }

            public Supplier<T> compile(Function<Dependency<?>, Supplier<?>> compiler) {
                return () -> ((javax.inject.Provider)this.beanEntry.getProvider()).get();
            }
        }
    }
}

