/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ModelInterpolator;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.model.RootLocator;
import org.apache.maven.api.services.model.UrlNormalizer;
import org.apache.maven.internal.impl.model.MavenBuildTimestamp;
import org.apache.maven.internal.impl.model.reflection.ReflectionValueExtractor;
import org.apache.maven.model.v4.MavenTransformer;

@Named
@Singleton
public class DefaultModelInterpolator
implements ModelInterpolator {
    private static final String PREFIX_PROJECT = "project.";
    private static final String PREFIX_POM = "pom.";
    private static final List<String> PROJECT_PREFIXES_3_1 = Arrays.asList("pom.", "project.");
    private static final List<String> PROJECT_PREFIXES_4_0 = Collections.singletonList("project.");
    private static final Set<String> TRANSLATED_PATH_EXPRESSIONS = Set.of("build.directory", "build.outputDirectory", "build.testOutputDirectory", "build.sourceDirectory", "build.testSourceDirectory", "build.scriptSourceDirectory", "reporting.outputDirectory");
    private static final Set<String> URL_EXPRESSIONS = Set.of("project.url", "project.scm.url", "project.scm.connection", "project.scm.developerConnection", "project.distributionManagement.site.url");
    private final PathTranslator pathTranslator;
    private final UrlNormalizer urlNormalizer;
    private final RootLocator rootLocator;
    private final Interpolator interpolator;

    @Inject
    public DefaultModelInterpolator(PathTranslator pathTranslator, UrlNormalizer urlNormalizer, RootLocator rootLocator, Interpolator interpolator) {
        this.pathTranslator = pathTranslator;
        this.urlNormalizer = urlNormalizer;
        this.rootLocator = rootLocator;
        this.interpolator = interpolator;
    }

    @Override
    public Model interpolateModel(Model model, Path projectDir, ModelBuilderRequest request, ModelProblemCollector problems) {
        InnerInterpolator innerInterpolator = this.createInterpolator(model, projectDir, request, problems);
        return new MavenTransformer(innerInterpolator::interpolate).visit(model);
    }

    private InnerInterpolator createInterpolator(Model model, Path projectDir, ModelBuilderRequest request, ModelProblemCollector problems) {
        HashMap cache = new HashMap();
        Function<String, Optional> ucb = v -> Optional.ofNullable(this.callback(model, projectDir, request, problems, (String)v));
        Function<String, String> cb = v -> ((Optional)cache.computeIfAbsent(v, ucb)).orElse(null);
        BiFunction<String, String, String> postprocessor = (e, v) -> this.postProcess(projectDir, request, (String)e, (String)v);
        return value -> {
            try {
                return this.interpolator.interpolate(value, cb, postprocessor, false);
            }
            catch (InterpolatorException e) {
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, e.getMessage(), (Exception)((Object)e));
                return null;
            }
        };
    }

    protected List<String> getProjectPrefixes(ModelBuilderRequest request) {
        return request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_PROJECT ? PROJECT_PREFIXES_4_0 : PROJECT_PREFIXES_3_1;
    }

    String callback(Model model, Path projectDir, ModelBuilderRequest request, ModelProblemCollector problems, String expression) {
        String value = this.doCallback(model, projectDir, request, problems, expression);
        if (value != null) {
            // empty if block
        }
        return value;
    }

    private String postProcess(Path projectDir, ModelBuilderRequest request, String expression, String value) {
        String exp = this.unprefix(expression, this.getProjectPrefixes(request));
        if (TRANSLATED_PATH_EXPRESSIONS.contains(exp)) {
            value = this.pathTranslator.alignToBaseDirectory(value, projectDir);
        }
        if (URL_EXPRESSIONS.contains(expression)) {
            value = this.urlNormalizer.normalize(value);
        }
        return value;
    }

    private String unprefix(String expression, List<String> prefixes) {
        for (String prefix : prefixes) {
            if (!expression.startsWith(prefix)) continue;
            return expression.substring(prefix.length());
        }
        return expression;
    }

    String doCallback(Model model, Path projectDir, ModelBuilderRequest request, ModelProblemCollector problems, String expression) {
        if ("build.timestamp".equals(expression) || "maven.build.timestamp".equals(expression)) {
            return new MavenBuildTimestamp(request.getSession().getStartTime(), model.getProperties()).formattedTimestamp();
        }
        for (String prefix : this.getProjectPrefixes(request)) {
            String subExpr;
            String v;
            if (!expression.startsWith(prefix) || (v = this.projectProperty(model, projectDir, subExpr = expression.substring(prefix.length()), true)) == null) continue;
            return v;
        }
        String value = (String)request.getUserProperties().get(expression);
        if (value == null) {
            value = (String)model.getProperties().get(expression);
        }
        if (value == null) {
            value = (String)request.getSystemProperties().get(expression);
        }
        if (value == null) {
            value = (String)request.getSystemProperties().get("env." + expression);
        }
        if (value != null) {
            return value;
        }
        return this.projectProperty(model, projectDir, expression, false);
    }

    String projectProperty(Model model, Path projectDir, String subExpr, boolean prefixed) {
        Object value;
        if (projectDir != null) {
            if (subExpr.equals("basedir")) {
                return projectDir.toAbsolutePath().toString();
            }
            if (subExpr.startsWith("basedir.")) {
                try {
                    value = ReflectionValueExtractor.evaluate(subExpr, projectDir.toAbsolutePath(), false);
                    if (value != null) {
                        return value.toString();
                    }
                }
                catch (Exception value2) {}
            } else {
                if (prefixed && subExpr.equals("baseUri")) {
                    return projectDir.toAbsolutePath().toUri().toASCIIString();
                }
                if (prefixed && subExpr.startsWith("baseUri.")) {
                    try {
                        value = ReflectionValueExtractor.evaluate(subExpr, projectDir.toAbsolutePath().toUri(), false);
                        if (value != null) {
                            return value.toString();
                        }
                    }
                    catch (Exception value3) {}
                } else {
                    if (prefixed && subExpr.equals("rootDirectory")) {
                        return this.rootLocator.findMandatoryRoot(projectDir).toString();
                    }
                    if (prefixed && subExpr.startsWith("rootDirectory.")) {
                        try {
                            value = ReflectionValueExtractor.evaluate(subExpr, projectDir.toAbsolutePath().toUri(), false);
                            if (value != null) {
                                return value.toString();
                            }
                        }
                        catch (Exception value4) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        try {
            value = ReflectionValueExtractor.evaluate(subExpr, model, false);
            if (value != null) {
                return value.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static interface InnerInterpolator {
        public String interpolate(String var1);
    }
}

