/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Named(value="reactor")
@SessionScoped
class ReactorReader
implements MavenWorkspaceReader {
    public static final String HINT = "reactor";
    private static final Collection<String> COMPILE_PHASE_TYPES = Arrays.asList("jar", "ejb-client", "war", "rar", "ejb3", "par", "sar", "wsr", "har", "app-client");
    private final MavenSession session;
    private final Map<String, MavenProject> projectsByGAV;
    private final Map<String, List<MavenProject>> projectsByGA;
    private final WorkspaceRepository repository;
    private Function<MavenProject, String> projectIntoKey = s -> ArtifactUtils.key((String)s.getGroupId(), (String)s.getArtifactId(), (String)s.getVersion());
    private Function<MavenProject, String> projectIntoVersionlessKey = s -> ArtifactUtils.versionlessKey((String)s.getGroupId(), (String)s.getArtifactId());

    @Inject
    ReactorReader(MavenSession session) {
        this.session = session;
        this.projectsByGAV = session.getProjects().stream().collect(Collectors.toMap(this.projectIntoKey, Function.identity()));
        this.projectsByGA = this.projectsByGAV.values().stream().collect(Collectors.groupingBy(this.projectIntoVersionlessKey));
        this.repository = new WorkspaceRepository(HINT, new HashSet<String>(this.projectsByGAV.keySet()));
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        String projectKey = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion());
        MavenProject project = this.projectsByGAV.get(projectKey);
        if (project != null) {
            File file = this.find(project, artifact);
            if (file == null && project != project.getExecutionProject()) {
                file = this.find(project.getExecutionProject(), artifact);
            }
            return file;
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        String key = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        return Optional.ofNullable(this.projectsByGA.get(key)).orElse(Collections.emptyList()).stream().filter(s -> Objects.nonNull(this.find((MavenProject)s, artifact))).map(MavenProject::getVersion).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public Model findModel(Artifact artifact) {
        String projectKey = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion());
        MavenProject project = this.projectsByGAV.get(projectKey);
        return project == null ? null : project.getModel();
    }

    private File find(MavenProject project, Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return project.getFile();
        }
        Artifact projectArtifact = this.findMatchingArtifact(project, artifact);
        if (this.hasArtifactFileFromPackagePhase(projectArtifact)) {
            return projectArtifact.getFile();
        }
        if (!this.hasBeenPackaged(project)) {
            if (ReactorReader.isTestArtifact(artifact)) {
                if (project.hasLifecyclePhase("test-compile")) {
                    return new File(project.getBuild().getTestOutputDirectory());
                }
            } else {
                String type = artifact.getProperty("type", "");
                if (project.hasLifecyclePhase("compile") && COMPILE_PHASE_TYPES.contains(type)) {
                    return new File(project.getBuild().getOutputDirectory());
                }
            }
        }
        return null;
    }

    private File determinePreviouslyPackagedArtifactFile(MavenProject project, Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String fileName = String.format("%s.%s", project.getBuild().getFinalName(), artifact.getExtension());
        return new File(project.getBuild().getDirectory(), fileName);
    }

    private boolean hasArtifactFileFromPackagePhase(Artifact projectArtifact) {
        return projectArtifact != null && projectArtifact.getFile() != null && projectArtifact.getFile().exists();
    }

    private boolean hasBeenPackaged(MavenProject project) {
        return project.hasLifecyclePhase("package") || project.hasLifecyclePhase("install") || project.hasLifecyclePhase("deploy");
    }

    private Artifact findMatchingArtifact(MavenProject project, Artifact requestedArtifact) {
        Artifact mainArtifact;
        String requestedRepositoryConflictId = ArtifactIdUtils.toVersionlessId((Artifact)requestedArtifact);
        if (requestedRepositoryConflictId.equals(ArtifactIdUtils.toVersionlessId((Artifact)(mainArtifact = RepositoryUtils.toArtifact(project.getArtifact()))))) {
            return mainArtifact;
        }
        return RepositoryUtils.toArtifacts(project.getAttachedArtifacts()).stream().filter(this.isRequestedArtifact(requestedArtifact)).findFirst().orElse(null);
    }

    private Predicate<Artifact> isRequestedArtifact(Artifact requestArtifact) {
        return s -> s.getArtifactId().equals(requestArtifact.getArtifactId()) && s.getGroupId().equals(requestArtifact.getGroupId()) && s.getVersion().equals(requestArtifact.getVersion()) && s.getExtension().equals(requestArtifact.getExtension()) && s.getClassifier().equals(requestArtifact.getClassifier());
    }

    private static boolean isTestArtifact(Artifact artifact) {
        return "test-jar".equals(artifact.getProperty("type", "")) || "jar".equals(artifact.getExtension()) && "tests".equals(artifact.getClassifier());
    }
}

