/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class JavadocWarningsTextToXml {
    private static final int ARGS_LENGTH = 3;
    private static final int PADDING = 10;
    private String inputFileName;
    private String outputEncoding;
    private String outputFileName;
    private boolean verbose = false;

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            throw new IllegalArgumentException("Wrong number of arguments");
        }
        JavadocWarningsTextToXml runner = new JavadocWarningsTextToXml();
        int i = 0;
        runner.setInputFileName(args[i++]);
        runner.setOutputFileName(args[i++]);
        runner.setOutputEncoding(args[i++]);
        runner.build();
    }

    public void setInputFileName(String inputFileNameValue) {
        if (this.isVerbose()) {
            System.out.println("Setting input file name: '" + inputFileNameValue + "'");
        }
        this.inputFileName = inputFileNameValue;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setOutputEncoding(String outputEncodingValue) {
        this.outputEncoding = outputEncodingValue;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputFileName(String outputFileNameValue) {
        if (this.isVerbose()) {
            System.out.println("Setting output file name: '" + outputFileNameValue + "'");
        }
        this.outputFileName = outputFileNameValue;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setVerbose(boolean verboseValue) {
        this.verbose = verboseValue;
        if (this.isVerbose()) {
            System.out.println("verbose is true");
        }
    }

    public void build() throws FileNotFoundException, IOException, UnsupportedEncodingException {
        if (StringUtils.isBlank((String)this.getInputFileName())) {
            throw new IllegalArgumentException("Input file name must be specified");
        }
        if (StringUtils.isBlank((String)this.getOutputFileName())) {
            throw new IllegalArgumentException("Output file name must be specified");
        }
        String[] lines = this.readInput();
        Map fileMap = this.buildMap(lines);
        this.buildOutput(fileMap);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private Map buildMap(String[] input) {
        if (this.isVerbose()) {
            System.out.println("Building map from " + input.length + " input line(s)");
        }
        TreeMap files = new TreeMap();
        for (int i = 0; i < input.length; ++i) {
            String line = input[i];
            if (this.isVerbose()) {
                System.out.println("Parsing line " + line);
            }
            try {
                Set lineMessages;
                Integer lineNumberInt;
                int javaDocStart = line.indexOf("[javadoc]");
                int fileNameStart = javaDocStart += 10;
                int warningStart = line.indexOf("warning - ");
                int fileNameEnd = warningStart - 1;
                String fileNameAndLineNumber = line.substring(fileNameStart, fileNameEnd);
                int lastColon = fileNameAndLineNumber.lastIndexOf(58);
                int nextToLastColon = fileNameAndLineNumber.lastIndexOf(58, lastColon - 1);
                String fileName = fileNameAndLineNumber.substring(0, nextToLastColon);
                String lineNumber = fileNameAndLineNumber.substring(nextToLastColon + 1, lastColon);
                int msgStart = warningStart + 10;
                String msg = line.substring(msgStart);
                try {
                    lineNumberInt = new Integer(lineNumber);
                }
                catch (NumberFormatException nfe) {
                    fileName = fileNameAndLineNumber.substring(0, lastColon);
                    System.err.println("*** WARNING: no line number found in '" + fileName + "', setting to 0.");
                    lineNumberInt = new Integer(0);
                }
                TreeMap<Integer, Set> fileMessages = (TreeMap<Integer, Set>)files.get(fileName);
                if (fileMessages == null) {
                    fileMessages = new TreeMap<Integer, Set>();
                    files.put(fileName, fileMessages);
                }
                if ((lineMessages = (Set)fileMessages.get(lineNumberInt)) == null) {
                    lineMessages = SetUtils.orderedSet(new TreeSet());
                    fileMessages.put(lineNumberInt, lineMessages);
                }
                lineMessages.add(msg);
                continue;
            }
            catch (Throwable t) {
                System.err.println("*** WARNING: exception parsing line '" + line + "': " + t.getMessage());
                if (!this.isVerbose()) continue;
                t.printStackTrace();
            }
        }
        return files;
    }

    private void buildOutput(Map fileMap) throws FileNotFoundException, UnsupportedEncodingException {
        File output = new File(this.outputFileName);
        File dir = output.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), this.getOutputEncoding()));
        this.writeOutput(fileMap, out);
        out.flush();
        out.close();
    }

    private String[] readInput() throws FileNotFoundException, IOException {
        if (this.isVerbose()) {
            System.out.println("Reading '" + this.getInputFileName() + "'");
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.getInputFileName()));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("warning - ") < 0) continue;
            lines.add(line);
        }
        reader.close();
        if (this.isVerbose()) {
            System.out.println("Read " + lines.size() + " line(s) from input file");
        }
        return lines.toArray(new String[lines.size()]);
    }

    private void writeOutput(Map fileMap, PrintWriter out) {
        if (this.isVerbose()) {
            System.out.println("Writing to output file '" + this.outputFileName);
        }
        out.println("<?xml version=\"1.0\" encoding=\"" + this.getOutputEncoding() + "\"?>");
        out.println("<javadoc>");
        Iterator fileMapIterator = fileMap.keySet().iterator();
        while (fileMapIterator.hasNext()) {
            String fileName = (String)fileMapIterator.next();
            out.println("<file name=\"" + fileName + "\">");
            Map fileMessages = (Map)fileMap.get(fileName);
            Iterator fileMessagesIterator = fileMessages.entrySet().iterator();
            while (fileMessagesIterator.hasNext()) {
                Map.Entry entry = fileMessagesIterator.next();
                Integer lineNumber = (Integer)entry.getKey();
                Set lineMessages = (Set)entry.getValue();
                Iterator lineMessagesIterator = lineMessages.iterator();
                while (lineMessagesIterator.hasNext()) {
                    String msg = (String)lineMessagesIterator.next();
                    out.println("<error line=\"" + lineNumber + "\" severity=\"warning\" message=\"" + StringEscapeUtils.escapeXml((String)msg) + "\"/>");
                }
            }
            out.println("</file>");
        }
        out.println("</javadoc>");
        if (this.isVerbose()) {
            System.out.println("Finished writing output file");
        }
    }
}

