/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.model.Branch;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.PackageGroup;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.SourceModification;
import org.apache.maven.model.UnitTest;
import org.apache.maven.model.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenStaxReader {
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        int eventType = xmlStreamReader.getEventType();
        while (xmlStreamReader.hasNext()) {
            if (eventType == 1) {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (xmlStreamReader.isEndElement()) {
                    values.add(null);
                } else {
                    values.add(new StringBuffer());
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    String value = xmlStreamReader.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append(text);
            } else if (eventType == 2) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private Branch parseBranch(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Branch branch = new Branch();
        branch.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("tag")) {
                if (parsed.contains("tag")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("tag");
                branch.setTag(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return branch;
    }

    private Build parseBuild(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Build build = new Build();
        build.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("nagEmailAddress")) {
                if (parsed.contains("nagEmailAddress")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("nagEmailAddress");
                build.setNagEmailAddress(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("sourceDirectory")) {
                if (parsed.contains("sourceDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("sourceDirectory");
                build.setSourceDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("unitTestSourceDirectory")) {
                if (parsed.contains("unitTestSourceDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("unitTestSourceDirectory");
                build.setUnitTestSourceDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("aspectSourceDirectory")) {
                if (parsed.contains("aspectSourceDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("aspectSourceDirectory");
                build.setAspectSourceDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("integrationUnitTestSourceDirectory")) {
                if (parsed.contains("integrationUnitTestSourceDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("integrationUnitTestSourceDirectory");
                build.setIntegrationUnitTestSourceDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("sourceModifications")) {
                if (parsed.contains("sourceModifications")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("sourceModifications");
                ArrayList sourceModifications = new ArrayList();
                build.setSourceModifications(sourceModifications);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("sourceModification")) {
                        build.addSourceModification(this.parseSourceModification("sourceModification", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("unitTest")) {
                if (parsed.contains("unitTest")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("unitTest");
                build.setUnitTest(this.parseUnitTest("unitTest", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("defaultGoal")) {
                if (parsed.contains("defaultGoal")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("defaultGoal");
                build.setDefaultGoal(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resources");
                ArrayList resources = new ArrayList();
                build.setResources(resources);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("resource")) {
                        build.addResource(this.parseResource("resource", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return build;
    }

    private BuildBase parseBuildBase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        BuildBase buildBase = new BuildBase();
        buildBase.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("defaultGoal")) {
                if (parsed.contains("defaultGoal")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("defaultGoal");
                buildBase.setDefaultGoal(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resources");
                ArrayList resources = new ArrayList();
                buildBase.setResources(resources);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("resource")) {
                        buildBase.addResource(this.parseResource("resource", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return buildBase;
    }

    private Contributor parseContributor(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Contributor contributor = new Contributor();
        contributor.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                contributor.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("email")) {
                if (parsed.contains("email")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("email");
                contributor.setEmail(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                contributor.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("organization") || xmlStreamReader.getLocalName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("organization");
                contributor.setOrganization(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("organizationUrl") || xmlStreamReader.getLocalName().equals("organisationUrl")) {
                if (parsed.contains("organizationUrl")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("organizationUrl");
                contributor.setOrganizationUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("roles");
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("role")) {
                        roles.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("timezone")) {
                if (parsed.contains("timezone")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("timezone");
                contributor.setTimezone(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("properties");
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    contributor.addProperty(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return contributor;
    }

    private Dependency parseDependency(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Dependency dependency = new Dependency();
        dependency.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                dependency.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("groupId");
                dependency.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("artifactId");
                dependency.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("version");
                dependency.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                dependency.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("jar")) {
                if (parsed.contains("jar")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("jar");
                dependency.setJar(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("type");
                dependency.setType(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("properties");
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    dependency.addProperty(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return dependency;
    }

    private Developer parseDeveloper(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Developer developer = new Developer();
        developer.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                developer.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                developer.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("email")) {
                if (parsed.contains("email")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("email");
                developer.setEmail(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                developer.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("organization") || xmlStreamReader.getLocalName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("organization");
                developer.setOrganization(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("organizationUrl") || xmlStreamReader.getLocalName().equals("organisationUrl")) {
                if (parsed.contains("organizationUrl")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("organizationUrl");
                developer.setOrganizationUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("roles");
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("role")) {
                        roles.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("timezone")) {
                if (parsed.contains("timezone")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("timezone");
                developer.setTimezone(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("properties");
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    developer.addProperty(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return developer;
    }

    private FileSet parseFileSet(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        FileSet fileSet = new FileSet();
        fileSet.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("directory");
                fileSet.setDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("include")) {
                        includes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return fileSet;
    }

    private License parseLicense(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        License license = new License();
        license.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                license.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                license.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("distribution")) {
                if (parsed.contains("distribution")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("distribution");
                license.setDistribution(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("comments")) {
                if (parsed.contains("comments")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("comments");
                license.setComments(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return license;
    }

    private MailingList parseMailingList(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        MailingList mailingList = new MailingList();
        mailingList.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                mailingList.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("subscribe")) {
                if (parsed.contains("subscribe")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("subscribe");
                mailingList.setSubscribe(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("unsubscribe")) {
                if (parsed.contains("unsubscribe")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("unsubscribe");
                mailingList.setUnsubscribe(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("post")) {
                if (parsed.contains("post")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("post");
                mailingList.setPost(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("archive")) {
                if (parsed.contains("archive")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("archive");
                mailingList.setArchive(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("otherArchives")) {
                if (parsed.contains("otherArchives")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("otherArchives");
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("otherArchive")) {
                        otherArchives.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return mailingList;
    }

    private Model parseModel(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Model model = new Model();
        model.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        boolean foundRoot = false;
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            if (xmlStreamReader.getLocalName().equals(tagName)) {
                foundRoot = true;
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("extend")) {
                if (parsed.contains("extend")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("extend");
                model.setExtend(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("pomVersion")) {
                if (parsed.contains("pomVersion")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("pomVersion");
                model.setPomVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("groupId");
                model.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("artifactId");
                model.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                model.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                model.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("currentVersion")) {
                if (parsed.contains("currentVersion")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("currentVersion");
                model.setCurrentVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("shortDescription")) {
                if (parsed.contains("shortDescription")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("shortDescription");
                model.setShortDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                model.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                model.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("logo")) {
                if (parsed.contains("logo")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("logo");
                model.setLogo(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("issueTrackingUrl")) {
                if (parsed.contains("issueTrackingUrl")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("issueTrackingUrl");
                model.setIssueTrackingUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("inceptionYear")) {
                if (parsed.contains("inceptionYear")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("inceptionYear");
                model.setInceptionYear(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("gumpRepositoryId")) {
                if (parsed.contains("gumpRepositoryId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("gumpRepositoryId");
                model.setGumpRepositoryId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("siteAddress")) {
                if (parsed.contains("siteAddress")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("siteAddress");
                model.setSiteAddress(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("siteDirectory")) {
                if (parsed.contains("siteDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("siteDirectory");
                model.setSiteDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("distributionSite")) {
                if (parsed.contains("distributionSite")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("distributionSite");
                model.setDistributionSite(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("distributionDirectory")) {
                if (parsed.contains("distributionDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("distributionDirectory");
                model.setDistributionDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("mailingLists")) {
                if (parsed.contains("mailingLists")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("mailingLists");
                ArrayList mailingLists = new ArrayList();
                model.setMailingLists(mailingLists);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("mailingList")) {
                        model.addMailingList(this.parseMailingList("mailingList", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("developers")) {
                if (parsed.contains("developers")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("developers");
                ArrayList developers = new ArrayList();
                model.setDevelopers(developers);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("developer")) {
                        model.addDeveloper(this.parseDeveloper("developer", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("contributors")) {
                if (parsed.contains("contributors")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("contributors");
                ArrayList contributors = new ArrayList();
                model.setContributors(contributors);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("contributor")) {
                        model.addContributor(this.parseContributor("contributor", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("licenses")) {
                if (parsed.contains("licenses")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("licenses");
                ArrayList licenses = new ArrayList();
                model.setLicenses(licenses);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("license")) {
                        model.addLicense(this.parseLicense("license", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("versions")) {
                if (parsed.contains("versions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("versions");
                ArrayList versions = new ArrayList();
                model.setVersions(versions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("version")) {
                        model.addVersion(this.parseVersion("version", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("branches")) {
                if (parsed.contains("branches")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("branches");
                ArrayList branches = new ArrayList();
                model.setBranches(branches);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("branch")) {
                        model.addBranch(this.parseBranch("branch", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("packageGroups")) {
                if (parsed.contains("packageGroups")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("packageGroups");
                ArrayList packageGroups = new ArrayList();
                model.setPackageGroups(packageGroups);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("packageGroup")) {
                        model.addPackageGroup(this.parsePackageGroup("packageGroup", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("reports")) {
                if (parsed.contains("reports")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("reports");
                ArrayList<String> reports = new ArrayList<String>();
                model.setReports(reports);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("report")) {
                        reports.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("repository")) {
                if (parsed.contains("repository")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("repository");
                model.setRepository(this.parseRepository("repository", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("organization") || xmlStreamReader.getLocalName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("organization");
                model.setOrganization(this.parseOrganization("organization", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("properties");
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    model.addProperty(key, value);
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("package")) {
                if (parsed.contains("package")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("package");
                model.setPackageName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("build")) {
                if (parsed.contains("build")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("build");
                model.setBuild(this.parseBuild("build", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("dependencies");
                ArrayList dependencies = new ArrayList();
                model.setDependencies(dependencies);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("dependency")) {
                        model.addDependency(this.parseDependency("dependency", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!foundRoot || !strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return model;
    }

    private ModelBase parseModelBase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ModelBase modelBase = new ModelBase();
        modelBase.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("dependencies");
                ArrayList dependencies = new ArrayList();
                modelBase.setDependencies(dependencies);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("dependency")) {
                        modelBase.addDependency(this.parseDependency("dependency", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return modelBase;
    }

    private Organization parseOrganization(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Organization organization = new Organization();
        organization.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                organization.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                organization.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("logo")) {
                if (parsed.contains("logo")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("logo");
                organization.setLogo(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return organization;
    }

    private PackageGroup parsePackageGroup(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        PackageGroup packageGroup = new PackageGroup();
        packageGroup.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("title")) {
                if (parsed.contains("title")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("title");
                packageGroup.setTitle(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("packages")) {
                if (parsed.contains("packages")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("packages");
                packageGroup.setPackages(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return packageGroup;
    }

    private PatternSet parsePatternSet(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        PatternSet patternSet = new PatternSet();
        patternSet.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("include")) {
                        includes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return patternSet;
    }

    private PluginConfiguration parsePluginConfiguration(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setModelEncoding(encoding);
        HashSet parsed = new HashSet();
        while (xmlStreamReader.nextTag() == 1) {
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        PluginContainer pluginContainer = new PluginContainer();
        pluginContainer.setModelEncoding(encoding);
        HashSet parsed = new HashSet();
        while (xmlStreamReader.nextTag() == 1) {
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return pluginContainer;
    }

    private Repository parseRepository(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Repository repository = new Repository();
        repository.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("connection")) {
                if (parsed.contains("connection")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("connection");
                repository.setConnection(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("developerConnection")) {
                if (parsed.contains("developerConnection")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("developerConnection");
                repository.setDeveloperConnection(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                repository.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return repository;
    }

    private Resource parseResource(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Resource resource = new Resource();
        resource.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("targetPath")) {
                if (parsed.contains("targetPath")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("targetPath");
                resource.setTargetPath(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("filtering")) {
                if (parsed.contains("filtering")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("filtering");
                resource.setFiltering(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "filtering", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("directory");
                resource.setDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("include")) {
                        includes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return resource;
    }

    private SourceModification parseSourceModification(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        SourceModification sourceModification = new SourceModification();
        sourceModification.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("className")) {
                if (parsed.contains("className")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("className");
                sourceModification.setClassName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("property")) {
                if (parsed.contains("property")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("property");
                sourceModification.setProperty(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("directory");
                sourceModification.setDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                sourceModification.setIncludes(includes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("include")) {
                        includes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                sourceModification.setExcludes(excludes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return sourceModification;
    }

    private UnitTest parseUnitTest(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        UnitTest unitTest = new UnitTest();
        unitTest.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resources");
                ArrayList resources = new ArrayList();
                unitTest.setResources(resources);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("resource")) {
                        unitTest.addResource(this.parseResource("resource", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                unitTest.setIncludes(includes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("include")) {
                        includes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                unitTest.setExcludes(excludes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("exclude")) {
                        excludes.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return unitTest;
    }

    private Version parseVersion(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Version version = new Version();
        version.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                version.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("tag")) {
                if (parsed.contains("tag")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("tag");
                version.setTag(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                version.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return version;
    }

    public Model read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        Model value = this.parseModel("project", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public Model read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public Model read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURL().toExternalForm(), new FileInputStream(file));
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        Model value = this.parseModel("project", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public Model read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private void resolveReferences(Model value) {
    }
}

