/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.linkcheck.validation;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.linkcheck.validation.HTTPLinkValidator;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationItem;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationResult;

public final class OnlineHTTPLinkValidator
extends HTTPLinkValidator {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$plugin$linkcheck$validation$OnlineHTTPLinkValidator == null ? (class$org$apache$maven$plugin$linkcheck$validation$OnlineHTTPLinkValidator = OnlineHTTPLinkValidator.class$("org.apache.maven.plugin.linkcheck.validation.OnlineHTTPLinkValidator")) : class$org$apache$maven$plugin$linkcheck$validation$OnlineHTTPLinkValidator));
    private static final int MAX_NB_REDIRECT = 10;
    private static final String GET_METHOD = "get";
    private static final String HEAD_METHOD = "head";
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPass;
    private String proxyNtlmHost;
    private String proxyNtlmDomain;
    private String method = "head";
    private transient HttpClient cl;
    static /* synthetic */ Class class$org$apache$maven$plugin$linkcheck$validation$OnlineHTTPLinkValidator;

    public OnlineHTTPLinkValidator(String method, String proxyHost, String proxyPort, String proxyUser, String proxyPass, String proxyNtlmHost, String proxyNtlmDomain) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Will use method : [" + method + "]"));
        }
        this.method = method;
        if (proxyHost == null || proxyHost.trim().equals("")) {
            this.proxyHost = null;
        } else {
            this.proxyHost = proxyHost;
            if (proxyPort != null) {
                try {
                    this.proxyPort = Integer.parseInt(proxyPort);
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Invalid number for Proxy Port:" + proxyPort));
                    LOG.warn((Object)"Proxy Port won't be used.");
                    this.proxyPort = -1;
                }
            }
            this.proxyUser = proxyUser;
            this.proxyPass = proxyPass;
            if (proxyNtlmHost != null && !proxyNtlmHost.trim().equals("")) {
                this.proxyNtlmHost = proxyNtlmHost;
                this.proxyNtlmDomain = proxyNtlmDomain;
            }
        }
        this.initHttpClient();
    }

    public LinkValidationResult validateLink(LinkValidationItem lvi) {
        if (this.cl == null) {
            this.initHttpClient();
        }
        try {
            String link = lvi.getLink();
            HttpMethod hm = null;
            try {
                hm = this.checkLink(this.cl, link, 0);
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Received: [" + t + "] for [" + lvi.getLink() + "] in page [" + lvi.getSource() + "]"), t);
                } else {
                    LOG.error((Object)("Received: [" + t + "] for [" + lvi.getLink() + "] in page [" + lvi.getSource() + "]"));
                }
                return new LinkValidationResult(1, false, t.getClass().getName() + " : " + t.getMessage());
            }
            if (hm == null) {
                return new LinkValidationResult(1, false, "Cannot retreive HTTP Status");
            }
            if (hm.getStatusCode() == 200) {
                return new LinkValidationResult(2, true, hm.getStatusCode() + " " + hm.getStatusText());
            }
            if (hm.getStatusCode() == 301 || hm.getStatusCode() == 302 || hm.getStatusCode() == 307) {
                LOG.warn((Object)("Received: [" + hm.getStatusCode() + "] for [" + lvi.getLink() + "] in page [" + lvi.getSource() + "]"));
                return new LinkValidationResult(4, true, hm.getStatusCode() + " " + hm.getStatusText());
            }
            LOG.error((Object)("Received: [" + hm.getStatusCode() + "] for [" + lvi.getLink() + "] in page [" + lvi.getSource() + "]"));
            return new LinkValidationResult(1, false, hm.getStatusCode() + " " + hm.getStatusText());
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Received: [" + t + "] for [" + lvi.getLink() + "] in page [" + lvi.getSource() + "]"), t);
            } else {
                LOG.error((Object)("Received: [" + t + "] for [" + lvi.getLink() + "] in page [" + lvi.getSource() + "]"));
            }
            return new LinkValidationResult(1, false, t.getMessage());
        }
    }

    private void initHttpClient() {
        LOG.debug((Object)"A new HttpClient instance is needed ...");
        System.setProperty("httpclient.useragent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        this.cl = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        HostConfiguration hc = new HostConfiguration();
        HttpState state = new HttpState();
        if (this.proxyHost != null) {
            hc.setProxy(this.proxyHost, this.proxyPort);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Proxy Host:" + this.proxyHost));
                LOG.debug((Object)("Proxy Port:" + this.proxyPort));
            }
            if (this.proxyUser != null && this.proxyPass != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Proxy User:" + this.proxyUser));
                }
                Object credentials = this.proxyNtlmHost != null ? new NTCredentials(this.proxyUser, this.proxyPass, this.proxyNtlmHost, this.proxyNtlmDomain) : new UsernamePasswordCredentials(this.proxyUser, this.proxyPass);
                state.setProxyCredentials(null, null, (Credentials)credentials);
            }
        } else {
            LOG.debug((Object)"Not using a proxy");
        }
        this.cl.setHostConfiguration(hc);
        this.cl.setState(state);
        LOG.debug((Object)"New HttpClient instance created.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpMethod checkLink(HttpClient cl, String link, int nbRedirect) throws HttpException, IOException {
        if (nbRedirect > 10) {
            throw new HttpException("Maximum number of redirections (10) exceeded");
        }
        Object hm = HEAD_METHOD.equals(this.method) ? new HeadMethod(link) : new GetMethod(link);
        try {
            hm.setFollowRedirects(false);
            URL url = new URL(link);
            cl.getHostConfiguration().setHost(url.getHost(), url.getPort(), url.getProtocol());
            cl.executeMethod((HttpMethod)hm);
            StatusLine sl = hm.getStatusLine();
            if (sl == null) {
                LOG.error((Object)("Unknown error validating link : " + link));
                HttpMethod httpMethod = null;
                return httpMethod;
            }
            if (hm.getStatusCode() == 301 || hm.getStatusCode() == 302 || hm.getStatusCode() == 307) {
                Header locationHeader = hm.getResponseHeader("location");
                if (locationHeader == null) {
                    LOG.error((Object)"Site sent redirect, but did not set Location header");
                    HeadMethod headMethod = hm;
                    return headMethod;
                }
                String newLink = locationHeader.getValue();
                if (!newLink.startsWith("http://") && !newLink.startsWith("https://")) {
                    if (newLink.startsWith("/")) {
                        URL oldUrl = new URL(link);
                        newLink = oldUrl.getProtocol() + "://" + oldUrl.getHost() + (oldUrl.getPort() > 0 ? ":" + oldUrl.getPort() : "") + newLink;
                    } else {
                        newLink = link + newLink;
                    }
                }
                HeadMethod oldHm = hm;
                LOG.info((Object)("[" + link + "] is redirected to [" + newLink + "]"));
                oldHm.releaseConnection();
                hm = this.checkLink(cl, newLink, nbRedirect + 1);
                if (hm.getStatusCode() == 200 && nbRedirect == 0) {
                    HeadMethod headMethod = oldHm;
                    return headMethod;
                }
            }
        }
        finally {
            hm.releaseConnection();
        }
        return hm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

