/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.linkcheck.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationItem;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationResult;
import org.apache.maven.plugin.linkcheck.validation.LinkValidator;

public class LinkValidatorManager
implements Serializable {
    private static final long serialVersionUID = 2467928182206500945L;
    private static Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$plugin$linkcheck$validation$LinkValidatorManager == null ? (class$org$apache$maven$plugin$linkcheck$validation$LinkValidatorManager = LinkValidatorManager.class$("org.apache.maven.plugin.linkcheck.validation.LinkValidatorManager")) : class$org$apache$maven$plugin$linkcheck$validation$LinkValidatorManager));
    private List validators = new LinkedList();
    private String[] excludes = new String[0];
    private Map cache = new HashMap();
    static /* synthetic */ Class class$org$apache$maven$plugin$linkcheck$validation$LinkValidatorManager;

    public List getValidators() {
        return this.validators;
    }

    public String getExclude() {
        return this.excludes[0];
    }

    public void setExclude(String exclude) {
        this.excludes = new String[]{exclude};
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void addLinkValidator(LinkValidator lv) {
        this.validators.add(lv);
    }

    public LinkValidationResult validateLink(LinkValidationItem lvi) throws Exception {
        LinkValidationResult lvr;
        Object resourceKey;
        LinkValidator lv;
        LinkValidationResult status = this.getCachedResult(lvi);
        if (status != null) {
            return status;
        }
        for (int i = 0; i < this.excludes.length; ++i) {
            if (this.excludes[i] == null || !lvi.getLink().startsWith(this.excludes[i])) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Excluded " + lvi.getLink()));
            }
            return new LinkValidationResult(2, false, "");
        }
        Iterator iter = this.validators.iterator();
        while (iter.hasNext()) {
            lv = (LinkValidator)iter.next();
            resourceKey = lv.getResourceKey(lvi);
            if (resourceKey == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(lv.getClass().getName() + " - Checking link " + lvi.getLink()));
            }
            if ((lvr = lv.validateLink(lvi)).getStatus() == 0) continue;
            this.setCachedResult(resourceKey, lvr);
            return lvr;
        }
        lv = null;
        resourceKey = null;
        lvr = null;
        LOG.error((Object)("Unable to validate link : " + lvi.getLink()));
        return new LinkValidationResult(3, false, "No validator found for this link");
    }

    public void loadCache(String cacheFilename) {
        try {
            File f = new File(cacheFilename);
            if (f.exists()) {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(cacheFilename));
                this.cache = (Map)is.readObject();
                is.close();
            }
        }
        catch (InvalidClassException e) {
            LOG.warn((Object)"Your cache is incompatible with this new release of the plugin. It will be recreated.");
        }
        catch (Throwable t) {
            LOG.error((Object)"Unable to load the cache", t);
        }
    }

    public void saveCache(String cacheFilename) {
        try {
            Object resourceKey;
            HashMap persistentCache = new HashMap();
            Iterator iter = this.cache.keySet().iterator();
            while (iter.hasNext()) {
                resourceKey = iter.next();
                if (!((LinkValidationResult)this.cache.get(resourceKey)).isPersistent()) continue;
                persistentCache.put(resourceKey, this.cache.get(resourceKey));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("[" + resourceKey + "] with result [" + this.cache.get(resourceKey) + "] is stored in the cache."));
            }
            File cacheFile = new File(cacheFilename);
            File dir = cacheFile.getParentFile();
            if (dir != null) {
                dir.mkdirs();
            }
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(cacheFilename));
            os.writeObject(persistentCache);
            os.close();
            persistentCache = null;
            iter = null;
            resourceKey = null;
            cacheFile = null;
            dir = null;
            os = null;
        }
        catch (Throwable t) {
            LOG.error((Object)"Unable to save the cache", t);
        }
    }

    public LinkValidationResult getCachedResult(LinkValidationItem lvi) {
        Object resourceKey;
        LinkValidator lv;
        Iterator iter = this.getValidators().iterator();
        while (iter.hasNext()) {
            lv = (LinkValidator)iter.next();
            resourceKey = lv.getResourceKey(lvi);
            if (resourceKey == null || !this.cache.containsKey(resourceKey)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The cache returns for [" + resourceKey + "] the result [" + this.cache.get(resourceKey) + "]."));
            }
            return (LinkValidationResult)this.cache.get(resourceKey);
        }
        lv = null;
        resourceKey = null;
        return null;
    }

    public void setCachedResult(Object resourceKey, LinkValidationResult lvr) {
        this.cache.put(resourceKey, lvr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

