/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.linkcheck;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.linkcheck.FileToCheck;
import org.apache.maven.plugin.linkcheck.validation.FileLinkValidator;
import org.apache.maven.plugin.linkcheck.validation.LinkValidatorManager;
import org.apache.maven.plugin.linkcheck.validation.MailtoLinkValidator;
import org.apache.maven.plugin.linkcheck.validation.OfflineHTTPLinkValidator;
import org.apache.maven.plugin.linkcheck.validation.OnlineHTTPLinkValidator;
import org.apache.maven.project.Project;

public final class LinkCheck {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$plugin$linkcheck$LinkCheck == null ? (class$org$apache$maven$plugin$linkcheck$LinkCheck = LinkCheck.class$("org.apache.maven.plugin.linkcheck.LinkCheck")) : class$org$apache$maven$plugin$linkcheck$LinkCheck));
    private static final FilenameFilter CUSTOM_FF = new CustomFilenameFilter();
    private static final long MEG = 0x100000L;
    private static final String MAVEN_PROXY_HOST = "maven.linkcheck.proxy.host";
    private static final String MAVEN_PROXY_PORT = "maven.linkcheck.proxy.port";
    private static final String MAVEN_PROXY_USERNAME = "maven.linkcheck.proxy.username";
    private static final String MAVEN_PROXY_PASSWORD = "maven.linkcheck.proxy.password";
    private static final String MAVEN_PROXY_NTLM_HOST = "maven.linkcheck.proxy.ntlm.host";
    private static final String MAVEN_PROXY_NTLM_DOMAIN = "maven.linkcheck.proxy.ntlm.domain";
    private File basedir;
    private String cache;
    private String exclude;
    private String method;
    private List filesToCheck = null;
    private LinkValidatorManager lvm = null;
    private File output;
    private String outputEncoding;
    private Project project;
    static /* synthetic */ Class class$org$apache$maven$plugin$linkcheck$LinkCheck;

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File base) {
        this.basedir = base;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List getFiles() {
        return this.filesToCheck;
    }

    public LinkValidatorManager getLinkValidatorManager() {
        if (this.lvm == null) {
            this.lvm = new LinkValidatorManager();
            if (this.exclude != null) {
                StringTokenizer st = new StringTokenizer(this.exclude, " ,\t\n\r\f");
                String[] tokens = new String[st.countTokens()];
                for (int i = 0; i < tokens.length; ++i) {
                    tokens[i] = st.nextToken();
                }
                this.lvm.setExcludes(tokens);
                tokens = null;
                st = null;
            }
            this.lvm.addLinkValidator(new FileLinkValidator());
            if (this.getProject() != null) {
                MavenJellyContext ctx = ((Project)this.getProject()).getContext();
                if (ctx.getOnline().booleanValue()) {
                    this.lvm.addLinkValidator(new OnlineHTTPLinkValidator(this.getMethod(), (String)ctx.getVariable(MAVEN_PROXY_HOST), (String)ctx.getVariable(MAVEN_PROXY_PORT), (String)ctx.getVariable(MAVEN_PROXY_USERNAME), (String)ctx.getVariable(MAVEN_PROXY_PASSWORD), (String)ctx.getVariable(MAVEN_PROXY_NTLM_HOST), (String)ctx.getVariable(MAVEN_PROXY_NTLM_DOMAIN)));
                } else {
                    this.lvm.addLinkValidator(new OfflineHTTPLinkValidator());
                }
                Object var1_1 = null;
            }
            this.lvm.addLinkValidator(new MailtoLinkValidator());
        }
        return this.lvm;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public Object getProject() {
        return this.project;
    }

    public void setProject(Object project) {
        this.project = (Project)project;
    }

    public void findFiles(List allFiles, File base) {
        File[] f = base.listFiles(CUSTOM_FF);
        if (f != null) {
            File file;
            for (int i = 0; i < f.length; ++i) {
                file = f[i];
                if (file.isDirectory()) {
                    this.findFiles(allFiles, file);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" File - " + file));
                }
                allFiles.add(new FileToCheck(this.basedir, file));
                if (allFiles.size() % 100 != 0) continue;
                LOG.info((Object)("Found " + allFiles.size() + " files so far."));
            }
            file = null;
        }
        f = null;
    }

    public void doExecute() throws FileNotFoundException, IOException, UnsupportedEncodingException {
        FileToCheck flc;
        if (this.output == null) {
            throw new NullPointerException("output must be set");
        }
        if (LOG.isDebugEnabled()) {
            this.displayMemoryConsumption();
        }
        LinkValidatorManager validator = this.getLinkValidatorManager();
        this.filesToCheck = new LinkedList();
        validator.loadCache(this.cache);
        LinkedList files = new LinkedList();
        LOG.debug((Object)"Locating all files to be checked...");
        this.findFiles(files, this.basedir);
        LOG.debug((Object)"Located all files to be checked.");
        LOG.info((Object)("Found " + files.size() + " files to check."));
        this.displayMemoryConsumption();
        LOG.info((Object)"Begin to check links in files...");
        Iterator fileIter = files.iterator();
        while (fileIter.hasNext()) {
            flc = (FileToCheck)fileIter.next();
            try {
                this.filesToCheck.add(flc);
                flc.check(validator);
            }
            catch (Exception e) {
                LOG.error((Object)("Error while checking : " + flc.getName()), (Throwable)e);
            }
        }
        flc = null;
        LOG.info((Object)"Links checked.");
        this.displayMemoryConsumption();
        this.createDocument(files);
        validator.saveCache(this.cache);
        this.displayMemoryConsumption();
    }

    public String toXML() {
        FileToCheck ftc;
        StringBuffer buf = new StringBuffer();
        buf.append("<linkcheck>\n");
        Iterator iter = this.getFiles().iterator();
        while (iter.hasNext()) {
            ftc = (FileToCheck)iter.next();
            buf.append(ftc.toXML());
        }
        ftc = null;
        buf.append("</linkcheck>\n");
        return buf.toString();
    }

    private void displayMemoryConsumption() {
        if (LOG.isDebugEnabled()) {
            Runtime r = Runtime.getRuntime();
            LOG.debug((Object)("Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M"));
        }
    }

    private void createDocument(List files) throws FileNotFoundException, UnsupportedEncodingException {
        File dir = this.output.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), this.getOutputEncoding()));
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"").append(this.getOutputEncoding()).append("\" ?>\n");
        out.write(buffer.toString());
        out.write(this.toXML());
        out.close();
        out = null;
        buffer = null;
        dir = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CustomFilenameFilter
    implements FilenameFilter {
        CustomFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            File n = new File(dir, name);
            if (n.isDirectory()) {
                return true;
            }
            return name.endsWith(".html");
        }
    }
}

