/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jellydoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import java.beans.Introspector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import org.cyberneko.html.parsers.SAXParser;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class TagXMLDoclet
extends Doclet {
    private String xmlns = "jvx";
    private String encodingFormat = "UTF-8";
    private String localName = "javadoc";
    private ContentHandler cm = null;
    private String targetFileName = null;
    private Attributes emptyAtts = new AttributesImpl();

    public TagXMLDoclet(RootDoc root) throws Exception {
        this.readOptions(root);
        File targetFile = new File(this.targetFileName);
        targetFile.getParentFile().mkdirs();
        FileOutputStream writer = new FileOutputStream(this.targetFileName);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(this.encodingFormat);
        XMLWriter xmlWriter = new XMLWriter((OutputStream)writer, format);
        try {
            this.cm = xmlWriter;
            this.cm.startDocument();
            this.javadocXML(root);
            this.cm.endDocument();
            xmlWriter.close();
        }
        catch (IOException e) {
            xmlWriter.close();
            throw e;
        }
    }

    private void javadocXML(RootDoc root) throws SAXException {
        this.cm.startElement(this.xmlns, this.localName, "tags", this.emptyAtts);
        PackageDoc[] packageArray = root.specifiedPackages();
        for (int i = 0; i < packageArray.length; ++i) {
            this.packageXML(packageArray[i]);
        }
        this.cm.endElement(this.xmlns, this.localName, "tags");
    }

    private void packageXML(PackageDoc packageDoc) throws SAXException {
        System.out.println("processing package: " + packageDoc.name());
        ClassDoc[] classArray = packageDoc.ordinaryClasses();
        boolean foundTag = false;
        for (int i = 0; i < classArray.length; ++i) {
            ClassDoc classDoc = classArray[i];
            if (!this.isTag(classArray[i])) continue;
            foundTag = true;
            break;
        }
        if (!foundTag) {
            System.out.println("no tags found");
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", packageDoc.name());
        String name = packageDoc.name();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            name = name.substring(idx + 1);
        }
        atts.addAttribute(this.xmlns, this.localName, "prefix", "String", name);
        String uri = "jelly:" + name;
        atts.addAttribute(this.xmlns, this.localName, "uri", "String", uri);
        this.cm.startElement(this.xmlns, this.localName, "library", atts);
        this.docXML((Doc)packageDoc);
        for (int i = 0; i < classArray.length; ++i) {
            if (!this.isTag(classArray[i])) continue;
            this.tagXML(classArray[i]);
        }
        this.cm.endElement(this.xmlns, this.localName, "library");
    }

    private boolean isTag(ClassDoc classDoc) {
        ClassDoc[] interfaceArray = classDoc.interfaces();
        for (int i = 0; i < interfaceArray.length; ++i) {
            String name = interfaceArray[i].qualifiedName();
            if (!"org.apache.commons.jelly.Tag".equals(name)) continue;
            return true;
        }
        ClassDoc base = classDoc.superclass();
        if (base != null) {
            return this.isTag(base);
        }
        return false;
    }

    private void tagXML(ClassDoc classDoc) throws SAXException {
        if (classDoc.isAbstract()) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "className", "String", classDoc.name());
        String name = classDoc.name();
        if (name.endsWith("Tag")) {
            name = name.substring(0, name.length() - 3);
        }
        name = Introspector.decapitalize(name);
        System.out.println("processing tag: " + name);
        atts.addAttribute(this.xmlns, this.localName, "name", "String", name);
        this.cm.startElement(this.xmlns, this.localName, "tag", atts);
        this.docXML((Doc)classDoc);
        this.propertiesXML(classDoc);
        this.cm.endElement(this.xmlns, this.localName, "tag");
    }

    private void propertiesXML(ClassDoc classDoc) throws SAXException {
        MethodDoc[] methodArray = classDoc.methods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.propertyXML(methodArray[i]);
        }
        ClassDoc base = classDoc.superclass();
        if (base != null) {
            this.propertiesXML(base);
        }
    }

    private void propertyXML(MethodDoc methodDoc) throws SAXException {
        if (!methodDoc.isPublic() || methodDoc.isStatic()) {
            return;
        }
        String name = methodDoc.name();
        if (!name.startsWith("set")) {
            return;
        }
        Parameter[] parameterArray = methodDoc.parameters();
        if (parameterArray == null || parameterArray.length != 1) {
            return;
        }
        Parameter parameter = parameterArray[0];
        name = name.substring(3);
        if ((name = Introspector.decapitalize(name)).equals("body") || name.equals("context") || name.equals("parent")) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute(this.xmlns, this.localName, "name", "String", name);
        atts.addAttribute(this.xmlns, this.localName, "type", "String", parameter.typeName());
        this.cm.startElement(this.xmlns, this.localName, "attribute", atts);
        this.docXML((Doc)methodDoc);
        this.cm.endElement(this.xmlns, this.localName, "attribute");
    }

    private void docXML(Doc doc) throws SAXException {
        int i;
        this.cm.startElement(this.xmlns, this.localName, "doc", this.emptyAtts);
        Tag[] tags = doc.inlineTags();
        for (i = 0; i < tags.length; ++i) {
            if (tags[i] instanceof SeeTag) {
                String label = ((SeeTag)tags[i]).label();
                if (null == label || "".equals(label)) {
                    String memberName;
                    StringBuffer buf = new StringBuffer();
                    String className = ((SeeTag)tags[i]).referencedClassName();
                    if ("".equals(className)) {
                        className = null;
                    }
                    if ("".equals(memberName = ((SeeTag)tags[i]).referencedMemberName())) {
                        memberName = null;
                    }
                    if (null != className) {
                        buf.append(className);
                        if (null != memberName) {
                            buf.append(".");
                        }
                    }
                    if (null != memberName) {
                        buf.append(memberName);
                    }
                    label = buf.toString();
                }
                this.parseHTML(label);
                continue;
            }
            this.parseHTML(tags[i].text());
        }
        tags = doc.tags();
        for (i = 0; i < tags.length; ++i) {
            this.javadocTagXML(tags[i]);
        }
        this.cm.endElement(this.xmlns, this.localName, "doc");
    }

    protected void parseHTML(String text) throws SAXException {
        SAXParser parser = new SAXParser();
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
        parser.setContentHandler((ContentHandler)new DefaultHandler(){

            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                if (TagXMLDoclet.this.validDocElementName(localName)) {
                    TagXMLDoclet.this.cm.startElement(namespaceURI, localName, qName, atts);
                }
            }

            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                if (TagXMLDoclet.this.validDocElementName(localName)) {
                    TagXMLDoclet.this.cm.endElement(namespaceURI, localName, qName);
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                TagXMLDoclet.this.cm.characters(ch, start, length);
            }
        });
        try {
            parser.parse(new InputSource(new StringReader(text)));
        }
        catch (IOException e) {
            System.err.println("This should never happen!" + e);
        }
    }

    protected boolean validDocElementName(String name) {
        return !name.equalsIgnoreCase("html") && !name.equalsIgnoreCase("body");
    }

    private void javadocTagXML(Tag tag) throws SAXException {
        String name = tag.name().substring(1) + "tag";
        if (!tag.text().equals("")) {
            this.cm.startElement(this.xmlns, this.localName, name, this.emptyAtts);
            this.cm.characters(tag.text().toCharArray(), 0, tag.text().length());
            this.cm.endElement(this.xmlns, this.localName, name);
        }
    }

    public static boolean start(RootDoc root) {
        try {
            new TagXMLDoclet(root);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }

    private void readOptions(RootDoc root) {
        String[][] options = root.options();
        for (int i = 0; i < options.length; ++i) {
            String[] opt = options[i];
            if (opt[0].equals("-d")) {
                this.targetFileName = opt[1] + "/taglib.xml";
            }
            if (!opt[0].equals("-encoding")) continue;
            this.encodingFormat = opt[1];
        }
    }

    public static int optionLength(String option) {
        if (option.equals("-d")) {
            return 2;
        }
        if (option.equals("-encoding")) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean foundEncodingOption = false;
        boolean foundDirOption = false;
        for (int i = 0; i < options.length; ++i) {
            String[] opt = options[i];
            if (opt[0].equals("-d")) {
                if (foundDirOption) {
                    reporter.printError("Only one -d option allowed.");
                    return false;
                }
                foundDirOption = true;
            }
            if (!opt[0].equals("-encoding")) continue;
            if (foundEncodingOption) {
                reporter.printError("Only one -encoding option allowed.");
                return false;
            }
            foundEncodingOption = true;
        }
        if (!foundDirOption) {
            reporter.printError("Usage: javadoc -d <directory> -doclet TagXMLDoclet ...");
            return false;
        }
        return true;
    }
}

