/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jalopy;

import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.History;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class JalopyBean {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$jalopy$JalopyBean == null ? (class$org$apache$maven$jalopy$JalopyBean = JalopyBean.class$("org.apache.maven.jalopy.JalopyBean")) : class$org$apache$maven$jalopy$JalopyBean));
    private String fileFormat;
    private String historyPolicy;
    private boolean failOnError;
    private boolean inspect;
    private boolean backup;
    private boolean force;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File convention;
    private String srcIncludesPattern;
    private String srcExcludesPattern;
    private String testIncludesPattern;
    private String testExcludesPattern;
    static /* synthetic */ Class class$org$apache$maven$jalopy$JalopyBean;

    public void execute() throws Exception {
        LOG.info((Object)("[jalopy] Jalopy Java Source Code Formatter " + Jalopy.getVersion()));
        try {
            String[] filesToFormat;
            if (this.getSourceDirectory().exists()) {
                filesToFormat = this.getIncludedFiles(this.getSourceDirectory(), this.getSrcIncludesPattern(), this.getSrcExcludesPattern());
                LOG.info((Object)("[jalopy] Format " + filesToFormat.length + " source files in " + this.getSourceDirectory().toString()));
                this.formatFiles(this.getSourceDirectory(), filesToFormat);
                LOG.info((Object)("[jalopy] " + filesToFormat.length + " source files formatted"));
            }
            if (this.getTestSourceDirectory().exists()) {
                filesToFormat = this.getIncludedFiles(this.getTestSourceDirectory(), this.getTestIncludesPattern(), this.getTestExcludesPattern());
                LOG.info((Object)("[jalopy] Format " + filesToFormat.length + " source files in " + this.getTestSourceDirectory().toString()));
                this.formatFiles(this.getTestSourceDirectory(), filesToFormat);
                LOG.info((Object)("[jalopy] " + filesToFormat.length + " source files formatted"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        String[] filesToFormat = scanner.getIncludedFiles();
        return filesToFormat;
    }

    private void formatFiles(File directory, String[] filesToFormat) throws FileNotFoundException, Exception {
        Jalopy jalopy = this.createJalopy();
        for (int i = 0; i < filesToFormat.length; ++i) {
            File currentFile = new File(directory, filesToFormat[i]);
            jalopy.setInput(currentFile);
            jalopy.setOutput(currentFile);
            if (this.isBackup()) {
                jalopy.setBackupDirectory(currentFile.getParentFile());
            }
            jalopy.format();
            this.logMessage(jalopy, currentFile);
        }
    }

    private void logMessage(Jalopy jalopy, File currentFile) throws Exception {
        if (jalopy.getState() == Jalopy.State.OK) {
            LOG.debug((Object)("[jalopy] " + currentFile + " formatted correctly."));
        } else if (jalopy.getState() == Jalopy.State.WARN) {
            LOG.warn((Object)("[jalopy] " + currentFile + " formatted with warnings."));
        } else if (jalopy.getState() == Jalopy.State.ERROR) {
            LOG.error((Object)("[jalopy] " + currentFile + " could not be formatted."));
            if (this.isFailOnError()) {
                throw new Exception(currentFile + " could not be formatted.");
            }
        } else {
            LOG.warn((Object)("[jalopy] " + currentFile + " formatted with unknown state."));
        }
    }

    private Jalopy createJalopy() {
        Jalopy jalopy = new Jalopy();
        try {
            if (this.convention != null && this.convention.exists()) {
                LOG.debug((Object)("[jalopy] Using convention file : " + this.convention.getAbsoluteFile()));
                Jalopy.setConvention((File)this.convention);
            } else {
                LOG.warn((Object)("[jalopy] Convention file does not exist: " + this.convention.getAbsoluteFile()));
                LOG.warn((Object)"[jalopy] Using default convention : jalopy.xml");
                InputStream in = this.getClass().getClassLoader().getResourceAsStream("plugin-resources/jalopy.xml");
                Convention.importSettings((InputStream)in, (String)".xml");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        jalopy.setFileFormat(this.getFileFormat());
        jalopy.setInspect(this.isInspect());
        if (!this.getHistoryPolicy().equalsIgnoreCase("none")) {
            jalopy.setHistoryPolicy(History.Policy.valueOf((String)this.getHistoryPolicy()));
        }
        jalopy.setBackup(this.isBackup());
        jalopy.setForce(this.isForce());
        return jalopy;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String newfileFormat) {
        this.fileFormat = newfileFormat;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean newfailOnError) {
        this.failOnError = newfailOnError;
    }

    public boolean isInspect() {
        return this.inspect;
    }

    public void setInspect(boolean newinspect) {
        this.inspect = newinspect;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean newbackup) {
        this.backup = newbackup;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean newforce) {
        this.force = newforce;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File newsourceDirectory) {
        this.sourceDirectory = newsourceDirectory;
    }

    public String getSrcIncludesPattern() {
        return this.srcIncludesPattern;
    }

    public void setSrcIncludesPattern(String newsrcIncludesPattern) {
        this.srcIncludesPattern = newsrcIncludesPattern;
    }

    public String getSrcExcludesPattern() {
        return this.srcExcludesPattern;
    }

    public void setSrcExcludesPattern(String newsrcExcludesPattern) {
        this.srcExcludesPattern = newsrcExcludesPattern;
    }

    public String getHistoryPolicy() {
        return this.historyPolicy;
    }

    public void setHistoryPolicy(String newhistoryPolicy) {
        this.historyPolicy = newhistoryPolicy;
    }

    public File getConvention() {
        return this.convention;
    }

    public void setConvention(File newconvention) {
        this.convention = newconvention;
    }

    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public void setTestSourceDirectory(File newtestSourceDirectory) {
        this.testSourceDirectory = newtestSourceDirectory;
    }

    public String getTestIncludesPattern() {
        return this.testIncludesPattern;
    }

    public void setTestIncludesPattern(String newtestIncludesPattern) {
        this.testIncludesPattern = newtestIncludesPattern;
    }

    public String getTestExcludesPattern() {
        return this.testExcludesPattern;
    }

    public void setTestExcludesPattern(String newtestExcludesPattern) {
        this.testExcludesPattern = newtestExcludesPattern;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

