/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.junitreport;

import java.util.ArrayList;

public class ExceptionTool {
    public String[] split(String text, String separator) {
        String subString;
        int idx;
        if (text == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int fromIndex = 0;
        while ((idx = text.indexOf(separator, fromIndex)) != -1) {
            subString = text.substring(fromIndex, idx);
            result.add(subString);
            fromIndex = idx + separator.length();
        }
        if (fromIndex != text.length()) {
            subString = text.substring(fromIndex);
            result.add(subString);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] splitNestedStackTraces(String nestedStackTrace) {
        String separator = "Caused by: ";
        String[] result = this.split(nestedStackTrace, separator);
        for (int i = 1; i < result.length; ++i) {
            result[i] = separator + result[i];
        }
        return result;
    }

    public String truncateStackTrace(String stackTrace, String searchedString) {
        String suffix;
        StringBuffer result = new StringBuffer();
        int fromIndex = 0;
        int idxSearchedString = stackTrace.indexOf(searchedString, fromIndex);
        if (idxSearchedString == -1) {
            idxSearchedString = stackTrace.length();
            suffix = "";
        } else {
            suffix = "... more";
        }
        String currentStack = stackTrace.substring(fromIndex, idxSearchedString);
        result.append(currentStack + suffix);
        return result.toString();
    }

    public String truncateNestedStackTrace(String netstedStackTrace, String searchedString) {
        String[] stackTraces = this.splitNestedStackTraces(netstedStackTrace);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < stackTraces.length; ++i) {
            String nestedStackTrace = stackTraces[i];
            String truncatedNestedStackTrace = this.truncateStackTrace(nestedStackTrace, searchedString);
            result.append(truncatedNestedStackTrace + "\r\n");
        }
        return result.toString();
    }
}

