/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jira;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.project.Project;

public final class JiraDownloader {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$jira$JiraDownloader == null ? (class$org$apache$maven$jira$JiraDownloader = JiraDownloader.class$("org.apache.maven.jira.JiraDownloader")) : class$org$apache$maven$jira$JiraDownloader));
    private static Map statusMap = new HashMap();
    private static Map resolutionMap = new HashMap();
    private static Map priorityMap = new HashMap();
    private File output;
    private int nbEntriesMax;
    private String filter;
    private String status;
    private String resolution;
    private String priority;
    private String component;
    private String jiraUser;
    private String jiraPassword;
    private String webUser;
    private String webPassword;
    private String proxyNtlmHost;
    private String proxyNtlmDomain;
    private Project project;
    private boolean roadmap;
    static /* synthetic */ Class class$org$apache$maven$jira$JiraDownloader;

    private String createFilter() {
        int i;
        if (this.filter != null && this.filter.length() > 0) {
            if (this.filter.charAt(0) == '&') {
                return this.filter.substring(1);
            }
            return this.filter;
        }
        StringBuffer localFilter = new StringBuffer();
        if (this.status != null) {
            String[] stats = this.status.split(",");
            for (i = 0; i < stats.length; ++i) {
                String statusParam = (String)statusMap.get(stats[i]);
                if (statusParam == null) continue;
                localFilter.append("&status=" + statusParam);
            }
        }
        if (this.priority != null) {
            String[] prios = this.priority.split(",");
            for (i = 0; i < prios.length; ++i) {
                String priorityParam = (String)priorityMap.get(prios[i]);
                if (priorityParam == null) continue;
                localFilter.append("&priority=" + priorityParam);
            }
        }
        if (this.resolution != null) {
            String[] resos = this.resolution.split(",");
            for (i = 0; i < resos.length; ++i) {
                String resoParam = (String)resolutionMap.get(resos[i]);
                if (resoParam == null) continue;
                localFilter.append("&resolution=" + resoParam);
            }
        }
        if (this.component != null) {
            String[] components = this.component.split(",");
            for (i = 0; i < components.length; ++i) {
                if (components[i].length() <= 0) continue;
                localFilter.append("&component=" + components[i]);
            }
        }
        String sort = "&sorter/field=created&sorter/order=DESC&sorter/field=priority&sorter/order=DESC";
        return localFilter + sort;
    }

    public void doExecute() throws Exception {
        if (this.project == null) {
            throw new Exception("No project set.");
        }
        if (this.project.getIssueTrackingUrl() == null) {
            throw new Exception("No issue tracking url set.");
        }
        try {
            String jiraUrl;
            HttpClient cl = new HttpClient();
            HttpState state = new HttpState();
            HostConfiguration hc = new HostConfiguration();
            cl.setHostConfiguration(hc);
            cl.setState(state);
            this.determineProxy(cl);
            String url = this.project.getIssueTrackingUrl();
            int pos = url.indexOf("?");
            String id = null;
            if (pos >= 0) {
                id = url.substring(url.lastIndexOf("=") + 1);
            }
            if ((jiraUrl = url.substring(0, url.lastIndexOf("/"))).endsWith("secure") || jiraUrl.endsWith("browse")) {
                jiraUrl = jiraUrl.substring(0, jiraUrl.lastIndexOf("/"));
            }
            LOG.info((Object)("Jira lives at: " + jiraUrl));
            this.doAuthentication(cl, jiraUrl);
            String projectPage = "";
            if (id == null || this.roadmap) {
                GetMethod gm = new GetMethod(url + "?report=com.atlassian.jira.plugin.system.project:roadmap-panel");
                try {
                    cl.executeMethod((HttpMethod)gm);
                    LOG.info((Object)"Succesfully reached JIRA.");
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.error((Object)"Unable to reach JIRA project page:", (Throwable)e);
                    }
                    LOG.error((Object)("Unable to reach JIRA project page. Cause is: " + e.getLocalizedMessage()));
                }
                projectPage = gm.getResponseBodyAsString();
            }
            if (id == null) {
                LOG.info((Object)("Jira URL " + url + " doesn't include a pid, trying to get it"));
                int pidIndex = projectPage.indexOf("pid=");
                if (pidIndex == -1) {
                    LOG.error((Object)("Unable to get JIRA pid using url " + this.project.getIssueTrackingUrl()));
                    return;
                }
                NumberFormat nf = NumberFormat.getInstance();
                Number pidNumber = nf.parse(projectPage, new ParsePosition(pidIndex + 4));
                id = Integer.toString(pidNumber.intValue());
            }
            String fullURL = jiraUrl + "/secure/IssueNavigator.jspa?view=rss&pid=" + id;
            fullURL = fullURL + this.createFilter();
            fullURL = fullURL + "&tempMax=" + this.nbEntriesMax + "&reset=true&decorator=none";
            this.download(cl, fullURL, this.output);
            if (this.roadmap) {
                int fixforIndex = projectPage.indexOf("fixfor=");
                if (fixforIndex == -1) {
                    LOG.error((Object)("Unable to get JIRA roadmap using url " + this.project.getIssueTrackingUrl()));
                    return;
                }
                NumberFormat nf = NumberFormat.getInstance();
                Number fixforNumber = nf.parse(projectPage, new ParsePosition(fixforIndex + 7));
                String fixfor = Integer.toString(fixforNumber.intValue());
                if (!fixfor.equals("-1")) {
                    this.setFilter("&&fixfor=" + fixfor + "&sorter/field=status&sorter/order=ASC");
                    fullURL = jiraUrl + "/secure/IssueNavigator.jspa?view=rss&pid=" + id;
                    fullURL = fullURL + this.createFilter();
                    fullURL = fullURL + "&tempMax=" + this.nbEntriesMax + "&reset=true&decorator=none";
                    String outFile = this.output.getAbsolutePath().replace('\\', '/');
                    int endIndex = outFile.lastIndexOf(47);
                    outFile = outFile.substring(0, endIndex) + "/jira-roadmap.xml";
                    this.download(cl, fullURL, new File(outFile));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error accessing " + this.project.getIssueTrackingUrl()), (Throwable)e);
        }
    }

    private void doAuthentication(HttpClient client, String jiraUrl) {
        if (this.webUser != null && this.webUser.length() > 0) {
            client.getState().setAuthenticationPreemptive(true);
            Object defaultcreds = this.proxyNtlmHost != null && this.proxyNtlmDomain != null ? new NTCredentials(this.webUser, this.webPassword, this.proxyNtlmHost, this.proxyNtlmDomain) : new UsernamePasswordCredentials(this.webUser, this.webPassword);
            LOG.info((Object)("Using username: " + this.webUser + " for Basic Authentication against the webserver at " + jiraUrl));
            client.getState().setCredentials(null, null, (Credentials)defaultcreds);
        }
        String loginUrl = null;
        if (this.jiraUser != null && this.jiraUser.length() > 0 && this.jiraPassword != null) {
            StringBuffer loginLink = new StringBuffer(jiraUrl);
            loginLink.append("/login.jsp?os_destination=/secure/");
            loginLink.append("&os_username=").append(this.jiraUser);
            LOG.info((Object)("Login URL: " + loginLink + "&os_password=*******"));
            loginLink.append("&os_password=").append(this.jiraPassword);
            loginUrl = loginLink.toString();
        }
        if (loginUrl != null) {
            GetMethod loginGet = new GetMethod(loginUrl);
            try {
                client.executeMethod((HttpMethod)loginGet);
                LOG.info((Object)"Succesfully logged in into JIRA.");
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)"Error trying to login into JIRA:", (Throwable)e);
                }
                LOG.error((Object)("Error trying to login into JIRA. Cause is: " + e.getLocalizedMessage()));
            }
        }
    }

    private void determineProxy(HttpClient client) {
        if (this.project == null) {
            LOG.error((Object)"No project set. No proxy info available.");
            return;
        }
        MavenJellyContext ctx = this.project.getContext();
        if (ctx == null) {
            LOG.error((Object)"Maven project has no context. No proxy info available.");
            return;
        }
        String proxyHost = ctx.getProxyHost();
        if (proxyHost != null) {
            String proxyPort = ctx.getProxyPort();
            client.getHostConfiguration().setProxy(proxyHost, Integer.parseInt(proxyPort));
            LOG.info((Object)("Using proxy: " + proxyHost + " at port " + proxyPort));
            String proxyUser = ctx.getProxyUserName();
            if (proxyUser != null) {
                LOG.info((Object)("Using proxy user: " + proxyUser));
                String proxyPass = ctx.getProxyPassword();
                client.getState().setProxyCredentials(null, null, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPass));
            }
        }
    }

    private void download(HttpClient cl, String link, File outFile) {
        try {
            GetMethod gm = new GetMethod(link);
            LOG.info((Object)("Downloading " + link));
            gm.setFollowRedirects(true);
            cl.executeMethod((HttpMethod)gm);
            String strGetResponseBody = gm.getResponseBodyAsString();
            PrintWriter pw = new PrintWriter(new FileWriter(outFile));
            pw.print(strGetResponseBody);
            pw.close();
            StatusLine sl = gm.getStatusLine();
            if (sl == null) {
                LOG.info((Object)("Unknown error validating link : " + link));
                return;
            }
            if (gm.getStatusCode() == 302) {
                Header locationHeader = gm.getResponseHeader("Location");
                if (locationHeader == null) {
                    LOG.info((Object)"Site sent redirect, but did not set Location header");
                } else {
                    String newLink = locationHeader.getValue();
                    LOG.debug((Object)("Following redirect to " + newLink));
                    this.download(cl, newLink, outFile);
                }
            }
            if (gm.getStatusCode() != 200) {
                LOG.warn((Object)("Received: [" + gm.getStatusCode() + "]"));
            }
        }
        catch (HttpException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)"Error downloading issues from JIRA:", (Throwable)e);
            } else {
                LOG.error((Object)("Error downloading issues from JIRA. Cause is: " + e.getLocalizedMessage()));
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)"Error downloading issues from JIRA:", (Throwable)e);
            }
            LOG.error((Object)("Error downloading issues from JIRA. Cause is: " + e.getLocalizedMessage()));
        }
    }

    public void setOutput(File thisOutput) {
        this.output = thisOutput;
    }

    public void setProject(Object thisProject) {
        this.project = (Project)thisProject;
    }

    public void setNbEntries(int nbEntries) {
        this.nbEntriesMax = nbEntries;
    }

    public void setStatus(String thisStatus) {
        this.status = thisStatus;
    }

    public void setPriority(String thisPriority) {
        this.priority = thisPriority;
    }

    public void setResolution(String thisResolution) {
        this.resolution = thisResolution;
    }

    public void setWebPassword(String thisWebPassword) {
        this.webPassword = thisWebPassword;
    }

    public void setWebUser(String thisWebUser) {
        this.webUser = thisWebUser;
    }

    public void setProxyNtlmHost(String thisProxyNtlmHost) {
        this.proxyNtlmHost = thisProxyNtlmHost;
    }

    public void setProxyNtlmDomain(String thisProxyNtlmDomain) {
        this.proxyNtlmDomain = thisProxyNtlmDomain;
    }

    public void setJiraPassword(String thisJiraPassword) {
        this.jiraPassword = thisJiraPassword;
    }

    public void setJiraUser(String thisJiraUser) {
        this.jiraUser = thisJiraUser;
    }

    public void setFilter(String thisFilter) {
        this.filter = thisFilter;
    }

    public void setComponent(String theseComponents) {
        this.component = theseComponents;
    }

    public void setRoadmap(boolean thisRoadmap) {
        this.roadmap = thisRoadmap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        statusMap.put("Open", "1");
        statusMap.put("In Progress", "3");
        statusMap.put("Reopened", "4");
        statusMap.put("Resolved", "5");
        statusMap.put("Closed", "6");
        resolutionMap.put("Unresolved", "-1");
        resolutionMap.put("Fixed", "1");
        resolutionMap.put("Won't Fix", "2");
        resolutionMap.put("Duplicate", "3");
        resolutionMap.put("Incomplete", "4");
        resolutionMap.put("Cannot Reproduce", "5");
        priorityMap.put("Blocker", "1");
        priorityMap.put("Critical", "2");
        priorityMap.put("Major", "3");
        priorityMap.put("Minor", "4");
        priorityMap.put("Trivial", "5");
    }
}

