/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLFilterImpl;

public class XPathLocationTracker
extends XMLFilterImpl {
    private State state;
    private static final Integer[] ints = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};

    public void startDocument() throws SAXException {
        this.state = new State(null);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.state = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.state = this.state.push(qName);
        try {
            super.startElement(uri, localName, qName, atts);
        }
        catch (SAXParseException e) {
            // empty catch block
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            super.endElement(uri, localName, qName);
        }
        catch (SAXParseException e) {
            // empty catch block
        }
        this.state = this.state.pop();
    }

    public final String getXPath() {
        if (this.state == null) {
            throw new IllegalStateException("startDocument event is not invoked");
        }
        return this.state.getXPath();
    }

    private static Integer getInt(int i) {
        if (i < ints.length) {
            return ints[i];
        }
        return new Integer(i);
    }

    private static final class State {
        private final Map counter = new HashMap();
        private final State parent;
        private State child;
        private String currentName;

        State(State newParent) {
            this.parent = newParent;
        }

        protected State push(String rawName) {
            this.count(rawName);
            this.currentName = rawName;
            if (this.child == null) {
                this.child = new State(this);
            } else {
                this.child.reset();
            }
            return this.child;
        }

        protected State pop() {
            this.parent.currentName = null;
            return this.parent;
        }

        private void count(String rawName) {
            Integer i = (Integer)this.counter.get(rawName);
            i = i == null ? XPathLocationTracker.getInt(1) : XPathLocationTracker.getInt(i + 1);
            this.counter.put(rawName, i);
        }

        private void reset() {
            this.counter.clear();
            this.currentName = null;
        }

        private String getXPath() {
            String xPath;
            if (this.parent == null) {
                xPath = "/";
                if (this.currentName != null) {
                    xPath = xPath + this.currentName;
                }
            } else {
                xPath = this.parent.getXPath();
                if (this.currentName != null) {
                    xPath = xPath + '/' + this.currentName;
                    Integer i = (Integer)this.counter.get(this.currentName);
                    xPath = xPath + '[' + i.toString() + ']';
                }
            }
            return xPath;
        }
    }
}

