/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.vsslib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.vsslib.VssConnection;

public class VssChangeLogParser
implements ChangeLogParser {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$vsslib$VssChangeLogParser == null ? (class$org$apache$maven$vsslib$VssChangeLogParser = VssChangeLogParser.class$("org.apache.maven.vsslib.VssChangeLogParser")) : class$org$apache$maven$vsslib$VssChangeLogParser));
    private static final SimpleDateFormat ENTRY_KEY_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private static final int GET_FILE = 1;
    private static final int GET_FILE_PATH = 2;
    private static final int GET_AUTHOR = 3;
    private static final int GET_COMMENT = 4;
    private static final int GET_REVISION = 5;
    private static final int GET_UNKNOWN = 6;
    private static final String START_FILE = "*****  ";
    private static String START_FILE_PATH = "$/";
    private static final String START_REVISION = "Version";
    private static final String START_AUTHOR = "User: ";
    private static final String START_COMMENT = "Comment: ";
    private Map entries = new TreeMap(Collections.reverseOrder());
    private int lastStatus = 1;
    private ChangeLogEntry currentLogEntry = null;
    private ChangeLogFile currentFile = null;
    private VssConnection vssConnection;
    static /* synthetic */ Class class$org$apache$maven$vsslib$VssChangeLogParser;

    public void init(ChangeLog changeLog) {
        String connection = changeLog.getRepositoryConnection();
        try {
            this.vssConnection = new VssConnection(connection);
        }
        catch (Exception e) {
            String message = "Unable to parse vss connection string : " + connection;
            throw new IllegalArgumentException(message);
        }
    }

    public Collection parse(InputStream inputStream) throws IOException {
        String line;
        BufferedReader stream = new BufferedReader(new InputStreamReader(inputStream));
        block7: while ((line = stream.readLine()) != null) {
            switch (this.getLineStatus(line)) {
                case 1: {
                    this.processGetFile(line);
                    continue block7;
                }
                case 5: {
                    this.processGetRevision(line);
                    continue block7;
                }
                case 3: {
                    this.processGetAuthor(line);
                    continue block7;
                }
                case 2: {
                    this.processGetFilePath(line);
                    continue block7;
                }
                case 4: {
                    this.processGetComment(line);
                    continue block7;
                }
            }
        }
        return this.entries.values();
    }

    private void processGetComment(String line) {
        String[] commentLine = line.split(":");
        if (commentLine.length == 2) {
            this.getCurrentLogEntry().setComment(commentLine[1]);
        } else {
            String comment = this.getCurrentLogEntry().getComment();
            comment = comment + " " + line;
            this.getCurrentLogEntry().setComment(comment);
        }
    }

    private void processGetAuthor(String line) {
        String[] result = line.split("\\s");
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < result.length; ++i) {
            if (result[i].equals("")) continue;
            vector.add(result[i]);
        }
        ChangeLogEntry entry = this.getCurrentLogEntry();
        entry.setAuthor((String)vector.get(1));
        entry.setDate(this.parseDate((String)vector.get(3) + " " + (String)vector.get(5)));
    }

    private void processGetFile(String line) {
        this.setCurrentLogEntry(new ChangeLogEntry());
        String[] fileLine = line.split(" ");
        this.setCurrentFile(new ChangeLogFile(fileLine[2]));
    }

    private void processGetFilePath(String line) {
        if (this.getCurrentFile() != null) {
            String fileName = this.getCurrentFile().getName();
            String path = line.substring(line.indexOf("$"), line.length());
            String longPath = path.substring(this.vssConnection.getVssProject().length() + 1, path.length()) + "/" + fileName;
            this.getCurrentFile().setName(longPath);
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
        }
    }

    private void processGetRevision(String line) {
        String[] revisionLine = line.split(" ");
        this.getCurrentFile().setRevision(revisionLine[1]);
    }

    private int getLineStatus(String line) {
        int argument = 6;
        if (line.startsWith(START_FILE)) {
            argument = 1;
        } else if (line.startsWith(START_REVISION)) {
            argument = 5;
        } else if (line.startsWith(START_AUTHOR)) {
            argument = 3;
        } else if (line.indexOf(START_FILE_PATH) != -1) {
            argument = 2;
        } else if (line.startsWith(START_COMMENT)) {
            argument = 4;
        } else if (this.getLastStatus() == 4) {
            argument = this.getLastStatus();
        }
        this.setLastStatus(argument);
        return argument;
    }

    private void addEntry(ChangeLogEntry entry, ChangeLogFile file) {
        if (entry.getAuthor() == null) {
            return;
        }
        String key = ENTRY_KEY_TIMESTAMP_FORMAT.format(entry.getDate()) + entry.getAuthor() + entry.getComment();
        if (!this.entries.containsKey(key)) {
            entry.addFile(file);
            this.entries.put(key, entry);
        } else {
            ChangeLogEntry existingEntry = (ChangeLogEntry)this.entries.get(key);
            existingEntry.addFile(file);
        }
    }

    private Date parseDate(String dateString) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yy HH:mm");
            Date date = format.parse(dateString);
            return date;
        }
        catch (ParseException e) {
            LOG.error((Object)"ParseException Caught", (Throwable)e);
            return null;
        }
    }

    private ChangeLogFile getCurrentFile() {
        return this.currentFile;
    }

    private void setCurrentFile(ChangeLogFile currentFile) {
        this.currentFile = currentFile;
    }

    private ChangeLogEntry getCurrentLogEntry() {
        return this.currentLogEntry;
    }

    private void setCurrentLogEntry(ChangeLogEntry currentLogEntry) {
        this.currentLogEntry = currentLogEntry;
    }

    private int getLastStatus() {
        return this.lastStatus;
    }

    private void setLastStatus(int status) {
        this.lastStatus = status;
    }

    public void cleanup() {
    }

    public void setDateFormatInFile(String s) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

