/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mkslib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogParser;

public class MksChangeLogParser
implements ChangeLogParser {
    private static final SimpleDateFormat MKS_TIMESTAMP_FORMAT = new SimpleDateFormat("MMM d, yyyy - h:mm a");
    private static final SimpleDateFormat ENTRY_KEY_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private static final int GET_FILE_NAME = 1;
    private static final int GET_FILE_REVISION = 2;
    private static final int WAITFOR_ENTRY_REVISION = 3;
    private static final int GET_ENTRY_INFO = 4;
    private static final int GET_ENTRY_COMMENT = 5;
    private Map entries = new TreeMap(Collections.reverseOrder());
    private int status = 1;
    private ChangeLogEntry changeLogEntry;
    private ChangeLogFile changeLogFile;
    private Date filterDateStart;
    private Date filterDateEnd;

    public void init(ChangeLog changeLog) {
        if (changeLog.getType().equals("range")) {
            try {
                if (changeLog.getRange() == null || changeLog.getRange().length() == 0) {
                    throw new NumberFormatException("no range");
                }
                long range = Integer.parseInt(changeLog.getRange());
                this.filterDateStart = new Date(System.currentTimeMillis() - range * 86400000L);
                this.filterDateEnd = null;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.filterDateStart = null;
                this.filterDateEnd = null;
            }
        } else if (changeLog.getType().equals("date")) {
            if (changeLog.getMarkerStart() != null && changeLog.getMarkerStart().length() != 0) {
                try {
                    this.filterDateStart = new SimpleDateFormat("y-M-d").parse(changeLog.getMarkerStart());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    this.filterDateStart = null;
                }
            }
            if (changeLog.getMarkerEnd() != null && changeLog.getMarkerEnd().length() != 0) {
                try {
                    this.filterDateEnd = new SimpleDateFormat("y-M-d").parse(changeLog.getMarkerEnd());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    this.filterDateEnd = null;
                }
            }
        } else if (changeLog.getType().equals("tag")) {
            // empty if block
        }
    }

    public void cleanup() {
    }

    public void setDateFormatInFile(String dateFormat) {
    }

    public Collection parse(InputStream in) throws IOException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            block10: while ((line = reader.readLine()) != null) {
                if (line.startsWith("========================================")) {
                    this.status = 1;
                }
                switch (this.status) {
                    case 1: {
                        this.addEntry();
                        this.processGetFileName(line);
                        continue block10;
                    }
                    case 2: {
                        this.processGetFileRevision(line);
                        continue block10;
                    }
                    case 3: {
                        this.processWaitForEntryRevision(line);
                        continue block10;
                    }
                    case 4: {
                        this.processGetEntryInfo(line);
                        continue block10;
                    }
                    case 5: {
                        this.processGetEntryComment(line);
                        continue block10;
                    }
                }
            }
            this.addEntry();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return this.entries.values();
    }

    protected void processGetFileName(String line) {
        if (line.startsWith("member name: ")) {
            String filename = line.indexOf(";") == -1 ? line.substring(13) : line.substring(13, line.indexOf(";"));
            this.changeLogFile = new ChangeLogFile(filename);
            this.status = 2;
        }
    }

    protected void processGetFileRevision(String line) {
        if (line.startsWith("member:\t")) {
            this.changeLogFile.setRevision(line.substring(8));
            this.status = 3;
        }
    }

    protected void processWaitForEntryRevision(String line) {
        if (line.equals("-----------------------")) {
            this.status = 4;
        }
    }

    protected void processGetEntryInfo(String line) {
        if (line.startsWith("date: ")) {
            this.changeLogEntry = new ChangeLogEntry();
            int posAuthor = line.indexOf("; author: ");
            if (posAuthor == -1) {
                return;
            }
            int posState = line.indexOf("; state: ");
            if (posState == -1) {
                return;
            }
            try {
                Date date = MKS_TIMESTAMP_FORMAT.parse(line.substring(6, posAuthor));
                String author = line.substring(posAuthor + 10, posState);
                this.changeLogEntry.setDate(date);
                this.changeLogEntry.setAuthor(author);
                this.status = 5;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("I don't understand this date: " + line.substring(6, posAuthor));
            }
        }
    }

    protected void processGetEntryComment(String line) {
        if (line.equals("-----------------------")) {
            this.addEntry();
            this.status = 4;
            return;
        }
        this.changeLogEntry.setComment(this.changeLogEntry.getComment() + line + "\n");
    }

    protected void addEntry() {
        if (this.changeLogEntry == null || this.changeLogFile == null) {
            return;
        }
        if (this.changeLogEntry.getAuthor() == null || this.changeLogEntry.getDate() == null) {
            return;
        }
        if (this.filterDateStart != null && this.changeLogEntry.getDate().before(this.filterDateStart) || this.filterDateEnd != null && this.changeLogEntry.getDate().after(this.filterDateEnd)) {
            return;
        }
        String key = ENTRY_KEY_TIMESTAMP_FORMAT.format(this.changeLogEntry.getDate()) + this.changeLogEntry.getAuthor() + this.changeLogEntry.getComment();
        if (!this.entries.containsKey(key)) {
            this.changeLogEntry.addFile(this.changeLogFile);
            this.entries.put(key, this.changeLogEntry);
        } else {
            ((ChangeLogEntry)this.entries.get(key)).addFile(this.changeLogFile);
        }
    }
}

