/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cvslib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogParser;

public class CvsChangeLogParser
implements ChangeLogParser {
    private static final SimpleDateFormat OLD_CVS_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final SimpleDateFormat NEW_CVS_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static final SimpleDateFormat ENTRY_KEY_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final String START_FILE = "Working file: ";
    private static final String END_FILE = "=============================================================================";
    private static final String START_REVISION = "----------------------------";
    private static final String REVISION_TAG = "revision ";
    private static final String DATE_TAG = "date: ";
    private Map entries = new TreeMap(Collections.reverseOrder());
    private int status = 1;
    private ChangeLogEntry currentLogEntry = null;
    private ChangeLogFile currentFile = null;

    public void init(ChangeLog changeLog) {
    }

    public void cleanup() {
    }

    public Collection parse(InputStream anInputStream) throws IOException {
        BufferedReader stream = new BufferedReader(new InputStreamReader(anInputStream));
        String line = null;
        block6: while ((line = stream.readLine()) != null) {
            switch (this.getStatus()) {
                case 1: {
                    this.processGetFile(line);
                    continue block6;
                }
                case 4: {
                    this.processGetRevision(line);
                    continue block6;
                }
                case 2: {
                    this.processGetDate(line);
                    continue block6;
                }
                case 3: {
                    this.processGetComment(line);
                    continue block6;
                }
            }
            throw new IllegalStateException("Unknown state: " + this.status);
        }
        return this.entries.values();
    }

    private void addEntry(ChangeLogEntry entry, ChangeLogFile file) {
        if (entry.getAuthor() == null) {
            return;
        }
        String key = ENTRY_KEY_TIMESTAMP_FORMAT.format(entry.getDate()) + entry.getAuthor() + entry.getComment();
        if (!this.entries.containsKey(key)) {
            entry.addFile(file);
            this.entries.put(key, entry);
        } else {
            ChangeLogEntry existingEntry = (ChangeLogEntry)this.entries.get(key);
            existingEntry.addFile(file);
        }
    }

    private void processGetFile(String line) {
        if (line.startsWith(START_FILE)) {
            this.setCurrentLogEntry(new ChangeLogEntry());
            this.setCurrentFile(new ChangeLogFile(line.substring(START_FILE.length(), line.length())));
            this.setStatus(4);
        }
    }

    private void processGetRevision(String line) {
        if (line.startsWith(REVISION_TAG)) {
            this.getCurrentFile().setRevision(line.substring(REVISION_TAG.length()));
            this.setStatus(2);
        } else if (line.startsWith(END_FILE)) {
            this.setStatus(1);
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
        }
    }

    private void processGetDate(String line) {
        if (line.startsWith(DATE_TAG)) {
            StringTokenizer tokenizer = new StringTokenizer(line, ";");
            String dateToken = tokenizer.nextToken();
            String dateString = dateToken.trim().substring(DATE_TAG.length()).trim();
            this.getCurrentLogEntry().setDate(this.parseDate(dateString));
            String authorToken = tokenizer.nextToken();
            String author = authorToken.trim().substring("author: ".length()).trim();
            this.getCurrentLogEntry().setAuthor(author);
            this.setStatus(3);
        }
    }

    private Date parseDate(String dateString) {
        Date date;
        try {
            date = OLD_CVS_TIMESTAMP_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            try {
                date = NEW_CVS_TIMESTAMP_FORMAT.parse(dateString);
            }
            catch (ParseException e1) {
                throw new IllegalArgumentException("I don't understand this date: " + dateString);
            }
        }
        return date;
    }

    private void processGetComment(String line) {
        if (line.startsWith(START_REVISION)) {
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
            this.setCurrentLogEntry(new ChangeLogEntry());
            this.setCurrentFile(new ChangeLogFile(this.getCurrentFile().getName()));
            this.setStatus(4);
        } else if (line.startsWith(END_FILE)) {
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
            this.setStatus(1);
        } else {
            this.getCurrentLogEntry().setComment(this.getCurrentLogEntry().getComment() + line + "\n");
        }
    }

    private ChangeLogFile getCurrentFile() {
        return this.currentFile;
    }

    private void setCurrentFile(ChangeLogFile currentFile) {
        this.currentFile = currentFile;
    }

    private ChangeLogEntry getCurrentLogEntry() {
        return this.currentLogEntry;
    }

    private void setCurrentLogEntry(ChangeLogEntry currentLogEntry) {
        this.currentLogEntry = currentLogEntry;
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    public void setDateFormatInFile(String dateFormat) {
    }
}

